#ifndef SETTINGSMANAGER_H
#define SETTINGSMANAGER_H

#include <QObject>
#include <QSettings>
#include <QString>

class SettingsManager : public QObject
{
    Q_OBJECT
    
    // Propietats MQTT
    Q_PROPERTY(QString mqttMac READ mqttMac WRITE setMqttMac NOTIFY mqttMacChanged)
    Q_PROPERTY(QString mqttBroker READ mqttBroker WRITE setMqttBroker NOTIFY mqttBrokerChanged)
    Q_PROPERTY(QString mqttUser READ mqttUser WRITE setMqttUser NOTIFY mqttUserChanged)
    Q_PROPERTY(QString mqttPassword READ mqttPassword WRITE setMqttPassword NOTIFY mqttPasswordChanged)
    
    // Propietats LDR
    Q_PROPERTY(bool ldrRandom READ ldrRandom WRITE setLdrRandom NOTIFY ldrRandomChanged)
    Q_PROPERTY(int ldrMin READ ldrMin WRITE setLdrMin NOTIFY ldrMinChanged)
    Q_PROPERTY(int ldrMax READ ldrMax WRITE setLdrMax NOTIFY ldrMaxChanged)
    
    // Propietats BME280
    Q_PROPERTY(bool bmeRandom READ bmeRandom WRITE setBmeRandom NOTIFY bmeRandomChanged)
    Q_PROPERTY(int tempMin READ tempMin WRITE setTempMin NOTIFY tempMinChanged)
    Q_PROPERTY(int tempMax READ tempMax WRITE setTempMax NOTIFY tempMaxChanged)
    Q_PROPERTY(int rhMin READ rhMin WRITE setRhMin NOTIFY rhMinChanged)
    Q_PROPERTY(int rhMax READ rhMax WRITE setRhMax NOTIFY rhMaxChanged)
    Q_PROPERTY(int pressureMin READ pressureMin WRITE setPressureMin NOTIFY pressureMinChanged)
    Q_PROPERTY(int pressureMax READ pressureMax WRITE setPressureMax NOTIFY pressureMaxChanged)

public:
    explicit SettingsManager(QObject *parent = nullptr);
    
    // Getters MQTT
    QString mqttMac() const { return m_mqttMac; }
    QString mqttBroker() const { return m_mqttBroker; }
    QString mqttUser() const { return m_mqttUser; }
    QString mqttPassword() const { return m_mqttPassword; }
    
    // Getters LDR
    bool ldrRandom() const { return m_ldrRandom; }
    int ldrMin() const { return m_ldrMin; }
    int ldrMax() const { return m_ldrMax; }
    
    // Getters BME280
    bool bmeRandom() const { return m_bmeRandom; }
    int tempMin() const { return m_tempMin; }
    int tempMax() const { return m_tempMax; }
    int rhMin() const { return m_rhMin; }
    int rhMax() const { return m_rhMax; }
    int pressureMin() const { return m_pressureMin; }
    int pressureMax() const { return m_pressureMax; }
    
    // Setters MQTT
    void setMqttMac(const QString &mac);
    void setMqttBroker(const QString &broker);
    void setMqttUser(const QString &user);
    void setMqttPassword(const QString &password);
    
    // Setters LDR
    void setLdrRandom(bool random);
    void setLdrMin(int min);
    void setLdrMax(int max);
    
    // Setters BME280
    void setBmeRandom(bool random);
    void setTempMin(int min);
    void setTempMax(int max);
    void setRhMin(int min);
    void setRhMax(int max);
    void setPressureMin(int min);
    void setPressureMax(int max);
    
    // Mètodes públics
    Q_INVOKABLE void save();
    Q_INVOKABLE void load();
    Q_INVOKABLE void cancel();
    Q_INVOKABLE bool isFirstRun() const;

signals:
    // Signals MQTT
    void mqttMacChanged();
    void mqttBrokerChanged();
    void mqttUserChanged();
    void mqttPasswordChanged();
    
    // Signals LDR
    void ldrRandomChanged();
    void ldrMinChanged();
    void ldrMaxChanged();
    
    // Signals BME280
    void bmeRandomChanged();
    void tempMinChanged();
    void tempMaxChanged();
    void rhMinChanged();
    void rhMaxChanged();
    void pressureMinChanged();
    void pressureMaxChanged();

private:
    QSettings m_settings;
    
    // Valors temporals (per cancel·lar)
    QString m_mqttMac;
    QString m_mqttBroker;
    QString m_mqttUser;
    QString m_mqttPassword;
    
    bool m_ldrRandom;
    int m_ldrMin;
    int m_ldrMax;
    
    bool m_bmeRandom;
    int m_tempMin;
    int m_tempMax;
    int m_rhMin;
    int m_rhMax;
    int m_pressureMin;
    int m_pressureMax;
    
    // Mètodes privats
    void loadDefaults();
    QString normalizeMac(const QString &mac);
    bool validateMac(const QString &mac);
};

#endif // SETTINGSMANAGER_H
