#include <QGuiApplication>
#include <QQmlApplicationEngine>
#include <QQmlContext>
#include "settingsmanager.h"
#include "mqttcontroller.h"

int main(int argc, char *argv[])
{
    QGuiApplication app(argc, argv);

    QQmlApplicationEngine engine;
    
    // Crear SettingsManager
    SettingsManager settingsManager;
    engine.rootContext()->setContextProperty("settingsManager", &settingsManager);
    
    // Crear MqttController (depèn de SettingsManager)
    MqttController mqttController(&settingsManager);
    engine.rootContext()->setContextProperty("mqttController", &mqttController);
    
    // Registrar l'enum per poder-lo usar a QML
    qmlRegisterUncreatableMetaObject(
        MqttController::staticMetaObject,
        "MqttController",
        1, 0,
        "MqttController",
        "Error: només per accedir a l'enum ConnectionState"
    );
    
    const QUrl url(QStringLiteral("qrc:/qt/qml/dt14/Main.qml"));
    QObject::connect(
        &engine,
        &QQmlApplicationEngine::objectCreationFailed,
        &app,
        []() { QCoreApplication::exit(-1); },
        Qt::QueuedConnection);
    engine.load(url);

    return app.exec();
}
