import QtQuick
import QtQuick.Controls
import QtQuick.Layouts

Item {
    id: root
    
    // Propietats públiques
    property string label: "Rang"
    property string unit: ""
    property int absoluteMin: 0
    property int absoluteMax: 100
    property int minValue: 0
    property int maxValue: 100
    
    // Alçada automàtica segons contingut
    implicitHeight: column.height
    
    Column {
        id: column
        width: parent.width
        spacing: 8
        
        // Label amb unitat integrada
        Text {
            text: root.label + (root.unit !== "" ? " (" + root.unit + ")" : "")
            font.pixelSize: 14
            font.bold: true
        }
        
        // Valors actuals (mínim i màxim)
        Row {
            width: parent.width
            spacing: 10
            
            Text {
                text: "Min: " + root.minValue + (root.unit !== "" ? " " + root.unit : "")
                font.pixelSize: 13
                color: "#666666"
                width: (parent.width - 10) / 2
            }
            
            Text {
                text: "Max: " + root.maxValue + (root.unit !== "" ? " " + root.unit : "")
                font.pixelSize: 13
                color: "#666666"
                width: (parent.width - 10) / 2
                horizontalAlignment: Text.AlignRight
            }
        }
        
        // RangeSlider per seleccionar rang
        RangeSlider {
            id: rangeSlider
            width: parent.width
            from: root.absoluteMin
            to: root.absoluteMax
            stepSize: 1
            
            first.value: root.minValue
            second.value: root.maxValue
            
            // Actualitzar només quan l'usuari mou els handles
            first.onMoved: {
                root.minValue = Math.round(first.value)
            }
            
            second.onMoved: {
                root.maxValue = Math.round(second.value)
            }
        }
        
        // Indicador visual del rang absolut (opcional, ajuda a orientar-se)
        Row {
            width: parent.width
            
            Text {
                text: root.absoluteMin.toString()
                font.pixelSize: 10
                color: "#999999"
                width: parent.width / 2
            }
            
            Text {
                text: root.absoluteMax.toString()
                font.pixelSize: 10
                color: "#999999"
                width: parent.width / 2
                horizontalAlignment: Text.AlignRight
            }
        }
    }
}
