# dt06 - Bessó Digital IoT-02 amb MQTT

Aplicació QML multiplataforma per controlar la placa IoT-02 mitjançant MQTT sobre WebSocket.

## Característiques

### Interfície gràfica
- Visualització de la placa IoT-02 amb escalat responsiu
- 3 botons interactius que publiquen a MQTT
- 4 LEDs controlats per MQTT
- Panell de connexió MQTT amb indicador d'estat visual
- Configuració persistent amb QSettings

### Comunicació MQTT

**Publicació (botons)**:
- `/<MAC>/btIO0` → `"btIO0 pressed"` / `"btIO0 released"`
- `/<MAC>/btI34` → `"btI34 pressed"` / `"btI34 released"`
- `/<MAC>/btI35` → `"btI35 pressed"` / `"btI35 released"`

**Subscripció (LEDs)**:
- `/<MAC>/ledW` ← `"1"` / `"0"` (LED blanc)
- `/<MAC>/ledR` ← `"1"` / `"0"` (LED vermell)
- `/<MAC>/ledY` ← `"1"` / `"0"` (LED groc)
- `/<MAC>/ledG` ← `"1"` / `"0"` (LED verd)

### Estats de connexió

- 🔴 **Desconnectat** (vermell): No connectat al broker
- 🔵 **Connectant** (blau): Establint connexió
- 🟢 **Connectat** (verd): Connectat i operatiu

## Estructura del projecte

```
dt06/
├── CMakeLists.txt              # Configuració CMake amb MQTT i WebSockets
├── main.cpp                    # Punt d'entrada
├── settingsmanager.h/cpp       # Gestor de configuració (QSettings)
├── mqttbasic.h/cpp             # Client MQTT base
├── mqttcontroller.h/cpp        # Controlador MQTT (lògica d'aplicació)
├── websocketiodevice.h/cpp     # Adaptador WebSocket per MQTT
├── Main.qml                    # Pantalla principal
├── ConfigPage.qml              # Pantalla de configuració
├── ConnectionPanel.qml         # Panell de control de connexió
├── InteractiveButton.qml       # Botó amb publicació MQTT
├── InteractiveLed.qml          # LED controlat per MQTT
├── RangeSelector.qml           # Selector de rangs
└── imatges/
    └── IoT-02.png              # Imatge de la placa
```

## Compilació

### Requisits
- Qt 6.8 o superior
- Qt6::Mqtt
- Qt6::WebSockets
- Per Android: OpenSSL (WSS requereix SSL/TLS)

### Desktop
```bash
cd dt06
mkdir build && cd build
cmake ..
cmake --build .
./appdt06
```

### WebAssembly
```bash
cd dt06
mkdir build-wasm && cd build-wasm
qt-cmake -DQT_HOST_PATH=/path/to/qt/host ..
cmake --build .
```

### Android
```bash
# Assegura't que tens OpenSSL configurat a ~/Android/android_openssl/
cd dt06
mkdir build-android && cd build-android
qt-cmake -DANDROID_ABI=arm64-v8a ..
cmake --build .
```

## Ús de l'aplicació

### Primera execució
1. L'aplicació detecta que és la primera execució
2. Mostra automàticament la pantalla de configuració
3. Configura:
   - **MAC**: Adreça MAC del dispositiu (ex: 112233AABBCC)
   - **Broker**: URL del broker MQTT (ex: wss://broker.emqx.io:8084/mqtt)
   - **Usuari/Contrasenya**: Opcionals (buits per connexió anònima)
4. Desa la configuració

### Connexió MQTT
- **Auto-connexió**: Si hi ha configuració guardada, es connecta automàticament a l'inici
- **Manual**: Usa el botó "Connecta"/"Desconnecta" al panell superior
- L'aplicació s'subscriu automàticament als 4 temes dels LEDs quan es connecta

### Interacció
- **Botons**: Prem/allibera per publicar a MQTT (no canvien visualment)
- **LEDs**: Controlats només per missatges MQTT (no es poden clicar)

## Arquitectura tècnica

### Classes C++

**SettingsManager**:
- Gestiona la configuració amb QSettings
- Persistència de broker, MAC, credencials, rangs de sensors

**MqttBasic**:
- Wrapper de QMqttClient
- Gestió de connexió WebSocket (WebSocketIODevice)
- Publish/Subscribe bàsic
- Emissió de signals d'estat

**MqttController**:
- Capa d'aplicació entre QML i MQTT
- Gestiona estats de connexió
- Auto-subscripció als LEDs
- Publicació formatada dels botons
- Actualització d'estats dels LEDs

**WebSocketIODevice**:
- Adaptador QIODevice per QWebSocket
- Permet usar WebSocket com a transport MQTT

### Flux de dades

```
Botó premut → InteractiveButton.qml
            ↓
     mqttController.publishButtonPressed()
            ↓
     MqttController → MqttBasic → WebSocketIODevice
            ↓
        Broker MQTT
```

```
Broker MQTT → WebSocketIODevice → MqttBasic
            ↓
     MqttController.onMqttMessageReceived()
            ↓
     Signal ledXStateChanged()
            ↓
     InteractiveLed.qml (actualitza visualment)
```

## Configuració MQTT

### Brokers públics de prova
- **EMQX**: `wss://broker.emqx.io:8084/mqtt`
- **HiveMQ**: `wss://broker.hivemq.com:8884/mqtt`
- **Mosquitto** (local): `ws://localhost:9001`

### Format dels topics
La MAC serveix com a namespace únic per cada dispositiu:
```
/112233AABBCC/btIO0    (publicació)
/112233AABBCC/ledW     (subscripció)
```

## Proves amb MQTT Explorer

Per provar l'aplicació:

1. Connecta l'aplicació al broker
2. Obre MQTT Explorer i connecta al mateix broker
3. Subscriu-te a `/<teva_MAC>/#`
4. Prem botons a l'aplicació → veuràs els missatges
5. Publica `1` o `0` a `/<teva_MAC>/ledW` → veuràs el LED encendre's

## Idioma

Interfície en català amb tractament formal:
- Imperatius: "Connecta", "Desconnecta", "Desa"
- Forma de respecte: "Configureu", "Premeu"

## Notes de seguretat

- Contrasenyes emmagatzemades en text pla (QSettings)
- Per producció: considerar xifratge o keychains del sistema
- WebSocket Secure (WSS) requereix OpenSSL en Android

## Crèdits

Desenvolupat per Jordi Bataller (educador en DAM)
Qt 6.8+
Gener 2025
