import QtQuick
import QtQuick.Controls
import QtQuick.Layouts

ApplicationWindow {
    id: mainWindow
    width: 1024
    height: 768
    visible: true
    title: "Bessó digital de la placa IoT-02"
    
    Component.onCompleted: {
        // Si és la primera execució, mostra la configuració
        if (settingsManager.isFirstRun()) {
            stackView.push(configPage)
        }
    }
    
    StackView {
        id: stackView
        anchors.fill: parent
        initialItem: boardPage
        
        Component {
            id: boardPage
            
            Page {
                // Capçalera amb panell de connexió i botó de configuració
                header: Column {
                    width: parent.width
                    spacing: 0
                    
                    ToolBar {
                        width: parent.width
                        
                        RowLayout {
                            anchors.fill: parent
                            
                            Label {
                                text: "IoT-02"
                                font.pixelSize: 16
                                font.bold: true
                                Layout.fillWidth: true
                            }
                            
                            ToolButton {
                                text: "⚙"
                                font.pixelSize: 24
                                onClicked: stackView.push(configPage)
                            }
                        }
                    }
                    
                    // Panell de connexió MQTT
                    ConnectionPanel {
                        width: parent.width
                    }
                }
                
                // Contenidor principal amb la imatge de fons
                Item {
                    id: boardContainer
                    anchors.fill: parent
                    
                    Image {
                        id: boardImage
                        source: "qrc:/img/IoT-02.png"
                        anchors.fill: parent
                        fillMode: Image.PreserveAspectFit
                        
                        // Aquesta propietat calcula l'escala real de la imatge
                        property real imageScale: Math.min(
                            parent.width / sourceSize.width,
                            parent.height / sourceSize.height
                        )
                        
                        // Offset per centrar la imatge
                        property real xOffset: (parent.width - sourceSize.width * imageScale) / 2
                        property real yOffset: (parent.height - sourceSize.height * imageScale) / 2
                    }
                    
                    // Botons (3 botons blancs) amb MQTT
                    InteractiveButton {
                        id: btIO0
                        boardX: 282
                        boardY: 870
                        boardWidth: 44
                        boardHeight: 44
                        imageScale: boardImage.imageScale
                        xOffset: boardImage.xOffset
                        yOffset: boardImage.yOffset
                        mqttName: "btIO0"
                    }
                    
                    InteractiveButton {
                        id: btI34
                        boardX: btIO0.boardX + 3
                        boardY: btIO0.boardY + 95
                        boardWidth: btIO0.boardWidth
                        boardHeight: btIO0.boardHeight
                        imageScale: boardImage.imageScale
                        xOffset: boardImage.xOffset
                        yOffset: boardImage.yOffset
                        mqttName: "btI34"
                    }
                    
                    InteractiveButton {
                        id: btI35
                        boardX: btI34.boardX
                        boardY: btI34.boardY + 95
                        boardWidth: btIO0.boardWidth
                        boardHeight: btIO0.boardHeight
                        imageScale: boardImage.imageScale
                        xOffset: boardImage.xOffset
                        yOffset: boardImage.yOffset
                        mqttName: "btI35"
                    }
                    
                    // LEDs SMD (4 leds) controlats per MQTT
                    InteractiveLed {
                        id: ledW
                        boardX: 670
                        boardY: 840
                        boardWidth: 30
                        boardHeight: 50
                        imageScale: boardImage.imageScale
                        xOffset: boardImage.xOffset
                        yOffset: boardImage.yOffset
                        ledColor: "white"
                        mqttName: "ledW"
                    }
                    
                    InteractiveLed {
                        id: ledR
                        boardX: ledW.boardX
                        boardY: ledW.boardY + 72
                        boardWidth: 30
                        boardHeight: 50
                        imageScale: boardImage.imageScale
                        xOffset: boardImage.xOffset
                        yOffset: boardImage.yOffset
                        ledColor: "red"
                        mqttName: "ledR"
                    }
                    
                    InteractiveLed {
                        id: ledY
                        boardX: ledW.boardX
                        boardY: ledR.boardY + 72
                        boardWidth: 30
                        boardHeight: 50
                        imageScale: boardImage.imageScale
                        xOffset: boardImage.xOffset
                        yOffset: boardImage.yOffset
                        ledColor: "yellow"
                        mqttName: "ledY"
                    }
                    
                    InteractiveLed {
                        id: ledG
                        boardX: ledW.boardX
                        boardY: ledY.boardY + 72
                        boardWidth: 30
                        boardHeight: 50
                        imageScale: boardImage.imageScale
                        xOffset: boardImage.xOffset
                        yOffset: boardImage.yOffset
                        ledColor: "lime"
                        mqttName: "ledG"
                    }
                    
                    // Pantalla OLED (0.96" 128x64 píxels)
                    InteractiveOled {
                        id: oled
                        boardX: 354 // 400
                        boardY: 540 // 200
                        boardWidth: 346 // 236 // 64   // Escalat 50% de 128px
                        boardHeight: 173 // 128 // 32  // Escalat 50% de 64px
                        imageScale: boardImage.imageScale
                        xOffset: boardImage.xOffset
                        yOffset: boardImage.yOffset
                    }
                    // Sensor LDR
                    InteractiveLdr {
                        id: ldr
                        boardX: 337 // 60 // 500  // TEMPORAL - ajusta segons imatge
                        boardY: 1105 // 300  // TEMPORAL - ajusta segons imatge
                        boardWidth: 70
                        boardHeight: 70
                        imageScale: boardImage.imageScale
                        xOffset: boardImage.xOffset
                        yOffset: boardImage.yOffset
                    }
                    InteractiveBme280 {
                        id: bme280
                        boardX: 385 // 430 // 600
                        boardY: 300 // 400
                        boardWidth: 150
                        boardHeight: 150
                        imageScale: boardImage.imageScale
                        xOffset: boardImage.xOffset
                        yOffset: boardImage.yOffset
                    }
                }
            }
        }
        
        Component {
            id: configPage
            ConfigPage {}
        }
    }
}
