import QtQuick

Item {
    id: root
    
    property real boardX: 0
    property real boardY: 0
    property real boardWidth: 20
    property real boardHeight: 30
    property real imageScale: 1.0
    property real xOffset: 0
    property real yOffset: 0
    property bool isOn: false
    property color ledColor: "red"
    
    // Nom del LED per MQTT
    property string mqttName: ""
    
    // Mides escalades dinàmicament
    width: boardWidth * imageScale
    height: boardHeight * imageScale
    
    x: boardX * imageScale + xOffset
    y: boardY * imageScale + yOffset
    
    // Connexió amb MqttController per actualitzar l'estat
    Connections {
        target: mqttController
        
        function onLedWStateChanged() {
            if (root.mqttName === "ledW") {
                root.isOn = mqttController.ledWState
            }
        }
        
        function onLedRStateChanged() {
            if (root.mqttName === "ledR") {
                root.isOn = mqttController.ledRState
            }
        }
        
        function onLedYStateChanged() {
            if (root.mqttName === "ledY") {
                root.isOn = mqttController.ledYState
            }
        }
        
        function onLedGStateChanged() {
            if (root.mqttName === "ledG") {
                root.isOn = mqttController.ledGState
            }
        }
    }
    
    Rectangle {
        anchors.fill: parent
        radius: Math.min(width, height) / 2
        color: root.isOn ? root.ledColor : "#40FFFFFF"
        border.color: "black"
        border.width: 1 * imageScale
        
        // Efecte brillant quan està encès
        Rectangle {
            anchors.centerIn: parent
            width: parent.width * 0.6
            height: parent.height * 0.6
            radius: width / 2
            color: "white"
            opacity: root.isOn ? 0.6 : 0
        }
    }
}
