import QtQuick
import QtQuick.Controls

Item {
    id: root
    
    // Propietats per posicionament i mida en píxels de la imatge original
    property real boardX: 0
    property real boardY: 0
    property real boardWidth: 40
    property real boardHeight: 40
    
    // Propietats d'escala i offset
    property real imageScale: 1.0
    property real xOffset: 0
    property real yOffset: 0
    
    // Nom del botó per MQTT
    property string mqttName: ""
    
    // Estat del botó (premut o no)
    property bool isPressed: false
    
    signal pressed()
    signal released()
    
    // Mides escalades dinàmicament
    width: boardWidth * imageScale
    height: boardHeight * imageScale
    
    // Posicions escalades dinàmicament
    x: boardX * imageScale + xOffset
    y: boardY * imageScale + yOffset
    
    Rectangle {
        anchors.fill: parent
        color: root.isPressed ? "#80FFFFFF" : "#40FFFFFF"
        radius: Math.min(width, height) / 2
        border.color: "white"
        border.width: 2 * imageScale
        
        MouseArea {
            id: mouseArea
            anchors.fill: parent
            
            onClicked: {
                root.isPressed = !root.isPressed

                if (mqttController && root.mqttName !== "") {
                    mqttController.setButtonState(root.mqttName, root.isPressed)
                }

                if (root.isPressed) {
                    root.pressed()
                    if (mqttController && root.mqttName !== "") {
                        mqttController.publishButtonPressed(root.mqttName)
                    }
                } else {
                    root.released()
                    if (mqttController && root.mqttName !== "") {
                        mqttController.publishButtonReleased(root.mqttName)
                    }
                }
            }
        }
    }
    Rectangle {
        id: stateDisplay
        // x: -(width + (5 * imageScale))  // A l'esquerra amb marge de 5px
        x: -(width + (30 * imageScale))  // A l'esquerra amb marge de 5px
        y: (parent.height - height) / 2  // Centrat verticalment
        // width: stateText.width + (10 * imageScale)
        // height: stateText.height + (6 * imageScale)
        width: stateText.width + (30 * imageScale)
        height: stateText.height + (18 * imageScale)
        color: "#E0000000"
        radius: 3 * imageScale
        border.color: root.isPressed ? "#80FF80" : "#FF8080"
        border.width: 1 * imageScale
        visible: root.mqttName !== ""

        Text {
            id: stateText
            anchors.centerIn: parent
            text: root.mqttName + " " + (root.isPressed ? "PRESSED" : "RELEASED")
            color: root.isPressed ? "#80FF80" : "#FF8080"
            // font.pixelSize: 10 * imageScale
            font.pixelSize: 30 * imageScale
            font.family: "Monospace"
            horizontalAlignment: Text.AlignRight  // Justificat a la dreta dins el Text
        }
    }

}
