import QtQuick
import QtQuick.Controls
import QtQuick.Layouts

Rectangle {
    id: connectionPanel
    height: 60
    color: mqttController ? mqttController.connectionColor: "#F5F5F5"
    border.color: mqttController ? Qt.darker(mqttController.connectionColor, 1.3) : "#E0E0E0"
    border.width: 1
    
    RowLayout {
        anchors.centerIn: parent
        spacing: 20
        
        // Indicador visual d'estat
        Rectangle {
            width: 24
            height: 24
            radius: 12
            color: mqttController ? mqttController.connectionColor : "#757575"
            border.color: mqttController ? Qt.darker(mqttController.connectionColor, 1.3) : "#555555"
            border.width: 2
            
            // Animació de pulsació quan està connectant
            SequentialAnimation on opacity {
                running: mqttController && mqttController.connectionState === 1 // Connecting
                loops: Animation.Infinite
                NumberAnimation { to: 0.3; duration: 800 }
                NumberAnimation { to: 1.0; duration: 800 }
            }
            
            // Símbol dins del cercle
            Text {
                anchors.centerIn: parent
                text: {
                    if (!mqttController) return "○"
                    if (mqttController.connectionState === 2) return "●"
                    if (mqttController.connectionState === 1) return "◐"
                    return "○"
                }
                color: "white"
                font.pixelSize: 14
                font.bold: true
            }
        }
        
        // Text d'estat
        Label {
            text: mqttController ? mqttController.connectionText : "Desconnectat"
            font.pixelSize: 15
            font.bold: mqttController && mqttController.connectionState === 2
            color: mqttController ? mqttController.connectionColor : "#757575"
            Layout.minimumWidth: 120
        }
        
        // Botó de connexió/desconnexió
        Button {
            text: (mqttController && mqttController.connectionState === 2) ? "Desconnecta" : "Connecta"
            enabled: mqttController && mqttController.connectionState !== 1 // Disabled quan està connectant
            highlighted: mqttController ? (mqttController.connectionState === 0) : false

            onClicked: {
                if (!mqttController) return

                if (mqttController.connectionState === 2) {
                    mqttController.disconnectFromBroker()
                } else {
                    mqttController.connectToBroker()
                }
            }
        }
    }
}
