import QtQuick
import QtQuick.Controls
import QtQuick.Layouts

Page {
    id: root
    
    signal configSaved()
    
    header: ToolBar {
        RowLayout {
            anchors.fill: parent
            
            ToolButton {
                text: "←"
                font.pixelSize: 24
                onClicked: {
                    settingsManager.cancel()
                    stackView.pop()
                }
            }
            
            Label {
                text: "Configuració"
                font.pixelSize: 18
                font.bold: true
                Layout.fillWidth: true
            }
        }
    }
    
    ScrollView {
        anchors.fill: parent
        contentWidth: availableWidth
        
        ColumnLayout {
            width: parent.width
            spacing: 20
            anchors.margins: 20
            
            // Botons d'acció
            RowLayout {
                Layout.fillWidth: true
                Layout.margins: 10
                spacing: 10

                Item { Layout.fillWidth: true }

                Button {
                    text: "Cancel·la"
                    onClicked: {
                        settingsManager.cancel()
                        stackView.pop()
                    }
                }

                Button {
                    text: "Desa i tanca"
                    highlighted: true
                    onClicked: {
                        settingsManager.save()
                        savedPopup.open()
                    }
                }
            }

            // Secció MQTT
            GroupBox {
                title: "Connexió MQTT"
                Layout.fillWidth: true
                Layout.margins: 10
                
                ColumnLayout {
                    anchors.fill: parent
                    spacing: 15
                    
                    ColumnLayout {
                        spacing: 5
                        Layout.fillWidth: true
                        
                        Label {
                            text: "Adreça MAC:"
                            font.pixelSize: 14
                        }
                        
                        TextField {
                            id: macField
                            Layout.fillWidth: true
                            text: settingsManager ? settingsManager.mqttMac : ""
                            placeholderText: "112233AABBCC o 11:22:33:AA:BB:CC"
                            onTextChanged: if (settingsManager) settingsManager.mqttMac = text

                            validator: RegularExpressionValidator {
                                regularExpression: /^([0-9A-Fa-f]{2}[:]?){0,5}[0-9A-Fa-f]{0,2}$/
                            }
                        }
                    }
                    
                    ColumnLayout {
                        spacing: 5
                        Layout.fillWidth: true
                        
                        Label {
                            text: "Broker:"
                            font.pixelSize: 14
                        }
                        
                        TextField {
                            id: brokerField
                            Layout.fillWidth: true
                            text: settingsManager ? settingsManager.mqttBroker : ""
                            placeholderText: "wss://broker.emqx.io:8084/mqtt"
                            onTextChanged: if (settingsManager) settingsManager.mqttBroker = text
                        }
                    }
                    
                    ColumnLayout {
                        spacing: 5
                        Layout.fillWidth: true
                        
                        Label {
                            text: "Usuari:"
                            font.pixelSize: 14
                        }
                        
                        TextField {
                            id: userField
                            Layout.fillWidth: true
                            text: settingsManager ? settingsManager.mqttUser : ""
                            placeholderText: "Deixa en blanc per a connexió anònima"
                            onTextChanged: if (settingsManager) settingsManager.mqttUser = text
                        }
                    }
                    
                    ColumnLayout {
                        spacing: 5
                        Layout.fillWidth: true
                        
                        Label {
                            text: "Contrasenya:"
                            font.pixelSize: 14
                        }
                        
                        RowLayout {
                            Layout.fillWidth: true
                            
                            TextField {
                                id: passwordField
                                Layout.fillWidth: true
                                text: settingsManager ? settingsManager.mqttPassword : ""
                                echoMode: TextInput.Password
                                placeholderText: "Deixa en blanc per a connexió anònima"
                                onTextChanged: if (settingsManager) settingsManager.mqttPassword = text
                            }
                            
                            Button {
                                text: passwordField.echoMode === TextInput.Password ? "👁" : "🔒"
                                onClicked: {
                                    passwordField.echoMode = passwordField.echoMode === TextInput.Password 
                                                             ? TextInput.Normal 
                                                             : TextInput.Password
                                }
                            }
                        }
                    }
                }
            }
            
            // Secció Sensors Aleatoris
            GroupBox {
                title: "Sensors aleatoris"
                Layout.fillWidth: true
                Layout.margins: 10
                
                ColumnLayout {
                    anchors.fill: parent
                    spacing: 20
                    
                    // LDR
                    ColumnLayout {
                        Layout.fillWidth: true
                        spacing: 10
                        
                        CheckBox {
                            id: ldrRandomCheck
                            text: "LDR aleatori"
                            checked: settingsManager ? settingsManager.ldrRandom : false
                            onCheckedChanged: if (settingsManager) settingsManager.ldrRandom = checked
                        }
                        
                        RangeSelector {
                            Layout.fillWidth: true
                            Layout.leftMargin: 30
                            enabled: ldrRandomCheck.checked
                            opacity: enabled ? 1.0 : 0.5
                            
                            label: "Ventall LDR"
                            unit: ""
                            absoluteMin: 0
                            absoluteMax: 4095
                            minValue: settingsManager ? settingsManager.ldrMin : 0
                            maxValue: settingsManager ? settingsManager.ldrMax : 4095
                            onMinValueChanged: if (settingsManager) settingsManager.ldrMin = minValue
                            onMaxValueChanged: if (settingsManager) settingsManager.ldrMax = maxValue
                        }
                    }
                    
                    Rectangle {
                        Layout.fillWidth: true
                        height: 1
                        color: "#E0E0E0"
                    }
                    
                    // BME280
                    ColumnLayout {
                        Layout.fillWidth: true
                        spacing: 10
                        
                        CheckBox {
                            id: bmeRandomCheck
                            text: "BME280 aleatori"
                            checked: settingsManager ? settingsManager.bmeRandom : false
                            onCheckedChanged: if (settingsManager) settingsManager.bmeRandom = checked
                        }
                        
                        RangeSelector {
                            Layout.fillWidth: true
                            Layout.leftMargin: 30
                            enabled: bmeRandomCheck.checked
                            opacity: enabled ? 1.0 : 0.5
                            
                            label: "Temperatura"
                            unit: "°C"
                            absoluteMin: -40
                            absoluteMax: 85
                            minValue: settingsManager ? settingsManager.tempMin : 15
                            maxValue: settingsManager ? settingsManager.tempMax : 30
                            onMinValueChanged: if (settingsManager) settingsManager.tempMin = minValue
                            onMaxValueChanged: if (settingsManager) settingsManager.tempMax = maxValue
                        }
                        
                        RangeSelector {
                            Layout.fillWidth: true
                            Layout.leftMargin: 30
                            enabled: bmeRandomCheck.checked
                            opacity: enabled ? 1.0 : 0.5
                            
                            label: "Humitat"
                            unit: "%"
                            absoluteMin: 0
                            absoluteMax: 100
                            minValue: settingsManager ? settingsManager.rhMin : 30
                            maxValue: settingsManager ? settingsManager.rhMax : 70
                            onMinValueChanged: if (settingsManager) settingsManager.rhMin = minValue
                            onMaxValueChanged: if (settingsManager) settingsManager.rhMax = maxValue
                        }
                        
                        RangeSelector {
                            Layout.fillWidth: true
                            Layout.leftMargin: 30
                            enabled: bmeRandomCheck.checked
                            opacity: enabled ? 1.0 : 0.5
                            
                            label: "Pressió"
                            unit: "hPa"
                            absoluteMin: 300
                            absoluteMax: 1100
                            minValue: settingsManager ? settingsManager.pressureMin : 900
                            maxValue: settingsManager ? settingsManager.pressureMax : 1020
                            onMinValueChanged: if (settingsManager) settingsManager.pressureMin = minValue
                            onMaxValueChanged: if (settingsManager) settingsManager.pressureMax = maxValue
                        }
                    }
                }
            }
            
            // // Botons d'acció
            // RowLayout {
            //     Layout.fillWidth: true
            //     Layout.margins: 10
            //     spacing: 10
                
            //     Item { Layout.fillWidth: true }
                
            //     Button {
            //         text: "Cancel·la"
            //         onClicked: {
            //             settingsManager.cancel()
            //             stackView.pop()
            //         }
            //     }
                
            //     Button {
            //         text: "Desa i tanca"
            //         highlighted: true
            //         onClicked: {
            //             settingsManager.save()
            //             savedPopup.open()
            //         }
            //     }
            // }
            
            Item { Layout.fillHeight: true }
        }
    }
    
    // Popup de confirmació
    Popup {
        id: savedPopup
        anchors.centerIn: parent
        width: 300
        height: 120
        modal: true
        closePolicy: Popup.NoAutoClose
        
        ColumnLayout {
            anchors.centerIn: parent
            spacing: 15
            
            Label {
                text: "✓ Configuració desada correctament"
                font.pixelSize: 16
                Layout.alignment: Qt.AlignHCenter
            }
        }
        
        Timer {
            interval: 1500
            running: savedPopup.opened
            onTriggered: {
                savedPopup.close()
                stackView.pop()
                root.configSaved()
            }
        }
    }
}
