#include <lvgl/lvgl.h>

/*******************************************************************************
 * Size: 32 px
 * Bpp: 3
 * Opts: --font ../font/liquid_crystal/LiquidCrystal-Normal.ttf -r 0x20-0x7F --size 32 --format lvgl --bpp 3 --lv-include lvgl/lvgl.h  -o liquidCrystal_nor_32.c
 ******************************************************************************/

#ifndef LIQUIDCRYSTAL_NOR_32
#define LIQUIDCRYSTAL_NOR_32 1
#endif

#if LIQUIDCRYSTAL_NOR_32

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x14, 0x65, 0x80, 0xff, 0xe7, 0xb0, 0xec, 0xa0,
    0x56, 0x56, 0x18, 0x1f, 0xfc, 0x36, 0x1d, 0x74,
    0x71, 0x26, 0x50,

    /* U+22 "\"" */
    0x3, 0xcb, 0x11, 0x9c, 0x35, 0x98, 0x7, 0xff,
    0x2, 0x8a, 0x83, 0x6e, 0x4b, 0xc0,

    /* U+24 "$" */
    0x0, 0xff, 0xfe, 0x20, 0x46, 0x1, 0x16, 0x6,
    0x80, 0x16, 0x69, 0x4d, 0xc9, 0x4f, 0x88, 0x15,
    0xb2, 0x6, 0xd4, 0x21, 0x81, 0xff, 0x10, 0x8,
    0xf, 0xfe, 0x6, 0xa4, 0xf, 0xc4, 0x8, 0xa0,
    0x3f, 0xfe, 0x30, 0x3b, 0x64, 0x2, 0xd4, 0x2,
    0x59, 0x2c, 0xeb, 0x48, 0xe0, 0x11, 0x80, 0x4a,
    0x20, 0x23, 0x40, 0x9f, 0xf3, 0x25, 0xfb, 0x24,
    0x60, 0x7f, 0xfe, 0x8, 0x1f, 0x50, 0x3f, 0xf8,
    0x35, 0x50, 0x3f, 0xf8, 0xc, 0x30, 0x3f, 0xf8,
    0x10, 0x2b, 0x64, 0xd, 0xa8, 0x43, 0x59, 0xa5,
    0x37, 0x25, 0x3e, 0x0, 0xc0, 0x22, 0xc0, 0xd0,
    0x0,

    /* U+27 "'" */
    0x2, 0x7c, 0xc1, 0x0, 0xf2, 0x1a, 0xc6,

    /* U+28 "(" */
    0x0, 0x7f, 0x30, 0x6, 0x0, 0x80, 0xe0, 0x92,
    0x84, 0x14, 0xa8, 0xf, 0xff, 0x49, 0x3, 0x1c,
    0x7, 0xff, 0x0, 0xe0, 0x3e, 0x20, 0x7f, 0xfa,
    0x18, 0x32, 0xa0, 0x19, 0xa4, 0xa4, 0x18, 0x1,
    0x90,

    /* U+29 ")" */
    0x17, 0xe0, 0x22, 0x81, 0x80, 0xd, 0x4d, 0x60,
    0xa, 0xe2, 0x48, 0xf, 0xff, 0x43, 0x3, 0xc6,
    0x90, 0x3f, 0xe3, 0x48, 0x19, 0x81, 0xff, 0xe9,
    0x57, 0x92, 0x46, 0xa5, 0x60, 0x58, 0x30, 0x0,

    /* U+2A "*" */
    0x6c, 0xc, 0x56, 0x5c, 0xca, 0x3, 0x2a, 0xf3,
    0x63, 0x1e, 0x6c, 0x98, 0xe8, 0x10,

    /* U+2B "+" */
    0x3, 0x91, 0x3, 0xf8, 0xdc, 0x40, 0xfc, 0xc0,
    0x30, 0x3f, 0x10, 0x3f, 0x1b, 0x5c, 0x96, 0xb4,
    0x5, 0x92, 0x34, 0x8d, 0x26, 0x1, 0x40, 0x13,
    0x80, 0x40, 0xb, 0xf4, 0x49, 0xfc, 0x80, 0xfc,
    0xc0, 0xff, 0xe4, 0x26, 0xc8, 0xf, 0xe9, 0x0,
    0x70,

    /* U+2C "," */
    0x3, 0x9d, 0x6, 0x26, 0x4, 0x58, 0x68, 0x38,
    0x14, 0x0,

    /* U+2E "." */
    0x3, 0xa4, 0x4, 0xd9, 0x1, 0x94, 0x84,

    /* U+2F "/" */
    0x3, 0xff, 0x81, 0xf8, 0x81, 0xff, 0x30, 0x3f,
    0xf8, 0x50, 0x1, 0x3, 0xfc, 0xc0, 0x40, 0x3f,
    0xe8, 0x1, 0x81, 0xfe, 0x80, 0x20, 0x1f, 0xf3,
    0x0, 0xc0, 0xff, 0x40, 0x10, 0xf, 0xf9, 0x80,
    0x60, 0x7f, 0xa0, 0x8, 0x7, 0xfc, 0x40, 0x30,
    0x3f, 0xf8, 0x30, 0xf, 0xfe, 0x1, 0x26, 0x7,
    0xfa, 0x69, 0x80, 0xff, 0x16, 0x40, 0xff, 0xe0,
    0x50, 0x3f, 0xf8, 0x25, 0x82, 0x7, 0xfd, 0x0,
    0x40, 0x3f, 0xc5, 0x2, 0x80, 0xff, 0x40, 0x10,
    0xf, 0xf1, 0x40, 0xa0, 0x3f, 0xd0, 0x4, 0x3,
    0xfc, 0x50, 0x48, 0x7, 0xfa, 0x0, 0x80, 0x7f,
    0xcc, 0x22, 0x7, 0xff, 0x6, 0x1, 0xff, 0xc0,

    /* U+30 "0" */
    0x0, 0xbf, 0xfe, 0x20, 0x46, 0x81, 0xfd, 0x8,
    0x59, 0x2f, 0xf0, 0xc7, 0x85, 0x6f, 0xe8, 0x85,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0x48, 0x84, 0x7,
    0xe2, 0x3, 0x48, 0xa0, 0x7f, 0x68, 0x80, 0xff,
    0xe1, 0xc8, 0xc0, 0x7f, 0x68, 0x88, 0x20, 0x7e,
    0x20, 0x30, 0x1f, 0xff, 0xf0, 0x3f, 0xfa, 0x5c,
    0x2b, 0x7f, 0x44, 0x2a, 0xc9, 0x7f, 0x86, 0x20,
    0xd0, 0x3f, 0xa1, 0x0,

    /* U+31 "1" */
    0x3, 0x46, 0x6, 0x4e, 0x10, 0x13, 0x0, 0x62,
    0x30, 0x32, 0x60, 0x71, 0x1, 0xc0, 0x99, 0xa0,
    0x76, 0x40, 0x7f, 0xf4, 0x10, 0x6, 0x4, 0x6e,
    0x20, 0x7f, 0x8d, 0xc4, 0x9, 0x0, 0x60, 0x7f,
    0xfb, 0xc8, 0x6, 0x4, 0x9c, 0x20,

    /* U+32 "2" */
    0x0, 0xbf, 0xfe, 0x20, 0x46, 0x81, 0xfd, 0x8,
    0x59, 0x2f, 0xf3, 0xc7, 0x85, 0x6f, 0xe8, 0x45,
    0xc1, 0x1, 0xff, 0xc0, 0x72, 0x81, 0xff, 0xc1,
    0x60, 0x7f, 0xff, 0xcd, 0xbf, 0xa1, 0x14, 0x6,
    0x4b, 0xf9, 0xf2, 0x5d, 0x1, 0xfd, 0x0, 0x40,
    0xbf, 0xfe, 0x20, 0x7f, 0xff, 0xc0, 0xff, 0xf2,
    0xab, 0x7f, 0x80, 0xc9, 0x7f, 0xd8, 0x6, 0x40,
    0x7f, 0x8e, 0x0,

    /* U+33 "3" */
    0x13, 0xff, 0xea, 0x4, 0x58, 0x1f, 0xc9, 0x80,
    0x35, 0x2f, 0xe7, 0x28, 0x5, 0x6f, 0xf7, 0x8,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xaa, 0xed, 0xfb,
    0x84, 0x40, 0x28, 0x97, 0xce, 0x50, 0x24, 0x80,
    0x7c, 0x6b, 0x3, 0x5f, 0xfe, 0xa6, 0x10, 0x3f,
    0xff, 0xe0, 0x7f, 0xf8, 0x95, 0xbf, 0xdc, 0x22,
    0x55, 0x2f, 0xe7, 0x28, 0x2c, 0xf, 0xe4, 0xc0,
    0x0,

    /* U+34 "4" */
    0x3, 0xff, 0x9f, 0x79, 0x14, 0xf, 0xe2, 0x85,
    0x8b, 0x1, 0xff, 0xc0, 0x20, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xbd, 0xc2, 0xb7, 0xf4, 0x22, 0xac,
    0x97, 0xf9, 0xe2, 0xd, 0x3, 0xfd, 0x0, 0x97,
    0xff, 0xb2, 0x46, 0x7, 0xff, 0xb, 0x81, 0xff,
    0xff, 0x3, 0xff, 0xd8, 0x48, 0x60, 0x3f, 0xf8,
    0x1a, 0xa0,

    /* U+35 "5" */
    0x7f, 0xff, 0xf0, 0x30, 0xcc, 0xf, 0xf1, 0xc0,
    0x1b, 0x25, 0xfd, 0x80, 0xce, 0xdf, 0xe0, 0x3f,
    0xff, 0xe0, 0x7f, 0xf5, 0xd5, 0xbf, 0xc0, 0x5e,
    0x25, 0xfe, 0xa0, 0x13, 0xa0, 0x7f, 0x1a, 0x4,
    0xbf, 0xfd, 0x9a, 0x80, 0x7f, 0xff, 0xc5, 0x3,
    0xff, 0x83, 0x16, 0x3, 0xff, 0x80, 0x41, 0x3,
    0xff, 0x81, 0xc3, 0xb7, 0xf4, 0x42, 0xac, 0xd2,
    0xfe, 0x18, 0x83, 0x40, 0xfe, 0x84, 0x0,

    /* U+36 "6" */
    0x0, 0xbf, 0xfe, 0x20, 0x46, 0x81, 0xfd, 0x0,
    0x2c, 0x97, 0xfa, 0x80, 0xe1, 0x5b, 0xfc, 0x7,
    0xff, 0xfc, 0xf, 0xfe, 0xba, 0xb7, 0xf8, 0xb,
    0x34, 0xbf, 0xd4, 0x6, 0x6c, 0x7, 0xf1, 0xa0,
    0x4f, 0xff, 0xd9, 0xa6, 0x7, 0xff, 0xb, 0x81,
    0xff, 0xff, 0x3, 0xff, 0xa5, 0xc2, 0xb7, 0xf4,
    0x42, 0xac, 0x97, 0xf8, 0x62, 0xd, 0x3, 0xfa,
    0x10,

    /* U+37 "7" */
    0x13, 0xff, 0xf9, 0x2, 0xc0, 0xff, 0xa0, 0x35,
    0x2f, 0xfb, 0x80, 0x56, 0xff, 0x89, 0x1, 0xff,
    0xc0, 0x64, 0xf, 0xfe, 0xc, 0x3, 0xff, 0x82,
    0xc0, 0xff, 0xe1, 0x40, 0x3f, 0xf8, 0x2c, 0x6,
    0x3, 0xfe, 0x80, 0xb0, 0x3f, 0xc4, 0x4, 0x3,
    0xfe, 0x60, 0xa0, 0x3f, 0xe6, 0x60, 0x1f, 0xe3,
    0x9e, 0x40, 0x7f, 0xa1, 0x20, 0x3f, 0xe2, 0x80,
    0xff, 0xe0, 0xc0, 0x8, 0xf, 0xf1, 0x41, 0x10,
    0x3f, 0xd0, 0x4, 0x3, 0xfc, 0x50, 0x44, 0xf,
    0xf7, 0x1, 0x0, 0xff, 0x22, 0x11, 0x3, 0xfd,
    0x0, 0x40, 0x3f, 0xc8, 0x84, 0x40, 0xff, 0x10,
    0x10, 0xf, 0xfe, 0xa, 0x20, 0x7f, 0x80,

    /* U+38 "8" */
    0x0, 0xbf, 0xfe, 0x20, 0x46, 0x81, 0xfd, 0x8,
    0x59, 0x2f, 0xf3, 0xc7, 0x85, 0x6f, 0xe8, 0x45,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0x4b, 0x85, 0x6f,
    0xe8, 0x45, 0x59, 0x2f, 0xf3, 0xc4, 0xbb, 0x3,
    0xfd, 0x4, 0x2f, 0xff, 0xd9, 0x23, 0x3, 0xff,
    0x85, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xd2, 0xe1,
    0x5b, 0xfa, 0x21, 0x56, 0x4b, 0xfc, 0x31, 0x6,
    0x81, 0xfd, 0x8,

    /* U+39 "9" */
    0x0, 0xbf, 0xfe, 0x20, 0x46, 0x81, 0xfd, 0x8,
    0x59, 0x2f, 0xf3, 0xc7, 0x85, 0x6f, 0xe8, 0x45,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0x4b, 0x85, 0x6f,
    0xe8, 0x40, 0x2c, 0x97, 0xf9, 0xb6, 0x6, 0x81,
    0xfe, 0x78, 0x2, 0xff, 0xf6, 0x40, 0x7f, 0xff,
    0xc0, 0xff, 0xf2, 0x9b, 0x7f, 0x44, 0x28, 0xc,
    0x97, 0xf0, 0xc4, 0x5, 0x3, 0xfa, 0x10,

    /* U+3A ":" */
    0x2, 0x5c, 0xd1, 0x8, 0x39, 0xc1, 0x0, 0xff,
    0x1c, 0x39, 0xa0, 0x5d, 0x50,

    /* U+3B ";" */
    0x2, 0x5d, 0x41, 0x18, 0x75, 0xd1, 0x0, 0xff,
    0x1c, 0x79, 0xe0, 0x63, 0x9e, 0x14, 0x0,

    /* U+3C "<" */
    0x3, 0x20, 0x28, 0x40, 0x16, 0x5, 0x0, 0x8a,
    0x2, 0x80, 0x11, 0x41, 0x98, 0x2, 0x86, 0x11,
    0x2, 0x80, 0x13, 0x20, 0x13, 0x3, 0xa0, 0x19,
    0x80, 0x80, 0x20, 0x44, 0x30, 0x10, 0x3, 0x8,
    0x81, 0xb8, 0x18, 0xa0, 0x34, 0x0,

    /* U+3D "=" */
    0x3f, 0xff, 0x21, 0x0, 0xfe, 0x82, 0xa5, 0xfd,
    0x80, 0x5b, 0xfc, 0x7, 0xff, 0xfc, 0xf, 0xfe,
    0x5, 0xbf, 0xc0, 0x2a, 0x5f, 0xd8, 0x40, 0x3f,
    0xa0,

    /* U+3E ">" */
    0x60, 0x6a, 0x40, 0xd0, 0xc, 0x88, 0x1b, 0x80,
    0xa0, 0xa0, 0xc0, 0x40, 0xc, 0x14, 0x20, 0x2,
    0x1, 0x81, 0xaa, 0x20, 0x12, 0x10, 0x10, 0x9,
    0x80, 0x22, 0x0, 0x4c, 0x4, 0x14, 0x16, 0x5,
    0x0, 0x8a, 0x2, 0x80, 0x49, 0x0, 0x80,

    /* U+3F "?" */
    0x1f, 0xff, 0x30, 0x10, 0xf, 0xea, 0x84, 0x69,
    0x7e, 0x75, 0x89, 0x6f, 0xe4, 0x28, 0x1f, 0xff,
    0xf0, 0x3f, 0xf9, 0x7b, 0xe6, 0x20, 0x1e, 0xc4,
    0x17, 0x90, 0x1d, 0x90, 0x14, 0x20, 0x75, 0x2f,
    0xf9, 0x81, 0xff, 0xff, 0x3, 0xfb, 0x86, 0x7,
    0xf9, 0x68, 0x7, 0xfd, 0xd0, 0x1f, 0xe4, 0x78,
    0x1f, 0xe5, 0x68, 0xf, 0x0,

    /* U+41 "A" */
    0x0, 0xbf, 0xfe, 0x20, 0x46, 0x81, 0xfd, 0x8,
    0x79, 0xa5, 0xfc, 0xf1, 0xa1, 0x5b, 0xfa, 0x11,
    0x40, 0xff, 0xff, 0x81, 0xff, 0xd4, 0x76, 0xfe,
    0x84, 0x2, 0x89, 0x7f, 0x9b, 0x65, 0x18, 0x1f,
    0xc5, 0xe0, 0xb, 0xff, 0xd9, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xe4, 0x82, 0x3, 0xf1, 0x21, 0xa4,
    0x80, 0xfe, 0xd5, 0x0,

    /* U+42 "B" */
    0x7f, 0xff, 0xc4, 0x5, 0x60, 0x7f, 0xa0, 0x13,
    0x64, 0xbf, 0x9f, 0x2, 0x56, 0xfe, 0x84, 0x30,
    0x3f, 0xff, 0xe0, 0x7f, 0xf5, 0x15, 0xbf, 0xa1,
    0x26, 0x9b, 0x25, 0xfe, 0xc1, 0x34, 0x7, 0xf1,
    0xa0, 0x4f, 0xff, 0xd9, 0x23, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0x8d, 0x5b, 0xfa, 0x10, 0xc3, 0x64,
    0xbf, 0x9f, 0x15, 0x81, 0xfe, 0x80, 0x0,

    /* U+43 "C" */
    0x0, 0xff, 0xfd, 0x80, 0xc6, 0x1, 0xf8, 0xd0,
    0xf, 0x34, 0xbf, 0x9e, 0x14, 0x2b, 0x7f, 0x72,
    0x4c, 0xf, 0xf9, 0x80, 0x40, 0x7f, 0xc6, 0xd1,
    0x3, 0xff, 0x80, 0x90, 0xf, 0xff, 0x9b, 0x3,
    0xff, 0x80, 0xd5, 0x3, 0xff, 0x9e, 0xd5, 0x3,
    0xff, 0x84, 0xc0, 0xff, 0xff, 0x81, 0xfc, 0x90,
    0xf, 0xfe, 0x1, 0xb4, 0x40, 0xff, 0x98, 0x5,
    0x2, 0xb7, 0xf7, 0x24, 0xd6, 0x69, 0x7f, 0x3c,
    0x0, 0xc0, 0x3f, 0x1a, 0x0,

    /* U+44 "D" */
    0x7f, 0xff, 0xc4, 0x5, 0x60, 0x7f, 0xa0, 0x13,
    0x64, 0xbf, 0x9e, 0x2, 0x56, 0xfe, 0x84, 0x98,
    0x1f, 0xff, 0xf0, 0x3f, 0xfa, 0x8c, 0xf, 0xfe,
    0x3, 0x54, 0xf, 0xc7, 0x10, 0x3f, 0xf8, 0x65,
    0xaa, 0x7, 0xe3, 0x89, 0x0, 0x60, 0x7f, 0xff,
    0xc0, 0xff, 0xf0, 0x2b, 0x7f, 0x42, 0x18, 0x6c,
    0x97, 0xf3, 0xe2, 0xb0, 0x3f, 0xd0, 0x0,

    /* U+45 "E" */
    0x0, 0xff, 0xfd, 0x80, 0x18, 0x7, 0xe3, 0x1e,
    0x69, 0x7e, 0x72, 0x85, 0x6f, 0xe8, 0x7, 0xff,
    0xfc, 0xf, 0xfe, 0x3b, 0xb7, 0xe0, 0x24, 0xd2,
    0xfd, 0x40, 0x26, 0x80, 0xfa, 0x1, 0x9f, 0xff,
    0x10, 0x3f, 0xff, 0xe0, 0x7f, 0xf4, 0xe0, 0x56,
    0xfe, 0x81, 0x66, 0x97, 0xe7, 0x1, 0x80, 0x7e,
    0x30,

    /* U+46 "F" */
    0x0, 0xff, 0xfd, 0x80, 0x18, 0x7, 0xe3, 0x1e,
    0x69, 0x7e, 0x72, 0x85, 0x6f, 0xe8, 0x7, 0xff,
    0xfc, 0xf, 0xfe, 0x3b, 0xb7, 0xe0, 0x24, 0xd2,
    0xfd, 0x40, 0x26, 0x80, 0xfa, 0x1, 0x9f, 0xff,
    0x10, 0x3f, 0xff, 0xe0, 0x7f, 0xf8, 0x10, 0x40,
    0x7f, 0xa4, 0x80, 0xff, 0x0,

    /* U+47 "G" */
    0x0, 0xff, 0xfd, 0x80, 0xc6, 0x1, 0xf8, 0xc0,
    0xf, 0x34, 0xbf, 0x38, 0x2, 0x85, 0x6f, 0xe8,
    0x7, 0xff, 0xfc, 0xf, 0xfe, 0xbd, 0x3, 0x9d,
    0xba, 0x5, 0x18, 0x18, 0xc4, 0xa6, 0x5a, 0x84,
    0xc, 0x50, 0x2, 0xd0, 0x17, 0x3, 0xaf, 0xe8,
    0x80, 0xff, 0xff, 0x81, 0xff, 0xe3, 0x81, 0x5b,
    0xfb, 0x92, 0x6b, 0x34, 0xbf, 0x9e, 0x0, 0x60,
    0x1f, 0x8d, 0x0,

    /* U+48 "H" */
    0x4, 0xf, 0xfe, 0xa, 0xc8, 0xf, 0xeb, 0x84,
    0x10, 0xf, 0xc9, 0xb, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xc9, 0xdb, 0xfb, 0x90, 0x9, 0xa5, 0xff,
    0xc0, 0x29, 0xa0, 0x3f, 0x12, 0x44, 0x3, 0xff,
    0xf4, 0x40, 0x7f, 0xff, 0xc0, 0xff, 0xf9, 0x20,
    0x80, 0xfc, 0x80, 0x29, 0x20, 0x3f, 0xb5, 0x20,

    /* U+49 "I" */
    0x14, 0x65, 0x80, 0xff, 0xe7, 0xb0, 0xec, 0xa0,
    0x56, 0x56, 0x18, 0x1f, 0xfc, 0xc6, 0x2, 0xac,

    /* U+4A "J" */
    0x3, 0xf4, 0xfe, 0x20, 0x7f, 0x16, 0x5, 0x0,
    0xfe, 0x35, 0x29, 0xe0, 0x3f, 0x95, 0xa8, 0x49,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xd8, 0x71, 0x3,
    0xff, 0x86, 0x40, 0xff, 0x8e, 0x24, 0x7, 0xff,
    0xfc, 0x40, 0x3f, 0xf8, 0x35, 0xd0, 0x3f, 0xf8,
    0xc, 0x30, 0x3f, 0xf8, 0x10, 0x2b, 0x7f, 0x42,
    0x1a, 0xcd, 0x2f, 0xf7, 0x0, 0x60, 0x1f, 0x8c,
    0x0,

    /* U+4B "K" */
    0x34, 0xf, 0xf5, 0xeb, 0xac, 0x7, 0xe4, 0x80,
    0x7f, 0xf0, 0x60, 0x6, 0x7, 0xf9, 0x10, 0xc8,
    0x1f, 0xea, 0x2, 0x1, 0xfe, 0x60, 0x18, 0x1f,
    0xf4, 0x1, 0x0, 0xff, 0x40, 0x10, 0xf, 0xf1,
    0x60, 0xb0, 0x3f, 0xd0, 0x4, 0x3, 0xfc, 0x50,
    0x28, 0xf, 0x3b, 0x70, 0xe, 0x7, 0x26, 0x97,
    0x36, 0x20, 0x72, 0x68, 0x9, 0x36, 0x3, 0xf3,
    0xff, 0x0, 0x80, 0x7f, 0xcc, 0x3, 0x3, 0xff,
    0x81, 0x0, 0x40, 0x3f, 0xe6, 0x43, 0x20, 0x7f,
    0xd0, 0x4, 0x3, 0xfe, 0x44, 0x22, 0x7, 0xfd,
    0x0, 0x40, 0x3f, 0xe4, 0x42, 0x20, 0x7f, 0xdc,
    0x4, 0x3, 0xfe, 0x28, 0x22, 0xc0, 0xff, 0x40,
    0xe, 0xac, 0x7, 0xe2, 0x80, 0x0,

    /* U+4C "L" */
    0x10, 0xf, 0xfa, 0xba, 0x7, 0xf9, 0x86, 0x7,
    0xff, 0xfc, 0xf, 0xfe, 0xeb, 0x3, 0xfe, 0x34,
    0xf, 0xfe, 0x61, 0xa0, 0x7f, 0xf0, 0x18, 0x1f,
    0xff, 0xf0, 0x3f, 0xf9, 0xd0, 0x2b, 0x7f, 0x40,
    0xb3, 0x4b, 0xf3, 0x80, 0xc0, 0x3f, 0x18,

    /* U+4D "M" */
    0x0, 0xff, 0xfd, 0x80, 0x6f, 0xff, 0x40, 0x23,
    0x0, 0xfc, 0x6c, 0x20, 0x7e, 0x68, 0x3c, 0xd2,
    0xfe, 0x69, 0xa5, 0xf9, 0xd9, 0x42, 0xb7, 0xf7,
    0x25, 0xed, 0xfc, 0x43, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xfc, 0xf, 0xfe, 0xb3, 0x3, 0xf3, 0x0,
    0x80, 0xfc, 0x40, 0x35, 0x40, 0xfc, 0x6d, 0x10,
    0x3f, 0x46, 0x0, 0x81, 0xfe, 0x60, 0x7f, 0xf0,
    0xb, 0x68, 0x7, 0xe3, 0xa9, 0x3, 0xf3, 0x62,
    0x1, 0x1, 0xf9, 0x80, 0x40, 0x7e, 0xc0, 0x7f,
    0xff, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xfb, 0x60,
    0x8, 0x1f, 0xf7, 0x3c, 0xf, 0xc6, 0x24, 0x3,
    0xf5, 0x38, 0xe2, 0x7, 0xf3, 0xa0, 0x7f, 0xb1,

    /* U+4E "N" */
    0x3, 0xff, 0x86, 0x71, 0x3, 0xfa, 0x40, 0xe7,
    0x81, 0xf8, 0xb6, 0x40, 0x5f, 0x1, 0xe6, 0x0,
    0x81, 0x8e, 0x3, 0xff, 0x80, 0x41, 0xc0, 0x7f,
    0xd8, 0x83, 0x80, 0xff, 0xb1, 0x7, 0x1, 0xff,
    0x62, 0xe, 0x3, 0xfe, 0xc4, 0x1c, 0x40, 0xff,
    0x62, 0xe, 0x3, 0xfe, 0xc4, 0xf, 0xa8, 0x1e,
    0xde, 0x90, 0x16, 0x98, 0x1f, 0xda, 0x2b, 0x0,
    0xff, 0x28, 0x81, 0xa0, 0x7e, 0x34, 0xc, 0xc0,
    0xfc, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xe4, 0x61,
    0x81, 0xf9, 0x80, 0x35, 0xd0, 0x3f, 0x1b, 0x10,

    /* U+4F "O" */
    0x0, 0xff, 0xfd, 0x80, 0xc6, 0x1, 0xf8, 0xd0,
    0xf, 0x34, 0xbf, 0x9e, 0x14, 0x2b, 0x7f, 0x72,
    0x4c, 0xf, 0xff, 0xf8, 0x1f, 0xfd, 0x46, 0x7,
    0xe6, 0x4, 0xd5, 0x3, 0xf1, 0xc4, 0x80, 0xff,
    0xe0, 0x30, 0xd, 0x50, 0x3f, 0x1a, 0x48, 0x3,
    0x3, 0xf3, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x56,
    0x5, 0x6f, 0xee, 0x49, 0xac, 0xd2, 0xfe, 0x78,
    0x1, 0x80, 0x7e, 0x34, 0x0,

    /* U+50 "P" */
    0x7f, 0xff, 0xc4, 0x5, 0x60, 0x7f, 0xa1, 0x0,
    0xd9, 0x2f, 0xe7, 0x88, 0x5, 0x6f, 0xe8, 0x42,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0x51, 0xdb, 0xfa,
    0x10, 0x92, 0x25, 0xfe, 0x7c, 0xa8, 0xc0, 0xfe,
    0x80, 0x65, 0xff, 0xf1, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xc9, 0x4, 0x7, 0xff, 0x2, 0x48, 0xf,
    0xfe, 0x0,

    /* U+51 "Q" */
    0x0, 0xff, 0xfd, 0x80, 0xc6, 0x1, 0xf8, 0xd0,
    0xf, 0x34, 0xbf, 0x9e, 0x14, 0x2b, 0x7f, 0x72,
    0x4c, 0xf, 0xff, 0xf8, 0x1f, 0xfd, 0x46, 0x7,
    0xe6, 0x4, 0xd5, 0x3, 0xf1, 0xc4, 0x80, 0xff,
    0xe0, 0x30, 0xd, 0x50, 0x39, 0x10, 0x69, 0x20,
    0xc, 0xe, 0x30, 0x30, 0x3f, 0xf8, 0x9, 0x0,
    0xff, 0xe1, 0x40, 0x3f, 0xf8, 0x4, 0x1c, 0x7,
    0xfc, 0x90, 0xf, 0xfe, 0x14, 0x3, 0xff, 0x84,
    0x58, 0x1f, 0xfc, 0x29, 0xc0, 0xa0, 0x56, 0xfe,
    0xc4, 0x9a, 0xcd, 0x2f, 0xe7, 0x80, 0x18, 0x7,
    0xe3, 0x40, 0x0,

    /* U+52 "R" */
    0x7f, 0xff, 0xc4, 0x5, 0x60, 0x7f, 0xa1, 0x0,
    0xd9, 0x2f, 0xe7, 0x88, 0x5, 0x6f, 0xe8, 0x42,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0x51, 0xdb, 0xfa,
    0x10, 0x92, 0x25, 0xfe, 0x7c, 0xa8, 0xc0, 0xfe,
    0x80, 0x65, 0x14, 0xff, 0xc4, 0xe, 0xaa, 0x30,
    0x3f, 0xe8, 0x2, 0x20, 0x3f, 0xca, 0x0, 0xa4,
    0xf, 0xf3, 0x60, 0x18, 0x81, 0xfe, 0x8c, 0x7,
    0x3, 0xfe, 0x88, 0x1c, 0x7, 0xfd, 0x48, 0x34,
    0xf, 0xfb, 0x10, 0xa8, 0x1f, 0xf7, 0x0, 0xa0,
    0x60, 0x7e, 0x38, 0x3, 0x55, 0x60, 0x3e, 0x34,
    0x1,

    /* U+53 "S" */
    0x0, 0xff, 0xfe, 0x20, 0x46, 0x1, 0xfd, 0x0,
    0x2c, 0xd2, 0xfe, 0x7c, 0x40, 0xad, 0xfd, 0x8,
    0x60, 0x7f, 0xc4, 0x2, 0x3, 0xff, 0x81, 0xa9,
    0x3, 0xff, 0x80, 0x50, 0x1f, 0xff, 0x18, 0x1d,
    0xbf, 0xa0, 0x12, 0xc9, 0x7f, 0x38, 0x4, 0x60,
    0x1f, 0xc6, 0x81, 0x3f, 0xff, 0x64, 0x8c, 0xf,
    0xff, 0xf8, 0xa0, 0x7f, 0xf0, 0x6a, 0xa0, 0x7f,
    0xf0, 0x18, 0x60, 0x7f, 0xf0, 0x20, 0x56, 0xfe,
    0x84, 0x35, 0x9a, 0x5f, 0xee, 0x0, 0xc0, 0x3f,
    0x18, 0x0,

    /* U+54 "T" */
    0x1f, 0xff, 0xd8, 0x40, 0x39, 0x20, 0x18, 0xb8,
    0xd2, 0xcd, 0x92, 0xcd, 0x84, 0xb6, 0xc4, 0xbd,
    0xb4, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x44, 0x80,
    0x60, 0x7f, 0x95, 0xc4, 0xf, 0xfe, 0x62, 0xb8,
    0x81, 0xfe, 0x20, 0x18, 0x1f, 0xff, 0xf0, 0x3f,
    0xfc, 0x64, 0x3, 0x3, 0xfc, 0x9c, 0x20, 0x70,

    /* U+55 "U" */
    0x10, 0xf, 0xf2, 0x62, 0xba, 0x7, 0xe3, 0x62,
    0x61, 0x81, 0xf9, 0x80, 0x20, 0x7f, 0xff, 0xc0,
    0xff, 0xf1, 0xb0, 0x3f, 0x30, 0x31, 0xa0, 0x7e,
    0x34, 0xf, 0xfe, 0x31, 0xa0, 0x7e, 0x34, 0xc,
    0xc0, 0xfc, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xd5,
    0x81, 0x5b, 0xfb, 0x92, 0x6b, 0x34, 0xbf, 0x9e,
    0x0, 0x60, 0x1f, 0x8d, 0x0,

    /* U+56 "V" */
    0x10, 0xf, 0xf2, 0x62, 0xba, 0x7, 0xe3, 0x62,
    0x61, 0x81, 0xff, 0x10, 0x3f, 0xff, 0xe0, 0x7f,
    0xfc, 0x90, 0x1f, 0x89, 0x1, 0x88, 0x1f, 0xc4,
    0xc, 0x88, 0x1f, 0x40, 0x2a, 0x2, 0x1, 0xf3,
    0x0, 0xd8, 0x84, 0x40, 0xe8, 0x2, 0x0, 0xa0,
    0x20, 0x1c, 0xc0, 0x30, 0xc, 0x84, 0x40, 0xa0,
    0x8, 0x6, 0xa0, 0x28, 0x13, 0x0, 0xc0, 0xcc,
    0x86, 0x44, 0x1, 0x0, 0xf5, 0x1, 0x43, 0x0,
    0xc0, 0xf3, 0x21, 0xc0, 0x10, 0xf, 0xd0, 0x1,
    0x0, 0xc0, 0xfc, 0x88, 0x14, 0x3, 0xfd, 0x0,
    0x98, 0x1c,

    /* U+57 "W" */
    0x10, 0xf, 0xf2, 0x60, 0x7f, 0xa0, 0xae, 0x81,
    0xf8, 0xd8, 0x80, 0xfd, 0x1e, 0x61, 0x81, 0xf9,
    0x80, 0x20, 0x7e, 0x20, 0x81, 0xff, 0xff, 0x3,
    0xff, 0xfe, 0x7, 0xff, 0xc1, 0x81, 0xf9, 0x80,
    0x20, 0x7e, 0x20, 0x46, 0x81, 0xf8, 0xd8, 0x80,
    0xfd, 0x10, 0x1f, 0xfd, 0x3, 0x40, 0xfc, 0x6c,
    0x40, 0x7e, 0x88, 0x9, 0x81, 0xf9, 0x80, 0x20,
    0x7e, 0x20, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xd6, 0x81, 0x5b, 0xfb, 0x92, 0xf6, 0xfe,
    0x21, 0xac, 0xd2, 0xfe, 0x69, 0xa5, 0xf9, 0xd8,
    0xc, 0x3, 0xf1, 0xb0, 0x81, 0xf9, 0xa0,

    /* U+58 "X" */
    0xdc, 0x81, 0xfd, 0xf8, 0x80, 0x80, 0x7e, 0x60,
    0x4c, 0x22, 0x7, 0xd0, 0x1, 0xe0, 0x20, 0x1e,
    0x60, 0x18, 0x44, 0x22, 0x7, 0x40, 0x10, 0x4,
    0x1, 0x0, 0xcc, 0x3, 0x2, 0x44, 0x22, 0x5,
    0x0, 0x40, 0x34, 0x1, 0x0, 0x30, 0xc, 0xe,
    0x48, 0x11, 0x10, 0x4, 0x3, 0xd0, 0x4, 0x60,
    0x18, 0x1f, 0x14, 0x16, 0x1, 0x0, 0xfd, 0x0,
    0xcc, 0xf, 0xe2, 0x89, 0xa0, 0x1f, 0xfc, 0xc4,
    0x84, 0xd0, 0xf, 0xe8, 0x6, 0x60, 0x7e, 0x44,
    0x1c, 0x2, 0x1, 0xf4, 0x1, 0x18, 0x6, 0x7,
    0x91, 0x5, 0x8, 0x2, 0x1, 0xd0, 0x7, 0x0,
    0xc0, 0x30, 0x32, 0x21, 0x10, 0x28, 0x2, 0x1,
    0x40, 0x10, 0xc, 0xc0, 0x30, 0x8, 0x84, 0x40,
    0xe8, 0x2, 0xe, 0x2, 0x1, 0xe6, 0x1, 0x86,
    0x11, 0x3, 0xe8, 0x0, 0x80, 0x80, 0x7e, 0x60,
    0x40,

    /* U+59 "Y" */
    0x4, 0xf, 0xfe, 0xa, 0xc8, 0xf, 0xeb, 0x84,
    0x10, 0xf, 0xc9, 0xb, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xc2, 0x87, 0x6f, 0xee, 0x49, 0xb5, 0x4b,
    0xfe, 0xc0, 0x14, 0x3, 0xf1, 0x2a, 0x4, 0xff,
    0xfd, 0x12, 0x30, 0x3f, 0xff, 0xe0, 0x7f, 0xf8,
    0xa5, 0xbf, 0xdc, 0x93, 0x72, 0x5f, 0xe7, 0x83,
    0x20, 0x7f, 0x1a, 0x0,

    /* U+5A "Z" */
    0x17, 0xff, 0xe2, 0x48, 0xf, 0xe8, 0x6a, 0x5f,
    0x9d, 0xa, 0xdf, 0xb8, 0x1f, 0xf4, 0x20, 0x7f,
    0x22, 0x7, 0xfa, 0x81, 0xfe, 0x60, 0x8, 0x1f,
    0xa0, 0x8, 0x7, 0xd0, 0x4, 0x3, 0xf2, 0x0,
    0xc0, 0xff, 0x50, 0x3f, 0x9a, 0x40, 0x3e, 0xb7,
    0x1, 0xf2, 0x46, 0x7, 0xf4, 0x3, 0xfc, 0xc8,
    0x40, 0x7e, 0x80, 0x20, 0x1f, 0x40, 0xc, 0xf,
    0xfa, 0x1, 0xfe, 0x80, 0x7f, 0x8b, 0x3, 0xfd,
    0x0, 0xff, 0xbd, 0xbf, 0x31, 0x1a, 0x5f, 0xa2,
    0x84, 0xf, 0xc9, 0x0,

    /* U+5B "[" */
    0x7f, 0xf9, 0xd6, 0x6, 0x2c, 0x36, 0x4a, 0xc0,
    0x4a, 0xd8, 0xf, 0xff, 0x82, 0x3, 0x9a, 0x80,
    0x7f, 0xf0, 0x5a, 0xa0, 0x7c, 0xc0, 0xff, 0xf9,
    0xab, 0x60, 0x26, 0xc9, 0x58, 0x56, 0x6, 0x2c,

    /* U+5C "\\" */
    0xdc, 0x81, 0xff, 0xc2, 0x80, 0x7f, 0xf0, 0x18,
    0x44, 0xf, 0xfa, 0x0, 0x80, 0x7f, 0xc5, 0x4,
    0x40, 0xff, 0xa0, 0xe, 0x7, 0xfc, 0x50, 0x28,
    0xf, 0xfa, 0x0, 0x80, 0x7f, 0xc5, 0x2, 0x80,
    0xff, 0xa0, 0x8, 0x7, 0xfc, 0x58, 0x20, 0x7f,
    0xf0, 0x20, 0x1f, 0xfc, 0x36, 0x40, 0xff, 0xe0,
    0xcd, 0x28, 0x1f, 0xfc, 0x12, 0x98, 0x1f, 0xfc,
    0x2a, 0x7, 0xff, 0x0, 0x82, 0xc0, 0xff, 0xa0,
    0x8, 0x7, 0xff, 0x1, 0x80, 0x60, 0x7f, 0xd0,
    0x4, 0x3, 0xff, 0x80, 0xc0, 0x30, 0x3f, 0xe8,
    0x2, 0x1, 0xff, 0xc0, 0x80, 0x18, 0x1f, 0xf3,
    0x1, 0x0, 0xff, 0xe0, 0x40, 0x4, 0xf, 0xf9,
    0x81, 0x0,

    /* U+5D "]" */
    0xdf, 0xf5, 0x30, 0xc, 0x9a, 0x4a, 0x94, 0xc8,
    0x5, 0x6b, 0x90, 0x3f, 0xfe, 0x4c, 0xf, 0x8e,
    0x24, 0x7, 0xff, 0x0, 0xe2, 0x40, 0x7f, 0xfd,
    0x55, 0xa8, 0x40, 0x2a, 0x94, 0xc8, 0x80, 0x64,
    0xd0,

    /* U+5F "_" */
    0x6, 0xdf, 0xd0, 0x6, 0x4b, 0xf3, 0x82, 0x1,
    0xfd, 0x40,

    /* U+61 "a" */
    0x0, 0xbf, 0xfe, 0x20, 0x46, 0x81, 0xfd, 0x8,
    0x79, 0xa5, 0xfc, 0xf1, 0xa1, 0x5b, 0xfa, 0x11,
    0x40, 0xff, 0xff, 0x81, 0xff, 0xd4, 0x76, 0xfe,
    0x84, 0x2, 0x89, 0x7f, 0x9b, 0x65, 0x18, 0x1f,
    0xc5, 0xe0, 0xb, 0xff, 0xd9, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xe4, 0x82, 0x3, 0xf1, 0x21, 0xa4,
    0x80, 0xfe, 0xd5, 0x0,

    /* U+62 "b" */
    0x7f, 0xff, 0xc4, 0x5, 0x60, 0x7f, 0xa0, 0x13,
    0x64, 0xbf, 0x9f, 0x2, 0x56, 0xfe, 0x84, 0x30,
    0x3f, 0xff, 0xe0, 0x7f, 0xf5, 0x15, 0xbf, 0xa1,
    0x26, 0x9b, 0x25, 0xfe, 0xc1, 0x34, 0x7, 0xf1,
    0xa0, 0x4f, 0xff, 0xd9, 0x23, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0x8d, 0x5b, 0xfa, 0x10, 0xc3, 0x64,
    0xbf, 0x9f, 0x15, 0x81, 0xfe, 0x80, 0x0,

    /* U+63 "c" */
    0x0, 0xff, 0xfd, 0x80, 0xc6, 0x1, 0xf8, 0xd0,
    0xf, 0x34, 0xbf, 0x9e, 0x14, 0x2b, 0x7f, 0x72,
    0x4c, 0xf, 0xf9, 0x80, 0x40, 0x7f, 0xc6, 0xd1,
    0x3, 0xff, 0x80, 0x90, 0xf, 0xff, 0x9b, 0x3,
    0xff, 0x80, 0xd5, 0x3, 0xff, 0x9e, 0xd5, 0x3,
    0xff, 0x84, 0xc0, 0xff, 0xff, 0x81, 0xfc, 0x90,
    0xf, 0xfe, 0x1, 0xb4, 0x40, 0xff, 0x98, 0x5,
    0x2, 0xb7, 0xf7, 0x24, 0xd6, 0x69, 0x7f, 0x3c,
    0x0, 0xc0, 0x3f, 0x1a, 0x0,

    /* U+64 "d" */
    0x7f, 0xff, 0xc4, 0x5, 0x60, 0x7f, 0xa0, 0x13,
    0x64, 0xbf, 0x9e, 0x2, 0x56, 0xfe, 0x84, 0x98,
    0x1f, 0xff, 0xf0, 0x3f, 0xfa, 0x8c, 0xf, 0xfe,
    0x3, 0x54, 0xf, 0xc7, 0x10, 0x3f, 0xf8, 0x65,
    0xaa, 0x7, 0xe3, 0x89, 0x0, 0x60, 0x7f, 0xff,
    0xc0, 0xff, 0xf0, 0x2b, 0x7f, 0x42, 0x18, 0x6c,
    0x97, 0xf3, 0xe2, 0xb0, 0x3f, 0xd0, 0x0,

    /* U+65 "e" */
    0x0, 0xff, 0xfd, 0x80, 0x18, 0x7, 0xe3, 0x1e,
    0x69, 0x7e, 0x72, 0x85, 0x6f, 0xe8, 0x7, 0xff,
    0xfc, 0xf, 0xfe, 0x3b, 0xb7, 0xe0, 0x24, 0xd2,
    0xfd, 0x40, 0x26, 0x80, 0xfa, 0x1, 0x9f, 0xff,
    0x10, 0x3f, 0xff, 0xe0, 0x7f, 0xf4, 0xe0, 0x56,
    0xfe, 0x81, 0x66, 0x97, 0xe7, 0x1, 0x80, 0x7e,
    0x30,

    /* U+66 "f" */
    0x0, 0xff, 0xfd, 0x80, 0x18, 0x7, 0xe3, 0x1e,
    0x69, 0x7e, 0x72, 0x85, 0x6f, 0xe8, 0x7, 0xff,
    0xfc, 0xf, 0xfe, 0x3b, 0xb7, 0xe0, 0x24, 0xd2,
    0xfd, 0x40, 0x26, 0x80, 0xfa, 0x1, 0x9f, 0xff,
    0x10, 0x3f, 0xff, 0xe0, 0x7f, 0xf8, 0x10, 0x40,
    0x7f, 0xa4, 0x80, 0xff, 0x0,

    /* U+67 "g" */
    0x0, 0xff, 0xfd, 0x80, 0xc6, 0x1, 0xf8, 0xc0,
    0xf, 0x34, 0xbf, 0x38, 0x2, 0x85, 0x6f, 0xe8,
    0x7, 0xff, 0xfc, 0xf, 0xfe, 0xbd, 0x3, 0x9d,
    0xba, 0x5, 0x18, 0x18, 0xc4, 0xa6, 0x5a, 0x84,
    0xc, 0x50, 0x2, 0xd0, 0x17, 0x3, 0xaf, 0xe8,
    0x80, 0xff, 0xff, 0x81, 0xff, 0xe3, 0x81, 0x5b,
    0xfb, 0x92, 0x6b, 0x34, 0xbf, 0x9e, 0x0, 0x60,
    0x1f, 0x8d, 0x0,

    /* U+68 "h" */
    0x4, 0xf, 0xfe, 0xa, 0xc8, 0xf, 0xeb, 0x84,
    0x10, 0xf, 0xc9, 0xb, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xc9, 0xdb, 0xfb, 0x90, 0x9, 0xa5, 0xff,
    0xc0, 0x29, 0xa0, 0x3f, 0x12, 0x44, 0x3, 0xff,
    0xf4, 0x40, 0x7f, 0xff, 0xc0, 0xff, 0xf9, 0x20,
    0x80, 0xfc, 0x80, 0x29, 0x20, 0x3f, 0xb5, 0x20,

    /* U+69 "i" */
    0x14, 0x65, 0x80, 0xff, 0xe7, 0xb0, 0xec, 0xa0,
    0x56, 0x56, 0x18, 0x1f, 0xfc, 0xc6, 0x2, 0xac,

    /* U+6A "j" */
    0x3, 0xff, 0x80, 0x98, 0x1f, 0xfc, 0x3, 0x62,
    0x3, 0xff, 0x84, 0x40, 0xff, 0xff, 0x81, 0xff,
    0xfb, 0x34, 0xf, 0xfe, 0x81, 0xa0, 0x7f, 0xff,
    0xc0, 0xa0, 0x1f, 0xfc, 0x1a, 0xe8, 0x1f, 0xfc,
    0x6, 0x18, 0x1f, 0xfc, 0x8, 0x15, 0xbf, 0xa1,
    0xd, 0x66, 0x97, 0xfb, 0x80, 0x30, 0xf, 0xc6,
    0x0,

    /* U+6B "k" */
    0x34, 0xf, 0xf5, 0xeb, 0xac, 0x7, 0xe4, 0x80,
    0x7f, 0xf0, 0x60, 0x6, 0x7, 0xf9, 0x10, 0xc8,
    0x1f, 0xea, 0x2, 0x1, 0xfe, 0x60, 0x18, 0x1f,
    0xf4, 0x1, 0x0, 0xff, 0x40, 0x10, 0xf, 0xf1,
    0x60, 0xb0, 0x3f, 0xd0, 0x4, 0x3, 0xfc, 0x50,
    0x28, 0xf, 0x3b, 0x70, 0xe, 0x7, 0x26, 0x97,
    0x36, 0x20, 0x72, 0x68, 0x9, 0x36, 0x3, 0xf3,
    0xff, 0x0, 0x80, 0x7f, 0xcc, 0x3, 0x3, 0xff,
    0x81, 0x0, 0x40, 0x3f, 0xe6, 0x43, 0x20, 0x7f,
    0xd0, 0x4, 0x3, 0xfe, 0x44, 0x22, 0x7, 0xfd,
    0x0, 0x40, 0x3f, 0xe4, 0x42, 0x20, 0x7f, 0xdc,
    0x4, 0x3, 0xfe, 0x28, 0x22, 0xc0, 0xff, 0x40,
    0xe, 0xac, 0x7, 0xe2, 0x80, 0x0,

    /* U+6C "l" */
    0x10, 0xf, 0xfa, 0xba, 0x7, 0xf9, 0x86, 0x7,
    0xff, 0xfc, 0xf, 0xfe, 0xeb, 0x3, 0xfe, 0x34,
    0xf, 0xfe, 0x61, 0xa0, 0x7f, 0xf0, 0x18, 0x1f,
    0xff, 0xf0, 0x3f, 0xf9, 0xd0, 0x2b, 0x7f, 0x40,
    0xb3, 0x4b, 0xf3, 0x80, 0xc0, 0x3f, 0x18,

    /* U+6D "m" */
    0x4, 0xf, 0xfe, 0xb, 0xc8, 0xf, 0xed, 0x82,
    0x88, 0x7, 0xe4, 0x49, 0x81, 0x10, 0x3e, 0x20,
    0x7b, 0x81, 0xe7, 0x80, 0xf9, 0x81, 0xd0, 0xf,
    0xd0, 0xc, 0xc0, 0xff, 0x40, 0x28, 0x7, 0xf9,
    0x80, 0x80, 0x8, 0x1e, 0x80, 0x20, 0x60, 0xe0,
    0x3c, 0x90, 0x38, 0x2, 0x1, 0xfa, 0x0, 0x20,
    0xa0, 0x3d, 0x41, 0x40, 0x5c, 0x22, 0x2, 0xd3,
    0x1, 0x1f, 0x84, 0x6, 0x8a, 0xc0, 0x23, 0x13,
    0x2, 0x51, 0x3, 0x40, 0xfc, 0x68, 0x19, 0x81,
    0xf9, 0x81, 0xff, 0xff, 0x3, 0xff, 0xc8, 0xc3,
    0x3, 0xf3, 0x0, 0x6b, 0xa0, 0x7e, 0x36, 0x20,

    /* U+6E "n" */
    0x3, 0xff, 0x86, 0x71, 0x3, 0xfa, 0x40, 0xe7,
    0x81, 0xf8, 0xb6, 0x40, 0x5f, 0x1, 0xe6, 0x0,
    0x81, 0x8e, 0x3, 0xff, 0x80, 0x41, 0xc0, 0x7f,
    0xd8, 0x83, 0x80, 0xff, 0xb1, 0x7, 0x1, 0xff,
    0x62, 0xe, 0x3, 0xfe, 0xc4, 0x1c, 0x40, 0xff,
    0x62, 0xe, 0x3, 0xfe, 0xc4, 0xf, 0xa8, 0x1e,
    0xde, 0x90, 0x16, 0x98, 0x1f, 0xda, 0x2b, 0x0,
    0xff, 0x28, 0x81, 0xa0, 0x7e, 0x34, 0xc, 0xc0,
    0xfc, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xe4, 0x61,
    0x81, 0xf9, 0x80, 0x35, 0xd0, 0x3f, 0x1b, 0x10,

    /* U+6F "o" */
    0x0, 0xff, 0xfd, 0x80, 0xc6, 0x1, 0xf8, 0xd0,
    0xf, 0x34, 0xbf, 0x9e, 0x14, 0x2b, 0x7f, 0x72,
    0x4c, 0xf, 0xff, 0xf8, 0x1f, 0xfd, 0x46, 0x7,
    0xe6, 0x4, 0xd5, 0x3, 0xf1, 0xc4, 0x80, 0xff,
    0xe0, 0x30, 0xd, 0x50, 0x3f, 0x1a, 0x48, 0x3,
    0x3, 0xf3, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x56,
    0x5, 0x6f, 0xee, 0x49, 0xac, 0xd2, 0xfe, 0x78,
    0x1, 0x80, 0x7e, 0x34, 0x0,

    /* U+70 "p" */
    0x7f, 0xff, 0xc4, 0x5, 0x60, 0x7f, 0xa1, 0x0,
    0xd9, 0x2f, 0xe7, 0x88, 0x5, 0x6f, 0xe8, 0x42,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0x51, 0xdb, 0xfa,
    0x10, 0x92, 0x25, 0xfe, 0x7c, 0xa8, 0xc0, 0xfe,
    0x80, 0x65, 0xff, 0xf1, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xc9, 0x4, 0x7, 0xff, 0x2, 0x48, 0xf,
    0xfe, 0x0,

    /* U+71 "q" */
    0x0, 0xff, 0xfd, 0x80, 0xc6, 0x1, 0xf8, 0xd0,
    0xf, 0x34, 0xbf, 0x9e, 0x14, 0x2b, 0x7f, 0x72,
    0x4c, 0xf, 0xff, 0xf8, 0x1f, 0xfd, 0x46, 0x7,
    0xe6, 0x4, 0xd5, 0x3, 0xf1, 0xc4, 0x80, 0xff,
    0xe0, 0x30, 0xd, 0x50, 0x39, 0x10, 0x69, 0x20,
    0xc, 0xe, 0x30, 0x30, 0x3f, 0xf8, 0x9, 0x0,
    0xff, 0xe1, 0x40, 0x3f, 0xf8, 0x4, 0x1c, 0x7,
    0xfc, 0x90, 0xf, 0xfe, 0x14, 0x3, 0xff, 0x84,
    0x58, 0x1f, 0xfc, 0x29, 0xc0, 0xa0, 0x56, 0xfe,
    0xc4, 0x9a, 0xcd, 0x2f, 0xe7, 0x80, 0x18, 0x7,
    0xe3, 0x40, 0x0,

    /* U+72 "r" */
    0x7f, 0xff, 0xc4, 0x5, 0x60, 0x7f, 0xa1, 0x0,
    0xd9, 0x2f, 0xe7, 0x88, 0x5, 0x6f, 0xe8, 0x42,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0x51, 0xdb, 0xfa,
    0x10, 0x92, 0x25, 0xfe, 0x7c, 0xa8, 0xc0, 0xfe,
    0x80, 0x65, 0x14, 0xff, 0xc4, 0xe, 0xaa, 0x30,
    0x3f, 0xe8, 0x2, 0x20, 0x3f, 0xca, 0x0, 0xa4,
    0xf, 0xf3, 0x60, 0x18, 0x81, 0xfe, 0x8c, 0x7,
    0x3, 0xfe, 0x88, 0x1c, 0x7, 0xfd, 0x48, 0x34,
    0xf, 0xfb, 0x10, 0xa8, 0x1f, 0xf7, 0x0, 0xa0,
    0x60, 0x7e, 0x38, 0x3, 0x55, 0x60, 0x3e, 0x34,
    0x1,

    /* U+73 "s" */
    0x0, 0xff, 0xfe, 0x20, 0x46, 0x1, 0xfd, 0x0,
    0x2c, 0xd2, 0xfe, 0x7c, 0x40, 0xad, 0xfd, 0x8,
    0x60, 0x7f, 0xc4, 0x2, 0x3, 0xff, 0x81, 0xa9,
    0x3, 0xff, 0x80, 0x50, 0x1f, 0xff, 0x18, 0x1d,
    0xbf, 0xa0, 0x12, 0xc9, 0x7f, 0x38, 0x4, 0x60,
    0x1f, 0xc6, 0x81, 0x3f, 0xff, 0x64, 0x8c, 0xf,
    0xff, 0xf8, 0xa0, 0x7f, 0xf0, 0x6a, 0xa0, 0x7f,
    0xf0, 0x18, 0x60, 0x7f, 0xf0, 0x20, 0x56, 0xfe,
    0x84, 0x35, 0x9a, 0x5f, 0xee, 0x0, 0xc0, 0x3f,
    0x18, 0x0,

    /* U+74 "t" */
    0x1f, 0xff, 0xd8, 0x40, 0x39, 0x20, 0x18, 0xb8,
    0xd2, 0xcd, 0x92, 0xcd, 0x84, 0xb6, 0xc4, 0xbd,
    0xb4, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x44, 0x80,
    0x60, 0x7f, 0x95, 0xc4, 0xf, 0xfe, 0x62, 0xb8,
    0x81, 0xfe, 0x20, 0x18, 0x1f, 0xff, 0xf0, 0x3f,
    0xfc, 0x64, 0x3, 0x3, 0xfc, 0x9c, 0x20, 0x70,

    /* U+75 "u" */
    0x10, 0xf, 0xf2, 0x62, 0xba, 0x7, 0xe3, 0x62,
    0x61, 0x81, 0xf9, 0x80, 0x20, 0x7f, 0xff, 0xc0,
    0xff, 0xf1, 0xb0, 0x3f, 0x30, 0x31, 0xa0, 0x7e,
    0x34, 0xf, 0xfe, 0x31, 0xa0, 0x7e, 0x34, 0xc,
    0xc0, 0xfc, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xd5,
    0x81, 0x5b, 0xfb, 0x92, 0x6b, 0x34, 0xbf, 0x9e,
    0x0, 0x60, 0x1f, 0x8d, 0x0,

    /* U+76 "v" */
    0x10, 0xf, 0xf2, 0x62, 0xba, 0x7, 0xe3, 0x62,
    0x61, 0x81, 0xff, 0x10, 0x3f, 0xff, 0xe0, 0x7f,
    0xfc, 0x90, 0x1f, 0x89, 0x1, 0x88, 0x1f, 0xc4,
    0xc, 0x88, 0x1f, 0x40, 0x2a, 0x2, 0x1, 0xf3,
    0x0, 0xd8, 0x84, 0x40, 0xe8, 0x2, 0x0, 0xa0,
    0x20, 0x1c, 0xc0, 0x30, 0xc, 0x84, 0x40, 0xa0,
    0x8, 0x6, 0xa0, 0x28, 0x13, 0x0, 0xc0, 0xcc,
    0x86, 0x44, 0x1, 0x0, 0xf5, 0x1, 0x43, 0x0,
    0xc0, 0xf3, 0x21, 0xc0, 0x10, 0xf, 0xd0, 0x1,
    0x0, 0xc0, 0xfc, 0x88, 0x14, 0x3, 0xfd, 0x0,
    0x98, 0x1c,

    /* U+77 "w" */
    0x3, 0xff, 0x86, 0xba, 0x3, 0xfa, 0xe1, 0x4,
    0x3, 0xf2, 0x42, 0xc0, 0xff, 0xff, 0x81, 0xff,
    0xf2, 0xa0, 0x7e, 0x44, 0x5, 0xa6, 0x7, 0xf6,
    0x8a, 0xc0, 0x27, 0xef, 0x2, 0x51, 0x3, 0x40,
    0x40, 0x26, 0xd, 0x3, 0x30, 0xc0, 0xd0, 0x30,
    0x3e, 0x80, 0xf0, 0x10, 0xf, 0xa0, 0x8, 0x88,
    0x64, 0xf, 0x20, 0x50, 0x80, 0x30, 0x1f, 0xa0,
    0x4, 0x80, 0x7e, 0x29, 0x0, 0xa0, 0x1f, 0xd0,
    0xc, 0x50, 0x1f, 0x32, 0x7, 0x40, 0x3e, 0x80,
    0x78, 0xf0, 0x26, 0x18, 0x1f, 0x98, 0x3, 0x55,
    0x3, 0xf1, 0xb1, 0x0,

    /* U+78 "x" */
    0xdc, 0x81, 0xfd, 0xf8, 0x80, 0x80, 0x7e, 0x60,
    0x4c, 0x22, 0x7, 0xd0, 0x1, 0xe0, 0x20, 0x1e,
    0x60, 0x18, 0x44, 0x22, 0x7, 0x40, 0x10, 0x4,
    0x1, 0x0, 0xcc, 0x3, 0x2, 0x44, 0x22, 0x5,
    0x0, 0x40, 0x34, 0x1, 0x0, 0x30, 0xc, 0xe,
    0x48, 0x11, 0x10, 0x4, 0x3, 0xd0, 0x4, 0x60,
    0x18, 0x1f, 0x14, 0x16, 0x1, 0x0, 0xfd, 0x0,
    0xcc, 0xf, 0xe2, 0x89, 0xa0, 0x1f, 0xfc, 0xc4,
    0x84, 0xd0, 0xf, 0xe8, 0x6, 0x60, 0x7e, 0x44,
    0x1c, 0x2, 0x1, 0xf4, 0x1, 0x18, 0x6, 0x7,
    0x91, 0x5, 0x8, 0x2, 0x1, 0xd0, 0x7, 0x0,
    0xc0, 0x30, 0x32, 0x21, 0x10, 0x28, 0x2, 0x1,
    0x40, 0x10, 0xc, 0xc0, 0x30, 0x8, 0x84, 0x40,
    0xe8, 0x2, 0xe, 0x2, 0x1, 0xe6, 0x1, 0x86,
    0x11, 0x3, 0xe8, 0x0, 0x80, 0x80, 0x7e, 0x60,
    0x40,

    /* U+79 "y" */
    0xdd, 0x81, 0xfd, 0xf9, 0x80, 0x80, 0x7e, 0x60,
    0x48, 0x3, 0x3, 0xea, 0x1, 0x40, 0x10, 0xf,
    0x22, 0x11, 0xc, 0x3, 0x3, 0xa0, 0x8, 0x2,
    0x80, 0xa0, 0x64, 0x42, 0x20, 0xa, 0x5, 0x1,
    0x40, 0x1c, 0xd, 0x0, 0x40, 0x4, 0x81, 0x40,
    0x62, 0x81, 0x42, 0x0, 0x80, 0x7a, 0x0, 0x85,
    0x2, 0x80, 0xf1, 0x40, 0xc0, 0x10, 0xf, 0xdc,
    0xc, 0x50, 0x1f, 0x91, 0x2, 0xa0, 0x7f, 0xb7,
    0xf3, 0x3, 0xfe, 0xb4, 0x80, 0xff, 0xe0, 0x21,
    0x80, 0xff, 0xff, 0x10, 0x3f, 0xfd, 0xe4, 0xf,
    0xfe, 0x4, 0x30, 0xf, 0xfe, 0x3, 0xc0, 0x7c,

    /* U+7A "z" */
    0x17, 0xff, 0xe2, 0x48, 0xf, 0xe8, 0x6a, 0x5f,
    0x9d, 0xa, 0xdf, 0xb8, 0x1f, 0xf4, 0x20, 0x7f,
    0x22, 0x7, 0xfa, 0x81, 0xfe, 0x60, 0x8, 0x1f,
    0xa0, 0x8, 0x7, 0xd0, 0x4, 0x3, 0xf2, 0x0,
    0xc0, 0xff, 0x50, 0x3f, 0x9a, 0x40, 0x3e, 0xb7,
    0x1, 0xf2, 0x46, 0x7, 0xf4, 0x3, 0xfc, 0xc8,
    0x40, 0x7e, 0x80, 0x20, 0x1f, 0x40, 0xc, 0xf,
    0xfa, 0x1, 0xfe, 0x80, 0x7f, 0x8b, 0x3, 0xfd,
    0x0, 0xff, 0xbd, 0xbf, 0x31, 0x1a, 0x5f, 0xa2,
    0x84, 0xf, 0xc9, 0x0,

    /* U+7C "|" */
    0x4, 0x2c, 0xa0, 0x80, 0x7f, 0xf4, 0x98, 0x76,
    0x50, 0x2b, 0x2b, 0xc, 0xf, 0xfe, 0x94, 0x11,
    0x64
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 154, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 74, .box_w = 3, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 19, .adv_w = 130, .box_w = 6, .box_h = 7, .ofs_x = -2, .ofs_y = 18},
    {.bitmap_index = 33, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 122, .adv_w = 73, .box_w = 3, .box_h = 7, .ofs_x = -2, .ofs_y = 18},
    {.bitmap_index = 129, .adv_w = 136, .box_w = 7, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 162, .adv_w = 136, .box_w = 7, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 194, .adv_w = 116, .box_w = 6, .box_h = 6, .ofs_x = -1, .ofs_y = 10},
    {.bitmap_index = 208, .adv_w = 217, .box_w = 12, .box_h = 12, .ofs_x = -1, .ofs_y = 7},
    {.bitmap_index = 249, .adv_w = 74, .box_w = 4, .box_h = 7, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 259, .adv_w = 74, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 266, .adv_w = 254, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 362, .adv_w = 262, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 422, .adv_w = 262, .box_w = 7, .box_h = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 460, .adv_w = 262, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 519, .adv_w = 262, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 576, .adv_w = 262, .box_w = 15, .box_h = 27, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 626, .adv_w = 262, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 689, .adv_w = 262, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 746, .adv_w = 262, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 841, .adv_w = 262, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 900, .adv_w = 262, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 955, .adv_w = 74, .box_w = 3, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 968, .adv_w = 74, .box_w = 3, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 983, .adv_w = 99, .box_w = 5, .box_h = 21, .ofs_x = -1, .ofs_y = 3},
    {.bitmap_index = 1021, .adv_w = 209, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1046, .adv_w = 99, .box_w = 5, .box_h = 21, .ofs_x = -1, .ofs_y = 3},
    {.bitmap_index = 1085, .adv_w = 233, .box_w = 13, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1138, .adv_w = 261, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1190, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1245, .adv_w = 259, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1314, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1369, .adv_w = 233, .box_w = 13, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1418, .adv_w = 233, .box_w = 13, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1463, .adv_w = 259, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1522, .adv_w = 259, .box_w = 15, .box_h = 27, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1570, .adv_w = 74, .box_w = 3, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1586, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1643, .adv_w = 257, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1745, .adv_w = 233, .box_w = 13, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1784, .adv_w = 444, .box_w = 26, .box_h = 27, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 1880, .adv_w = 259, .box_w = 15, .box_h = 27, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1960, .adv_w = 259, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2021, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2071, .adv_w = 259, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2154, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2235, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2309, .adv_w = 248, .box_w = 14, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2357, .adv_w = 259, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2410, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2492, .adv_w = 444, .box_w = 26, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2579, .adv_w = 254, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2700, .adv_w = 259, .box_w = 15, .box_h = 27, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2752, .adv_w = 219, .box_w = 12, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2828, .adv_w = 147, .box_w = 8, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2860, .adv_w = 254, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2958, .adv_w = 147, .box_w = 8, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2991, .adv_w = 208, .box_w = 12, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3001, .adv_w = 261, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3053, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3108, .adv_w = 259, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3177, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3232, .adv_w = 233, .box_w = 13, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3281, .adv_w = 233, .box_w = 13, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3326, .adv_w = 259, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3385, .adv_w = 259, .box_w = 15, .box_h = 27, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3433, .adv_w = 74, .box_w = 3, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3449, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3498, .adv_w = 257, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3600, .adv_w = 233, .box_w = 13, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3639, .adv_w = 259, .box_w = 15, .box_h = 27, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3727, .adv_w = 259, .box_w = 15, .box_h = 27, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3807, .adv_w = 259, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3868, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3918, .adv_w = 259, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4001, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4082, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4156, .adv_w = 248, .box_w = 14, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4204, .adv_w = 259, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4257, .adv_w = 260, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4339, .adv_w = 259, .box_w = 15, .box_h = 27, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4423, .adv_w = 254, .box_w = 15, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4544, .adv_w = 260, .box_w = 15, .box_h = 27, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 4632, .adv_w = 219, .box_w = 12, .box_h = 26, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4708, .adv_w = 74, .box_w = 3, .box_h = 30, .ofs_x = -1, .ofs_y = -2}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint8_t glyph_id_ofs_list_0[] = {
    0, 1, 2, 0, 3, 0, 0, 4,
    5, 6, 7, 8, 9
};

static const uint8_t glyph_id_ofs_list_3[] = {
    0, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 10, 11, 12, 13, 14,
    15, 16, 17, 18, 19, 20, 21, 22,
    23, 24, 25, 26, 0, 27
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 13, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = glyph_id_ofs_list_0, .list_length = 13, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_FULL
    },
    {
        .range_start = 46, .range_length = 18, .glyph_id_start = 11,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 65, .range_length = 29, .glyph_id_start = 29,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 95, .range_length = 30, .glyph_id_start = 58,
        .unicode_list = NULL, .glyph_id_ofs_list = glyph_id_ofs_list_3, .list_length = 30, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_FULL
    }
};



/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 4,
    .bpp = 3,
    .kern_classes = 0,
    .bitmap_format = 1
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t liquidCrystal_nor_32 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 30,          /*The maximum line height required by the font*/
    .base_line = 2,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if LIQUIDCRYSTAL_NOR_32*/

