#include <lvgl/lvgl.h>

/*******************************************************************************
 * Size: 32 px
 * Bpp: 3
 * Opts: --font ../font/new/GRACETIANS-Cutting/GRACETIANS-Cutting-2.ttf -r 0x20-0x7F --size 32 --format lvgl --bpp 3 --lv-include lvgl/lvgl.h  -o gracetians_32.c
 ******************************************************************************/

#ifndef GRACETIANS_32
#define GRACETIANS_32 1
#endif

#if GRACETIANS_32

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x3f, 0x1, 0xff, 0xe7, 0x32, 0x3, 0x40, 0x47,
    0xe0, 0x20,

    /* U+22 "\"" */
    0x3f, 0xe0, 0x38, 0xf7, 0xd8, 0x8, 0x20,

    /* U+23 "#" */
    0x2, 0x48, 0x6, 0x28, 0x81, 0xd2, 0x90, 0x29,
    0x50, 0x1f, 0xfc, 0x43, 0xf8, 0x8d, 0xfc, 0x84,
    0xf8, 0xf, 0xfe, 0x11, 0xfc, 0x46, 0xfe, 0x42,
    0x7c, 0x7, 0xff, 0x78, 0xfe, 0x23, 0x7f, 0x21,
    0x3e, 0x3, 0xff, 0x84, 0x7f, 0x11, 0xbf, 0x90,
    0x9f, 0x1, 0xff, 0xd0,

    /* U+24 "$" */
    0x2, 0x3f, 0x5, 0xe8, 0x1f, 0xfc, 0x74, 0xf,
    0xa1, 0x7e, 0xc0, 0x24, 0x0, 0x48, 0x1, 0x25,
    0xd, 0xc0, 0xde, 0x15, 0xa6, 0x23, 0xa0, 0x7f,
    0x11, 0x0, 0xff, 0xe5, 0x90, 0x40, 0xff, 0x97,
    0x3, 0xfe, 0x87, 0x1, 0xfe, 0x34, 0x1, 0xf4,
    0x22, 0x6, 0x58, 0x2, 0x40, 0x19, 0x1, 0xe3,
    0x78, 0x25, 0x40, 0xff, 0x3c, 0x18, 0x1f, 0xf3,
    0xc0, 0x7f, 0xdc, 0xf, 0xfe, 0x6, 0x20, 0x7f,
    0x92, 0x60, 0x3f, 0x95, 0x48, 0x7f, 0x60, 0x7d,
    0x0, 0xa8, 0x4, 0xa0, 0x9, 0x1, 0xa0, 0xd,
    0xa8, 0xd, 0xe1, 0x81, 0x0,

    /* U+25 "%" */
    0xb, 0x7a, 0x7, 0xdb, 0xb0, 0x2a, 0xd9, 0x40,
    0x38, 0x90, 0x60, 0x8, 0x90, 0x88, 0x1d, 0x4,
    0x2, 0x21, 0x16, 0x40, 0xe4, 0x18, 0x19, 0xcc,
    0x68, 0x1a, 0x6, 0x7, 0x4d, 0x9c, 0x81, 0x98,
    0xa0, 0x78, 0x90, 0x1c, 0xc2, 0x20, 0x7f, 0xf0,
    0x68, 0xe0, 0x7f, 0xf0, 0x51, 0x24, 0x7, 0xff,
    0x6, 0x8, 0x7, 0xff, 0x4, 0x90, 0x40, 0x7f,
    0xf0, 0x60, 0x80, 0x7f, 0xf0, 0x4a, 0xc, 0xf,
    0xfe, 0xd, 0xc, 0xf, 0xfe, 0x13, 0x14, 0xf,
    0xfe, 0xb, 0x8, 0x81, 0xff, 0xc1, 0x82, 0x1,
    0xff, 0xc1, 0x40, 0x90, 0x1f, 0xfc, 0x18, 0x20,
    0x18, 0xef, 0xc8, 0xc, 0x48, 0x20, 0x37, 0x15,
    0x50, 0x34, 0x10, 0xf, 0x55, 0xc0, 0xc5, 0x6,
    0x7, 0x3a, 0xe1, 0x2, 0xa1, 0x81, 0xe8, 0xe0,
    0xe0,

    /* U+26 "&" */
    0x3, 0x94, 0xdf, 0xfd, 0xa2, 0x3, 0xf8, 0xea,
    0xc8, 0x1f, 0x17, 0x72, 0x3, 0xcf, 0x12, 0x9b,
    0xff, 0xb4, 0x25, 0x58, 0x18, 0xc1, 0x33, 0x20,
    0x7c, 0x5e, 0x82, 0x20, 0x2e, 0x23, 0x3, 0xff,
    0x82, 0xe8, 0x80, 0x44, 0x98, 0x1f, 0xfc, 0x34,
    0x4c, 0x8, 0x60, 0x7f, 0xf1, 0x50, 0x60, 0x84,
    0x7, 0xff, 0x15, 0x6, 0x1, 0x8, 0x7, 0xff,
    0xd, 0x93, 0x0, 0x81, 0xc0, 0x3f, 0xf8, 0x32,
    0x7, 0x2, 0x34, 0x3f, 0x10, 0x1f, 0x17, 0xd8,
    0xa4, 0xc, 0xb9, 0xe, 0xff, 0xf6, 0x81, 0x64,
    0x7, 0x99, 0x3, 0x13, 0xc9, 0xdf, 0x48, 0x1e,
    0xb0, 0x3a, 0x5, 0xf6, 0xac, 0x40, 0x7e, 0x68,
    0xe8, 0xba, 0x3a, 0x1, 0xff, 0xc1, 0x83, 0x90,
    0x2b, 0x41, 0xe2, 0x7, 0xc5, 0x12, 0x8, 0x81,
    0xcb, 0xa3, 0x98, 0x1c, 0x75, 0x4, 0x30, 0x3f,
    0x58, 0x26, 0x20, 0x5c, 0x32, 0x9, 0x20, 0x3f,
    0x3c, 0x4b, 0x30, 0xc8, 0x80, 0x20, 0xac, 0xf,
    0xc7, 0x31, 0x2c, 0x14, 0x9, 0x41, 0x33, 0x20,
    0x7d, 0x18, 0x40, 0xa0, 0x33, 0xc4, 0xa6, 0xff,
    0xf3, 0x2, 0x30, 0xe, 0x3a, 0xb2, 0x7, 0xc5,
    0xdf, 0x43, 0xc4,

    /* U+27 "'" */
    0x3f, 0x1, 0x1e, 0x80, 0x40,

    /* U+28 "(" */
    0x3, 0xc9, 0x0, 0xc7, 0x5c, 0x4, 0x71, 0x2c,
    0x5, 0xc4, 0xc8, 0x4, 0x2d, 0x80, 0xcc, 0xc0,
    0x33, 0x14, 0xe, 0xc1, 0x81, 0xcc, 0x81, 0xe2,
    0x80, 0xe2, 0x38, 0x1f, 0xfc, 0x92, 0x38, 0x1f,
    0x10, 0x3c, 0x50, 0x1e, 0x41, 0x1, 0xd4, 0x70,
    0x38, 0xa5, 0x1, 0xd0, 0x52, 0x6, 0x30, 0x66,
    0x6, 0x6c, 0x24, 0x1, 0xa6, 0x5c,

    /* U+29 ")" */
    0xc, 0xf, 0x19, 0xd8, 0x18, 0xa1, 0x18, 0x1a,
    0xe1, 0x8, 0x18, 0xe1, 0xc0, 0xe2, 0xca, 0x3,
    0xa8, 0xe0, 0x71, 0x48, 0x7, 0x88, 0x20, 0x76,
    0xc, 0xe, 0x60, 0x81, 0xc4, 0x70, 0x38, 0x81,
    0xfd, 0xc0, 0xe4, 0x8, 0x1d, 0xc2, 0x3, 0x99,
    0x3, 0x98, 0xa0, 0x74, 0xc, 0xd, 0x44, 0x2,
    0x59, 0x16, 0x0, 0xd2, 0x58, 0xc, 0x66, 0x3,
    0x0,

    /* U+2A "*" */
    0x3, 0xc9, 0x0, 0xff, 0x2b, 0x40, 0x44, 0x3,
    0xe8, 0xf, 0x4c, 0x45, 0x15, 0x1, 0xab, 0x14,
    0x62, 0x2f, 0x1, 0x50, 0x70, 0x6, 0x21, 0x0,
    0x41, 0xc0, 0x36, 0x40, 0x69, 0x0, 0x7a, 0x1,
    0x16, 0x7, 0x8e, 0x2, 0x34, 0xe, 0x58, 0xe,
    0x58, 0x9, 0x50, 0x60, 0x8, 0xe, 0x1, 0x41,
    0xc4, 0x3, 0xa0, 0xc1, 0x96, 0x3, 0x96, 0x50,
    0x1a, 0x7, 0xc6, 0x80,

    /* U+2B "+" */
    0x3, 0x14, 0x7, 0xe9, 0x50, 0x1f, 0xfc, 0xb3,
    0xfc, 0x85, 0xfd, 0x80, 0xff, 0x1f, 0xe4, 0x2f,
    0xec, 0x7, 0xff, 0x48,

    /* U+2C "," */
    0x2, 0x3f, 0x1, 0x14, 0x0,

    /* U+2D "-" */
    0x3, 0xfc, 0x7f, 0xfd, 0x80, 0xff, 0x0,

    /* U+2E "." */
    0x2, 0x3f, 0x1, 0x0,

    /* U+2F "/" */
    0x3, 0xfc, 0x7f, 0x1, 0xff, 0x50, 0xc0, 0xff,
    0x98, 0x80, 0x7f, 0xa0, 0x40, 0x7f, 0xcc, 0x40,
    0x3f, 0xcc, 0x22, 0x7, 0xfa, 0x8e, 0x7, 0xf9,
    0x12, 0x40, 0x7f, 0xb8, 0xa0, 0x7f, 0x8a, 0xc,
    0xf, 0xf4, 0xc, 0xf, 0xf9, 0x8, 0x7, 0xfa,
    0x6, 0x7, 0xfc, 0xc5, 0x3, 0xfc, 0xc2, 0x20,
    0x7f, 0xa8, 0xe0, 0x7f, 0x91, 0x24, 0x7, 0xfa,
    0xa, 0x7, 0xf8, 0x90, 0x60, 0x7f, 0xa0, 0x80,
    0x7f, 0xc8, 0x30, 0x3f, 0xd0, 0x30, 0x3f, 0xe6,
    0x28, 0x1f, 0xe0,

    /* U+30 "0" */
    0x3, 0x95, 0xdf, 0xfd, 0xaa, 0x3, 0xf2, 0xd5,
    0x10, 0x3e, 0x2a, 0xe4, 0x7, 0x3a, 0x4a, 0x6f,
    0xff, 0x52, 0x55, 0x81, 0x28, 0x26, 0x64, 0xf,
    0xcb, 0x51, 0x10, 0x8, 0x2b, 0x3, 0xff, 0x82,
    0xb0, 0xa0, 0x9, 0x20, 0x3f, 0xf8, 0x65, 0x2,
    0x40, 0x7f, 0xf2, 0x58, 0x1f, 0xff, 0xf0, 0x3f,
    0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xe2, 0x7, 0xff,
    0x25, 0x82, 0x48, 0xf, 0xfe, 0x19, 0x40, 0x88,
    0x2b, 0x3, 0xff, 0x82, 0xb0, 0x80, 0x15, 0x13,
    0x32, 0x7, 0xe7, 0xa8, 0x6c, 0x4, 0xb1, 0x29,
    0xbf, 0xfd, 0x9, 0x58, 0x7, 0x1d, 0x59, 0x3,
    0xe2, 0xee, 0x40, 0x40,

    /* U+31 "1" */
    0x2, 0x3f, 0x88, 0x16, 0x3, 0xb0, 0x1d, 0x8,
    0x20, 0x5a, 0xf0, 0x32, 0x40, 0x3f, 0xff, 0xe0,
    0x7f, 0xf9, 0x0,

    /* U+32 "2" */
    0x3, 0x94, 0xdf, 0xfd, 0x58, 0x1f, 0xe3, 0xab,
    0x20, 0x7c, 0xa7, 0x80, 0x7c, 0xf1, 0x29, 0xbf,
    0xfa, 0xa0, 0xf0, 0x1c, 0xa0, 0x79, 0x90, 0x3e,
    0x57, 0x12, 0xc0, 0x68, 0x24, 0x1, 0xff, 0xc0,
    0x38, 0x14, 0x4, 0x43, 0x3, 0xff, 0x87, 0x6,
    0x0, 0x41, 0x3, 0xff, 0x8c, 0x40, 0x1f, 0x80,
    0xff, 0xe2, 0x61, 0x80, 0xff, 0xe4, 0x44, 0x18,
    0x1f, 0xfc, 0x7a, 0xc5, 0x3, 0xff, 0x8f, 0x90,
    0xa8, 0xf, 0xfe, 0x29, 0xe4, 0x64, 0x7, 0xff,
    0x15, 0x60, 0x79, 0x3, 0xff, 0x8a, 0xe8, 0x58,
    0xf, 0xfe, 0x34, 0x80, 0xe8, 0x1f, 0xfc, 0x6a,
    0xc5, 0x80, 0x7f, 0xf1, 0x4e, 0x43, 0x20, 0x3f,
    0xf8, 0xa7, 0x12, 0xc4, 0xf, 0xfe, 0x2a, 0xc1,
    0x62, 0x7, 0xff, 0x16, 0x50, 0xe8, 0x1f, 0xfc,
    0x6a, 0xc4, 0x80, 0x3f, 0xf8, 0xd9, 0x0, 0x9f,
    0xff, 0xf0, 0xd0, 0x3c, 0x81, 0xff, 0xc8,

    /* U+33 "3" */
    0x3f, 0xff, 0xb6, 0x44, 0x7, 0xff, 0x10, 0x93,
    0xbd, 0x81, 0x1f, 0xff, 0xed, 0x8, 0x94, 0xf,
    0xfe, 0x11, 0x7a, 0x5, 0x0, 0xff, 0xe2, 0x3c,
    0x19, 0x3, 0xff, 0x88, 0x58, 0xa0, 0x7f, 0xf1,
    0x78, 0x20, 0x7f, 0xf1, 0x78, 0x20, 0x7f, 0xf1,
    0xb, 0x14, 0xf, 0xfe, 0x1a, 0xc1, 0x10, 0x3f,
    0xf8, 0x5, 0xea, 0x15, 0x7, 0xff, 0xfb, 0x42,
    0x25, 0x2, 0x4b, 0xfe, 0x20, 0x54, 0x80, 0x36,
    0xff, 0xdb, 0xc0, 0x71, 0x3, 0xff, 0x86, 0xfa,
    0x18, 0xf, 0xfe, 0x2d, 0x21, 0x81, 0xff, 0xc5,
    0xa3, 0x81, 0xff, 0xd9, 0x83, 0x1, 0xff, 0xc3,
    0x38, 0x14, 0x7, 0xff, 0x5, 0x5c, 0x4b, 0x3,
    0xff, 0xff, 0x2, 0xa0, 0xf0, 0x1f, 0xfc, 0x35,
    0x3c, 0x2,

    /* U+34 "4" */
    0x3, 0xff, 0x80, 0x7f, 0x80, 0xff, 0xe2, 0x1c,
    0x7, 0xff, 0x18, 0xe0, 0x80, 0xff, 0xe2, 0x1c,
    0x15, 0x3, 0xff, 0x89, 0xc1, 0xa0, 0x7f, 0xf1,
    0x31, 0x2c, 0x7, 0xff, 0x13, 0x12, 0xc0, 0x7f,
    0xf1, 0x31, 0x2c, 0x7, 0xff, 0x12, 0x91, 0xc0,
    0xff, 0xe2, 0x54, 0x31, 0x3, 0xff, 0x87, 0x50,
    0xc4, 0xf, 0xfe, 0x1c, 0x43, 0x10, 0x3f, 0xf8,
    0x71, 0x8a, 0x40, 0xff, 0xe2, 0x30, 0xd0, 0x1f,
    0xf1, 0x3, 0xa0, 0x7f, 0xff, 0x80, 0x6f, 0xe6,
    0x19, 0x3, 0xff, 0x91, 0xbf, 0xff, 0x80, 0x7f,
    0x98, 0x1f, 0xff, 0xf0, 0x3f, 0xfc, 0xe0,

    /* U+35 "5" */
    0x3f, 0xff, 0xf1, 0xa8, 0x1f, 0xfc, 0x72, 0x0,
    0xff, 0xff, 0xc4, 0x80, 0x7f, 0xff, 0xc0, 0xff,
    0xff, 0x81, 0xff, 0xc0, 0x3f, 0xff, 0x6a, 0xc8,
    0x1c, 0x97, 0xfc, 0x14, 0xd8, 0x40, 0x1b, 0x7f,
    0xed, 0x90, 0x1c, 0x40, 0x10, 0x3f, 0xe2, 0xfa,
    0x1c, 0x1d, 0x80, 0x7f, 0xf0, 0x69, 0x26, 0x7,
    0xff, 0x16, 0x8e, 0x0, 0x81, 0xff, 0xc5, 0x24,
    0x18, 0x1f, 0xfc, 0x18, 0x30, 0x82, 0x40, 0x1f,
    0xe3, 0x81, 0x41, 0x40, 0xfb, 0x20, 0x72, 0x98,
    0x96, 0x2, 0x74, 0x89, 0xbf, 0xea, 0xc3, 0xc0,
    0x72, 0xd5, 0x90, 0x39, 0x4f, 0x0, 0x80,

    /* U+36 "6" */
    0x3, 0x8c, 0xdf, 0xfb, 0x56, 0x7, 0xf1, 0xd8,
    0xc8, 0x1e, 0x2a, 0x76, 0x7, 0x96, 0x22, 0x6f,
    0xfe, 0xa4, 0x4a, 0x6, 0x34, 0x3e, 0xc8, 0x1f,
    0x2d, 0x42, 0xa0, 0x5c, 0x38, 0x7, 0xff, 0x1,
    0x60, 0x88, 0x2, 0x20, 0x1f, 0xfc, 0x22, 0xc5,
    0x4, 0x10, 0x3f, 0xf8, 0x9c, 0x10, 0x3f, 0xf9,
    0xa, 0x40, 0x1f, 0xfc, 0x82, 0xc8, 0x1f, 0xfe,
    0x83, 0x37, 0xff, 0x6a, 0x80, 0xfc, 0x76, 0x32,
    0x7, 0xc5, 0x5e, 0xc0, 0xe3, 0x89, 0x4d, 0xff,
    0xea, 0x84, 0xa0, 0x7a, 0x66, 0x40, 0xfc, 0xad,
    0x5, 0x40, 0xd1, 0x81, 0xff, 0xc1, 0x58, 0x22,
    0x40, 0x18, 0x1f, 0xfc, 0x32, 0x82, 0x3, 0xff,
    0x98, 0x83, 0x3, 0xff, 0x86, 0x50, 0x43, 0x88,
    0xc0, 0xff, 0xe0, 0xac, 0x19, 0xa, 0x9, 0x99,
    0x3, 0xf2, 0xb4, 0x14, 0x2, 0x74, 0x94, 0xdf,
    0xfe, 0xa8, 0x4a, 0x7, 0x2d, 0x59, 0x3, 0xe2,
    0xa7, 0x60, 0x40,

    /* U+37 "7" */
    0x3f, 0xff, 0xf1, 0x40, 0xff, 0xe3, 0x40, 0x7f,
    0xff, 0xe0, 0xd0, 0xc, 0xf, 0xfe, 0x1c, 0xc,
    0xf, 0xfe, 0x19, 0x21, 0x40, 0xff, 0xe1, 0xc0,
    0x88, 0x1f, 0xfc, 0x34, 0x20, 0x1f, 0xfc, 0x38,
    0x9, 0x1, 0xff, 0xc3, 0x62, 0x1, 0xff, 0xc3,
    0x60, 0x10, 0x1f, 0xfc, 0x3a, 0x20, 0x1f, 0xfc,
    0x34, 0x43, 0x3, 0xff, 0x87, 0x3, 0x3, 0xff,
    0x86, 0x48, 0x50, 0x3f, 0xf8, 0x70, 0x22, 0x7,
    0xff, 0xd, 0x8, 0x7, 0xff, 0xe, 0x2, 0x40,
    0x7f, 0xf0, 0xd8, 0x80, 0x7f, 0xf0, 0xd8, 0x4,
    0x7, 0xff, 0xe, 0x88, 0x7, 0xff, 0xd, 0x10,
    0xc0, 0xff, 0xe1, 0xc0, 0xc0, 0xff, 0xe1, 0x92,
    0x14, 0xf, 0xf0,

    /* U+38 "8" */
    0x3, 0x94, 0xdf, 0xfd, 0xa2, 0x3, 0xf1, 0xd5,
    0x90, 0x3e, 0x2e, 0xe4, 0x7, 0x3c, 0x4a, 0x6f,
    0xfe, 0xd0, 0x95, 0x60, 0x46, 0x7, 0x99, 0x3,
    0xe2, 0xf4, 0x11, 0x0, 0xe2, 0x40, 0x1f, 0xfc,
    0x17, 0x44, 0x0, 0x49, 0x81, 0xff, 0xc3, 0x44,
    0xe0, 0xc0, 0xff, 0xe2, 0xa0, 0xc8, 0x40, 0x7f,
    0xf1, 0x50, 0x61, 0x8, 0x7, 0xff, 0xd, 0x93,
    0x8, 0x1c, 0x3, 0xff, 0x83, 0x20, 0x70, 0x6,
    0x87, 0xe2, 0x3, 0xe2, 0xfb, 0x14, 0x81, 0x2e,
    0x43, 0xbf, 0xfd, 0xa0, 0x39, 0x1, 0xcc, 0x81,
    0x25, 0xe2, 0x4, 0x68, 0x1d, 0x20, 0x3d, 0xed,
    0xf6, 0xf9, 0x87, 0x40, 0x9b, 0x1d, 0x8, 0x1f,
    0xc6, 0x62, 0xa0, 0x8, 0x39, 0x3, 0xff, 0x82,
    0x70, 0x60, 0x84, 0x40, 0xff, 0xe2, 0x20, 0x88,
    0x60, 0x7f, 0xf1, 0xd8, 0x24, 0x80, 0xff, 0xe1,
    0x94, 0x8, 0x82, 0xb0, 0x3f, 0xf8, 0x2b, 0x8,
    0x1, 0x41, 0x33, 0x20, 0x7e, 0x5a, 0x86, 0xc0,
    0x4e, 0x92, 0x9b, 0xff, 0xd4, 0x8b, 0x0, 0xe5,
    0xab, 0x20, 0x7c, 0x55, 0xe8, 0x8,

    /* U+39 "9" */
    0x3, 0x94, 0xdf, 0xfd, 0xaa, 0x3, 0xf1, 0xd5,
    0x90, 0x3e, 0x2a, 0xf4, 0x7, 0x2c, 0x44, 0xdf,
    0xfd, 0xa1, 0x16, 0x1, 0x1a, 0x1f, 0x64, 0xf,
    0x8b, 0xd0, 0x36, 0x1, 0x3, 0x80, 0x7f, 0xf0,
    0x5d, 0x10, 0x2, 0x10, 0xf, 0xfe, 0x1a, 0x20,
    0x90, 0x20, 0x7f, 0xf1, 0x50, 0x64, 0x10, 0x3f,
    0xf8, 0xa8, 0x10, 0x85, 0x3, 0xff, 0x86, 0xc8,
    0x14, 0xa, 0x81, 0xff, 0xc1, 0x90, 0x6, 0x38,
    0x2f, 0x10, 0x1f, 0x17, 0xd8, 0x1e, 0x3d, 0x7,
    0x7f, 0xfb, 0x40, 0x73, 0x3, 0xd7, 0x44, 0x40,
    0xe2, 0x9e, 0xc2, 0x7, 0xe2, 0xee, 0xff, 0xb5,
    0x84, 0xf, 0xff, 0x42, 0xf0, 0xf, 0xfe, 0x51,
    0x3, 0xff, 0x88, 0x40, 0x90, 0x48, 0x7, 0xff,
    0x8, 0xa0, 0x80, 0x31, 0x50, 0x1f, 0xfc, 0x5,
    0x83, 0x20, 0x22, 0x17, 0x20, 0x3f, 0x2b, 0x41,
    0x40, 0x35, 0x80, 0xdf, 0xff, 0x54, 0x25, 0x3,
    0xcf, 0xd4, 0x40, 0xf1, 0x53, 0xb0, 0x20,

    /* U+3A ":" */
    0x17, 0x22, 0x3f, 0x17, 0xf0, 0xd8, 0xc0, 0xff,
    0xe0, 0xec, 0x65, 0x7c, 0x4b, 0xf0,

    /* U+3B ";" */
    0x17, 0x22, 0x3f, 0x17, 0xf0, 0xd8, 0xc0, 0xff,
    0xe0, 0xee, 0x40, 0xed, 0x40, 0x91,

    /* U+3C "<" */
    0x3, 0xff, 0x8d, 0x40, 0xf9, 0x74, 0x7, 0xa5,
    0x14, 0xc, 0x73, 0x39, 0x1, 0x3c, 0x5e, 0x20,
    0x56, 0xb, 0x0, 0xee, 0x3, 0x1, 0xe5, 0xd3,
    0xc4, 0xf, 0x58, 0x73, 0x3, 0xcf, 0x19, 0x40,
    0xf1, 0xcd, 0x1, 0xfa, 0x50,

    /* U+3D "=" */
    0x3f, 0xfe, 0xc0, 0x7f, 0x8f, 0xff, 0xb0, 0x1f,
    0xe3, 0xff, 0xec, 0x7, 0xf8,

    /* U+3E ">" */
    0x3, 0xfc, 0x60, 0x1f, 0xcf, 0x10, 0x3c, 0x61,
    0xcc, 0xf, 0x3c, 0x25, 0x3, 0xc7, 0xa4, 0xe8,
    0xf, 0x58, 0x2c, 0x3, 0xd8, 0x1a, 0x6, 0x5d,
    0x3c, 0x40, 0xa5, 0x16, 0x1, 0xb3, 0x5d, 0x1,
    0x89, 0x4a, 0x7, 0x8e, 0x60, 0x7c,

    /* U+3F "?" */
    0x3f, 0xed, 0x58, 0x1f, 0xe2, 0xa7, 0x60, 0x47,
    0xfe, 0xa8, 0x4a, 0x7, 0xe5, 0x68, 0x28, 0x7,
    0xf2, 0xc1, 0x81, 0xfe, 0x2c, 0x20, 0x3f, 0xdc,
    0xf, 0xfe, 0x6, 0x8, 0xf, 0xe4, 0x84, 0xf,
    0xe7, 0x44, 0x3, 0xc5, 0xe8, 0x22, 0x7, 0xfd,
    0xa1, 0x2a, 0xc0, 0xf1, 0x27, 0x72, 0x3, 0x8f,
    0xd9, 0x10, 0x1f, 0xfe, 0xf6, 0x7, 0xf8, 0xfa,
    0x7, 0xff, 0x2c, 0xfc, 0x7, 0xff, 0x2c,

    /* U+40 "@" */
    0x3, 0xe2, 0xee, 0xfe, 0xd5, 0x1, 0xff, 0xc0,
    0x37, 0x40, 0xa4, 0x93, 0xbe, 0x1, 0xfd, 0x33,
    0x9e, 0xc6, 0xe9, 0xb1, 0xb7, 0x40, 0x7a, 0xb6,
    0xcc, 0xf, 0xc6, 0x73, 0x58, 0x1a, 0x29, 0x0,
    0x7f, 0xf0, 0x72, 0x88, 0x1, 0x6e, 0x3, 0xff,
    0x87, 0x4c, 0x1, 0x4, 0x3, 0x9c, 0xb7, 0xe0,
    0x28, 0x50, 0x4c, 0xc, 0x7c, 0x69, 0x7c, 0x4,
    0x87, 0x23, 0x81, 0xb0, 0x9f, 0xf8, 0x81, 0xc9,
    0x80, 0x20, 0x54, 0x56, 0x7, 0xff, 0x4, 0x81,
    0xe4, 0xa0, 0x3f, 0xf9, 0x4, 0x70, 0x3f, 0xf9,
    0x2c, 0x30, 0x3f, 0xf9, 0x2c, 0x30, 0x3f, 0xf8,
    0xc4, 0x1, 0x1c, 0xf, 0xfe, 0x19, 0x21, 0xc0,
    0x92, 0x80, 0xff, 0xe0, 0xa6, 0x13, 0x2, 0xa2,
    0xb0, 0x3f, 0xe4, 0x30, 0x82, 0x1, 0x61, 0x3f,
    0xf1, 0x3, 0x42, 0xc1, 0x6e, 0x0, 0x7c, 0x4b,
    0xc0, 0x6a, 0x60, 0x14, 0x52, 0x0, 0x9d, 0xbe,
    0x0, 0x72, 0x88, 0xd, 0x5b, 0x66, 0x7, 0xfb,
    0x1a, 0xc0, 0xf4, 0xce, 0x7b, 0x1b, 0x80, 0xcf,
    0xa0, 0x3f, 0x1b, 0xa0, 0x52, 0x40, 0x2f, 0x80,
    0x70,

    /* U+41 "A" */
    0x3, 0xfc, 0x7f, 0x30, 0x3f, 0xf9, 0x14, 0x5,
    0x3, 0xff, 0x90, 0xc1, 0x24, 0x7, 0xff, 0x1a,
    0x5, 0x44, 0x3, 0xff, 0x8c, 0xc4, 0x60, 0x90,
    0x1f, 0xfc, 0x46, 0x11, 0x10, 0x40, 0x3f, 0xf8,
    0x94, 0x70, 0xc, 0x20, 0x3f, 0xf8, 0x68, 0x92,
    0x2, 0x62, 0x1, 0xff, 0xc2, 0xe2, 0x81, 0xa8,
    0x60, 0x7f, 0xf0, 0x4a, 0xc, 0xc, 0x50, 0x60,
    0x7f, 0xf0, 0x28, 0x60, 0x7b, 0x88, 0x7, 0xff,
    0x1, 0x88, 0x7, 0x91, 0x8, 0xf, 0xf4, 0x8,
    0xf, 0xd0, 0x40, 0x3f, 0xcc, 0x40, 0x3f, 0x20,
    0x48, 0xf, 0xcc, 0x22, 0x7, 0xf4, 0x10, 0xf,
    0xd4, 0x70, 0x3f, 0xcc, 0x22, 0x7, 0x91, 0x24,
    0x7, 0xfc, 0xc5, 0x3, 0xdc, 0x50, 0x3f, 0xf8,
    0x14, 0x30, 0x38, 0xa0, 0xc0, 0xff, 0xe0, 0x14,
    0x18, 0x1a, 0x8, 0x7, 0xff, 0xa, 0x8, 0x6,
    0x41, 0x81, 0xff, 0xc2, 0x24, 0x10, 0x8, 0x18,
    0x1f, 0xfc, 0x48, 0x20, 0x6, 0x28, 0x1f, 0xfc,
    0x44, 0x49, 0x0,

    /* U+42 "B" */
    0x3f, 0xff, 0xf0, 0x35, 0x40, 0x7f, 0xf1, 0xca,
    0xb8, 0x81, 0x8f, 0xff, 0xfc, 0x18, 0x4b, 0x20,
    0x3f, 0xf8, 0xaf, 0x41, 0x48, 0x1f, 0xfc, 0x67,
    0x4, 0x3, 0xff, 0x8e, 0xc2, 0x3, 0xff, 0x90,
    0x40, 0xff, 0xe4, 0x90, 0x34, 0x40, 0x7f, 0xf0,
    0xa0, 0x40, 0xb, 0xe0, 0x7f, 0xf0, 0x63, 0x10,
    0xf, 0xfe, 0x19, 0x99, 0x8a, 0x40, 0xcb, 0xff,
    0xf6, 0x64, 0x44, 0x7, 0x92, 0xff, 0x88, 0x9,
    0x40, 0xe3, 0x6f, 0xfd, 0xbc, 0xb, 0x90, 0x3f,
    0xf8, 0xaf, 0xa1, 0x81, 0xf8, 0xf, 0xfe, 0x1d,
    0x21, 0x81, 0xff, 0xc7, 0xa3, 0x1, 0xff, 0xc9,
    0x20, 0x7f, 0xf1, 0xe8, 0xc0, 0x7f, 0xf1, 0x4e,
    0x24, 0x80, 0xff, 0xe1, 0xab, 0x89, 0x60, 0x7f,
    0xff, 0xe1, 0x54, 0x1e, 0x3, 0xff, 0x8a, 0xa7,
    0x80, 0x40,

    /* U+43 "C" */
    0x3, 0xc6, 0x7f, 0xff, 0x40, 0x3a, 0x66, 0x7,
    0xff, 0x13, 0x30, 0xef, 0xff, 0x98, 0x1d, 0x48,
    0xd1, 0x1, 0xfb, 0x81, 0x92, 0xc, 0x40, 0xff,
    0x2b, 0x40, 0x20, 0x84, 0xf, 0xf8, 0xa2, 0x11,
    0x26, 0x7, 0xff, 0x13, 0x8a, 0x7, 0xff, 0x15,
    0x4, 0x7, 0xff, 0x1c, 0x81, 0xff, 0xc4, 0x20,
    0x81, 0xff, 0xed, 0x20, 0x81, 0xff, 0xc8, 0x20,
    0x7f, 0xf1, 0x50, 0x40, 0x7f, 0xf1, 0x78, 0xa0,
    0x7f, 0xf1, 0x51, 0x26, 0x7, 0xff, 0x16, 0x8,
    0x40, 0xff, 0x8a, 0x20, 0x12, 0xc, 0x40, 0xff,
    0x2b, 0x40, 0x54, 0x8d, 0x8, 0x1f, 0xb8, 0x1e,
    0xc8, 0x3d, 0xff, 0xe6, 0x7, 0xd6, 0x90, 0x1f,
    0xfc, 0x0,

    /* U+44 "D" */
    0x3f, 0xff, 0xd5, 0x81, 0xff, 0xc6, 0x53, 0x10,
    0x31, 0xff, 0xfd, 0xa0, 0x38, 0x81, 0xff, 0xc2,
    0x2f, 0xa1, 0x80, 0xff, 0xe2, 0xd2, 0x28, 0x1f,
    0xfc, 0x5c, 0x11, 0x3, 0xff, 0x8a, 0xc4, 0x3,
    0xff, 0x8b, 0x42, 0x3, 0xff, 0x8a, 0x48, 0x10,
    0x3f, 0xf8, 0xac, 0x20, 0x3f, 0xf8, 0xa4, 0xf,
    0xfe, 0x3f, 0x1c, 0xf, 0xfe, 0x2f, 0x1c, 0xf,
    0xfe, 0x29, 0x3, 0xff, 0x8e, 0xc2, 0x3, 0xff,
    0x88, 0x48, 0x10, 0x3f, 0xf8, 0x94, 0x20, 0x3f,
    0xf8, 0xac, 0x40, 0x9, 0x0, 0xff, 0xe0, 0x60,
    0x88, 0x36, 0x1, 0xff, 0x52, 0x28, 0x1f, 0xfc,
    0x12, 0xfa, 0x18, 0xe, 0x3f, 0xfe, 0xd0, 0x1c,
    0x40, 0xff, 0xe1, 0x99, 0x88, 0x18,

    /* U+45 "E" */
    0x3f, 0xff, 0xf1, 0xa8, 0x1f, 0xfc, 0x83, 0xff,
    0xff, 0x1a, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe,
    0x7, 0xf8, 0xff, 0xff, 0xc6, 0xa0, 0x7f, 0xf2,
    0x8f, 0xff, 0xfc, 0x4a, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xb9, 0xff, 0xff, 0x89, 0x40, 0xff, 0xe4,
    0x0,

    /* U+46 "F" */
    0x3f, 0xff, 0xf1, 0xa8, 0x1f, 0xfc, 0x83, 0xff,
    0xff, 0x1a, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe,
    0x7, 0xf8, 0xff, 0xff, 0xc6, 0xa0, 0x7f, 0xf2,
    0x8f, 0xff, 0xfc, 0x4a, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xf8, 0x1f, 0xfd, 0x20,

    /* U+47 "G" */
    0x3, 0xc6, 0xff, 0xff, 0x40, 0x3a, 0x64, 0x7,
    0xff, 0x13, 0x30, 0xef, 0xff, 0x98, 0x1d, 0x48,
    0xd1, 0x1, 0xfb, 0x81, 0x92, 0xc, 0x40, 0xff,
    0x29, 0x40, 0x41, 0x8, 0x1f, 0xf1, 0x64, 0x22,
    0x4c, 0xf, 0xfe, 0x27, 0x14, 0xf, 0xfe, 0x2a,
    0x8, 0xf, 0xfe, 0x39, 0x3, 0xff, 0x88, 0x41,
    0x3, 0xff, 0xda, 0x41, 0x3, 0xf6, 0xff, 0xe8,
    0x4, 0x40, 0xff, 0xe2, 0xa0, 0x80, 0xfb, 0x7f,
    0xd0, 0xb, 0x8a, 0x7, 0xff, 0x15, 0x12, 0x60,
    0x7f, 0xf1, 0x60, 0x84, 0xf, 0xfe, 0x22, 0x41,
    0x88, 0x1f, 0xfc, 0x4a, 0x46, 0x84, 0xf, 0xdc,
    0xf, 0x64, 0x1e, 0xff, 0xf3, 0x3, 0xeb, 0x90,
    0x1f, 0xfc, 0x0,

    /* U+48 "H" */
    0x3e, 0x81, 0xff, 0xc2, 0x5e, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0x8c, 0x81, 0x97,
    0xff, 0xfc, 0x28, 0x7, 0xff, 0x31, 0x7f, 0xff,
    0xc2, 0xa0, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xd4,

    /* U+49 "I" */
    0x3f, 0x1, 0xff, 0xf6,

    /* U+4A "J" */
    0x3, 0xff, 0x81, 0x7a, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xfc, 0x24, 0x3, 0xff, 0x80, 0x6c, 0x3,
    0xff, 0xa2, 0x40, 0xff, 0xe0, 0x10, 0x3f, 0xf8,
    0x68, 0x40, 0x3f, 0xf8, 0x10, 0x32, 0x7, 0xfc,
    0x58, 0xc4, 0xf, 0xfa, 0x11, 0x98, 0x1f, 0xf6,
    0x42, 0x78, 0x88, 0x1f, 0xad, 0x10, 0xee, 0xe8,
    0xf, 0x96, 0xac, 0x81, 0xc0,

    /* U+4B "K" */
    0x3f, 0x1, 0xff, 0xc0, 0x5f, 0x1, 0xff, 0xc4,
    0x82, 0x1, 0xff, 0xc3, 0x24, 0x10, 0x1f, 0xfc,
    0x38, 0x20, 0x1f, 0xfc, 0x44, 0x18, 0x1f, 0xfc,
    0x36, 0x18, 0x1f, 0xfc, 0x48, 0x20, 0x1f, 0xfc,
    0x34, 0x10, 0x18, 0xee, 0x7, 0xf4, 0x10, 0xe,
    0x24, 0x7, 0xe2, 0x70, 0x1f, 0xfc, 0x38, 0x20,
    0x1c, 0x7f, 0xff, 0x20, 0x80, 0xff, 0xe3, 0x20,
    0x3e, 0x3f, 0xfe, 0x62, 0x1, 0xff, 0xc4, 0x80,
    0x90, 0x1f, 0xfc, 0x44, 0x20, 0x1f, 0xfc, 0x48,
    0x10, 0x1f, 0xfc, 0x42, 0x84, 0x3, 0xff, 0x89,
    0x3, 0x3, 0xff, 0x88, 0x48, 0x30, 0x3f, 0xf8,
    0x90, 0x40, 0x3f, 0xf8, 0x88, 0x84, 0x7, 0xff,
    0x12, 0x88, 0x0,

    /* U+4C "L" */
    0x3f, 0x1, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0,
    0x7, 0xff, 0xfe, 0x10, 0x1f, 0xfc, 0x70,

    /* U+4D "M" */
    0x3f, 0x98, 0x1f, 0xfc, 0x6d, 0xf0, 0x14, 0x3,
    0xff, 0x8a, 0xc8, 0x1e, 0xa0, 0x7f, 0xf1, 0x20,
    0x1f, 0x24, 0x3, 0xff, 0x85, 0x41, 0x3, 0x18,
    0x28, 0x1f, 0xfc, 0x14, 0x82, 0x1, 0xcc, 0x88,
    0x7, 0xff, 0x2, 0x8, 0xc0, 0xf7, 0xc, 0x81,
    0xfe, 0x84, 0x98, 0x1f, 0x16, 0x38, 0x1f, 0xc5,
    0x88, 0x7, 0xf4, 0x5, 0x81, 0xfa, 0x4, 0x80,
    0x7f, 0xa8, 0x80, 0x7c, 0x90, 0x50, 0x3f, 0xe4,
    0x82, 0x1, 0xea, 0x20, 0x1f, 0xfc, 0x18, 0x19,
    0x3, 0x40, 0x58, 0x1f, 0xfc, 0x12, 0xc7, 0x2,
    0x2c, 0x70, 0x3f, 0xf8, 0x70, 0x93, 0x1, 0xc3,
    0x20, 0x7f, 0xf1, 0x20, 0x81, 0x91, 0x0, 0xff,
    0xe2, 0xa4, 0x16, 0xa, 0x7, 0xff, 0x1e, 0x84,
    0x12, 0x1, 0xff, 0xc8, 0x80, 0x20, 0x1f, 0xfc,
    0x96, 0x61, 0x3, 0xff, 0x95, 0xd8, 0x1f, 0xfc,
    0xb2, 0x7, 0xff, 0xc8,

    /* U+4E "N" */
    0x3f, 0xa0, 0x1f, 0xfc, 0x3d, 0xc8, 0x13, 0x40,
    0x7f, 0xf2, 0x69, 0x3, 0xff, 0x8c, 0x60, 0xe0,
    0x7f, 0xf1, 0xda, 0x34, 0xf, 0xfe, 0x3d, 0x29,
    0x81, 0xff, 0xc7, 0xe2, 0x20, 0x3f, 0xf8, 0xc6,
    0x8a, 0x7, 0xff, 0x1d, 0x31, 0x80, 0xff, 0xe3,
    0xc4, 0x60, 0x1f, 0xfc, 0x7a, 0x1b, 0x1, 0xff,
    0xc7, 0xc2, 0x10, 0x3f, 0xf8, 0xc6, 0xc, 0x7,
    0xff, 0x1d, 0xb0, 0xa0, 0x7f, 0xf1, 0xe1, 0x50,
    0xf, 0xfe, 0x3e, 0xd, 0x1, 0xff, 0xc7, 0xa2,
    0x90, 0x3f, 0xf8, 0xca, 0xe, 0x7, 0xff, 0x1d,
    0xa3, 0x40, 0xff, 0xe3, 0xd2, 0x98, 0x1f, 0xfc,
    0x7e, 0x21, 0x3, 0xff, 0x8c, 0x68, 0x1f, 0xfc,
    0x94, 0xc0, 0x80,

    /* U+4F "O" */
    0x3, 0xe7, 0x70, 0xd, 0x58, 0x1f, 0xfc, 0x9,
    0xe2, 0x20, 0xa, 0x9e, 0x1, 0xf8, 0xe6, 0xc,
    0xc0, 0x34, 0x21, 0xe0, 0x3e, 0xc4, 0xb6, 0x32,
    0x0, 0xbd, 0x84, 0xb8, 0x1d, 0x82, 0xc4, 0xf,
    0xc7, 0x21, 0x80, 0x91, 0x2a, 0x7, 0xff, 0x2,
    0x92, 0x40, 0x20, 0x80, 0x7f, 0xf0, 0xa0, 0x80,
    0x9, 0x20, 0x3f, 0xf8, 0x48, 0x10, 0x43, 0x3,
    0xff, 0x88, 0x81, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0x5c, 0x81, 0xff, 0xc6, 0x60, 0x80, 0x40, 0x7f,
    0xf1, 0x8, 0x12, 0xc, 0xf, 0xfe, 0x13, 0x8,
    0x4, 0x10, 0x81, 0xff, 0xc0, 0x30, 0x40, 0x5,
    0x8c, 0x40, 0xff, 0x1c, 0x21, 0x2, 0x88, 0x68,
    0x40, 0xf1, 0xb8, 0x36, 0x3, 0xab, 0xf, 0x64,
    0x1, 0x36, 0x21, 0x20, 0xf, 0xa6, 0x40, 0xb0,
    0xc, 0x85, 0x98, 0x1f, 0xc6, 0xfb, 0x0, 0x4b,
    0xe9, 0x3, 0x80,

    /* U+50 "P" */
    0x3f, 0xff, 0xf0, 0x75, 0x60, 0x7f, 0xf1, 0xca,
    0x9d, 0x81, 0x1f, 0xff, 0xf8, 0x55, 0x9, 0x80,
    0xff, 0xe2, 0xab, 0x40, 0xd0, 0x3f, 0xf8, 0xcb,
    0x4, 0x80, 0x7f, 0xf1, 0x8b, 0x18, 0xf, 0xfe,
    0x3e, 0x4, 0xf, 0xfe, 0x3e, 0x4, 0xf, 0xfe,
    0x31, 0x62, 0x81, 0xff, 0xc5, 0x58, 0x32, 0x7,
    0xff, 0x8, 0xbd, 0x42, 0x80, 0xff, 0xff, 0xc1,
    0xd0, 0x89, 0x40, 0xff, 0xe1, 0x92, 0x77, 0xb0,
    0x38, 0xff, 0xfe, 0xd9, 0x10, 0x1f, 0xff, 0xf0,
    0x3f, 0xff, 0xe0, 0x7f, 0xfa, 0x40,

    /* U+51 "Q" */
    0x3, 0xe7, 0x7f, 0xd5, 0x81, 0xff, 0xc0, 0x9e,
    0x20, 0x32, 0x9e, 0x1, 0xf8, 0xe6, 0xc, 0xdf,
    0xb4, 0x21, 0xe0, 0x3e, 0xc4, 0xb6, 0x32, 0x0,
    0xbd, 0x84, 0xb0, 0x1d, 0x40, 0x62, 0x7, 0xe3,
    0x91, 0xa0, 0x49, 0x0, 0x40, 0x3f, 0xea, 0x52,
    0x0, 0xe1, 0x86, 0xc0, 0x7f, 0xd0, 0x70, 0x8,
    0x48, 0x10, 0x81, 0xfe, 0x41, 0x2, 0x10, 0x68,
    0x60, 0x3f, 0xe4, 0x8, 0x1d, 0x48, 0xc0, 0x7f,
    0xf1, 0xf0, 0x34, 0xf, 0xfe, 0x3e, 0x9, 0x81,
    0xff, 0xc6, 0x30, 0x44, 0x7, 0xff, 0x19, 0xb0,
    0xa4, 0xf, 0xfe, 0x34, 0x23, 0x81, 0xe6, 0x0,
    0x84, 0x7, 0xd8, 0x1a, 0x7, 0x10, 0x42, 0x8,
    0xf, 0xb0, 0x50, 0x9, 0x84, 0x3, 0x88, 0x7,
    0xc6, 0x6, 0xc0, 0xc1, 0xc0, 0x24, 0x34, 0xf,
    0x9b, 0x8, 0xf0, 0x48, 0x5, 0x4a, 0xc4, 0xf,
    0x42, 0x20, 0xa, 0x7, 0x62, 0x5b, 0x19, 0x4,
    0x98, 0x1b, 0x81, 0xf6, 0x60, 0xcd, 0xf6, 0x42,
    0x4, 0xc0, 0xfd, 0x3c, 0x40, 0x65, 0x3c, 0x10,
    0x80,

    /* U+52 "R" */
    0x3f, 0xff, 0xf0, 0x75, 0x60, 0x7f, 0xf1, 0xca,
    0x9d, 0x81, 0x1f, 0xff, 0xf8, 0x55, 0x9, 0x80,
    0xff, 0xe2, 0xab, 0x40, 0xd0, 0x3f, 0xf8, 0xcb,
    0x4, 0x80, 0x7f, 0xf1, 0x8b, 0x18, 0xf, 0xfe,
    0x3e, 0x4, 0xf, 0xfe, 0x3e, 0x4, 0xf, 0xfe,
    0x31, 0x62, 0x81, 0xff, 0xc5, 0x58, 0x32, 0x7,
    0xff, 0x8, 0xbd, 0x42, 0x80, 0xff, 0xff, 0xc1,
    0xd0, 0x89, 0x40, 0xff, 0xe1, 0x92, 0x77, 0xb0,
    0x38, 0xfe, 0x20, 0x27, 0xfb, 0x64, 0x40, 0x7f,
    0xb4, 0x12, 0x81, 0xff, 0xc6, 0x78, 0xae, 0x80,
    0xff, 0xe2, 0x9c, 0x85, 0x80, 0x7f, 0xf1, 0xad,
    0x7, 0x88, 0x1f, 0xfc, 0x55, 0xc9, 0x66, 0x7,
    0xff, 0x1b, 0x41, 0x28, 0x1f, 0xfc, 0x67, 0x8a,
    0xe8, 0xf, 0xfe, 0x29, 0xcc, 0x58, 0x7, 0xff,
    0x1a, 0x50, 0xf1,

    /* U+53 "S" */
    0x3, 0x94, 0xdf, 0xff, 0xf0, 0x68, 0x11, 0xd5,
    0x90, 0x3f, 0xf8, 0x8b, 0x11, 0x37, 0xff, 0xf5,
    0x2, 0x34, 0x3e, 0xc8, 0x1f, 0xfc, 0x3e, 0x1c,
    0x3, 0xff, 0x84, 0xe7, 0x4, 0x40, 0x3f, 0xf8,
    0x65, 0xa2, 0x8, 0x1f, 0xfc, 0x72, 0x8, 0x1f,
    0xfc, 0x84, 0x28, 0x1f, 0xfc, 0x78, 0x15, 0x3,
    0xff, 0x8c, 0x68, 0x5e, 0xa2, 0x7, 0xff, 0xd,
    0x74, 0x15, 0xdf, 0xfb, 0x42, 0x7, 0xeb, 0xa2,
    0x20, 0x78, 0xbd, 0x48, 0x1f, 0x17, 0x77, 0xfe,
    0xd0, 0x2c, 0x40, 0xff, 0xe2, 0x17, 0xd0, 0xc0,
    0x7f, 0xf1, 0xe9, 0xc, 0xf, 0xfe, 0x3d, 0x18,
    0xf, 0xfe, 0x49, 0x4, 0x80, 0xff, 0xe2, 0x51,
    0x8e, 0xe0, 0x7f, 0xf0, 0x8e, 0x24, 0x80, 0xff,
    0xe1, 0xab, 0x89, 0x60, 0x23, 0xff, 0xff, 0x2,
    0xa0, 0xf0, 0x1f, 0xfc, 0x55, 0x3c, 0x2,

    /* U+54 "T" */
    0x3f, 0xff, 0xf2, 0x70, 0x1f, 0xfc, 0xb3, 0xff,
    0xf5, 0x7, 0xff, 0xec, 0x7, 0xf9, 0x81, 0xff,
    0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xc0,

    /* U+55 "U" */
    0x3f, 0x1, 0xff, 0xc4, 0xdc, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf, 0xff,
    0xf8, 0x1f, 0x88, 0x20, 0x7f, 0xf1, 0x8, 0x21,
    0x4, 0x7, 0xff, 0x9, 0x4, 0x3, 0x88, 0x7,
    0xff, 0xa, 0xe, 0x1, 0x21, 0xa0, 0x7f, 0xf0,
    0x29, 0x48, 0x5, 0x4a, 0xc4, 0xf, 0xcb, 0x23,
    0x40, 0xec, 0x4b, 0x63, 0x20, 0xb, 0xd4, 0x96,
    0x3, 0xec, 0xc1, 0x9b, 0xf6, 0x84, 0x3c, 0x7,
    0xf4, 0xf1, 0x1, 0x94, 0xf0, 0xe,

    /* U+56 "V" */
    0x1f, 0x88, 0x1f, 0xfc, 0x5d, 0xd0, 0x62, 0x81,
    0xff, 0xc4, 0x44, 0x90, 0x81, 0x81, 0xff, 0xc4,
    0xe2, 0x81, 0x20, 0xc0, 0xff, 0xe1, 0x14, 0x18,
    0x14, 0x10, 0xf, 0xfe, 0x15, 0xc, 0xc, 0x48,
    0x30, 0x3f, 0xf8, 0x2c, 0x40, 0x3a, 0xa, 0x7,
    0xff, 0x2, 0x4, 0x7, 0x91, 0x24, 0x7, 0xfc,
    0xc4, 0x3, 0xea, 0x38, 0x1f, 0xe6, 0x11, 0x3,
    0xe6, 0x11, 0x3, 0xfa, 0x8e, 0x7, 0xf3, 0x14,
    0xf, 0xc8, 0x92, 0x3, 0xfa, 0x6, 0x7, 0xee,
    0x28, 0x1f, 0xf2, 0x10, 0xf, 0x14, 0x18, 0x1f,
    0xf4, 0xc, 0xf, 0x40, 0xc0, 0xff, 0xe0, 0x14,
    0x18, 0x1c, 0x84, 0x3, 0xff, 0x83, 0xc5, 0x3,
    0x40, 0xc0, 0xff, 0xe1, 0x22, 0x48, 0x9, 0x8a,
    0x7, 0xff, 0xe, 0x8e, 0x1, 0x84, 0x40, 0xff,
    0xe1, 0xb0, 0x88, 0xa3, 0x81, 0xff, 0xc5, 0x62,
    0x22, 0x48, 0xf, 0xfe, 0x2c, 0xa, 0xa, 0x7,
    0xff, 0x1d, 0x82, 0x18, 0x1f, 0xfc, 0x7a, 0x2,
    0x1, 0xfe,

    /* U+57 "W" */
    0x1f, 0x88, 0x1f, 0xfd, 0x25, 0xf0, 0x6, 0x28,
    0x1f, 0xfd, 0x28, 0x28, 0x8, 0x18, 0x1f, 0xfd,
    0x12, 0x41, 0x81, 0x20, 0xc0, 0xff, 0xe8, 0x41,
    0x0, 0xd0, 0x40, 0x3f, 0xfa, 0x8, 0x30, 0x31,
    0x20, 0xc0, 0xff, 0xe7, 0x40, 0xc0, 0xf4, 0x14,
    0xf, 0xfe, 0x4, 0x40, 0x7f, 0xf0, 0x18, 0xa0,
    0x79, 0x12, 0x40, 0x7f, 0xce, 0x1, 0xff, 0x30,
    0x88, 0x1f, 0x51, 0xc0, 0xff, 0x30, 0x48, 0xf,
    0xf4, 0x1c, 0xf, 0xcc, 0x22, 0x7, 0xf5, 0x1,
    0x0, 0xfe, 0x40, 0xa0, 0x3f, 0x98, 0xa0, 0x7e,
    0x44, 0x82, 0x20, 0x7e, 0x82, 0x1, 0xfe, 0x81,
    0x81, 0xfb, 0x8a, 0xc5, 0x3, 0xe2, 0x41, 0x1,
    0xff, 0x21, 0x0, 0xf1, 0x41, 0xd0, 0xc0, 0xfa,
    0x8, 0x7, 0xff, 0x2, 0x6, 0x7, 0xa0, 0x60,
    0xa0, 0xc0, 0xe2, 0x83, 0x3, 0xff, 0x80, 0x50,
    0x60, 0x72, 0x10, 0x4, 0x10, 0xe, 0xa1, 0x81,
    0xff, 0xc2, 0xe2, 0x81, 0xa0, 0x60, 0x44, 0x82,
    0x3, 0x31, 0x40, 0xff, 0xe1, 0x22, 0x48, 0x9,
    0x8a, 0x6, 0x82, 0x1, 0x30, 0x88, 0x1f, 0xfc,
    0x3a, 0x38, 0x6, 0x11, 0x3, 0x20, 0x48, 0x4,
    0x10, 0xf, 0xfe, 0x23, 0x8, 0x8a, 0x38, 0x1e,
    0x82, 0x4, 0x9, 0x1, 0xff, 0xc5, 0x62, 0x22,
    0x48, 0xf, 0x30, 0x8c, 0x10, 0xf, 0xfe, 0x34,
    0xa, 0xa, 0x7, 0xe6, 0x39, 0x8, 0xf, 0xfe,
    0x3b, 0x4, 0x30, 0x3f, 0x50, 0x44, 0x3, 0xff,
    0x91, 0x40, 0x40, 0x3f, 0x8a, 0x0, 0xc0, 0xff,
    0x0,

    /* U+58 "X" */
    0x1b, 0xe0, 0x3f, 0xf8, 0x47, 0xf3, 0x18, 0x18,
    0x7, 0xff, 0x7, 0x84, 0xc0, 0x60, 0xd8, 0xf,
    0xfa, 0x92, 0xa0, 0x46, 0x8, 0x40, 0xfe, 0x88,
    0x70, 0x39, 0xb0, 0xc0, 0x7e, 0x4c, 0x52, 0x7,
    0xa1, 0x18, 0xf, 0x1a, 0x22, 0x3, 0xf6, 0x6,
    0x1, 0xd8, 0x26, 0x7, 0xfb, 0x6, 0xc0, 0x54,
    0x1a, 0x7, 0xfc, 0x60, 0x84, 0x44, 0x30, 0x1f,
    0xfc, 0x16, 0xc3, 0x36, 0x18, 0xf, 0xfe, 0x1c,
    0x22, 0x8, 0x40, 0xff, 0xe2, 0x60, 0x5, 0x81,
    0xff, 0xc6, 0xc0, 0xb0, 0x3f, 0xf8, 0x84, 0x18,
    0x21, 0x3, 0xff, 0x84, 0xb1, 0xd, 0x86, 0x3,
    0xff, 0x82, 0x68, 0x40, 0x21, 0x18, 0xf, 0xfe,
    0x6, 0xd, 0x80, 0xb0, 0x34, 0xf, 0xf6, 0x6,
    0x1, 0xd8, 0x26, 0x7, 0xe8, 0x46, 0x3, 0xc6,
    0x88, 0x80, 0xf3, 0x61, 0x80, 0xfc, 0x98, 0xa4,
    0xc, 0x60, 0x84, 0xf, 0xe8, 0x87, 0x3, 0x60,
    0xd8, 0xf, 0xfa, 0x92, 0xa0, 0x30, 0x30, 0xf,
    0xfe, 0xf, 0x9, 0x80,

    /* U+59 "Y" */
    0x3f, 0x90, 0x1f, 0xfc, 0x25, 0xf9, 0x18, 0x29,
    0x3, 0xff, 0x80, 0x68, 0x88, 0x36, 0x18, 0xf,
    0xfe, 0x7, 0x9, 0x81, 0x42, 0x30, 0x1f, 0xea,
    0x4a, 0x81, 0xd8, 0x18, 0x7, 0xe8, 0x87, 0x3,
    0xec, 0x1b, 0x1, 0xe4, 0xc5, 0x20, 0x7c, 0x60,
    0x84, 0xc, 0x68, 0x88, 0xf, 0xe6, 0xc3, 0x1,
    0xb8, 0x4c, 0xf, 0xfa, 0x11, 0x80, 0x52, 0x54,
    0xf, 0xfe, 0xe, 0x6, 0x42, 0x1c, 0xf, 0xfe,
    0x1e, 0xd, 0x85, 0x20, 0x7f, 0xf0, 0xcc, 0x1,
    0x10, 0x1f, 0xfc, 0x56, 0x1, 0x1, 0xff, 0xff,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xc,

    /* U+5A "Z" */
    0x3f, 0xff, 0xf1, 0x0, 0xff, 0xe2, 0xc0, 0x7f,
    0xff, 0xe0, 0x20, 0x58, 0x1f, 0xfc, 0x12, 0x87,
    0x3, 0xff, 0x85, 0xc3, 0x20, 0x7f, 0xf0, 0x59,
    0x10, 0xf, 0xfe, 0x14, 0x14, 0xf, 0xfe, 0x15,
    0x9, 0x0, 0xff, 0xe0, 0xa4, 0x10, 0xf, 0xfe,
    0x14, 0x10, 0x81, 0xff, 0xc1, 0x84, 0x98, 0x1f,
    0xfc, 0x12, 0xc7, 0x3, 0xff, 0x85, 0x2, 0x20,
    0x7f, 0xf0, 0x52, 0xa, 0x7, 0xff, 0xa, 0x88,
    0x7, 0xff, 0xa, 0x2, 0xc0, 0xff, 0xe0, 0x96,
    0x38, 0x1f, 0xfc, 0x2e, 0x19, 0x3, 0xff, 0x82,
    0xc8, 0x80, 0x7f, 0xf0, 0xa0, 0xa0, 0x7f, 0xf0,
    0xa8, 0x28, 0xf, 0xfe, 0xa, 0x40, 0x7f, 0xff,
    0xe0, 0x21, 0x0, 0xff, 0xe2, 0x0,

    /* U+5B "[" */
    0x3f, 0xe8, 0x0, 0xa4, 0xc0, 0x2d, 0x90, 0x1f,
    0xff, 0xf0, 0x3f, 0xfa, 0xf6, 0xc8, 0x1, 0x49,
    0x80,

    /* U+5C "\\" */
    0x1f, 0x88, 0x1f, 0xf3, 0x14, 0xf, 0xfa, 0x6,
    0x7, 0xff, 0x1, 0x6, 0x7, 0xfd, 0x4, 0x3,
    0xfe, 0x24, 0x18, 0x1f, 0xf4, 0x14, 0xf, 0xf9,
    0x12, 0x40, 0x7f, 0xd4, 0x70, 0x3f, 0xe6, 0x11,
    0x3, 0xfe, 0x62, 0x81, 0xff, 0x40, 0xc0, 0xff,
    0xe0, 0x21, 0x0, 0xff, 0xa0, 0x60, 0x7f, 0xc5,
    0x6, 0x7, 0xfd, 0xc5, 0x3, 0xfe, 0x44, 0x90,
    0x1f, 0xf5, 0x1c, 0xf, 0xf9, 0x84, 0x40, 0xff,
    0x98, 0x80, 0x7f, 0xd0, 0x20, 0x3f, 0xf8, 0xc,
    0x40, 0x3f, 0xea, 0x18,

    /* U+5D "]" */
    0x3f, 0xe8, 0x12, 0x80, 0x1b, 0x60, 0x3f, 0xff,
    0xe0, 0x7f, 0xf5, 0xcd, 0xb0, 0x12, 0x50, 0x0,

    /* U+5E "^" */
    0x3, 0xff, 0x8c, 0x79, 0x3, 0xfd, 0xc7, 0x3,
    0xf9, 0x93, 0x30, 0x3e, 0x30, 0xe3, 0x8, 0x1e,
    0xe3, 0x8e, 0x38, 0x1d, 0xc, 0x20, 0xc3, 0x0,
    0x8b, 0x2c, 0x9, 0x96, 0x40, 0x71, 0xc0, 0xee,
    0x38,

    /* U+5F "_" */
    0x3, 0xfc, 0x7f, 0xfc, 0x7, 0xfc,

    /* U+60 "`" */
    0x2, 0x3f, 0x1, 0x1e, 0x80, 0x40,

    /* U+61 "a" */
    0x3, 0xfc, 0x7f, 0x30, 0x3f, 0xf9, 0x14, 0x5,
    0x3, 0xff, 0x90, 0xc1, 0x24, 0x7, 0xff, 0x1a,
    0x5, 0x44, 0x3, 0xff, 0x8c, 0xc4, 0x60, 0x90,
    0x1f, 0xfc, 0x46, 0x11, 0x10, 0x40, 0x3f, 0xf8,
    0x94, 0x70, 0xc, 0x20, 0x3f, 0xf8, 0x68, 0x92,
    0x2, 0x62, 0x1, 0xff, 0xc2, 0xe2, 0x81, 0xa8,
    0x60, 0x7f, 0xf0, 0x4a, 0xc, 0xc, 0x50, 0x60,
    0x7f, 0xf0, 0x28, 0x60, 0x7b, 0x88, 0x7, 0xff,
    0x1, 0x88, 0x7, 0x91, 0x8, 0xf, 0xf4, 0x8,
    0xf, 0xd0, 0x40, 0x3f, 0xcc, 0x40, 0x3f, 0x20,
    0x48, 0xf, 0xcc, 0x22, 0x7, 0xf4, 0x10, 0xf,
    0xd4, 0x70, 0x3f, 0xcc, 0x22, 0x7, 0x91, 0x24,
    0x7, 0xfc, 0xc5, 0x3, 0xdc, 0x50, 0x3f, 0xf8,
    0x14, 0x30, 0x38, 0xa0, 0xc0, 0xff, 0xe0, 0x14,
    0x18, 0x1a, 0x8, 0x7, 0xff, 0xa, 0x8, 0x6,
    0x41, 0x81, 0xff, 0xc2, 0x24, 0x10, 0x8, 0x18,
    0x1f, 0xfc, 0x48, 0x20, 0x6, 0x28, 0x1f, 0xfc,
    0x44, 0x49, 0x0,

    /* U+62 "b" */
    0x3f, 0xff, 0xf0, 0x35, 0x40, 0x7f, 0xf1, 0xca,
    0xb8, 0x81, 0x8f, 0xff, 0xfc, 0x18, 0x4b, 0x20,
    0x3f, 0xf8, 0xaf, 0x41, 0x48, 0x1f, 0xfc, 0x67,
    0x4, 0x3, 0xff, 0x8e, 0xc2, 0x3, 0xff, 0x90,
    0x40, 0xff, 0xe4, 0x90, 0x34, 0x40, 0x7f, 0xf0,
    0xa0, 0x40, 0xb, 0xe0, 0x7f, 0xf0, 0x63, 0x10,
    0xf, 0xfe, 0x19, 0x99, 0x8a, 0x40, 0xcb, 0xff,
    0xf6, 0x64, 0x44, 0x7, 0x92, 0xff, 0x88, 0x9,
    0x40, 0xe3, 0x6f, 0xfd, 0xbc, 0xb, 0x90, 0x3f,
    0xf8, 0xaf, 0xa1, 0x81, 0xf8, 0xf, 0xfe, 0x1d,
    0x21, 0x81, 0xff, 0xc7, 0xa3, 0x1, 0xff, 0xc9,
    0x20, 0x7f, 0xf1, 0xe8, 0xc0, 0x7f, 0xf1, 0x4e,
    0x24, 0x80, 0xff, 0xe1, 0xab, 0x89, 0x60, 0x7f,
    0xff, 0xe1, 0x54, 0x1e, 0x3, 0xff, 0x8a, 0xa7,
    0x80, 0x40,

    /* U+63 "c" */
    0x3, 0xc6, 0x7f, 0xff, 0x40, 0x3a, 0x66, 0x7,
    0xff, 0x13, 0x30, 0xef, 0xff, 0x98, 0x1d, 0x48,
    0xd1, 0x1, 0xfb, 0x81, 0x92, 0xc, 0x40, 0xff,
    0x2b, 0x40, 0x20, 0x84, 0xf, 0xf8, 0xa2, 0x11,
    0x26, 0x7, 0xff, 0x13, 0x8a, 0x7, 0xff, 0x15,
    0x4, 0x7, 0xff, 0x1c, 0x81, 0xff, 0xc4, 0x20,
    0x81, 0xff, 0xed, 0x20, 0x81, 0xff, 0xc8, 0x20,
    0x7f, 0xf1, 0x50, 0x40, 0x7f, 0xf1, 0x78, 0xa0,
    0x7f, 0xf1, 0x51, 0x26, 0x7, 0xff, 0x16, 0x8,
    0x40, 0xff, 0x8a, 0x20, 0x12, 0xc, 0x40, 0xff,
    0x2b, 0x40, 0x54, 0x8d, 0x8, 0x1f, 0xb8, 0x1e,
    0xc8, 0x3d, 0xff, 0xe6, 0x7, 0xd6, 0x90, 0x1f,
    0xfc, 0x0,

    /* U+64 "d" */
    0x3f, 0xff, 0xd5, 0x81, 0xff, 0xc6, 0x53, 0x10,
    0x31, 0xff, 0xfd, 0xa0, 0x38, 0x81, 0xff, 0xc2,
    0x2f, 0xa1, 0x80, 0xff, 0xe2, 0xd2, 0x28, 0x1f,
    0xfc, 0x5c, 0x11, 0x3, 0xff, 0x8a, 0xc4, 0x3,
    0xff, 0x8b, 0x42, 0x3, 0xff, 0x8a, 0x48, 0x10,
    0x3f, 0xf8, 0xac, 0x20, 0x3f, 0xf8, 0xa4, 0xf,
    0xfe, 0x3f, 0x1c, 0xf, 0xfe, 0x2f, 0x1c, 0xf,
    0xfe, 0x29, 0x3, 0xff, 0x8e, 0xc2, 0x3, 0xff,
    0x88, 0x48, 0x10, 0x3f, 0xf8, 0x94, 0x20, 0x3f,
    0xf8, 0xac, 0x40, 0x9, 0x0, 0xff, 0xe0, 0x60,
    0x88, 0x36, 0x1, 0xff, 0x52, 0x28, 0x1f, 0xfc,
    0x12, 0xfa, 0x18, 0xe, 0x3f, 0xfe, 0xd0, 0x1c,
    0x40, 0xff, 0xe1, 0x99, 0x88, 0x18,

    /* U+65 "e" */
    0x3f, 0xff, 0xf1, 0xa8, 0x1f, 0xfc, 0x83, 0xff,
    0xff, 0x1a, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe,
    0x7, 0xf8, 0xff, 0xff, 0xc6, 0xa0, 0x7f, 0xf2,
    0x8f, 0xff, 0xfc, 0x4a, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xb9, 0xff, 0xff, 0x89, 0x40, 0xff, 0xe4,
    0x0,

    /* U+66 "f" */
    0x3f, 0xff, 0xf1, 0xa8, 0x1f, 0xfc, 0x83, 0xff,
    0xff, 0x1a, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe,
    0x7, 0xf8, 0xff, 0xff, 0xc6, 0xa0, 0x7f, 0xf2,
    0x8f, 0xff, 0xfc, 0x4a, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xf8, 0x1f, 0xfd, 0x20,

    /* U+67 "g" */
    0x3, 0xc6, 0xff, 0xff, 0x40, 0x3a, 0x64, 0x7,
    0xff, 0x13, 0x30, 0xef, 0xff, 0x98, 0x1d, 0x48,
    0xd1, 0x1, 0xfb, 0x81, 0x92, 0xc, 0x40, 0xff,
    0x29, 0x40, 0x41, 0x8, 0x1f, 0xf1, 0x64, 0x22,
    0x4c, 0xf, 0xfe, 0x27, 0x14, 0xf, 0xfe, 0x2a,
    0x8, 0xf, 0xfe, 0x39, 0x3, 0xff, 0x88, 0x41,
    0x3, 0xff, 0xda, 0x41, 0x3, 0xf6, 0xff, 0xe8,
    0x4, 0x40, 0xff, 0xe2, 0xa0, 0x80, 0xfb, 0x7f,
    0xd0, 0xb, 0x8a, 0x7, 0xff, 0x15, 0x12, 0x60,
    0x7f, 0xf1, 0x60, 0x84, 0xf, 0xfe, 0x22, 0x41,
    0x88, 0x1f, 0xfc, 0x4a, 0x46, 0x84, 0xf, 0xdc,
    0xf, 0x64, 0x1e, 0xff, 0xf3, 0x3, 0xeb, 0x90,
    0x1f, 0xfc, 0x0,

    /* U+68 "h" */
    0x3e, 0x81, 0xff, 0xc2, 0x5e, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0x8c, 0x81, 0x97,
    0xff, 0xfc, 0x28, 0x7, 0xff, 0x31, 0x7f, 0xff,
    0xc2, 0xa0, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xd4,

    /* U+69 "i" */
    0x3f, 0x1, 0xff, 0xf6,

    /* U+6A "j" */
    0x3, 0xff, 0x81, 0x7a, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xfc, 0x24, 0x3, 0xff, 0x80, 0x6c, 0x3,
    0xff, 0xa2, 0x40, 0xff, 0xe0, 0x10, 0x3f, 0xf8,
    0x68, 0x40, 0x3f, 0xf8, 0x10, 0x32, 0x7, 0xfc,
    0x58, 0xc4, 0xf, 0xfa, 0x11, 0x98, 0x1f, 0xf6,
    0x42, 0x78, 0x88, 0x1f, 0xad, 0x10, 0xee, 0xe8,
    0xf, 0x96, 0xac, 0x81, 0xc0,

    /* U+6B "k" */
    0x3f, 0x1, 0xff, 0xc0, 0x5f, 0x1, 0xff, 0xc4,
    0x82, 0x1, 0xff, 0xc3, 0x24, 0x10, 0x1f, 0xfc,
    0x38, 0x20, 0x1f, 0xfc, 0x44, 0x18, 0x1f, 0xfc,
    0x36, 0x18, 0x1f, 0xfc, 0x48, 0x20, 0x1f, 0xfc,
    0x34, 0x10, 0x18, 0xee, 0x7, 0xf4, 0x10, 0xe,
    0x24, 0x7, 0xe2, 0x70, 0x1f, 0xfc, 0x38, 0x20,
    0x1c, 0x7f, 0xff, 0x20, 0x80, 0xff, 0xe3, 0x20,
    0x3e, 0x3f, 0xfe, 0x62, 0x1, 0xff, 0xc4, 0x80,
    0x90, 0x1f, 0xfc, 0x44, 0x20, 0x1f, 0xfc, 0x48,
    0x10, 0x1f, 0xfc, 0x42, 0x84, 0x3, 0xff, 0x89,
    0x3, 0x3, 0xff, 0x88, 0x48, 0x30, 0x3f, 0xf8,
    0x90, 0x40, 0x3f, 0xf8, 0x88, 0x84, 0x7, 0xff,
    0x12, 0x88, 0x0,

    /* U+6C "l" */
    0x3f, 0x1, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0,
    0x7, 0xff, 0xfe, 0x10, 0x1f, 0xfc, 0x70,

    /* U+6D "m" */
    0x3f, 0x98, 0x1f, 0xfc, 0x6d, 0xf0, 0x14, 0x3,
    0xff, 0x8a, 0xc8, 0x1e, 0xa0, 0x7f, 0xf1, 0x20,
    0x1f, 0x24, 0x3, 0xff, 0x85, 0x41, 0x3, 0x18,
    0x28, 0x1f, 0xfc, 0x14, 0x82, 0x1, 0xcc, 0x88,
    0x7, 0xff, 0x2, 0x8, 0xc0, 0xf7, 0xc, 0x81,
    0xfe, 0x84, 0x98, 0x1f, 0x16, 0x38, 0x1f, 0xc5,
    0x88, 0x7, 0xf4, 0x5, 0x81, 0xfa, 0x4, 0x80,
    0x7f, 0xa8, 0x80, 0x7c, 0x90, 0x50, 0x3f, 0xe4,
    0x82, 0x1, 0xea, 0x20, 0x1f, 0xfc, 0x18, 0x19,
    0x3, 0x40, 0x58, 0x1f, 0xfc, 0x12, 0xc7, 0x2,
    0x2c, 0x70, 0x3f, 0xf8, 0x70, 0x93, 0x1, 0xc3,
    0x20, 0x7f, 0xf1, 0x20, 0x81, 0x91, 0x0, 0xff,
    0xe2, 0xa4, 0x16, 0xa, 0x7, 0xff, 0x1e, 0x84,
    0x12, 0x1, 0xff, 0xc8, 0x80, 0x20, 0x1f, 0xfc,
    0x96, 0x61, 0x3, 0xff, 0x95, 0xd8, 0x1f, 0xfc,
    0xb2, 0x7, 0xff, 0xc8,

    /* U+6E "n" */
    0x3f, 0xa0, 0x1f, 0xfc, 0x3d, 0xc8, 0x13, 0x40,
    0x7f, 0xf2, 0x69, 0x3, 0xff, 0x8c, 0x60, 0xe0,
    0x7f, 0xf1, 0xda, 0x34, 0xf, 0xfe, 0x3d, 0x29,
    0x81, 0xff, 0xc7, 0xe2, 0x20, 0x3f, 0xf8, 0xc6,
    0x8a, 0x7, 0xff, 0x1d, 0x31, 0x80, 0xff, 0xe3,
    0xc4, 0x60, 0x1f, 0xfc, 0x7a, 0x1b, 0x1, 0xff,
    0xc7, 0xc2, 0x10, 0x3f, 0xf8, 0xc6, 0xc, 0x7,
    0xff, 0x1d, 0xb0, 0xa0, 0x7f, 0xf1, 0xe1, 0x50,
    0xf, 0xfe, 0x3e, 0xd, 0x1, 0xff, 0xc7, 0xa2,
    0x90, 0x3f, 0xf8, 0xca, 0xe, 0x7, 0xff, 0x1d,
    0xa3, 0x40, 0xff, 0xe3, 0xd2, 0x98, 0x1f, 0xfc,
    0x7e, 0x21, 0x3, 0xff, 0x8c, 0x68, 0x1f, 0xfc,
    0x94, 0xc0, 0x80,

    /* U+6F "o" */
    0x3, 0xe7, 0x70, 0xd, 0x58, 0x1f, 0xfc, 0x9,
    0xe2, 0x20, 0xa, 0x9e, 0x1, 0xf8, 0xe6, 0xc,
    0xc0, 0x34, 0x21, 0xe0, 0x3e, 0xc4, 0xb6, 0x32,
    0x0, 0xbd, 0x84, 0xb8, 0x1d, 0x82, 0xc4, 0xf,
    0xc7, 0x21, 0x80, 0x91, 0x2a, 0x7, 0xff, 0x2,
    0x92, 0x40, 0x20, 0x80, 0x7f, 0xf0, 0xa0, 0x80,
    0x9, 0x20, 0x3f, 0xf8, 0x48, 0x10, 0x43, 0x3,
    0xff, 0x88, 0x81, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0x5c, 0x81, 0xff, 0xc6, 0x60, 0x80, 0x40, 0x7f,
    0xf1, 0x8, 0x12, 0xc, 0xf, 0xfe, 0x13, 0x8,
    0x4, 0x10, 0x81, 0xff, 0xc0, 0x30, 0x40, 0x5,
    0x8c, 0x40, 0xff, 0x1c, 0x21, 0x2, 0x88, 0x68,
    0x40, 0xf1, 0xb8, 0x36, 0x3, 0xab, 0xf, 0x64,
    0x1, 0x36, 0x21, 0x20, 0xf, 0xa6, 0x40, 0xb0,
    0xc, 0x85, 0x98, 0x1f, 0xc6, 0xfb, 0x0, 0x4b,
    0xe9, 0x3, 0x80,

    /* U+70 "p" */
    0x3f, 0xff, 0xf0, 0x75, 0x60, 0x7f, 0xf1, 0xca,
    0x9d, 0x81, 0x1f, 0xff, 0xf8, 0x55, 0x9, 0x80,
    0xff, 0xe2, 0xab, 0x40, 0xd0, 0x3f, 0xf8, 0xcb,
    0x4, 0x80, 0x7f, 0xf1, 0x8b, 0x18, 0xf, 0xfe,
    0x3e, 0x4, 0xf, 0xfe, 0x3e, 0x4, 0xf, 0xfe,
    0x31, 0x62, 0x81, 0xff, 0xc5, 0x58, 0x32, 0x7,
    0xff, 0x8, 0xbd, 0x42, 0x80, 0xff, 0xff, 0xc1,
    0xd0, 0x89, 0x40, 0xff, 0xe1, 0x92, 0x77, 0xb0,
    0x38, 0xff, 0xfe, 0xd9, 0x10, 0x1f, 0xff, 0xf0,
    0x3f, 0xff, 0xe0, 0x7f, 0xfa, 0x40,

    /* U+71 "q" */
    0x3, 0xe7, 0x7f, 0xd5, 0x81, 0xff, 0xc0, 0x9e,
    0x20, 0x32, 0x9e, 0x1, 0xf8, 0xe6, 0xc, 0xdf,
    0xb4, 0x21, 0xe0, 0x3e, 0xc4, 0xb6, 0x32, 0x0,
    0xbd, 0x84, 0xb0, 0x1d, 0x40, 0x62, 0x7, 0xe3,
    0x91, 0xa0, 0x49, 0x0, 0x40, 0x3f, 0xea, 0x52,
    0x0, 0xe1, 0x86, 0xc0, 0x7f, 0xd0, 0x70, 0x8,
    0x48, 0x10, 0x81, 0xfe, 0x41, 0x2, 0x10, 0x68,
    0x60, 0x3f, 0xe4, 0x8, 0x1d, 0x48, 0xc0, 0x7f,
    0xf1, 0xf0, 0x34, 0xf, 0xfe, 0x3e, 0x9, 0x81,
    0xff, 0xc6, 0x30, 0x44, 0x7, 0xff, 0x19, 0xb0,
    0xa4, 0xf, 0xfe, 0x34, 0x23, 0x81, 0xe6, 0x0,
    0x84, 0x7, 0xd8, 0x1a, 0x7, 0x10, 0x42, 0x8,
    0xf, 0xb0, 0x50, 0x9, 0x84, 0x3, 0x88, 0x7,
    0xc6, 0x6, 0xc0, 0xc1, 0xc0, 0x24, 0x34, 0xf,
    0x9b, 0x8, 0xf0, 0x48, 0x5, 0x4a, 0xc4, 0xf,
    0x42, 0x20, 0xa, 0x7, 0x62, 0x5b, 0x19, 0x4,
    0x98, 0x1b, 0x81, 0xf6, 0x60, 0xcd, 0xf6, 0x42,
    0x4, 0xc0, 0xfd, 0x3c, 0x40, 0x65, 0x3c, 0x10,
    0x80,

    /* U+72 "r" */
    0x3f, 0xff, 0xf0, 0x75, 0x60, 0x7f, 0xf1, 0xca,
    0x9d, 0x81, 0x1f, 0xff, 0xf8, 0x55, 0x9, 0x80,
    0xff, 0xe2, 0xab, 0x40, 0xd0, 0x3f, 0xf8, 0xcb,
    0x4, 0x80, 0x7f, 0xf1, 0x8b, 0x18, 0xf, 0xfe,
    0x3e, 0x4, 0xf, 0xfe, 0x3e, 0x4, 0xf, 0xfe,
    0x31, 0x62, 0x81, 0xff, 0xc5, 0x58, 0x32, 0x7,
    0xff, 0x8, 0xbd, 0x42, 0x80, 0xff, 0xff, 0xc1,
    0xd0, 0x89, 0x40, 0xff, 0xe1, 0x92, 0x77, 0xb0,
    0x38, 0xfe, 0x20, 0x27, 0xfb, 0x64, 0x40, 0x7f,
    0xb4, 0x12, 0x81, 0xff, 0xc6, 0x78, 0xae, 0x80,
    0xff, 0xe2, 0x9c, 0x85, 0x80, 0x7f, 0xf1, 0xad,
    0x7, 0x88, 0x1f, 0xfc, 0x55, 0xc9, 0x66, 0x7,
    0xff, 0x1b, 0x41, 0x28, 0x1f, 0xfc, 0x67, 0x8a,
    0xe8, 0xf, 0xfe, 0x29, 0xcc, 0x58, 0x7, 0xff,
    0x1a, 0x50, 0xf1,

    /* U+73 "s" */
    0x3, 0x94, 0xdf, 0xff, 0xf0, 0x68, 0x11, 0xd5,
    0x90, 0x3f, 0xf8, 0x8b, 0x11, 0x37, 0xff, 0xf5,
    0x2, 0x34, 0x3e, 0xc8, 0x1f, 0xfc, 0x3e, 0x1c,
    0x3, 0xff, 0x84, 0xe7, 0x4, 0x40, 0x3f, 0xf8,
    0x65, 0xa2, 0x8, 0x1f, 0xfc, 0x72, 0x8, 0x1f,
    0xfc, 0x84, 0x28, 0x1f, 0xfc, 0x78, 0x15, 0x3,
    0xff, 0x8c, 0x68, 0x5e, 0xa2, 0x7, 0xff, 0xd,
    0x74, 0x15, 0xdf, 0xfb, 0x42, 0x7, 0xeb, 0xa2,
    0x20, 0x78, 0xbd, 0x48, 0x1f, 0x17, 0x77, 0xfe,
    0xd0, 0x2c, 0x40, 0xff, 0xe2, 0x17, 0xd0, 0xc0,
    0x7f, 0xf1, 0xe9, 0xc, 0xf, 0xfe, 0x3d, 0x18,
    0xf, 0xfe, 0x49, 0x4, 0x80, 0xff, 0xe2, 0x51,
    0x8e, 0xe0, 0x7f, 0xf0, 0x8e, 0x24, 0x80, 0xff,
    0xe1, 0xab, 0x89, 0x60, 0x23, 0xff, 0xff, 0x2,
    0xa0, 0xf0, 0x1f, 0xfc, 0x55, 0x3c, 0x2,

    /* U+74 "t" */
    0x3f, 0xff, 0xf2, 0x70, 0x1f, 0xfc, 0xb3, 0xff,
    0xf5, 0x7, 0xff, 0xec, 0x7, 0xf9, 0x81, 0xff,
    0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xc0,

    /* U+75 "u" */
    0x3f, 0x1, 0xff, 0xc4, 0xdc, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf, 0xff,
    0xf8, 0x1f, 0x88, 0x20, 0x7f, 0xf1, 0x8, 0x21,
    0x4, 0x7, 0xff, 0x9, 0x4, 0x3, 0x88, 0x7,
    0xff, 0xa, 0xe, 0x1, 0x21, 0xa0, 0x7f, 0xf0,
    0x29, 0x48, 0x5, 0x4a, 0xc4, 0xf, 0xcb, 0x23,
    0x40, 0xec, 0x4b, 0x63, 0x20, 0xb, 0xd4, 0x96,
    0x3, 0xec, 0xc1, 0x9b, 0xf6, 0x84, 0x3c, 0x7,
    0xf4, 0xf1, 0x1, 0x94, 0xf0, 0xe,

    /* U+76 "v" */
    0x1f, 0x80, 0xff, 0xe3, 0x7e, 0x21, 0x6, 0x7,
    0xff, 0x11, 0x82, 0x42, 0x8, 0x7, 0xff, 0x12,
    0x88, 0x0, 0x90, 0x60, 0x7f, 0xf0, 0x91, 0x24,
    0x5, 0x5, 0x3, 0xff, 0x85, 0xc5, 0x3, 0x22,
    0x48, 0xf, 0xfe, 0x1, 0x41, 0x81, 0xd4, 0x70,
    0x3f, 0xf8, 0x14, 0x30, 0x3c, 0xc2, 0x20, 0x7f,
    0xcc, 0x40, 0x3e, 0x62, 0x81, 0xfe, 0x81, 0x1,
    0xfa, 0x6, 0x7, 0xf9, 0x88, 0x7, 0xf2, 0x10,
    0xf, 0xcc, 0x22, 0x7, 0xf4, 0xc, 0xf, 0xd4,
    0x70, 0x3f, 0xc5, 0x6, 0x7, 0x91, 0x24, 0x7,
    0xfd, 0xc5, 0x3, 0xdc, 0x50, 0x3f, 0xf8, 0x8,
    0x92, 0x3, 0x14, 0x18, 0x1f, 0xfc, 0x1a, 0x38,
    0x1a, 0x6, 0x7, 0xff, 0x9, 0x84, 0x40, 0x90,
    0x80, 0x7f, 0xf0, 0xd8, 0x80, 0x20, 0x60, 0x7f,
    0xf1, 0x20, 0x40, 0x18, 0xa0, 0x7f, 0xf1, 0x58,
    0x8c, 0x22, 0x7, 0xff, 0x16, 0x87, 0x47, 0x3,
    0xff, 0x8c, 0x50, 0x24, 0x80, 0xff, 0xe3, 0xf0,
    0x14, 0xf, 0xf0,

    /* U+77 "w" */
    0x3f, 0x80, 0xff, 0xe9, 0xbf, 0x4a, 0xc, 0xf,
    0xfe, 0x94, 0x10, 0x71, 0x40, 0xff, 0xe8, 0xb0,
    0x48, 0x22, 0x48, 0xf, 0xfe, 0x85, 0x10, 0xa,
    0x8, 0x7, 0xff, 0x3d, 0x12, 0x40, 0x48, 0x12,
    0x3, 0xff, 0x9d, 0xc5, 0x3, 0xa0, 0x80, 0x7f,
    0xf0, 0x29, 0x3, 0xfe, 0x28, 0x30, 0x39, 0x84,
    0x7, 0xff, 0x1, 0x50, 0x3f, 0xea, 0x18, 0x1f,
    0x31, 0x0, 0xff, 0x40, 0xc0, 0xff, 0x98, 0x80,
    0x7d, 0x43, 0x3, 0xfc, 0xc0, 0x40, 0x3f, 0xa0,
    0x40, 0x7e, 0x28, 0x30, 0x3f, 0x30, 0x43, 0x3,
    0xf9, 0x88, 0x7, 0xf4, 0x14, 0xf, 0xd0, 0x72,
    0x18, 0x1f, 0x30, 0x88, 0x1f, 0xc4, 0xc8, 0xf,
    0x20, 0x4a, 0xa, 0x7, 0xd4, 0x70, 0x3f, 0xe8,
    0x20, 0x1e, 0x82, 0x4, 0x49, 0x1, 0xc8, 0x92,
    0x3, 0xfe, 0x40, 0x90, 0x18, 0x90, 0x40, 0x28,
    0xe0, 0x74, 0x14, 0xf, 0xfe, 0xc, 0x10, 0xd,
    0x4, 0x2, 0x61, 0x10, 0x22, 0x41, 0x81, 0xff,
    0xc1, 0x61, 0x10, 0x5, 0x6, 0x6, 0x62, 0x81,
    0x40, 0xc0, 0xff, 0xe1, 0xb1, 0x40, 0x50, 0xc0,
    0xe8, 0x18, 0x12, 0x10, 0xf, 0xfe, 0x1d, 0xc,
    0x3, 0x10, 0xf, 0x31, 0x4, 0xc, 0xf, 0xfe,
    0x21, 0x41, 0xb0, 0x40, 0x7d, 0x43, 0xc, 0x50,
    0x3f, 0xf8, 0xb0, 0x48, 0x10, 0xf, 0x8a, 0x18,
    0x22, 0x7, 0xff, 0x14, 0x90, 0x2, 0x40, 0x7e,
    0xe0, 0x8e, 0x7, 0xff, 0x1e, 0x0, 0x80, 0x7f,
    0x22, 0xa, 0x3, 0xf8,

    /* U+78 "x" */
    0x1b, 0xe0, 0x3f, 0xf8, 0x47, 0xf3, 0x18, 0x18,
    0x7, 0xff, 0x7, 0x84, 0xc0, 0x60, 0xd8, 0xf,
    0xfa, 0x92, 0xa0, 0x46, 0x8, 0x40, 0xfe, 0x88,
    0x70, 0x39, 0xb0, 0xc0, 0x7e, 0x4c, 0x52, 0x7,
    0xa1, 0x18, 0xf, 0x1a, 0x22, 0x3, 0xf6, 0x6,
    0x1, 0xd8, 0x26, 0x7, 0xfb, 0x6, 0xc0, 0x54,
    0x1a, 0x7, 0xfc, 0x60, 0x84, 0x44, 0x30, 0x1f,
    0xfc, 0x16, 0xc3, 0x36, 0x18, 0xf, 0xfe, 0x1c,
    0x22, 0x8, 0x40, 0xff, 0xe2, 0x60, 0x5, 0x81,
    0xff, 0xc6, 0xc0, 0xb0, 0x3f, 0xf8, 0x84, 0x18,
    0x21, 0x3, 0xff, 0x84, 0xb1, 0xd, 0x86, 0x3,
    0xff, 0x82, 0x68, 0x40, 0x21, 0x18, 0xf, 0xfe,
    0x6, 0xd, 0x80, 0xb0, 0x34, 0xf, 0xf6, 0x6,
    0x1, 0xd8, 0x26, 0x7, 0xe8, 0x46, 0x3, 0xc6,
    0x88, 0x80, 0xf3, 0x61, 0x80, 0xfc, 0x98, 0xa4,
    0xc, 0x60, 0x84, 0xf, 0xe8, 0x87, 0x3, 0x60,
    0xd8, 0xf, 0xfa, 0x92, 0xa0, 0x30, 0x30, 0xf,
    0xfe, 0xf, 0x9, 0x80,

    /* U+79 "y" */
    0x1b, 0xe0, 0x3f, 0xf8, 0x7b, 0xd0, 0x18, 0x18,
    0x7, 0xff, 0x6, 0x92, 0xa0, 0x58, 0x36, 0x3,
    0xfe, 0x68, 0x70, 0x31, 0x82, 0x10, 0x3f, 0x94,
    0x14, 0x81, 0xcd, 0x86, 0x3, 0xf1, 0xa2, 0x20,
    0x3e, 0x84, 0x60, 0x3e, 0xe1, 0x30, 0x3f, 0xb0,
    0x30, 0xe, 0xa4, 0xa8, 0x1f, 0xf6, 0xd, 0x80,
    0xa2, 0x1c, 0xf, 0xfe, 0x1, 0x82, 0x10, 0x98,
    0xa4, 0xf, 0xfe, 0xb, 0x61, 0x95, 0x11, 0x1,
    0xff, 0xc3, 0x84, 0x50, 0x98, 0x1f, 0xfc, 0x5c,
    0x0, 0xd0, 0x3f, 0xf8, 0xf0, 0x20, 0x3f, 0xff,
    0xe0, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81, 0xff,
    0xc3,

    /* U+7A "z" */
    0x3f, 0xff, 0xf1, 0x0, 0xff, 0xe2, 0xc0, 0x7f,
    0xff, 0xe0, 0x20, 0x58, 0x1f, 0xfc, 0x12, 0x87,
    0x3, 0xff, 0x85, 0xc3, 0x20, 0x7f, 0xf0, 0x59,
    0x10, 0xf, 0xfe, 0x14, 0x14, 0xf, 0xfe, 0x15,
    0x9, 0x0, 0xff, 0xe0, 0xa4, 0x10, 0xf, 0xfe,
    0x14, 0x10, 0x81, 0xff, 0xc1, 0x84, 0x98, 0x1f,
    0xfc, 0x12, 0xc7, 0x3, 0xff, 0x85, 0x2, 0x20,
    0x7f, 0xf0, 0x52, 0xa, 0x7, 0xff, 0xa, 0x88,
    0x7, 0xff, 0xa, 0x2, 0xc0, 0xff, 0xe0, 0x96,
    0x38, 0x1f, 0xfc, 0x2e, 0x19, 0x3, 0xff, 0x82,
    0xc8, 0x80, 0x7f, 0xf0, 0xa0, 0xa0, 0x7f, 0xf0,
    0xa8, 0x28, 0xf, 0xfe, 0xa, 0x40, 0x7f, 0xff,
    0xe0, 0x21, 0x0, 0xff, 0xe2, 0x0,

    /* U+7B "{" */
    0x3, 0xf9, 0x81, 0xfa, 0x78, 0x40, 0xe3, 0xd8,
    0x44, 0xe, 0xc1, 0x7a, 0x7, 0x40, 0xa8, 0x1f,
    0x21, 0x0, 0xfc, 0x41, 0x3, 0xf1, 0x4, 0xf,
    0xd4, 0x70, 0x3e, 0x34, 0x1, 0x3, 0x9e, 0x2f,
    0x10, 0x35, 0x83, 0x40, 0x3d, 0xc0, 0x50, 0x3e,
    0x5c, 0xbc, 0x40, 0xfb, 0x33, 0x80, 0xfc, 0x44,
    0x3, 0xf2, 0xc, 0xf, 0xfe, 0x3a, 0xc, 0xf,
    0xd0, 0x46, 0x7, 0xc6, 0x9, 0x50, 0x1e, 0x74,
    0x2a, 0x40, 0xf2, 0xf0, 0x80,

    /* U+7C "|" */
    0x3d, 0x81, 0xff, 0xf6,

    /* U+7D "}" */
    0xc, 0xf, 0xe3, 0x3c, 0x3, 0xe2, 0x83, 0xc0,
    0x7d, 0x79, 0x2c, 0x7, 0xec, 0x8b, 0x3, 0xf4,
    0x14, 0xf, 0xc4, 0x10, 0x3f, 0x10, 0x40, 0xfd,
    0xc5, 0x3, 0xf2, 0x11, 0x81, 0xf4, 0xa2, 0x50,
    0x3e, 0x58, 0x2c, 0x7, 0x8f, 0xb, 0x1, 0xcf,
    0x19, 0x40, 0xe3, 0x5, 0x60, 0x78, 0xc1, 0xc0,
    0xfc, 0xc3, 0x3, 0xff, 0x8f, 0x2, 0x3, 0xe6,
    0xc2, 0x81, 0xcb, 0x41, 0x8, 0x18, 0xd2, 0x2b,
    0x3, 0xc6, 0x74, 0x7, 0x80,

    /* U+7E "~" */
    0x3, 0x29, 0xc, 0x81, 0xff, 0xc0, 0x37, 0xd6,
    0xd3, 0x78, 0x40, 0xfe, 0xc8, 0x39, 0xd, 0x7,
    0xa1, 0x2, 0x4c, 0x6, 0x9e, 0x36, 0x97, 0xc0,
    0xf7, 0xf5, 0x80, 0xb, 0x3, 0xe7, 0xe1, 0x0,
    0x55, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 173, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 90, .box_w = 3, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10, .adv_w = 123, .box_w = 5, .box_h = 4, .ofs_x = 1, .ofs_y = 19},
    {.bitmap_index = 17, .adv_w = 265, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 61, .adv_w = 249, .box_w = 13, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 146, .adv_w = 301, .box_w = 17, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 259, .adv_w = 426, .box_w = 24, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 422, .adv_w = 90, .box_w = 3, .box_h = 4, .ofs_x = 1, .ofs_y = 19},
    {.bitmap_index = 427, .adv_w = 166, .box_w = 8, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 481, .adv_w = 165, .box_w = 8, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 538, .adv_w = 251, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 598, .adv_w = 202, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 618, .adv_w = 90, .box_w = 3, .box_h = 4, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 623, .adv_w = 202, .box_w = 10, .box_h = 3, .ofs_x = 1, .ofs_y = 10},
    {.bitmap_index = 630, .adv_w = 90, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 634, .adv_w = 257, .box_w = 14, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 709, .adv_w = 402, .box_w = 23, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 801, .adv_w = 145, .box_w = 7, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 820, .adv_w = 418, .box_w = 24, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 947, .adv_w = 359, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1053, .adv_w = 372, .box_w = 21, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1140, .adv_w = 359, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1227, .adv_w = 404, .box_w = 23, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1358, .adv_w = 335, .box_w = 19, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1457, .adv_w = 402, .box_w = 23, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1607, .adv_w = 405, .box_w = 23, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1742, .adv_w = 104, .box_w = 4, .box_h = 10, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 1756, .adv_w = 103, .box_w = 4, .box_h = 11, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 1770, .adv_w = 189, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 1807, .adv_w = 202, .box_w = 10, .box_h = 6, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 1820, .adv_w = 189, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 1858, .adv_w = 243, .box_w = 13, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1921, .adv_w = 427, .box_w = 24, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2074, .adv_w = 420, .box_w = 24, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2213, .adv_w = 392, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2327, .adv_w = 358, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2425, .adv_w = 358, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2527, .adv_w = 360, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2568, .adv_w = 360, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2605, .adv_w = 358, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2704, .adv_w = 360, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2738, .adv_w = 90, .box_w = 3, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2742, .adv_w = 274, .box_w = 15, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2795, .adv_w = 334, .box_w = 19, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2894, .adv_w = 318, .box_w = 18, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2917, .adv_w = 443, .box_w = 25, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3041, .adv_w = 384, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3140, .adv_w = 385, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3263, .adv_w = 392, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3341, .adv_w = 384, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3486, .adv_w = 392, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3601, .adv_w = 392, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3720, .adv_w = 411, .box_w = 23, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3752, .adv_w = 385, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3822, .adv_w = 422, .box_w = 24, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3960, .adv_w = 638, .box_w = 38, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4169, .adv_w = 377, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4309, .adv_w = 409, .box_w = 22, .box_h = 23, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4396, .adv_w = 322, .box_w = 18, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4498, .adv_w = 133, .box_w = 6, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4515, .adv_w = 256, .box_w = 14, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4591, .adv_w = 133, .box_w = 6, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4607, .adv_w = 241, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 14},
    {.bitmap_index = 4640, .adv_w = 189, .box_w = 10, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4646, .adv_w = 90, .box_w = 3, .box_h = 5, .ofs_x = 1, .ofs_y = 19},
    {.bitmap_index = 4652, .adv_w = 420, .box_w = 24, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4791, .adv_w = 392, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4905, .adv_w = 357, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5003, .adv_w = 358, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5105, .adv_w = 359, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5146, .adv_w = 360, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5183, .adv_w = 357, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5282, .adv_w = 360, .box_w = 20, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5316, .adv_w = 90, .box_w = 3, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5320, .adv_w = 274, .box_w = 15, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5373, .adv_w = 333, .box_w = 19, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5472, .adv_w = 317, .box_w = 18, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5495, .adv_w = 442, .box_w = 25, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5619, .adv_w = 384, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5718, .adv_w = 385, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5841, .adv_w = 392, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5919, .adv_w = 384, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6064, .adv_w = 392, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6179, .adv_w = 392, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6298, .adv_w = 410, .box_w = 23, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6330, .adv_w = 385, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6400, .adv_w = 388, .box_w = 24, .box_h = 23, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6539, .adv_w = 587, .box_w = 37, .box_h = 23, .ofs_x = -2, .ofs_y = 0},
    {.bitmap_index = 6743, .adv_w = 395, .box_w = 22, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6883, .adv_w = 399, .box_w = 23, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6972, .adv_w = 322, .box_w = 18, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7074, .adv_w = 208, .box_w = 11, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7143, .adv_w = 83, .box_w = 3, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7147, .adv_w = 208, .box_w = 11, .box_h = 23, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7216, .adv_w = 354, .box_w = 20, .box_h = 5, .ofs_x = 1, .ofs_y = 8}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Pair left and right glyphs for kerning*/
static const uint8_t kern_pair_glyph_ids[] =
{
    34, 36,
    34, 40,
    34, 48,
    34, 50,
    34, 53,
    34, 54,
    34, 55,
    34, 56,
    34, 58,
    34, 87,
    34, 88,
    35, 55,
    35, 56,
    35, 58,
    37, 34,
    37, 56,
    37, 58,
    45, 53,
    45, 55,
    45, 56,
    45, 58,
    53, 34,
    55, 34,
    55, 36,
    55, 40,
    55, 48,
    55, 66,
    56, 34,
    56, 40,
    56, 48,
    56, 66,
    58, 34,
    58, 36,
    58, 48,
    66, 68,
    66, 72,
    66, 85,
    66, 86,
    66, 87,
    66, 88,
    66, 90,
    77, 90,
    85, 66,
    87, 66,
    88, 66
};

/* Kerning between the respective left and right glyphs
 * 4.4 format which needs to scaled with `kern_scale`*/
static const int8_t kern_pair_values[] =
{
    -37, -49, -41, -41, -78, -37, -94, -94,
    -111, -86, -74, -37, -29, -45, -33, -29,
    -29, -119, -70, -74, -102, -86, -119, -49,
    -41, -41, -111, -94, -29, -25, -115, -90,
    -45, -49, -37, -49, -102, -37, -94, -66,
    -106, -86, -86, -119, -115
};

/*Collect the kern pair's data in one place*/
static const lv_font_fmt_txt_kern_pair_t kern_pairs =
{
    .glyph_ids = kern_pair_glyph_ids,
    .values = kern_pair_values,
    .pair_cnt = 45,
    .glyph_ids_size = 0
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_pairs,
    .kern_scale = 22,
    .cmap_num = 1,
    .bpp = 3,
    .kern_classes = 0,
    .bitmap_format = 1
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t gracetians_32 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 25,          /*The maximum line height required by the font*/
    .base_line = 1,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if GRACETIANS_32*/

