/* Generated by Edge Impulse
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
// Generated on: 31.01.2024 19:45:06

#include <stdio.h>
#include <stdlib.h>
#include "edge-impulse-sdk/tensorflow/lite/c/builtin_op_data.h"
#include "edge-impulse-sdk/tensorflow/lite/c/common.h"
#include "edge-impulse-sdk/tensorflow/lite/micro/micro_mutable_op_resolver.h"
#include "edge-impulse-sdk/porting/ei_classifier_porting.h"

#if EI_CLASSIFIER_PRINT_STATE
#if defined(__cplusplus) && EI_C_LINKAGE == 1
extern "C" {
    extern void ei_printf(const char *format, ...);
}
#else
extern void ei_printf(const char *format, ...);
#endif
#endif

#if defined __GNUC__
#define ALIGN(X) __attribute__((aligned(X)))
#elif defined _MSC_VER
#define ALIGN(X) __declspec(align(X))
#elif defined __TASKING__
#define ALIGN(X) __align(X)
#elif defined __ICCARM__
#define ALIGN(x) __attribute__((aligned(x)))
#endif

#ifndef EI_MAX_SCRATCH_BUFFER_COUNT
#ifndef CONFIG_IDF_TARGET_ESP32S3
#define EI_MAX_SCRATCH_BUFFER_COUNT 4
#else
#define EI_MAX_SCRATCH_BUFFER_COUNT 4
#endif // CONFIG_IDF_TARGET_ESP32S3
#endif // EI_MAX_SCRATCH_BUFFER_COUNT

#ifndef EI_MAX_OVERFLOW_BUFFER_COUNT
#define EI_MAX_OVERFLOW_BUFFER_COUNT 10
#endif // EI_MAX_OVERFLOW_BUFFER_COUNT

using namespace tflite;
using namespace tflite::ops;
using namespace tflite::ops::micro;

namespace {

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX) || defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
constexpr int kTensorArenaSize = 1472;
#else
constexpr int kTensorArenaSize = 448;
#endif

#if defined(EI_CLASSIFIER_ALLOCATION_STATIC)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX)
#pragma Bss(".tensor_arena")
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16);
#pragma Bss()
#elif defined(EI_CLASSIFIER_ALLOCATION_STATIC_HIMAX_GNU)
uint8_t tensor_arena[kTensorArenaSize] ALIGN(16) __attribute__((section(".tensor_arena")));
#else
#define EI_CLASSIFIER_ALLOCATION_HEAP 1
uint8_t* tensor_arena = NULL;
#endif

static uint8_t* tensor_boundary;
static uint8_t* current_location;

template <int SZ, class T> struct TfArray {
  int sz; T elem[SZ];
};

enum used_operators_e {
  OP_FULLY_CONNECTED, OP_SOFTMAX,  OP_LAST
};

struct TensorInfo_t { // subset of TfLiteTensor used for initialization from constant memory
  TfLiteAllocationType allocation_type;
  TfLiteType type;
  void* data;
  TfLiteIntArray* dims;
  size_t bytes;
  TfLiteQuantization quantization;
};

typedef struct {
  TfLiteTensor tensor;
  int16_t index;
} TfLiteTensorWithIndex;

typedef struct {
  TfLiteEvalTensor tensor;
  int16_t index;
} TfLiteEvalTensorWithIndex;

TfLiteContext ctx{};
static const int MAX_TFL_TENSOR_COUNT = 4;
static TfLiteTensorWithIndex tflTensors[MAX_TFL_TENSOR_COUNT];
static const int MAX_TFL_EVAL_COUNT = 4;
static TfLiteEvalTensorWithIndex tflEvalTensors[MAX_TFL_EVAL_COUNT];
TfLiteRegistration registrations[OP_LAST];

namespace g0 {
const TfArray<2, int> tensor_dimension0 = { 2, { 1,102 } };
const TfArray<1, float> quant0_scale = { 1, { 0.15380392968654633, } };
const TfArray<1, int> quant0_zero = { 1, { -1 } };
const TfLiteAffineQuantization quant0 = { (TfLiteFloatArray*)&quant0_scale, (TfLiteIntArray*)&quant0_zero, 0 };
const ALIGN(8) int32_t tensor_data1[3] = { 5, 53, -34, };
const TfArray<1, int> tensor_dimension1 = { 1, { 3 } };
const TfArray<1, float> quant1_scale = { 1, { 0.0002794323954731226, } };
const TfArray<1, int> quant1_zero = { 1, { 0 } };
const TfLiteAffineQuantization quant1 = { (TfLiteFloatArray*)&quant1_scale, (TfLiteIntArray*)&quant1_zero, 0 };
const ALIGN(16) int8_t tensor_data2[3*10] = { 
  79, 16, 111, -96, -41, 63, 91, -97, -127, 93, 
  70, 75, -27, -80, -127, 3, 40, -99, 15, -22, 
  -110, -24, 125, -3, -113, -102, -107, -60, 117, 31, 
};
const TfArray<2, int> tensor_dimension2 = { 2, { 3,10 } };
const TfArray<1, float> quant2_scale = { 1, { 0.0052389521151781082, } };
const TfArray<1, int> quant2_zero = { 1, { 0 } };
const TfLiteAffineQuantization quant2 = { (TfLiteFloatArray*)&quant2_scale, (TfLiteIntArray*)&quant2_zero, 0 };
const ALIGN(16) int32_t tensor_data3[10] = { 36, 41, 44, -54, 94, 68, 17, -8, -10, -53, };
const TfArray<1, int> tensor_dimension3 = { 1, { 10 } };
const TfArray<1, float> quant3_scale = { 1, { 0.00030358190997503698, } };
const TfArray<1, int> quant3_zero = { 1, { 0 } };
const TfLiteAffineQuantization quant3 = { (TfLiteFloatArray*)&quant3_scale, (TfLiteIntArray*)&quant3_zero, 0 };
const ALIGN(16) int8_t tensor_data4[10*20] = { 
  46, -77, -66, 17, 106, 18, 127, -107, -2, -52, 25, 24, 65, 126, 59, -80, 0, -26, -70, 31, 
  -57, -115, 73, 73, 59, -39, -41, -97, -93, 20, -53, -50, 65, 22, 75, 95, -48, 38, -44, -28, 
  -23, -96, -3, 112, -49, -61, -33, 25, -42, -9, 33, 52, -22, -89, -14, -72, 91, -96, -103, -83, 
  57, 10, 93, 0, -73, 77, -65, -52, -33, 74, 102, 46, -76, -102, -9, -50, -32, -59, 107, 82, 
  -38, 69, -97, -41, -80, 78, -34, 35, -95, 67, 93, 61, -21, 57, 32, -92, -43, 111, 77, 64, 
  -84, 77, -66, 55, -25, -116, 0, 87, -120, -44, 80, 65, -52, 72, -18, -64, -34, 71, -68, 10, 
  100, 51, -59, -77, 85, 84, 20, -35, -23, 6, 66, 47, -73, -36, 11, -15, 65, -17, -15, -32, 
  -19, 93, 46, 60, -13, 87, 83, -114, 113, -34, -62, 112, 67, -33, -104, 49, 86, 6, 12, 83, 
  60, 40, 54, 39, 89, 31, -118, -27, -36, 11, 97, 17, -6, -115, -37, 94, -92, 72, -51, -37, 
  51, -76, -15, -4, 79, 103, -22, 8, 86, -94, -61, 55, -76, -49, 58, -16, -22, 90, 6, 83, 
};
const TfArray<2, int> tensor_dimension4 = { 2, { 10,20 } };
const TfArray<1, float> quant4_scale = { 1, { 0.0037091581616550684, } };
const TfArray<1, int> quant4_zero = { 1, { 0 } };
const TfLiteAffineQuantization quant4 = { (TfLiteFloatArray*)&quant4_scale, (TfLiteIntArray*)&quant4_zero, 0 };
const ALIGN(16) int32_t tensor_data5[20] = { 21, -15, -15, -50, 46, -43, 55, -5, -29, -43, -16, -25, -20, 33, 15, 4, -25, 6, -37, -30, };
const TfArray<1, int> tensor_dimension5 = { 1, { 20 } };
const TfArray<1, float> quant5_scale = { 1, { 0.00030753828468732536, } };
const TfArray<1, int> quant5_zero = { 1, { 0 } };
const TfLiteAffineQuantization quant5 = { (TfLiteFloatArray*)&quant5_scale, (TfLiteIntArray*)&quant5_zero, 0 };
const ALIGN(16) int8_t tensor_data6[20*102] = { 
  -1, -15, -21, 90, 35, 53, 33, -70, 39, -87, 0, 39, -95, -71, -21, 96, 30, 79, -51, -53, 97, -28, 93, 20, -99, 69, -50, -54, -73, -98, 27, 34, 69, -90, -100, 47, -67, 79, -7, -71, 50, -9, -83, -33, -91, 90, -42, 96, -76, -78, -16, -102, 42, -24, -96, 70, 106, 81, 107, 64, 36, -44, 15, -77, -17, -76, -4, 35, 95, -14, 27, -93, -65, -29, -20, -60, 80, 51, -10, 89, 33, -4, -9, 33, -17, 13, -107, -13, -74, -102, 44, -26, -52, 91, -5, -104, 109, 57, -79, -43, -2, -110, 
  -114, -18, 87, 2, -40, 31, 27, 22, 46, 89, -80, 59, 8, 9, 65, -70, 72, 69, 105, -76, -21, -21, 78, -10, 61, 42, -22, 69, -36, -71, -9, 91, 92, 94, 66, -25, -80, -21, 26, -63, -48, -51, 114, 66, 61, -43, 90, -66, 16, -10, -102, -27, 16, -31, -13, -121, -106, 72, 105, -78, -27, 64, -46, -34, -15, 11, 73, -119, 58, -45, 104, -52, 56, -11, 13, 73, -40, -51, -18, 99, -17, -126, -67, 10, 40, 13, -24, -95, 7, -16, 36, 39, 96, 10, -9, 72, -44, -77, 16, -112, 10, 115, 
  62, -25, -96, -89, 38, -44, 60, 82, 102, -21, -93, 31, -82, 43, -66, 64, 24, 79, 8, 36, 107, -113, 49, -75, 25, -38, 102, 43, -68, -76, -45, 62, 54, -91, -31, -26, -86, -17, 61, -97, 51, 66, -96, -28, 37, -35, -49, -78, 41, -38, 54, -39, -10, 8, 47, -100, 9, 0, 24, -20, 90, -48, -20, 3, -20, 74, 13, -72, -36, -52, 0, -97, 0, 89, -21, -109, -99, 70, -59, -64, 43, -75, 28, 7, 17, 23, -30, -17, -100, 11, -67, 96, 22, -53, 95, 86, 44, 67, 36, 17, -118, -82, 
  -87, 57, -66, 62, -17, 66, -12, 106, 47, -95, 82, 90, 47, 67, 39, -27, -91, -51, 29, 69, -79, 42, -76, -41, 62, 56, -86, 62, 87, 70, -49, 45, 84, -51, 66, 12, 107, -105, 13, 72, -86, 65, 5, 85, 97, -87, 2, -71, 68, 50, -79, -6, -15, -112, 27, -84, -101, -110, -39, -14, 99, 37, 96, 76, -69, -100, 60, -95, -77, -103, 61, -59, -65, -78, 16, 35, -34, 109, 33, 106, 14, 68, 68, -35, -22, -88, -17, -45, 59, -46, 44, 37, -98, 11, 83, -43, -63, -22, 78, -29, -42, -11, 
  94, 33, 25, -58, -83, -93, 97, -15, -45, 75, -27, 9, -63, -38, -69, 70, 72, 59, -5, -15, -5, 110, -14, -25, -40, 16, 86, 83, -95, -93, 43, -60, 104, -68, -29, -60, -41, -90, 30, 76, 14, 27, -103, -29, 68, -54, 73, 59, -27, 85, 76, 93, -95, -35, -28, 116, 77, 98, 84, 57, -89, -77, 106, 115, -4, 54, -41, 119, -101, -12, -100, 22, 80, 42, 52, 66, -32, -38, -52, -45, 88, -90, 63, -86, 29, -68, 30, -64, 85, -47, -51, -1, 34, 86, 43, -5, 12, -37, -74, -71, -14, -105, 
  -37, 84, 13, -8, -29, -74, 15, 111, -49, 21, -94, -27, -103, 53, 12, -5, -92, 44, -28, 11, -92, -95, -2, -39, 85, -27, 23, -19, -44, 124, -21, -10, 78, -71, 28, -87, 74, -62, 38, 92, 73, 57, -83, -28, 12, -111, -84, -58, -12, 71, 90, -19, 34, -29, 41, 67, 30, -17, 60, 23, 24, -103, 65, -89, -31, 14, -39, 89, 88, 47, 102, -34, 88, -75, -116, -73, -10, -2, 84, 7, -92, 38, -49, 101, 3, -77, 25, -10, 113, -5, 24, 14, -74, 81, 10, 4, -7, 41, -9, 64, -7, 47, 
  60, -29, -31, -55, -66, -112, -31, 80, -30, 14, -7, -13, 6, 66, 52, -12, -47, -62, 109, 87, -43, 25, -52, 66, -52, -8, 118, -87, 87, 24, 66, -99, 10, -8, -86, 59, -106, 48, -80, 117, -9, 19, -15, 7, -46, -87, 112, -65, -15, -21, -64, 98, -85, 62, 39, -10, 18, 98, 71, -45, -60, 14, 87, -60, 64, 23, -91, 72, -73, -53, 31, 92, -27, 52, 41, 72, 67, 81, 52, -47, 90, 74, 18, 27, -69, -32, 76, 33, -45, -52, -88, 69, -35, 106, -32, -111, -59, -69, -89, -6, -65, -68, 
  87, -118, 30, 85, 92, 43, 26, 35, -36, 84, -22, 117, -50, 33, -73, -114, -34, -46, -86, 92, 89, -77, -50, 5, -35, 95, -32, 23, -88, -10, 18, 91, 22, -104, -28, -96, -16, 20, 74, -48, -12, 37, 119, 96, 37, -23, 31, -86, -55, 44, -76, -41, -14, 24, -24, -79, -96, 64, 76, -101, -67, -46, 55, -92, 55, 37, 28, -55, -52, 97, -76, 26, -24, 41, -3, 6, -51, 71, -61, 55, 108, -122, 57, 4, 23, -100, 45, 35, 66, -30, -31, -89, 14, -75, -94, -40, -37, -82, 4, 87, -30, 73, 
  64, 105, 61, -21, -86, 69, -4, -65, -13, -20, 9, 68, 76, -40, 13, -50, 39, -49, 111, 22, 96, 72, 89, 43, 66, 70, 74, -13, 82, -98, 55, -104, -21, -4, -98, -33, -105, 93, -77, 8, -61, -59, -111, -43, -101, 30, -37, -16, -69, 33, -106, -110, 115, -71, 53, 52, 10, 49, -2, -43, 76, -25, 88, -46, 16, -107, 104, 79, 64, -59, -37, -35, 29, -88, -39, -101, -71, -52, -50, 93, -59, -66, -81, -53, 102, 23, -9, 37, 61, 58, 8, -100, -103, -27, 78, -10, 98, 26, 44, -63, -83, -69, 
  -84, 49, -100, -7, -70, 65, -93, -1, -67, -111, -101, -76, -107, -29, -77, 86, -19, 64, 73, -70, -29, 70, 15, 103, 104, 74, -1, 33, -10, 50, -55, -31, -87, -3, 71, 34, 68, 83, -22, 16, 18, 46, -65, 27, -53, -110, 64, 45, 99, -86, 50, 104, -113, -104, -60, 20, 55, 12, -107, 33, -92, -60, -83, 83, -5, -26, -96, -31, -82, 46, -76, 73, 105, 2, -26, -83, 95, -31, -109, 76, 49, 106, -100, -62, -82, 84, -82, -59, 46, 20, 82, 42, -37, -14, 6, 100, -9, -102, -91, -49, 62, -85, 
  103, 26, 47, -106, -89, -44, 61, 18, -9, 36, -86, 33, 27, -85, 50, -64, -4, -1, 36, 24, -96, 51, -103, 86, 93, -20, -55, -35, 76, 75, -103, -87, -89, -24, 107, 97, -29, -86, -89, 31, 39, -14, 8, -34, -39, 76, 5, -104, 67, 42, -37, -68, -24, -7, 78, 97, -75, -47, 22, -18, 26, 37, 68, 74, 25, -107, -101, 49, 47, 30, 83, 12, -27, -45, -4, 98, 27, -69, 47, 109, -49, -76, 30, -74, -46, 74, -41, 28, -44, -56, 0, 103, 48, -58, -19, 6, -59, 39, -100, 52, 90, 67, 
  -10, 33, 94, -38, -74, -81, 115, -47, 77, -30, 101, 118, 66, 96, -45, 45, -45, -21, 94, -1, -29, -28, 99, 22, 28, 40, 65, 49, 101, 60, -14, -27, 1, -50, 19, -7, -79, 24, 25, 54, 38, 97, 99, -21, -62, -39, 18, 69, -88, -13, -86, 69, 32, 55, 107, 60, 51, -25, 20, -70, 88, 55, -7, -35, 88, 84, 76, -31, -26, -30, -74, 22, -57, -67, 84, 26, 59, 106, 53, 18, 45, 95, -83, -41, -99, -98, -75, 47, -9, 89, 55, -86, -111, -87, 22, 50, 46, 75, -22, -34, -17, 11, 
  -47, -105, -2, -35, 64, -95, -63, -107, -92, 53, -29, -102, 24, 59, -41, 81, 11, -37, 88, -30, 48, 62, -72, 69, 52, -35, 5, -53, 89, -29, -50, 26, -110, 99, 65, 68, 86, -72, -96, -69, -16, 17, -86, -54, -113, -43, 98, 62, -13, 109, 70, -97, -113, 20, -69, -108, -78, 33, -24, 48, -33, -79, -87, 73, 15, 27, 76, 41, 6, 75, -4, -52, 47, 71, 27, -108, -46, 84, -98, -95, 14, 47, 90, 70, 99, 83, -104, -63, 1, 67, -81, 99, 19, 18, -79, -99, 36, 11, 68, -25, -78, 64, 
  36, -101, -55, 3, 87, 94, -87, 112, -10, 35, 12, 17, 93, 39, -16, -69, -113, -31, -96, -32, -79, -79, 5, -39, -57, -101, -69, 102, -1, 8, 23, -97, -77, -98, 4, 27, 41, 1, 94, -26, 121, 54, 87, -70, 97, -46, 11, 62, 115, 76, 41, 59, -69, -52, 109, -34, 24, 84, 56, -19, 11, -28, -13, -77, 65, 85, 100, 96, 26, 112, -104, -21, 77, -19, 57, -73, -73, -52, 55, -67, -40, 54, -47, -39, 54, 12, 84, 96, -15, -109, -1, 18, -70, 62, -108, -80, -59, 93, 6, -53, 27, 92, 
  105, -83, -57, 34, 17, -81, -43, 48, 54, 49, 116, -125, -89, 117, -106, -30, -86, -3, 65, -77, 95, 118, -44, 66, -109, -55, -14, -79, 96, -43, 103, -49, -48, 81, -9, -85, -95, 35, 90, -87, -108, 78, -114, 81, -15, 83, -50, -84, -114, -36, -20, 64, 23, -32, -84, -61, 101, -11, 82, -75, 13, 56, -64, 116, 5, 86, 102, 79, -18, 74, 7, -80, 108, -42, 97, 69, -39, 14, 7, 6, 60, 28, -63, -65, 28, -94, 85, 25, -77, 8, -53, 27, -15, 78, -79, -17, 78, 72, 91, 127, -88, 87, 
  -5, 83, -81, -114, -116, 41, -20, 8, 41, 26, -21, 53, -68, 42, 52, 75, 2, 61, 33, 55, -100, 83, -106, 56, 29, -9, -48, -50, -37, -54, 36, -48, -39, 47, -24, 30, 6, -112, 28, 85, 56, -46, 40, -89, 78, -81, -92, -20, -73, 66, 46, -23, 88, 101, 48, -73, 96, 35, -68, 99, -3, -78, 21, -62, 28, 52, 8, -75, 10, 56, -91, 97, 78, 90, 46, 64, -55, 33, 80, 41, -76, -79, 0, 112, 98, 87, 11, 43, 45, 118, -9, 112, 23, 56, 87, 86, -86, 66, 59, 36, 66, 104, 
  -11, -61, -48, 6, 99, -42, -51, -70, 36, -83, -88, -51, 20, 64, -42, 54, -78, -72, 49, -26, -96, -51, 51, -61, 53, -26, -23, 97, -70, 66, 52, 9, 82, -52, -29, -71, 45, -84, -53, 19, -5, -32, 22, 90, -16, -72, 75, -114, -13, -34, 5, 2, -31, -94, -23, -95, -20, -7, 61, -90, -85, 105, -68, 23, -85, 37, -13, -31, -6, 121, -93, -36, -66, 97, 78, 75, -43, 16, -66, 18, 20, 115, -98, -50, -4, 67, 1, -51, 117, -41, 21, 100, 98, 35, 30, -67, 21, -46, 93, -35, -4, -30, 
  -22, 43, 99, 64, 72, -17, -51, 81, 39, -28, -45, 124, -49, 67, -78, -50, -86, 46, 91, -71, 60, -59, -88, 123, -65, -96, -55, 23, -9, -50, -9, -94, 5, 13, 10, 122, 113, -70, 78, -108, -100, -19, 121, -44, 34, -89, 22, 118, -73, 43, -50, -80, 115, 72, 41, -93, 83, -113, -11, -39, 33, -97, 54, 86, -14, 72, -20, -8, 37, -48, 84, -26, 59, 97, 52, 9, -98, -67, 69, -82, -88, -118, -110, 34, 47, 109, -42, 8, 10, 63, -10, 112, -101, -73, 64, 72, 51, -26, 99, -118, 84, 60, 
  -97, -28, 53, -108, 53, 9, -69, -10, -9, -39, -101, -42, -87, -78, -88, -57, 8, -65, -54, 42, -60, 91, -59, 87, -41, -96, -10, -31, -98, -76, 57, -48, -76, -99, 108, 87, 36, -74, -91, -37, -85, 22, -63, 57, -3, -17, 106, 25, -91, -101, 0, -94, 46, -63, 63, -78, -77, -69, -34, 79, -41, -58, -78, 86, 51, -57, 91, -89, 0, 97, 65, 60, 82, -50, -110, 33, 95, 20, -31, 38, 25, 46, 91, -3, 55, 19, 88, 11, -10, -88, -102, 87, 64, -36, -80, -80, 65, 25, 98, -67, -110, 109, 
  7, 71, 1, -70, -22, -17, 44, -26, 75, 59, -91, 106, 68, -13, -6, -61, -8, -73, -67, 18, -46, -116, 81, -67, -18, -9, -76, -61, 37, 106, -88, 4, 88, -84, 7, 57, -111, 12, 2, -31, -71, -57, 31, 50, -4, -106, -96, 49, -4, -8, 23, 34, -84, 57, 60, -68, 54, -109, -63, 111, -75, 62, -85, 22, -73, 7, -6, -87, -84, -83, -98, 92, -21, -11, -29, 19, -90, -89, -84, -41, 80, -25, -7, -74, -14, 49, 92, -28, 25, 22, -104, 27, -79, -41, 24, -70, -79, -67, 105, -82, -41, 105, 
};
const TfArray<2, int> tensor_dimension6 = { 2, { 20,102 } };
const TfArray<1, float> quant6_scale = { 1, { 0.0019995477050542831, } };
const TfArray<1, int> quant6_zero = { 1, { 0 } };
const TfLiteAffineQuantization quant6 = { (TfLiteFloatArray*)&quant6_scale, (TfLiteIntArray*)&quant6_zero, 0 };
const TfArray<2, int> tensor_dimension7 = { 2, { 1,20 } };
const TfArray<1, float> quant7_scale = { 1, { 0.081846579909324646, } };
const TfArray<1, int> quant7_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant7 = { (TfLiteFloatArray*)&quant7_scale, (TfLiteIntArray*)&quant7_zero, 0 };
const TfArray<2, int> tensor_dimension8 = { 2, { 1,10 } };
const TfArray<1, float> quant8_scale = { 1, { 0.053337458521127701, } };
const TfArray<1, int> quant8_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant8 = { (TfLiteFloatArray*)&quant8_scale, (TfLiteIntArray*)&quant8_zero, 0 };
const TfArray<2, int> tensor_dimension9 = { 2, { 1,3 } };
const TfArray<1, float> quant9_scale = { 1, { 0.062233366072177887, } };
const TfArray<1, int> quant9_zero = { 1, { -29 } };
const TfLiteAffineQuantization quant9 = { (TfLiteFloatArray*)&quant9_scale, (TfLiteIntArray*)&quant9_zero, 0 };
const TfArray<2, int> tensor_dimension10 = { 2, { 1,3 } };
const TfArray<1, float> quant10_scale = { 1, { 0.00390625, } };
const TfArray<1, int> quant10_zero = { 1, { -128 } };
const TfLiteAffineQuantization quant10 = { (TfLiteFloatArray*)&quant10_scale, (TfLiteIntArray*)&quant10_zero, 0 };
const TfLiteFullyConnectedParams opdata0 = { kTfLiteActRelu, kTfLiteFullyConnectedWeightsFormatDefault, false, false };
const TfArray<3, int> inputs0 = { 3, { 0,6,5 } };
const TfArray<1, int> outputs0 = { 1, { 7 } };
const TfLiteFullyConnectedParams opdata1 = { kTfLiteActRelu, kTfLiteFullyConnectedWeightsFormatDefault, false, false };
const TfArray<3, int> inputs1 = { 3, { 7,4,3 } };
const TfArray<1, int> outputs1 = { 1, { 8 } };
const TfLiteFullyConnectedParams opdata2 = { kTfLiteActNone, kTfLiteFullyConnectedWeightsFormatDefault, false, false };
const TfArray<3, int> inputs2 = { 3, { 8,2,1 } };
const TfArray<1, int> outputs2 = { 1, { 9 } };
const TfLiteSoftmaxParams opdata3 = { 1 };
const TfArray<1, int> inputs3 = { 1, { 9 } };
const TfArray<1, int> outputs3 = { 1, { 10 } };
};

TensorInfo_t tensorData[] = {
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension0, 102, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant0))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data1, (TfLiteIntArray*)&g0::tensor_dimension1, 12, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant1))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data2, (TfLiteIntArray*)&g0::tensor_dimension2, 30, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant2))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data3, (TfLiteIntArray*)&g0::tensor_dimension3, 40, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant3))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data4, (TfLiteIntArray*)&g0::tensor_dimension4, 200, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant4))}, },
{ kTfLiteMmapRo, kTfLiteInt32, (int32_t*)g0::tensor_data5, (TfLiteIntArray*)&g0::tensor_dimension5, 80, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant5))}, },
{ kTfLiteMmapRo, kTfLiteInt8, (int32_t*)g0::tensor_data6, (TfLiteIntArray*)&g0::tensor_dimension6, 2040, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant6))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 112), (TfLiteIntArray*)&g0::tensor_dimension7, 20, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant7))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension8, 10, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant8))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 16), (TfLiteIntArray*)&g0::tensor_dimension9, 3, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant9))}, },
{ kTfLiteArenaRw, kTfLiteInt8, (int32_t*)(tensor_arena + 0), (TfLiteIntArray*)&g0::tensor_dimension10, 3, {kTfLiteAffineQuantization, const_cast<void*>(static_cast<const void*>(&g0::quant10))}, },
};

#ifndef TF_LITE_STATIC_MEMORY
TfLiteNode tflNodes[4] = {
{ (TfLiteIntArray*)&g0::inputs0, (TfLiteIntArray*)&g0::outputs0, (TfLiteIntArray*)&g0::inputs0, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata0)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs1, (TfLiteIntArray*)&g0::outputs1, (TfLiteIntArray*)&g0::inputs1, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata1)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs2, (TfLiteIntArray*)&g0::outputs2, (TfLiteIntArray*)&g0::inputs2, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata2)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs3, (TfLiteIntArray*)&g0::outputs3, (TfLiteIntArray*)&g0::inputs3, nullptr, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata3)), nullptr, 0, },
};
#else
TfLiteNode tflNodes[4] = {
{ (TfLiteIntArray*)&g0::inputs0, (TfLiteIntArray*)&g0::outputs0, (TfLiteIntArray*)&g0::inputs0, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata0)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs1, (TfLiteIntArray*)&g0::outputs1, (TfLiteIntArray*)&g0::inputs1, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata1)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs2, (TfLiteIntArray*)&g0::outputs2, (TfLiteIntArray*)&g0::inputs2, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata2)), nullptr, 0, },
{ (TfLiteIntArray*)&g0::inputs3, (TfLiteIntArray*)&g0::outputs3, (TfLiteIntArray*)&g0::inputs3, nullptr, const_cast<void*>(static_cast<const void*>(&g0::opdata3)), nullptr, 0, },
};
#endif

used_operators_e used_ops[] =
{OP_FULLY_CONNECTED, OP_FULLY_CONNECTED, OP_FULLY_CONNECTED, OP_SOFTMAX, };


// Indices into tflTensors and tflNodes for subgraphs
const size_t tflTensors_subgraph_index[] = {0, 11, };
const size_t tflNodes_subgraph_index[] = {0, 4, };

// Input/output tensors
static const int in_tensor_indices[] = {
  0, 
};

static const int out_tensor_indices[] = {
  10, 
};


size_t current_subgraph_index = 0;

static void init_tflite_tensor(size_t i, TfLiteTensor *tensor) {
  tensor->type = tensorData[i].type;
  tensor->is_variable = 0;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  tensor->allocation_type = tensorData[i].allocation_type;
#else
  tensor->allocation_type = (tensor_arena <= tensorData[i].data && tensorData[i].data < tensor_arena + kTensorArenaSize) ? kTfLiteArenaRw : kTfLiteMmapRo;
#endif
  tensor->bytes = tensorData[i].bytes;
  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  if(tensor->allocation_type == kTfLiteArenaRw){
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
      tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
  tensor->quantization = tensorData[i].quantization;
  if (tensor->quantization.type == kTfLiteAffineQuantization) {
    TfLiteAffineQuantization const* quant = ((TfLiteAffineQuantization const*)(tensorData[i].quantization.params));
    tensor->params.scale = quant->scale->data[0];
    tensor->params.zero_point = quant->zero_point->data[0];
  }

}

static void init_tflite_eval_tensor(int i, TfLiteEvalTensor *tensor) {

  tensor->type = tensorData[i].type;

  tensor->dims = tensorData[i].dims;

#if defined(EI_CLASSIFIER_ALLOCATION_HEAP)
  auto allocation_type = tensorData[i].allocation_type;
  if(allocation_type == kTfLiteArenaRw) {
    uint8_t* start = (uint8_t*) ((uintptr_t)tensorData[i].data + (uintptr_t) tensor_arena);

    tensor->data.data =  start;
  }
  else {
    tensor->data.data = tensorData[i].data;
  }
#else
  tensor->data.data = tensorData[i].data;
#endif // EI_CLASSIFIER_ALLOCATION_HEAP
}

static void* overflow_buffers[EI_MAX_OVERFLOW_BUFFER_COUNT];
static size_t overflow_buffers_ix = 0;
static void * AllocatePersistentBufferImpl(struct TfLiteContext* ctx,
                                       size_t bytes) {
  void *ptr;
  uint32_t align_bytes = (bytes % 16) ? 16 - (bytes % 16) : 0;

  if (current_location - (bytes + align_bytes) < tensor_boundary) {
    if (overflow_buffers_ix > EI_MAX_OVERFLOW_BUFFER_COUNT - 1) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d, does not fit in tensor arena and reached EI_MAX_OVERFLOW_BUFFER_COUNT\n",
        (int)bytes);
      return NULL;
    }

    // OK, this will look super weird, but.... we have CMSIS-NN buffers which
    // we cannot calculate beforehand easily.
    ptr = ei_calloc(bytes, 1);
    if (ptr == NULL) {
      ei_printf("ERR: Failed to allocate persistent buffer of size %d\n", (int)bytes);
      return NULL;
    }
    overflow_buffers[overflow_buffers_ix++] = ptr;
    return ptr;
  }

  current_location -= bytes;

  // align to the left aligned boundary of 16 bytes
  current_location -= 15; // for alignment
  current_location += 16 - ((uintptr_t)(current_location) & 15);

  ptr = current_location;
  memset(ptr, 0, bytes);

  return ptr;
}

typedef struct {
  size_t bytes;
  void *ptr;
} scratch_buffer_t;

static scratch_buffer_t scratch_buffers[EI_MAX_SCRATCH_BUFFER_COUNT];
static size_t scratch_buffers_ix = 0;

static TfLiteStatus RequestScratchBufferInArenaImpl(struct TfLiteContext* ctx, size_t bytes,
                                                int* buffer_idx) {
  if (scratch_buffers_ix > EI_MAX_SCRATCH_BUFFER_COUNT - 1) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d, reached EI_MAX_SCRATCH_BUFFER_COUNT\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffer_t b;
  b.bytes = bytes;

  b.ptr = AllocatePersistentBufferImpl(ctx, b.bytes);
  if (!b.ptr) {
    ei_printf("ERR: Failed to allocate scratch buffer of size %d\n",
      (int)bytes);
    return kTfLiteError;
  }

  scratch_buffers[scratch_buffers_ix] = b;
  *buffer_idx = scratch_buffers_ix;

  scratch_buffers_ix++;

  return kTfLiteOk;
}

static void* GetScratchBufferImpl(struct TfLiteContext* ctx, int buffer_idx) {
  if (buffer_idx > (int)scratch_buffers_ix) {
    return NULL;
  }
  return scratch_buffers[buffer_idx].ptr;
}

static const uint16_t TENSOR_IX_UNUSED = 0x7FFF;

static void ResetTensors() {
  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    tflTensors[ix].index = TENSOR_IX_UNUSED;
  }
  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    tflEvalTensors[ix].index = TENSOR_IX_UNUSED;
  }
}

static TfLiteTensor* GetTensorImpl(const struct TfLiteContext* context,
                               int tensor_idx) {

  tensor_idx = tflTensors_subgraph_index[current_subgraph_index] + tensor_idx;

  for (size_t ix = 0; ix < MAX_TFL_TENSOR_COUNT; ix++) {
    // already used? OK!
    if (tflTensors[ix].index == tensor_idx) {
      return &tflTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_tensor(tensor_idx, &tflTensors[ix].tensor);
      tflTensors[ix].index = tensor_idx;
      return &tflTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_TENSOR_COUNT (%d)\n", MAX_TFL_TENSOR_COUNT);
  return nullptr;
}

static TfLiteEvalTensor* GetEvalTensorImpl(const struct TfLiteContext* context,
                                       int tensor_idx) {

  tensor_idx = tflTensors_subgraph_index[current_subgraph_index] + tensor_idx;

  for (size_t ix = 0; ix < MAX_TFL_EVAL_COUNT; ix++) {
    // already used? OK!
    if (tflEvalTensors[ix].index == tensor_idx) {
      return &tflEvalTensors[ix].tensor;
    }
    // passed all the ones we've used, so end of the list?
    if (tflEvalTensors[ix].index == TENSOR_IX_UNUSED) {
      // init the tensor
      init_tflite_eval_tensor(tensor_idx, &tflEvalTensors[ix].tensor);
      tflEvalTensors[ix].index = tensor_idx;
      return &tflEvalTensors[ix].tensor;
    }
  }

  ei_printf("ERR: GetTensor called beyond MAX_TFL_EVAL_COUNT (%d)\n", (int)MAX_TFL_EVAL_COUNT);
  return nullptr;
}

class EonMicroContext : public MicroContext {
 public:
 
  EonMicroContext(): MicroContext(nullptr, nullptr, nullptr) { }

  void* AllocatePersistentBuffer(size_t bytes) {
    return AllocatePersistentBufferImpl(nullptr, bytes);
  }

  TfLiteStatus RequestScratchBufferInArena(size_t bytes,
                                           int* buffer_index) {
  return RequestScratchBufferInArenaImpl(nullptr, bytes, buffer_index);
  }

  void* GetScratchBuffer(int buffer_index) {
    return GetScratchBufferImpl(nullptr, buffer_index);
  }
 
  TfLiteTensor* AllocateTempTfLiteTensor(int tensor_index) {
    return GetTensorImpl(nullptr, tensor_index);
  }

  void DeallocateTempTfLiteTensor(TfLiteTensor* tensor) {
    return;
  }

  bool IsAllTempTfLiteTensorDeallocated() {
    return true;
  }

  TfLiteEvalTensor* GetEvalTensor(int tensor_index) {
    return GetEvalTensorImpl(nullptr, tensor_index);
  }

};


} // namespace

TfLiteStatus tflite_learn_10_init( void*(*alloc_fnc)(size_t,size_t) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  tensor_arena = (uint8_t*) alloc_fnc(16, kTensorArenaSize);
  if (!tensor_arena) {
    ei_printf("ERR: failed to allocate tensor arena\n");
    return kTfLiteError;
  }
#else
  memset(tensor_arena, 0, kTensorArenaSize);
#endif
  tensor_boundary = tensor_arena;
  current_location = tensor_arena + kTensorArenaSize;

  EonMicroContext micro_context_;
  
  // Set microcontext as the context ptr
  ctx.impl_ = static_cast<void*>(&micro_context_);
  // Setup tflitecontext functions
  ctx.AllocatePersistentBuffer = &AllocatePersistentBufferImpl;
  ctx.RequestScratchBufferInArena = &RequestScratchBufferInArenaImpl;
  ctx.GetScratchBuffer = &GetScratchBufferImpl;
  ctx.GetTensor = &GetTensorImpl;
  ctx.GetEvalTensor = &GetEvalTensorImpl;
  ctx.ReportError = &MicroContextReportOpError;

  ctx.tensors_size = 11;
  for (size_t i = 0; i < 11; ++i) {
    TfLiteTensor tensor;
    init_tflite_tensor(i, &tensor);
    if (tensor.allocation_type == kTfLiteArenaRw) {
      auto data_end_ptr = (uint8_t*)tensor.data.data + tensorData[i].bytes;
      if (data_end_ptr > tensor_boundary) {
        tensor_boundary = data_end_ptr;
      }
    }
  }

  if (tensor_boundary > current_location /* end of arena size */) {
    ei_printf("ERR: tensor arena is too small, does not fit model - even without scratch buffers\n");
    return kTfLiteError;
  }

  registrations[OP_FULLY_CONNECTED] = Register_FULLY_CONNECTED();
  registrations[OP_SOFTMAX] = Register_SOFTMAX();

  for (size_t g = 0; g < 1; ++g) {
    current_subgraph_index = g;
    for(size_t i = tflNodes_subgraph_index[g]; i < tflNodes_subgraph_index[g+1]; ++i) {
      if (registrations[used_ops[i]].init) {
        tflNodes[i].user_data = registrations[used_ops[i]].init(&ctx, (const char*)tflNodes[i].builtin_data, 0);
      }
    }
  }
  current_subgraph_index = 0;

  for(size_t g = 0; g < 1; ++g) {
    current_subgraph_index = g;
    for(size_t i = tflNodes_subgraph_index[g]; i < tflNodes_subgraph_index[g+1]; ++i) {
      if (registrations[used_ops[i]].prepare) {
        ResetTensors();
        TfLiteStatus status = registrations[used_ops[i]].prepare(&ctx, &tflNodes[i]);
        if (status != kTfLiteOk) {
          return status;
        }
      }
    }
  }
  current_subgraph_index = 0;

  return kTfLiteOk;
}

TfLiteStatus tflite_learn_10_input(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(in_tensor_indices[index], tensor);
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_10_output(int index, TfLiteTensor *tensor) {
  init_tflite_tensor(out_tensor_indices[index], tensor);
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_10_invoke() {
  for (size_t i = 0; i < 4; ++i) {
    ResetTensors();

    TfLiteStatus status = registrations[used_ops[i]].invoke(&ctx, &tflNodes[i]);

#if EI_CLASSIFIER_PRINT_STATE
    ei_printf("layer %lu\n", i);
    ei_printf("    inputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].inputs->size; ix++) {
      auto d = tensorData[tflNodes[i].inputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");

    ei_printf("    outputs:\n");
    for (size_t ix = 0; ix < tflNodes[i].outputs->size; ix++) {
      auto d = tensorData[tflNodes[i].outputs->data[ix]];

      size_t data_ptr = (size_t)d.data;

      if (d.allocation_type == kTfLiteArenaRw) {
        data_ptr = (size_t)tensor_arena + data_ptr;
      }

      if (d.type == TfLiteType::kTfLiteInt8) {
        int8_t* data = (int8_t*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes; jx++) {
          ei_printf("%d ", data[jx]);
        }
      }
      else {
        float* data = (float*)data_ptr;
        ei_printf("        %lu (%zu bytes, ptr=%p, alloc_type=%d, type=%d): ", ix, d.bytes, data, (int)d.allocation_type, (int)d.type);
        for (size_t jx = 0; jx < d.bytes / 4; jx++) {
          ei_printf("%f ", data[jx]);
        }
      }
      ei_printf("\n");
    }
    ei_printf("\n");
#endif // EI_CLASSIFIER_PRINT_STATE

    if (status != kTfLiteOk) {
      return status;
    }
  }
  return kTfLiteOk;
}

TfLiteStatus tflite_learn_10_reset( void (*free_fnc)(void* ptr) ) {
#ifdef EI_CLASSIFIER_ALLOCATION_HEAP
  free_fnc(tensor_arena);
#endif

  // scratch buffers are allocated within the arena, so just reset the counter so memory can be reused
  scratch_buffers_ix = 0;

  // overflow buffers are on the heap, so free them first
  for (size_t ix = 0; ix < overflow_buffers_ix; ix++) {
    ei_free(overflow_buffers[ix]);
  }
  overflow_buffers_ix = 0;
  return kTfLiteOk;
}
