#include "../lvgl/lvgl.h"

/*******************************************************************************
 * Size: 64 px
 * Bpp: 1
 * Opts: 
 ******************************************************************************/

#ifndef UBUNTU
#define UBUNTU 1
#endif

#if UBUNTU

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x7c, 0x3e, 0x1f, 0xf, 0x87, 0xc3, 0xe1, 0xf0,
    0xf8, 0x7c, 0x3e, 0x1f, 0xf, 0x87, 0xc3, 0xe1,
    0xf0, 0xf8, 0x7c, 0x3e, 0x1f, 0xf, 0x87, 0xc3,
    0xe0, 0xe0, 0x70, 0x38, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x78, 0x7f, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0xfc, 0x7c,

    /* U+22 "\"" */
    0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f,
    0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f,
    0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f,
    0x70, 0xe, 0x70, 0xe, 0x70, 0xe, 0x70, 0xe,

    /* U+23 "#" */
    0x0, 0x7c, 0x7, 0xc0, 0x7, 0xc0, 0x7c, 0x0,
    0x7c, 0x7, 0xc0, 0xf, 0x80, 0xf8, 0x0, 0xf8,
    0xf, 0x80, 0xf, 0x80, 0xf8, 0x0, 0xf8, 0xf,
    0x80, 0xf, 0x80, 0xf8, 0x1, 0xf8, 0x1f, 0x80,
    0x1f, 0x1, 0xf0, 0x1, 0xf0, 0x1f, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x3e, 0x3, 0xe0,
    0x3, 0xe0, 0x3e, 0x0, 0x3e, 0x3, 0xe0, 0x3,
    0xe0, 0x3e, 0x0, 0x3e, 0x3, 0xe0, 0x7, 0xc0,
    0x7c, 0x0, 0x7c, 0x7, 0xc0, 0x7, 0xc0, 0x7c,
    0x0, 0x7c, 0x7, 0xc0, 0x7, 0xc0, 0x7c, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xf8, 0xf,
    0x80, 0xf, 0x80, 0xf8, 0x1, 0xf8, 0x1f, 0x80,
    0x1f, 0x1, 0xf0, 0x1, 0xf0, 0x1f, 0x0, 0x1f,
    0x1, 0xf0, 0x1, 0xf0, 0x1f, 0x0, 0x1f, 0x1,
    0xf0, 0x3, 0xe0, 0x3e, 0x0, 0x3e, 0x3, 0xe0,
    0x3, 0xe0, 0x3e, 0x0,

    /* U+24 "$" */
    0x0, 0x1f, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x1,
    0xf0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x3, 0xfe, 0x0, 0x7,
    0xff, 0xf8, 0x7, 0xff, 0xff, 0x3, 0xff, 0xff,
    0xc1, 0xff, 0xff, 0xe0, 0xff, 0x0, 0xf8, 0x3f,
    0x0, 0x2, 0x1f, 0x80, 0x0, 0x7, 0xc0, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x1f,
    0x80, 0x0, 0x7, 0xe0, 0x0, 0x0, 0xfe, 0x0,
    0x0, 0x3f, 0xe0, 0x0, 0x7, 0xff, 0x0, 0x0,
    0xff, 0xf0, 0x0, 0x1f, 0xff, 0x80, 0x1, 0xff,
    0xf8, 0x0, 0x1f, 0xff, 0x0, 0x0, 0xff, 0xe0,
    0x0, 0x7, 0xfc, 0x0, 0x0, 0x7f, 0x80, 0x0,
    0x7, 0xe0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x7, 0xc0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x1f,
    0x9f, 0x0, 0x1f, 0xe7, 0xff, 0xff, 0xf3, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xfc, 0xf, 0xff, 0xfe,
    0x0, 0x3f, 0xf8, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x7, 0xc0, 0x0,

    /* U+25 "%" */
    0x7, 0x80, 0x0, 0x7c, 0x7f, 0x80, 0x3, 0xe3,
    0xff, 0x0, 0xf, 0x1f, 0x3e, 0x0, 0x7c, 0x78,
    0x78, 0x3, 0xe1, 0xe1, 0xe0, 0xf, 0x8f, 0x3,
    0xc0, 0x7c, 0x3c, 0xf, 0x3, 0xe0, 0xf0, 0x3c,
    0xf, 0x83, 0xc0, 0xf0, 0x7c, 0xf, 0x3, 0xc1,
    0xe0, 0x3c, 0xf, 0xf, 0x80, 0xf0, 0x3c, 0x7c,
    0x3, 0xc0, 0xf1, 0xf0, 0x7, 0x87, 0x8f, 0x80,
    0x1e, 0x1e, 0x7c, 0x0, 0x7c, 0xf9, 0xf0, 0x0,
    0xff, 0xcf, 0x80, 0x1, 0xfe, 0x3c, 0x0, 0x1,
    0xe1, 0xf0, 0x0, 0x0, 0xf, 0x87, 0x80, 0x0,
    0x3c, 0x7f, 0x80, 0x1, 0xf3, 0xff, 0x0, 0xf,
    0x9f, 0x3e, 0x0, 0x3e, 0x78, 0x78, 0x1, 0xf1,
    0xe1, 0xe0, 0xf, 0x8f, 0x3, 0xc0, 0x3e, 0x3c,
    0xf, 0x1, 0xf0, 0xf0, 0x3c, 0x7, 0x83, 0xc0,
    0xf0, 0x3e, 0xf, 0x3, 0xc1, 0xf0, 0x3c, 0xf,
    0x7, 0x80, 0xf0, 0x3c, 0x3e, 0x3, 0xc0, 0xf1,
    0xf0, 0x7, 0x87, 0x87, 0xc0, 0x1e, 0x1e, 0x3e,
    0x0, 0x7c, 0xf8, 0xf0, 0x0, 0xff, 0xc7, 0xc0,
    0x1, 0xfe, 0x3e, 0x0, 0x3, 0xe0,

    /* U+26 "&" */
    0x0, 0x7f, 0x0, 0x0, 0x1f, 0xfc, 0x0, 0x3,
    0xff, 0xe0, 0x0, 0x7f, 0xff, 0x0, 0xf, 0xff,
    0xf0, 0x0, 0xfc, 0x3f, 0x80, 0x1f, 0x81, 0xf8,
    0x1, 0xf0, 0xf, 0x80, 0x1f, 0x0, 0xf8, 0x1,
    0xf0, 0xf, 0x80, 0x1f, 0x0, 0xf0, 0x1, 0xf0,
    0x1f, 0x0, 0xf, 0x81, 0xf0, 0x0, 0xf8, 0x3e,
    0x0, 0xf, 0xc7, 0xc0, 0x0, 0x7f, 0xf8, 0x0,
    0x3, 0xff, 0x0, 0x0, 0x3f, 0xe0, 0x0, 0x3,
    0xfc, 0x7, 0x80, 0x7f, 0xc0, 0x7c, 0xf, 0xfe,
    0x7, 0xc1, 0xfb, 0xf0, 0x7c, 0x3f, 0x1f, 0x87,
    0x83, 0xe1, 0xfc, 0xf8, 0x7c, 0xf, 0xef, 0x87,
    0xc0, 0x7f, 0xf8, 0xf8, 0x3, 0xff, 0xf, 0x80,
    0x1f, 0xf0, 0xf8, 0x0, 0xff, 0xf, 0x80, 0x7,
    0xe0, 0xf8, 0x0, 0x3e, 0xf, 0xc0, 0x7, 0xf0,
    0xfc, 0x0, 0xff, 0x7, 0xe0, 0x1f, 0xf8, 0x7f,
    0x87, 0xff, 0xc3, 0xff, 0xff, 0x7c, 0x3f, 0xff,
    0xe7, 0xe1, 0xff, 0xfc, 0x3e, 0x7, 0xff, 0x3,
    0xe0, 0x1f, 0xc0, 0x1f,

    /* U+27 "'" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb9, 0xce, 0x70,

    /* U+28 "(" */
    0x0, 0x2, 0x0, 0x7, 0x0, 0x7, 0xc0, 0x7,
    0xf0, 0x7, 0xf0, 0x7, 0xf0, 0x7, 0xf0, 0x3,
    0xf0, 0x3, 0xf0, 0x3, 0xf0, 0x1, 0xf8, 0x1,
    0xf8, 0x0, 0xf8, 0x0, 0xfc, 0x0, 0x7c, 0x0,
    0x7e, 0x0, 0x3e, 0x0, 0x1f, 0x0, 0x1f, 0x80,
    0xf, 0x80, 0x7, 0xc0, 0x3, 0xe0, 0x3, 0xf0,
    0x1, 0xf8, 0x0, 0xf8, 0x0, 0x7c, 0x0, 0x3e,
    0x0, 0x1f, 0x0, 0xf, 0x80, 0x7, 0xc0, 0x3,
    0xe0, 0x1, 0xf0, 0x0, 0xf8, 0x0, 0x7e, 0x0,
    0x1f, 0x0, 0xf, 0x80, 0x7, 0xc0, 0x3, 0xf0,
    0x0, 0xf8, 0x0, 0x7c, 0x0, 0x3f, 0x0, 0xf,
    0x80, 0x7, 0xe0, 0x1, 0xf0, 0x0, 0xfc, 0x0,
    0x3f, 0x0, 0x1f, 0xc0, 0x7, 0xe0, 0x1, 0xf8,
    0x0, 0xfe, 0x0, 0x3f, 0x80, 0xf, 0xe0, 0x3,
    0xf8, 0x0, 0xf8, 0x0, 0x38, 0x0, 0x4,

    /* U+29 ")" */
    0x20, 0x0, 0x1c, 0x0, 0x1f, 0x0, 0x1f, 0xc0,
    0x7, 0xf0, 0x1, 0xfc, 0x0, 0x7f, 0x0, 0x1f,
    0x80, 0x7, 0xe0, 0x3, 0xf8, 0x0, 0xfc, 0x0,
    0x3f, 0x0, 0xf, 0x80, 0x7, 0xe0, 0x1, 0xf0,
    0x0, 0xfc, 0x0, 0x3e, 0x0, 0x1f, 0x0, 0xf,
    0xc0, 0x3, 0xe0, 0x1, 0xf0, 0x0, 0xf8, 0x0,
    0x7e, 0x0, 0x1f, 0x0, 0xf, 0x80, 0x7, 0xc0,
    0x3, 0xe0, 0x1, 0xf0, 0x0, 0xf8, 0x0, 0x7c,
    0x0, 0x3e, 0x0, 0x1f, 0x0, 0x1f, 0x80, 0xf,
    0xc0, 0x7, 0xc0, 0x3, 0xe0, 0x1, 0xf0, 0x1,
    0xf8, 0x0, 0xf8, 0x0, 0x7c, 0x0, 0x7e, 0x0,
    0x3e, 0x0, 0x3f, 0x0, 0x1f, 0x0, 0x1f, 0x80,
    0x1f, 0x80, 0xf, 0xc0, 0xf, 0xc0, 0xf, 0xc0,
    0xf, 0xe0, 0xf, 0xe0, 0xf, 0xe0, 0xf, 0xe0,
    0x3, 0xe0, 0x0, 0xe0, 0x0, 0x40, 0x0,

    /* U+2A "*" */
    0x0, 0x3f, 0x0, 0x0, 0xf, 0xc0, 0x0, 0x3,
    0xf0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x3f, 0x0,
    0x0, 0xf, 0xc0, 0x2, 0x1, 0xe0, 0x11, 0xe0,
    0x78, 0x1e, 0x7f, 0x1e, 0x3f, 0x9f, 0xf7, 0xbf,
    0xef, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xfe, 0x3,
    0xff, 0xf0, 0x0, 0xf, 0xe0, 0x0, 0xf, 0xfc,
    0x0, 0x7, 0xff, 0x80, 0x3, 0xf3, 0xf0, 0x0,
    0xfc, 0xfe, 0x0, 0x7e, 0x1f, 0x80, 0x3f, 0x87,
    0xf0, 0x1f, 0xc0, 0xfe, 0x3, 0xf0, 0x3f, 0x0,
    0x38, 0x7, 0x0, 0x4, 0x0, 0x80,

    /* U+2B "+" */
    0x0, 0x1f, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0xf, 0x80, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xf, 0x80,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x1f,
    0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0xf, 0x80, 0x0,

    /* U+2C "," */
    0x7, 0x80, 0xfe, 0x1f, 0xe1, 0xff, 0x1f, 0xf1,
    0xff, 0x1f, 0xf0, 0xff, 0x7, 0xf0, 0x3e, 0x3,
    0xe0, 0x7e, 0xf, 0xc3, 0xf8, 0xff, 0xf, 0xe0,
    0xfc, 0x6, 0x0,

    /* U+2D "-" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc,

    /* U+2E "." */
    0x3e, 0x3f, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xfe, 0x3e, 0x0,

    /* U+2F "/" */
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x1,
    0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0,
    0x3, 0xe0, 0x0, 0x3, 0xe0, 0x0, 0x3, 0xe0,
    0x0, 0x7, 0xc0, 0x0, 0x7, 0xc0, 0x0, 0x7,
    0x80, 0x0, 0xf, 0x80, 0x0, 0xf, 0x80, 0x0,
    0xf, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0x78, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0xf0, 0x0, 0x1, 0xf0,
    0x0, 0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x3,
    0xe0, 0x0, 0x3, 0xc0, 0x0, 0x3, 0xc0, 0x0,
    0x7, 0xc0, 0x0, 0x7, 0x80, 0x0, 0x7, 0x80,
    0x0, 0xf, 0x80, 0x0, 0xf, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x78, 0x0, 0x0, 0x78,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0xf0, 0x0, 0x0,

    /* U+30 "0" */
    0x0, 0x3f, 0x0, 0x0, 0x7f, 0xf8, 0x0, 0x3f,
    0xff, 0x0, 0x1f, 0xff, 0xe0, 0xf, 0xff, 0xfc,
    0x7, 0xf8, 0x7f, 0x81, 0xf8, 0x7, 0xe0, 0xfc,
    0x0, 0xfc, 0x3e, 0x0, 0x1f, 0x1f, 0x80, 0x7,
    0xe7, 0xc0, 0x0, 0xf9, 0xf0, 0x0, 0x3e, 0x7c,
    0x0, 0xf, 0xbf, 0x0, 0x3, 0xff, 0x80, 0x0,
    0x7f, 0xe0, 0x70, 0x1f, 0xf8, 0x3e, 0x7, 0xfe,
    0x1f, 0xc1, 0xff, 0x87, 0xf0, 0x7f, 0xe1, 0xfc,
    0x1f, 0xf8, 0x7f, 0x7, 0xfe, 0xf, 0x81, 0xff,
    0x81, 0xc0, 0x7f, 0xe0, 0x0, 0x1f, 0xf8, 0x0,
    0x7, 0xfe, 0x0, 0x1, 0xff, 0xc0, 0x0, 0xfd,
    0xf0, 0x0, 0x3e, 0x7c, 0x0, 0xf, 0x9f, 0x0,
    0x3, 0xe7, 0xe0, 0x1, 0xf8, 0xf8, 0x0, 0x7c,
    0x3f, 0x0, 0x3f, 0x7, 0xe0, 0x1f, 0x81, 0xfc,
    0xf, 0xe0, 0x3f, 0xff, 0xf0, 0x7, 0xff, 0xf8,
    0x0, 0xff, 0xfc, 0x0, 0x1f, 0xfe, 0x0, 0x0,
    0xfc, 0x0,

    /* U+31 "1" */
    0x0, 0xf, 0x0, 0x0, 0x3e, 0x0, 0x0, 0xfc,
    0x0, 0x7, 0xf8, 0x0, 0x1f, 0xf0, 0x0, 0xff,
    0xe0, 0x3, 0xff, 0xc0, 0x3f, 0xff, 0x80, 0xff,
    0x9f, 0x0, 0xfe, 0x3e, 0x1, 0xf0, 0x7c, 0x3,
    0x0, 0xf8, 0x0, 0x1, 0xf0, 0x0, 0x3, 0xe0,
    0x0, 0x7, 0xc0, 0x0, 0xf, 0x80, 0x0, 0x1f,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0xf8, 0x0, 0x1, 0xf0, 0x0, 0x3, 0xe0, 0x0,
    0x7, 0xc0, 0x0, 0xf, 0x80, 0x0, 0x1f, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xf8,
    0x0, 0x1, 0xf0, 0x0, 0x3, 0xe0, 0x0, 0x7,
    0xc0, 0x0, 0xf, 0x80, 0x0, 0x1f, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xf8, 0x3,
    0xff, 0xff, 0xe7, 0xff, 0xff, 0xcf, 0xff, 0xff,
    0x9f, 0xff, 0xff,

    /* U+32 "2" */
    0x0, 0xff, 0x0, 0x1, 0xff, 0xf8, 0x1, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xe0, 0x7f, 0xff, 0xfc,
    0x3f, 0xe0, 0x7f, 0x87, 0xc0, 0x7, 0xe0, 0xe0,
    0x0, 0xfc, 0x20, 0x0, 0x3f, 0x0, 0x0, 0x7,
    0xc0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x1f, 0x80, 0x0, 0xf,
    0xc0, 0x0, 0x7, 0xe0, 0x0, 0x3, 0xf0, 0x0,
    0x1, 0xfc, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x7e,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0x1f, 0x80, 0x0,
    0xf, 0xc0, 0x0, 0x7, 0xe0, 0x0, 0x3, 0xf0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0xf, 0x80, 0x0, 0x3, 0xc0,
    0x0, 0x1, 0xf0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xdf, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff,

    /* U+33 "3" */
    0x1, 0xfe, 0x0, 0xf, 0xff, 0x80, 0x3f, 0xff,
    0xe0, 0x7f, 0xff, 0xf0, 0x3f, 0xff, 0xf8, 0x3e,
    0x7, 0xf8, 0x10, 0x1, 0xfc, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0xf8, 0x0, 0x1, 0xf0, 0x0, 0x7, 0xf0,
    0x1, 0xff, 0xc0, 0x1, 0xff, 0x80, 0x1, 0xff,
    0xc0, 0x1, 0xff, 0xf0, 0x0, 0x7, 0xf8, 0x0,
    0x1, 0xfc, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x3f, 0x0, 0x0, 0x3f,
    0x0, 0x0, 0x7e, 0x40, 0x0, 0xfe, 0x78, 0x3,
    0xfc, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xe0, 0x3f, 0xff, 0xc0, 0x7, 0xfe, 0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x7e, 0x0, 0x0, 0xf, 0xe0, 0x0,
    0x1, 0xfe, 0x0, 0x0, 0x3f, 0xe0, 0x0, 0x7,
    0xfe, 0x0, 0x0, 0x7f, 0xe0, 0x0, 0xf, 0xfe,
    0x0, 0x1, 0xfb, 0xe0, 0x0, 0x3f, 0x3e, 0x0,
    0x3, 0xe3, 0xe0, 0x0, 0x7e, 0x3e, 0x0, 0xf,
    0xc3, 0xe0, 0x0, 0xf8, 0x3e, 0x0, 0x1f, 0x3,
    0xe0, 0x3, 0xf0, 0x3e, 0x0, 0x3e, 0x3, 0xe0,
    0x7, 0xc0, 0x3e, 0x0, 0x7c, 0x3, 0xe0, 0xf,
    0x80, 0x3e, 0x1, 0xf8, 0x3, 0xe0, 0x1f, 0x0,
    0x3e, 0x3, 0xf0, 0x3, 0xe0, 0x3e, 0x0, 0x3e,
    0x7, 0xe0, 0x3, 0xe0, 0x7c, 0x0, 0x3e, 0x7,
    0xc0, 0x3, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3, 0xe0,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x3, 0xe0,

    /* U+35 "5" */
    0x1f, 0xff, 0xfc, 0x3f, 0xff, 0xf8, 0x7f, 0xff,
    0xf0, 0xff, 0xff, 0xe1, 0xf0, 0x0, 0x3, 0xe0,
    0x0, 0x7, 0xc0, 0x0, 0xf, 0x80, 0x0, 0x1f,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x78, 0x0, 0x0,
    0xf0, 0x0, 0x1, 0xe0, 0x0, 0x3, 0xc0, 0x0,
    0x7, 0x80, 0x0, 0x1f, 0xf0, 0x0, 0x3f, 0xfe,
    0x0, 0x7f, 0xff, 0x0, 0xff, 0xff, 0x81, 0xff,
    0xff, 0x80, 0x7, 0xff, 0x80, 0x0, 0xff, 0x0,
    0x0, 0x7f, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x7e,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0xf8, 0x0, 0x1,
    0xf0, 0x0, 0x3, 0xe0, 0x0, 0x7, 0xc0, 0x0,
    0xf, 0x80, 0x0, 0x3f, 0x0, 0x0, 0x7c, 0x80,
    0x3, 0xf9, 0xe0, 0x1f, 0xe7, 0xff, 0xff, 0xcf,
    0xff, 0xff, 0x1f, 0xff, 0xfc, 0x1f, 0xff, 0xe0,
    0x3, 0xfe, 0x0,

    /* U+36 "6" */
    0x0, 0x0, 0x1f, 0x0, 0x0, 0xff, 0xc0, 0x0,
    0xff, 0xf0, 0x0, 0xff, 0xfc, 0x0, 0x7f, 0xff,
    0x0, 0x7f, 0xf8, 0x0, 0x3f, 0xe0, 0x0, 0x1f,
    0xc0, 0x0, 0xf, 0xe0, 0x0, 0x3, 0xf0, 0x0,
    0x1, 0xf8, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x7, 0xc0, 0x0,
    0x1, 0xf1, 0xfe, 0x0, 0x7f, 0xff, 0xf0, 0x1f,
    0xff, 0xff, 0xf, 0xff, 0xff, 0xe3, 0xff, 0xff,
    0xfc, 0xff, 0x80, 0xff, 0x3e, 0x0, 0xf, 0xef,
    0x80, 0x1, 0xfb, 0xe0, 0x0, 0x3f, 0xf8, 0x0,
    0xf, 0xfe, 0x0, 0x1, 0xff, 0x80, 0x0, 0x7f,
    0xe0, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xdf, 0x0,
    0x1, 0xf7, 0xc0, 0x0, 0xfd, 0xf8, 0x0, 0x3e,
    0x3e, 0x0, 0x1f, 0x8f, 0xc0, 0xf, 0xe1, 0xfc,
    0xf, 0xf0, 0x7f, 0xff, 0xf8, 0xf, 0xff, 0xfc,
    0x1, 0xff, 0xfe, 0x0, 0x1f, 0xff, 0x0, 0x0,
    0xfe, 0x0,

    /* U+37 "7" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x7, 0x80, 0x0, 0x7, 0xc0,
    0x0, 0x3, 0xe0, 0x0, 0x3, 0xe0, 0x0, 0x1,
    0xf0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x7, 0xc0, 0x0, 0x3, 0xe0,
    0x0, 0x3, 0xe0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7e, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x7, 0xc0, 0x0,

    /* U+38 "8" */
    0x0, 0x7f, 0x80, 0x0, 0x7f, 0xfc, 0x0, 0x7f,
    0xff, 0x80, 0x3f, 0xff, 0xf0, 0x1f, 0xff, 0xfe,
    0xf, 0xf0, 0x3f, 0xc3, 0xf0, 0x3, 0xf0, 0xf8,
    0x0, 0x7e, 0x7c, 0x0, 0xf, 0x9f, 0x0, 0x3,
    0xe7, 0xc0, 0x0, 0xf9, 0xf0, 0x0, 0x3e, 0x7e,
    0x0, 0xf, 0x9f, 0x80, 0x7, 0xc3, 0xf0, 0x1,
    0xf0, 0xfe, 0x0, 0xf8, 0x1f, 0xe0, 0xfc, 0x7,
    0xff, 0xfe, 0x0, 0xff, 0xff, 0x0, 0xf, 0xff,
    0xc0, 0x3, 0xff, 0xf8, 0x3, 0xff, 0xff, 0x81,
    0xfc, 0x3f, 0xf0, 0xfc, 0x3, 0xfe, 0x3e, 0x0,
    0x3f, 0x9f, 0x0, 0x7, 0xe7, 0xc0, 0x0, 0xff,
    0xe0, 0x0, 0x1f, 0xf8, 0x0, 0x7, 0xfe, 0x0,
    0x1, 0xff, 0x80, 0x0, 0x7f, 0xf0, 0x0, 0x3f,
    0xfc, 0x0, 0xf, 0x9f, 0x80, 0x7, 0xe7, 0xf8,
    0x7, 0xf8, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xfe,
    0x3, 0xff, 0xff, 0x0, 0x7f, 0xff, 0x80, 0x3,
    0xff, 0x0,

    /* U+39 "9" */
    0x0, 0x7f, 0x0, 0x0, 0xff, 0xf8, 0x0, 0x7f,
    0xff, 0x80, 0x3f, 0xff, 0xf0, 0x1f, 0xff, 0xfe,
    0xf, 0xf0, 0x3f, 0x87, 0xf0, 0x7, 0xf1, 0xf8,
    0x0, 0x7c, 0x7c, 0x0, 0x1f, 0xbf, 0x0, 0x3,
    0xef, 0x80, 0x0, 0xfb, 0xe0, 0x0, 0x3f, 0xf8,
    0x0, 0x7, 0xfe, 0x0, 0x1, 0xff, 0x80, 0x0,
    0x7f, 0xe0, 0x0, 0x1f, 0xfc, 0x0, 0x7, 0xdf,
    0x80, 0x1, 0xf7, 0xe0, 0x0, 0x7c, 0xff, 0x0,
    0xff, 0x3f, 0xff, 0xff, 0xc7, 0xff, 0xff, 0xf0,
    0xff, 0xff, 0xfc, 0xf, 0xff, 0xfe, 0x0, 0xff,
    0x8f, 0x80, 0x0, 0x3, 0xe0, 0x0, 0x1, 0xf8,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0x3f, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x7, 0xe0, 0x0, 0x3, 0xf0,
    0x0, 0x3, 0xf8, 0x0, 0x3, 0xfe, 0x0, 0xf,
    0xff, 0x0, 0xff, 0xff, 0x0, 0x3f, 0xff, 0x80,
    0xf, 0xff, 0x80, 0x3, 0xff, 0x0, 0x0, 0xfc,
    0x0, 0x0,

    /* U+3A ":" */
    0x3e, 0x3f, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xfe, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xf1, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xf1, 0xf0,

    /* U+3B ";" */
    0x7, 0xc0, 0xfe, 0x1f, 0xf1, 0xff, 0x1f, 0xf1,
    0xff, 0x1f, 0xf0, 0xfe, 0x7, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x78, 0xf, 0xe1, 0xfe, 0x1f, 0xf1, 0xff, 0x1f,
    0xf1, 0xff, 0xf, 0xf0, 0x7f, 0x3, 0xe0, 0x3e,
    0x7, 0xe0, 0xfc, 0x3f, 0x8f, 0xf0, 0xfe, 0xf,
    0xc0, 0x60, 0x0,

    /* U+3C "<" */
    0x0, 0x0, 0x1, 0x80, 0x0, 0x1, 0xe0, 0x0,
    0x1, 0xf8, 0x0, 0x3, 0xff, 0x0, 0x3, 0xff,
    0x80, 0x7, 0xff, 0x80, 0x7, 0xff, 0x0, 0x7,
    0xff, 0x0, 0xf, 0xfe, 0x0, 0xf, 0xfe, 0x0,
    0xf, 0xfe, 0x0, 0x3, 0xfc, 0x0, 0x0, 0xfe,
    0x0, 0x0, 0x3f, 0xc0, 0x0, 0xf, 0xfe, 0x0,
    0x0, 0xff, 0xe0, 0x0, 0xf, 0xfe, 0x0, 0x0,
    0xff, 0xf0, 0x0, 0x7, 0xff, 0x0, 0x0, 0x7f,
    0xf0, 0x0, 0x3, 0xff, 0x80, 0x0, 0x3f, 0xf0,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x1, 0x80,

    /* U+3D "=" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0,

    /* U+3E ">" */
    0x60, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x7, 0xe0,
    0x0, 0x3, 0xff, 0x0, 0x0, 0x7f, 0xf0, 0x0,
    0x7, 0xff, 0x80, 0x0, 0x3f, 0xf8, 0x0, 0x3,
    0xff, 0x80, 0x0, 0x1f, 0xfc, 0x0, 0x1, 0xff,
    0xc0, 0x0, 0x1f, 0xfc, 0x0, 0x0, 0xff, 0x0,
    0x0, 0x1f, 0xc0, 0x0, 0xf, 0xf0, 0x0, 0x1f,
    0xfc, 0x0, 0x1f, 0xfc, 0x0, 0x1f, 0xfc, 0x0,
    0x3f, 0xfc, 0x0, 0x3f, 0xf8, 0x0, 0x3f, 0xf8,
    0x0, 0x7f, 0xf0, 0x0, 0x3f, 0xf0, 0x0, 0x7,
    0xf0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x60, 0x0,
    0x0, 0x0,

    /* U+3F "?" */
    0x3, 0xfc, 0x1, 0xff, 0xfc, 0x3f, 0xff, 0xf1,
    0xff, 0xff, 0xc7, 0xff, 0xff, 0x3e, 0x3, 0xf9,
    0x80, 0xf, 0xe0, 0x0, 0x3f, 0x0, 0x0, 0xf8,
    0x0, 0x7, 0xc0, 0x0, 0x3e, 0x0, 0x1, 0xe0,
    0x0, 0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f, 0x0,
    0x1, 0xf0, 0x0, 0x1f, 0x0, 0x1, 0xf0, 0x0,
    0x1f, 0x0, 0x1, 0xf0, 0x0, 0x1f, 0x80, 0x1,
    0xf8, 0x0, 0xf, 0xc0, 0x0, 0x7c, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1c, 0x0, 0x3, 0xf8, 0x0, 0x3f,
    0xe0, 0x1, 0xff, 0x0, 0xf, 0xf8, 0x0, 0x7f,
    0xc0, 0x3, 0xfe, 0x0, 0xf, 0xe0, 0x0, 0x3e,
    0x0,

    /* U+40 "@" */
    0x0, 0xf, 0xc0, 0x0, 0xf, 0xff, 0x0, 0x3,
    0xff, 0xf0, 0x1, 0xff, 0xff, 0x80, 0x3f, 0xff,
    0xf0, 0xf, 0xe0, 0xff, 0x3, 0xf0, 0x7, 0xf0,
    0xfc, 0x0, 0x7e, 0x1f, 0x80, 0x7, 0xc7, 0xe0,
    0x0, 0xfc, 0xf8, 0x0, 0xf, 0x9f, 0x0, 0x1,
    0xf3, 0xe0, 0x0, 0x3e, 0xf8, 0x0, 0x7, 0xdf,
    0x0, 0x1f, 0xfb, 0xe0, 0x1f, 0xff, 0x7c, 0x7,
    0xff, 0xff, 0x81, 0xff, 0xff, 0xe0, 0x7f, 0xff,
    0xfc, 0x1f, 0xc1, 0xff, 0x83, 0xf0, 0x3f, 0xf0,
    0xfc, 0x7, 0xfe, 0x1f, 0x80, 0xff, 0xc3, 0xe0,
    0x1f, 0xf8, 0x7c, 0x3, 0xff, 0xf, 0x80, 0x7f,
    0xe1, 0xf0, 0xf, 0xfc, 0x3e, 0x1, 0xff, 0x87,
    0xc0, 0x3f, 0xf0, 0xfc, 0x7, 0xff, 0xf, 0xc0,
    0xfb, 0xe1, 0xfc, 0x1f, 0x7c, 0x1f, 0xff, 0xef,
    0x83, 0xff, 0xfd, 0xf8, 0x3f, 0xff, 0x9f, 0x1,
    0xff, 0xf3, 0xe0, 0xf, 0xf0, 0x7e, 0x0, 0x0,
    0x7, 0xe0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xf,
    0xc0, 0x0, 0x1, 0xfc, 0x0, 0x0, 0x1f, 0xc0,
    0x0, 0x1, 0xff, 0x0, 0x0, 0x1f, 0xff, 0xf0,
    0x1, 0xff, 0xfe, 0x0, 0x1f, 0xff, 0xc0, 0x0,
    0xff, 0xf8, 0x0, 0x3, 0xfc, 0x0,

    /* U+41 "A" */
    0x0, 0xf, 0xc0, 0x0, 0x0, 0x3f, 0x0, 0x0,
    0x1, 0xfe, 0x0, 0x0, 0x7, 0xf8, 0x0, 0x0,
    0x3f, 0xf0, 0x0, 0x0, 0xff, 0xc0, 0x0, 0x3,
    0xcf, 0x0, 0x0, 0x1f, 0x3e, 0x0, 0x0, 0x7c,
    0xf8, 0x0, 0x1, 0xf1, 0xe0, 0x0, 0xf, 0x87,
    0xc0, 0x0, 0x3e, 0x1f, 0x0, 0x0, 0xf8, 0x7c,
    0x0, 0x7, 0xc0, 0xf8, 0x0, 0x1f, 0x3, 0xe0,
    0x0, 0x7c, 0xf, 0x80, 0x3, 0xf0, 0x1e, 0x0,
    0xf, 0x80, 0x7c, 0x0, 0x3e, 0x1, 0xf0, 0x0,
    0xf8, 0x7, 0xc0, 0x7, 0xe0, 0xf, 0x80, 0x1f,
    0x0, 0x3e, 0x0, 0x7c, 0x0, 0xf8, 0x3, 0xf0,
    0x3, 0xf0, 0xf, 0xc0, 0xf, 0xc0, 0x3f, 0xff,
    0xff, 0x0, 0xff, 0xff, 0xfc, 0x7, 0xff, 0xff,
    0xf8, 0x1f, 0xff, 0xff, 0xe0, 0x7c, 0x0, 0xf,
    0x83, 0xf0, 0x0, 0x3f, 0xf, 0xc0, 0x0, 0xfc,
    0x3e, 0x0, 0x1, 0xf0, 0xf8, 0x0, 0x7, 0xc7,
    0xe0, 0x0, 0x1f, 0x9f, 0x0, 0x0, 0x3e, 0x7c,
    0x0, 0x0, 0xf9, 0xf0, 0x0, 0x3, 0xef, 0xc0,
    0x0, 0xf, 0xfe, 0x0, 0x0, 0x1f,

    /* U+42 "B" */
    0x1f, 0xfe, 0x0, 0x3f, 0xff, 0xf0, 0xf, 0xff,
    0xff, 0x3, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xfc,
    0x3e, 0x0, 0xff, 0x8f, 0x80, 0xf, 0xe3, 0xe0,
    0x0, 0xfc, 0xf8, 0x0, 0x3f, 0x3e, 0x0, 0x7,
    0xcf, 0x80, 0x1, 0xf3, 0xe0, 0x0, 0x7c, 0xf8,
    0x0, 0x1f, 0x3e, 0x0, 0xf, 0x8f, 0x80, 0x3,
    0xe3, 0xe0, 0x3, 0xf0, 0xf8, 0x3, 0xf8, 0x3f,
    0xff, 0xfc, 0xf, 0xff, 0xfe, 0x3, 0xff, 0xff,
    0xc0, 0xff, 0xff, 0xfc, 0x3e, 0x0, 0x7f, 0x8f,
    0x80, 0x3, 0xf3, 0xe0, 0x0, 0x7e, 0xf8, 0x0,
    0xf, 0xbe, 0x0, 0x1, 0xff, 0x80, 0x0, 0x7f,
    0xe0, 0x0, 0x1f, 0xf8, 0x0, 0x7, 0xfe, 0x0,
    0x1, 0xff, 0x80, 0x0, 0xff, 0xe0, 0x0, 0x3f,
    0xf8, 0x0, 0x1f, 0xbe, 0x0, 0xf, 0xef, 0x80,
    0x1f, 0xf3, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xfe,
    0x3f, 0xff, 0xfe, 0xf, 0xff, 0xfe, 0x0, 0xff,
    0xfc, 0x0,

    /* U+43 "C" */
    0x0, 0x7, 0xf0, 0x0, 0xf, 0xff, 0xc0, 0xf,
    0xff, 0xf8, 0x7, 0xff, 0xff, 0x3, 0xff, 0xff,
    0x81, 0xfe, 0x3, 0xe0, 0xfe, 0x0, 0x18, 0x7f,
    0x0, 0x0, 0x1f, 0x80, 0x0, 0xf, 0xc0, 0x0,
    0x3, 0xe0, 0x0, 0x1, 0xf8, 0x0, 0x0, 0x7c,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x3, 0xf0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x3e, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x3, 0xe0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x1,
    0xf0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x1f, 0x80,
    0x0, 0x3, 0xf0, 0x0, 0x0, 0xfc, 0x0, 0x0,
    0x1f, 0x80, 0x0, 0x7, 0xf8, 0x0, 0x20, 0xff,
    0x80, 0x78, 0x1f, 0xff, 0xfe, 0x3, 0xff, 0xff,
    0xc0, 0x7f, 0xff, 0xf0, 0x7, 0xff, 0xf0, 0x0,
    0x3f, 0xe0,

    /* U+44 "D" */
    0x1f, 0xf8, 0x0, 0x3f, 0xff, 0xc0, 0xf, 0xff,
    0xfc, 0x3, 0xff, 0xff, 0x80, 0xff, 0xff, 0xf8,
    0x3e, 0x3, 0xff, 0xf, 0x80, 0x1f, 0xc3, 0xe0,
    0x3, 0xf8, 0xf8, 0x0, 0x3f, 0x3e, 0x0, 0xf,
    0xcf, 0x80, 0x1, 0xfb, 0xe0, 0x0, 0x7e, 0xf8,
    0x0, 0xf, 0xbe, 0x0, 0x3, 0xef, 0x80, 0x0,
    0xff, 0xe0, 0x0, 0x1f, 0xf8, 0x0, 0x7, 0xfe,
    0x0, 0x1, 0xff, 0x80, 0x0, 0x7f, 0xe0, 0x0,
    0x1f, 0xf8, 0x0, 0x7, 0xfe, 0x0, 0x1, 0xff,
    0x80, 0x0, 0x7f, 0xe0, 0x0, 0x1f, 0xf8, 0x0,
    0x7, 0xfe, 0x0, 0x3, 0xff, 0x80, 0x0, 0xfb,
    0xe0, 0x0, 0x3e, 0xf8, 0x0, 0x1f, 0xbe, 0x0,
    0x7, 0xef, 0x80, 0x3, 0xf3, 0xe0, 0x0, 0xfc,
    0xf8, 0x0, 0x7e, 0x3e, 0x0, 0x7f, 0xf, 0x80,
    0x7f, 0xc3, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xf0,
    0x3f, 0xff, 0xf0, 0xf, 0xff, 0xf0, 0x0, 0xff,
    0xe0, 0x0,

    /* U+45 "E" */
    0xff, 0xff, 0xfd, 0xff, 0xff, 0xfb, 0xff, 0xff,
    0xf7, 0xff, 0xff, 0xef, 0x80, 0x0, 0x1f, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xf8,
    0x0, 0x1, 0xf0, 0x0, 0x3, 0xe0, 0x0, 0x7,
    0xc0, 0x0, 0xf, 0x80, 0x0, 0x1f, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xf8, 0x0,
    0x1, 0xff, 0xff, 0xc3, 0xff, 0xff, 0x87, 0xff,
    0xff, 0xf, 0xff, 0xfe, 0x1f, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0xf8, 0x0, 0x1,
    0xf0, 0x0, 0x3, 0xe0, 0x0, 0x7, 0xc0, 0x0,
    0xf, 0x80, 0x0, 0x1f, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0xf8, 0x0, 0x1, 0xf0,
    0x0, 0x3, 0xe0, 0x0, 0x7, 0xc0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff,

    /* U+46 "F" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x3, 0xe0, 0x0,
    0xf, 0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0,
    0x3, 0xe0, 0x0, 0xf, 0x80, 0x0, 0x3e, 0x0,
    0x0, 0xf8, 0x0, 0x3, 0xe0, 0x0, 0xf, 0x80,
    0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0, 0x3, 0xff,
    0xff, 0xcf, 0xff, 0xff, 0x3f, 0xff, 0xfc, 0xff,
    0xff, 0xf3, 0xe0, 0x0, 0xf, 0x80, 0x0, 0x3e,
    0x0, 0x0, 0xf8, 0x0, 0x3, 0xe0, 0x0, 0xf,
    0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0, 0x3,
    0xe0, 0x0, 0xf, 0x80, 0x0, 0x3e, 0x0, 0x0,
    0xf8, 0x0, 0x3, 0xe0, 0x0, 0xf, 0x80, 0x0,
    0x3e, 0x0, 0x0, 0xf8, 0x0, 0x3, 0xe0, 0x0,
    0xf, 0x80, 0x0, 0x3e, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0xf, 0xf8, 0x0, 0xf, 0xff, 0x80, 0xf,
    0xff, 0xf8, 0x7, 0xff, 0xff, 0x3, 0xff, 0xff,
    0x81, 0xfe, 0x3, 0xe0, 0xfe, 0x0, 0x38, 0x7f,
    0x0, 0x0, 0x1f, 0x80, 0x0, 0xf, 0xc0, 0x0,
    0x3, 0xe0, 0x0, 0x1, 0xf8, 0x0, 0x0, 0x7c,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x3, 0xf0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0xf8, 0x0, 0x7, 0xfe, 0x0, 0x1, 0xff,
    0x80, 0x0, 0x7f, 0xe0, 0x0, 0x1f, 0xf8, 0x0,
    0x7, 0xff, 0x0, 0x1, 0xf7, 0xc0, 0x0, 0x7d,
    0xf0, 0x0, 0x1f, 0x7e, 0x0, 0x7, 0xcf, 0x80,
    0x1, 0xf3, 0xf0, 0x0, 0x7c, 0xfe, 0x0, 0x1f,
    0x1f, 0xc0, 0x7, 0xc7, 0xf8, 0x1, 0xf0, 0xff,
    0x80, 0xfc, 0x1f, 0xff, 0xff, 0x3, 0xff, 0xff,
    0xc0, 0x7f, 0xff, 0xf0, 0x7, 0xff, 0xf8, 0x0,
    0x3f, 0xf0,

    /* U+48 "H" */
    0xf8, 0x0, 0x7, 0xfe, 0x0, 0x1, 0xff, 0x80,
    0x0, 0x7f, 0xe0, 0x0, 0x1f, 0xf8, 0x0, 0x7,
    0xfe, 0x0, 0x1, 0xff, 0x80, 0x0, 0x7f, 0xe0,
    0x0, 0x1f, 0xf8, 0x0, 0x7, 0xfe, 0x0, 0x1,
    0xff, 0x80, 0x0, 0x7f, 0xe0, 0x0, 0x1f, 0xf8,
    0x0, 0x7, 0xfe, 0x0, 0x1, 0xff, 0x80, 0x0,
    0x7f, 0xe0, 0x0, 0x1f, 0xf8, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x1, 0xff,
    0x80, 0x0, 0x7f, 0xe0, 0x0, 0x1f, 0xf8, 0x0,
    0x7, 0xfe, 0x0, 0x1, 0xff, 0x80, 0x0, 0x7f,
    0xe0, 0x0, 0x1f, 0xf8, 0x0, 0x7, 0xfe, 0x0,
    0x1, 0xff, 0x80, 0x0, 0x7f, 0xe0, 0x0, 0x1f,
    0xf8, 0x0, 0x7, 0xfe, 0x0, 0x1, 0xff, 0x80,
    0x0, 0x7f, 0xe0, 0x0, 0x1f, 0xf8, 0x0, 0x7,
    0xfe, 0x0, 0x1, 0xff, 0x80, 0x0, 0x7f, 0xe0,
    0x0, 0x1f,

    /* U+49 "I" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0xf, 0x80, 0x0, 0x7c, 0x0,
    0x3, 0xe0, 0x0, 0x1f, 0x0, 0x0, 0xf8, 0x0,
    0x7, 0xc0, 0x0, 0x3e, 0x0, 0x1, 0xf0, 0x0,
    0xf, 0x80, 0x0, 0x7c, 0x0, 0x3, 0xe0, 0x0,
    0x1f, 0x0, 0x0, 0xf8, 0x0, 0x7, 0xc0, 0x0,
    0x3e, 0x0, 0x1, 0xf0, 0x0, 0xf, 0x80, 0x0,
    0x7c, 0x0, 0x3, 0xe0, 0x0, 0x1f, 0x0, 0x0,
    0xf8, 0x0, 0x7, 0xc0, 0x0, 0x3e, 0x0, 0x1,
    0xf0, 0x0, 0xf, 0x80, 0x0, 0x7c, 0x0, 0x3,
    0xe0, 0x0, 0x1f, 0x0, 0x0, 0xf8, 0x0, 0x7,
    0xc0, 0x0, 0x3e, 0x0, 0x1, 0xf0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff,

    /* U+4A "J" */
    0x7, 0xff, 0xff, 0x7, 0xff, 0xff, 0x7, 0xff,
    0xff, 0x7, 0xff, 0xff, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x3f, 0x0, 0x0, 0x3e,
    0x20, 0x0, 0x7e, 0x78, 0x0, 0xfe, 0x7e, 0x3,
    0xfc, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xf8, 0x7f,
    0xff, 0xf0, 0x1f, 0xff, 0xc0, 0x3, 0xfe, 0x0,

    /* U+4B "K" */
    0xf8, 0x0, 0x1f, 0xdf, 0x0, 0x7, 0xf3, 0xe0,
    0x0, 0xfc, 0x7c, 0x0, 0x3f, 0x8f, 0x80, 0xf,
    0xe1, 0xf0, 0x3, 0xf8, 0x3e, 0x0, 0x7e, 0x7,
    0xc0, 0x1f, 0x80, 0xf8, 0x7, 0xf0, 0x1f, 0x1,
    0xfc, 0x3, 0xe0, 0x7f, 0x0, 0x7c, 0x1f, 0xc0,
    0xf, 0x83, 0xf0, 0x1, 0xf0, 0xfc, 0x0, 0x3e,
    0x3f, 0x80, 0x7, 0xcf, 0xe0, 0x0, 0xfb, 0xf8,
    0x0, 0x1f, 0xfe, 0x0, 0x3, 0xff, 0x80, 0x0,
    0x7f, 0xf0, 0x0, 0xf, 0xff, 0x80, 0x1, 0xf7,
    0xf8, 0x0, 0x3e, 0x7f, 0x80, 0x7, 0xc7, 0xf8,
    0x0, 0xf8, 0x3f, 0x80, 0x1f, 0x3, 0xf0, 0x3,
    0xe0, 0x3f, 0x0, 0x7c, 0x7, 0xf0, 0xf, 0x80,
    0x7f, 0x1, 0xf0, 0x7, 0xf0, 0x3e, 0x0, 0x7f,
    0x7, 0xc0, 0x7, 0xe0, 0xf8, 0x0, 0xfe, 0x1f,
    0x0, 0xf, 0xe3, 0xe0, 0x0, 0xfc, 0x7c, 0x0,
    0x1f, 0xcf, 0x80, 0x1, 0xf9, 0xf0, 0x0, 0x3f,
    0xbe, 0x0, 0x3, 0xf7, 0xc0, 0x0, 0x7f,

    /* U+4C "L" */
    0xf8, 0x0, 0x1, 0xf0, 0x0, 0x3, 0xe0, 0x0,
    0x7, 0xc0, 0x0, 0xf, 0x80, 0x0, 0x1f, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xf8,
    0x0, 0x1, 0xf0, 0x0, 0x3, 0xe0, 0x0, 0x7,
    0xc0, 0x0, 0xf, 0x80, 0x0, 0x1f, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xf8, 0x0,
    0x1, 0xf0, 0x0, 0x3, 0xe0, 0x0, 0x7, 0xc0,
    0x0, 0xf, 0x80, 0x0, 0x1f, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0xf8, 0x0, 0x1,
    0xf0, 0x0, 0x3, 0xe0, 0x0, 0x7, 0xc0, 0x0,
    0xf, 0x80, 0x0, 0x1f, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0xf8, 0x0, 0x1, 0xf0,
    0x0, 0x3, 0xe0, 0x0, 0x7, 0xc0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff,

    /* U+4D "M" */
    0x1f, 0x0, 0xf, 0x81, 0xf0, 0x0, 0xf8, 0x1f,
    0x80, 0x1f, 0xc3, 0xf8, 0x1, 0xfc, 0x3f, 0x80,
    0x1f, 0xc3, 0xf8, 0x3, 0xfc, 0x3f, 0xc0, 0x3f,
    0xc3, 0xfc, 0x3, 0xfc, 0x3f, 0xc0, 0x3f, 0xc3,
    0xde, 0x7, 0xbc, 0x3d, 0xe0, 0x7b, 0xc3, 0xde,
    0x7, 0xbe, 0x3c, 0xf0, 0xf3, 0xe7, 0xcf, 0xf,
    0x3e, 0x7c, 0xf0, 0xf3, 0xe7, 0xcf, 0x9f, 0x3e,
    0x7c, 0x79, 0xe3, 0xe7, 0xc7, 0x9e, 0x3e, 0x7c,
    0x7b, 0xe3, 0xe7, 0xc3, 0xfc, 0x1e, 0x7c, 0x3f,
    0xc1, 0xe7, 0xc3, 0xfc, 0x1e, 0x78, 0x1f, 0x81,
    0xe7, 0x81, 0xf8, 0x1e, 0x78, 0x1f, 0x81, 0xe7,
    0x80, 0x0, 0x1e, 0x78, 0x0, 0x1, 0xef, 0x80,
    0x0, 0x1f, 0xf8, 0x0, 0x1, 0xff, 0x80, 0x0,
    0x1f, 0xf8, 0x0, 0x1, 0xff, 0x80, 0x0, 0x1f,
    0xf8, 0x0, 0x1, 0xff, 0x80, 0x0, 0x1f, 0xf8,
    0x0, 0x1, 0xff, 0x80, 0x0, 0x1f, 0xf8, 0x0,
    0x1, 0xff, 0x80, 0x0, 0x1f, 0xf8, 0x0, 0x1,
    0xff, 0x80, 0x0, 0x1f,

    /* U+4E "N" */
    0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xfc, 0x0,
    0x1f, 0xfe, 0x0, 0x1f, 0xfe, 0x0, 0x1f, 0xff,
    0x0, 0x1f, 0xff, 0x0, 0x1f, 0xff, 0x80, 0x1f,
    0xff, 0x80, 0x1f, 0xfb, 0xc0, 0x1f, 0xfb, 0xc0,
    0x1f, 0xf9, 0xe0, 0x1f, 0xf9, 0xe0, 0x1f, 0xf8,
    0xf0, 0x1f, 0xf8, 0xf0, 0x1f, 0xf8, 0x78, 0x1f,
    0xf8, 0x78, 0x1f, 0xf8, 0x78, 0x1f, 0xf8, 0x3c,
    0x1f, 0xf8, 0x3c, 0x1f, 0xf8, 0x1e, 0x1f, 0xf8,
    0x1e, 0x1f, 0xf8, 0xf, 0x1f, 0xf8, 0xf, 0x1f,
    0xf8, 0x7, 0x1f, 0xf8, 0x7, 0x9f, 0xf8, 0x7,
    0x9f, 0xf8, 0x3, 0xdf, 0xf8, 0x3, 0xdf, 0xf8,
    0x1, 0xdf, 0xf8, 0x1, 0xff, 0xf8, 0x1, 0xff,
    0xf8, 0x0, 0xff, 0xf8, 0x0, 0xff, 0xf8, 0x0,
    0x7f, 0xf8, 0x0, 0x7f, 0xf8, 0x0, 0x7f, 0xf8,
    0x0, 0x3f, 0xf8, 0x0, 0x3f, 0xf8, 0x0, 0x1f,

    /* U+4F "O" */
    0x0, 0x3f, 0xc0, 0x0, 0xf, 0xff, 0x0, 0x3,
    0xff, 0xfc, 0x0, 0x7f, 0xff, 0xe0, 0xf, 0xff,
    0xff, 0x1, 0xfe, 0x7, 0xf8, 0x1f, 0x80, 0x1f,
    0x83, 0xf0, 0x0, 0xfc, 0x3e, 0x0, 0xf, 0xc3,
    0xe0, 0x0, 0x7c, 0x7c, 0x0, 0x7, 0xe7, 0xc0,
    0x0, 0x3e, 0x7c, 0x0, 0x3, 0xe7, 0xc0, 0x0,
    0x3e, 0xf8, 0x0, 0x3, 0xff, 0x80, 0x0, 0x1f,
    0xf8, 0x0, 0x1, 0xff, 0x80, 0x0, 0x1f, 0xf8,
    0x0, 0x1, 0xff, 0x80, 0x0, 0x1f, 0xf8, 0x0,
    0x1, 0xff, 0x80, 0x0, 0x1f, 0xf8, 0x0, 0x1,
    0xff, 0x80, 0x0, 0x1f, 0xf8, 0x0, 0x1, 0xff,
    0x80, 0x0, 0x3f, 0x7c, 0x0, 0x3, 0xe7, 0xc0,
    0x0, 0x3e, 0x7c, 0x0, 0x3, 0xe7, 0xc0, 0x0,
    0x7e, 0x3e, 0x0, 0x7, 0xc3, 0xe0, 0x0, 0xfc,
    0x3f, 0x0, 0xf, 0xc1, 0xf8, 0x1, 0xf8, 0x1f,
    0xe0, 0x7f, 0x80, 0xff, 0xff, 0xf0, 0x7, 0xff,
    0xfe, 0x0, 0x3f, 0xff, 0xc0, 0x0, 0xff, 0xf0,
    0x0, 0x3, 0xfc, 0x0,

    /* U+50 "P" */
    0x1f, 0xfc, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff,
    0xe0, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xfc, 0xf8,
    0x3, 0xfc, 0xf8, 0x0, 0xfe, 0xf8, 0x0, 0x7e,
    0xf8, 0x0, 0x3f, 0xf8, 0x0, 0x3f, 0xf8, 0x0,
    0x1f, 0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8,
    0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f,
    0xf8, 0x0, 0x3e, 0xf8, 0x0, 0x3e, 0xf8, 0x0,
    0x7e, 0xf8, 0x0, 0xfc, 0xf8, 0x3, 0xf8, 0xff,
    0xff, 0xf8, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xc0,
    0xff, 0xfe, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x3f, 0xc0, 0x0, 0xf, 0xff, 0x0, 0x3,
    0xff, 0xfc, 0x0, 0x7f, 0xff, 0xe0, 0xf, 0xff,
    0xff, 0x1, 0xfe, 0x7, 0xf0, 0x1f, 0x80, 0x1f,
    0x83, 0xf0, 0x0, 0xfc, 0x3e, 0x0, 0xf, 0xc3,
    0xe0, 0x0, 0x7c, 0x7c, 0x0, 0x7, 0xe7, 0xc0,
    0x0, 0x3e, 0x7c, 0x0, 0x3, 0xe7, 0xc0, 0x0,
    0x3e, 0xf8, 0x0, 0x3, 0xff, 0x80, 0x0, 0x1f,
    0xf8, 0x0, 0x1, 0xff, 0x80, 0x0, 0x1f, 0xf8,
    0x0, 0x1, 0xff, 0x80, 0x0, 0x1f, 0xf8, 0x0,
    0x1, 0xff, 0x80, 0x0, 0x1f, 0xf8, 0x0, 0x1,
    0xff, 0x80, 0x0, 0x1f, 0xf8, 0x0, 0x1, 0xff,
    0x80, 0x0, 0x3f, 0xfc, 0x0, 0x3, 0xe7, 0xc0,
    0x0, 0x3e, 0x7c, 0x0, 0x3, 0xe7, 0xc0, 0x0,
    0x7e, 0x7e, 0x0, 0x7, 0xc3, 0xe0, 0x0, 0xfc,
    0x3f, 0x0, 0xf, 0xc1, 0xf8, 0x1, 0xf8, 0x1f,
    0xe0, 0x7f, 0x80, 0xff, 0xff, 0xf0, 0x7, 0xff,
    0xfe, 0x0, 0x3f, 0xff, 0xc0, 0x1, 0xff, 0xf0,
    0x0, 0x3, 0xfc, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x1, 0xf8, 0x0, 0x0, 0xf, 0xc0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x7, 0xfe, 0x0, 0x0, 0x3f,
    0xfc, 0x0, 0x1, 0xff, 0xc0, 0x0, 0x7, 0xf8,
    0x0, 0x0, 0x1f, 0x80, 0x0, 0x0, 0x38,

    /* U+52 "R" */
    0x1f, 0xfc, 0x0, 0x3f, 0xff, 0xf0, 0xf, 0xff,
    0xfe, 0x3, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xfc,
    0x3e, 0x0, 0xff, 0xf, 0x80, 0xf, 0xe3, 0xe0,
    0x1, 0xf8, 0xf8, 0x0, 0x3f, 0x3e, 0x0, 0x7,
    0xcf, 0x80, 0x1, 0xf3, 0xe0, 0x0, 0x7c, 0xf8,
    0x0, 0x1f, 0x3e, 0x0, 0x7, 0xcf, 0x80, 0x1,
    0xf3, 0xe0, 0x0, 0x7c, 0xf8, 0x0, 0x3e, 0x3e,
    0x0, 0x1f, 0x8f, 0x80, 0xf, 0xc3, 0xe0, 0xf,
    0xe0, 0xff, 0xff, 0xf0, 0x3f, 0xff, 0xf8, 0xf,
    0xff, 0xfc, 0x3, 0xff, 0xff, 0x0, 0xf8, 0xf,
    0xc0, 0x3e, 0x1, 0xf8, 0xf, 0x80, 0x3e, 0x3,
    0xe0, 0xf, 0xc0, 0xf8, 0x1, 0xf0, 0x3e, 0x0,
    0x7e, 0xf, 0x80, 0xf, 0xc3, 0xe0, 0x3, 0xf0,
    0xf8, 0x0, 0x7e, 0x3e, 0x0, 0x1f, 0x8f, 0x80,
    0x3, 0xf3, 0xe0, 0x0, 0xfc, 0xf8, 0x0, 0x1f,
    0x3e, 0x0, 0x7, 0xef, 0x80, 0x0, 0xfb, 0xe0,
    0x0, 0x3f,

    /* U+53 "S" */
    0x0, 0x3f, 0xc0, 0x0, 0xff, 0xfe, 0x1, 0xff,
    0xff, 0xc1, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xe1,
    0xfe, 0x1, 0xf0, 0xfc, 0x0, 0x10, 0xfc, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x7, 0xe0, 0x0,
    0x3, 0xf0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x7f,
    0x80, 0x0, 0x1f, 0xf0, 0x0, 0x7, 0xfe, 0x0,
    0x1, 0xff, 0xe0, 0x0, 0x7f, 0xfc, 0x0, 0xf,
    0xff, 0x0, 0x1, 0xff, 0xe0, 0x0, 0x1f, 0xf8,
    0x0, 0x3, 0xfc, 0x0, 0x0, 0x7f, 0x0, 0x0,
    0x1f, 0x80, 0x0, 0x7, 0xe0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x1f, 0x40, 0x0, 0x1f, 0xb8,
    0x0, 0x1f, 0x9f, 0x80, 0x3f, 0xdf, 0xff, 0xff,
    0xcf, 0xff, 0xff, 0xc3, 0xff, 0xff, 0xc0, 0x7f,
    0xff, 0x80, 0x7, 0xff, 0x0,

    /* U+54 "T" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x1, 0xf0,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x1, 0xf0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x7, 0xc0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0xf, 0x80, 0x0, 0x1,
    0xf0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x3, 0xe0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0xf8, 0x0,

    /* U+55 "U" */
    0xf8, 0x0, 0x7, 0xfe, 0x0, 0x1, 0xff, 0x80,
    0x0, 0x7f, 0xe0, 0x0, 0x1f, 0xf8, 0x0, 0x7,
    0xfe, 0x0, 0x1, 0xff, 0x80, 0x0, 0x7f, 0xe0,
    0x0, 0x1f, 0xf8, 0x0, 0x7, 0xfe, 0x0, 0x1,
    0xff, 0x80, 0x0, 0x7f, 0xe0, 0x0, 0x1f, 0xf8,
    0x0, 0x7, 0xfe, 0x0, 0x1, 0xff, 0x80, 0x0,
    0x7f, 0xe0, 0x0, 0x1f, 0xf8, 0x0, 0x7, 0xfe,
    0x0, 0x1, 0xff, 0x80, 0x0, 0x7f, 0xe0, 0x0,
    0x1f, 0xf8, 0x0, 0x7, 0xfe, 0x0, 0x1, 0xff,
    0x80, 0x0, 0x7f, 0xe0, 0x0, 0x1f, 0xf8, 0x0,
    0x7, 0xfe, 0x0, 0x1, 0xff, 0x80, 0x0, 0x7f,
    0xe0, 0x0, 0x1f, 0xf8, 0x0, 0x7, 0xff, 0x0,
    0x3, 0xff, 0xc0, 0x0, 0xfd, 0xf0, 0x0, 0x3e,
    0x7e, 0x0, 0x1f, 0x9f, 0xc0, 0xf, 0xe3, 0xfc,
    0xf, 0xf0, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xfe,
    0x3, 0xff, 0xff, 0x0, 0x3f, 0xff, 0x0, 0x1,
    0xfe, 0x0,

    /* U+56 "V" */
    0xf8, 0x0, 0x0, 0x7f, 0xf0, 0x0, 0x3, 0xf7,
    0xc0, 0x0, 0xf, 0x9f, 0x0, 0x0, 0x3e, 0x7c,
    0x0, 0x0, 0xf9, 0xf0, 0x0, 0x7, 0xe3, 0xe0,
    0x0, 0x1f, 0xf, 0x80, 0x0, 0x7c, 0x3e, 0x0,
    0x1, 0xf0, 0xfc, 0x0, 0xf, 0xc1, 0xf0, 0x0,
    0x3e, 0x7, 0xc0, 0x0, 0xf8, 0x1f, 0x0, 0x3,
    0xe0, 0x7e, 0x0, 0x1f, 0x80, 0xf8, 0x0, 0x7c,
    0x3, 0xe0, 0x1, 0xf0, 0xf, 0x80, 0xf, 0xc0,
    0x1f, 0x0, 0x3e, 0x0, 0x7c, 0x0, 0xf8, 0x1,
    0xf0, 0x3, 0xe0, 0x3, 0xe0, 0x1f, 0x80, 0xf,
    0x80, 0x7c, 0x0, 0x3e, 0x1, 0xf0, 0x0, 0xfc,
    0xf, 0xc0, 0x1, 0xf0, 0x3e, 0x0, 0x7, 0xc0,
    0xf8, 0x0, 0x1f, 0x87, 0xe0, 0x0, 0x3e, 0x1f,
    0x0, 0x0, 0xf8, 0x7c, 0x0, 0x3, 0xf3, 0xf0,
    0x0, 0x7, 0xcf, 0x80, 0x0, 0x1f, 0x3e, 0x0,
    0x0, 0x7f, 0xf8, 0x0, 0x0, 0xff, 0xc0, 0x0,
    0x3, 0xff, 0x0, 0x0, 0xf, 0xfc, 0x0, 0x0,
    0x1f, 0xe0, 0x0, 0x0, 0x7f, 0x80, 0x0, 0x1,
    0xfe, 0x0, 0x0, 0x3, 0xf0, 0x0,

    /* U+57 "W" */
    0xf8, 0x0, 0x1, 0xf7, 0xc0, 0x0, 0xf, 0xbe,
    0x0, 0x0, 0x7d, 0xf0, 0x0, 0x3, 0xef, 0x80,
    0x0, 0x1f, 0x7c, 0x0, 0x0, 0xfb, 0xe0, 0x0,
    0x7, 0xdf, 0x0, 0x0, 0x3e, 0xf8, 0x0, 0x1,
    0xf7, 0xc0, 0x0, 0xf, 0xbe, 0x0, 0x0, 0x7d,
    0xf0, 0x0, 0x3, 0xef, 0x80, 0x0, 0x1f, 0x7c,
    0x0, 0x0, 0xfb, 0xe0, 0x0, 0x7, 0xdf, 0x1,
    0xe0, 0x3e, 0xfc, 0x1f, 0x81, 0xf7, 0xe0, 0xfc,
    0xf, 0xbf, 0x7, 0xe0, 0xfc, 0xf8, 0x7f, 0x87,
    0xc7, 0xc3, 0xfc, 0x3e, 0x3e, 0x1f, 0xe1, 0xf1,
    0xf1, 0xe7, 0x8f, 0x8f, 0x8f, 0x3c, 0x7c, 0x7c,
    0x79, 0xe3, 0xe3, 0xe7, 0x87, 0x9f, 0x1f, 0x3c,
    0x3c, 0xf8, 0xf9, 0xe1, 0xe7, 0xc7, 0xde, 0x7,
    0xbe, 0x3e, 0xf0, 0x3d, 0xf1, 0xf7, 0x81, 0xef,
    0x8f, 0xbc, 0xf, 0xfc, 0x7f, 0xc0, 0x3f, 0xe3,
    0xfe, 0x1, 0xff, 0x1f, 0xf0, 0xf, 0xf8, 0x7f,
    0x0, 0x3f, 0x83, 0xf8, 0x1, 0xfc, 0x1f, 0xc0,
    0xf, 0xe0, 0xfe, 0x0, 0x3f, 0x7, 0xe0, 0x1,
    0xf8,

    /* U+58 "X" */
    0x7e, 0x0, 0x7, 0xe3, 0xe0, 0x0, 0xfc, 0x3f,
    0x0, 0xf, 0xc1, 0xf0, 0x1, 0xf8, 0x1f, 0x80,
    0x1f, 0x80, 0xf8, 0x3, 0xf0, 0xf, 0xc0, 0x3e,
    0x0, 0x7c, 0x3, 0xe0, 0x3, 0xe0, 0x7c, 0x0,
    0x3e, 0x7, 0xc0, 0x1, 0xf0, 0xf8, 0x0, 0x1f,
    0xf, 0x80, 0x0, 0xf9, 0xf0, 0x0, 0xf, 0x9f,
    0x0, 0x0, 0x7b, 0xe0, 0x0, 0x7, 0xfe, 0x0,
    0x0, 0x3f, 0xc0, 0x0, 0x3, 0xf8, 0x0, 0x0,
    0x1f, 0x80, 0x0, 0x1, 0xf8, 0x0, 0x0, 0x3f,
    0xc0, 0x0, 0x3, 0xfc, 0x0, 0x0, 0x7f, 0xe0,
    0x0, 0xf, 0xbf, 0x0, 0x0, 0xf9, 0xf0, 0x0,
    0x1f, 0xf, 0x80, 0x1, 0xf0, 0xf8, 0x0, 0x3e,
    0x7, 0xc0, 0x3, 0xc0, 0x7c, 0x0, 0x7c, 0x3,
    0xe0, 0x7, 0x80, 0x1e, 0x0, 0xf8, 0x1, 0xf0,
    0xf, 0x0, 0xf, 0x1, 0xf0, 0x0, 0xf8, 0x1e,
    0x0, 0x7, 0x83, 0xe0, 0x0, 0x7c, 0x3c, 0x0,
    0x3, 0xc7, 0xc0, 0x0, 0x3e, 0x78, 0x0, 0x1,
    0xef, 0x80, 0x0, 0x1f,

    /* U+59 "Y" */
    0xfc, 0x0, 0x0, 0x7e, 0xf8, 0x0, 0x0, 0xf9,
    0xf8, 0x0, 0x3, 0xf3, 0xf0, 0x0, 0x7, 0xe3,
    0xf0, 0x0, 0xf, 0x87, 0xe0, 0x0, 0x3f, 0x7,
    0xe0, 0x0, 0x7c, 0xf, 0xc0, 0x1, 0xf8, 0xf,
    0xc0, 0x3, 0xe0, 0x1f, 0x80, 0xf, 0xc0, 0x1f,
    0x80, 0x1f, 0x0, 0x3f, 0x0, 0x7e, 0x0, 0x3f,
    0x0, 0xf8, 0x0, 0x7e, 0x3, 0xf0, 0x0, 0x7e,
    0x7, 0xc0, 0x0, 0xfc, 0x1f, 0x80, 0x0, 0xfc,
    0x3e, 0x0, 0x1, 0xfc, 0xf8, 0x0, 0x1, 0xf9,
    0xf0, 0x0, 0x1, 0xff, 0xc0, 0x0, 0x3, 0xff,
    0x80, 0x0, 0x3, 0xfe, 0x0, 0x0, 0x7, 0xfc,
    0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x3, 0xe0, 0x0,

    /* U+5A "Z" */
    0x7f, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xf9, 0xff,
    0xff, 0xff, 0x3f, 0xff, 0xff, 0xe0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x3f, 0x0, 0x0, 0xf, 0xc0,
    0x0, 0x3, 0xf0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x1f, 0x80, 0x0, 0x7, 0xe0, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0x7, 0xe0, 0x0,
    0x1, 0xf8, 0x0, 0x0, 0x7e, 0x0, 0x0, 0xf,
    0xc0, 0x0, 0x3, 0xf0, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x7, 0xe0, 0x0, 0x0,
    0xfc, 0x0, 0x0, 0x3f, 0x0, 0x0, 0xf, 0xc0,
    0x0, 0x1, 0xf8, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0xf, 0xc0, 0x0, 0x3, 0xf0, 0x0, 0x0, 0xfe,
    0x0, 0x0, 0x1f, 0x80, 0x0, 0x7, 0xe0, 0x0,
    0x0, 0xfc, 0x0, 0x0, 0x3f, 0x0, 0x0, 0x7,
    0xe0, 0x0, 0x1, 0xf8, 0x0, 0x0, 0x3f, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+5B "[" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0x1f, 0x0, 0x3e, 0x0, 0x7c, 0x0, 0xf8,
    0x1, 0xf0, 0x3, 0xe0, 0x7, 0xc0, 0xf, 0x80,
    0x1f, 0x0, 0x3e, 0x0, 0x7c, 0x0, 0xf8, 0x1,
    0xf0, 0x3, 0xe0, 0x7, 0xc0, 0xf, 0x80, 0x1f,
    0x0, 0x3e, 0x0, 0x7c, 0x0, 0xf8, 0x1, 0xf0,
    0x3, 0xe0, 0x7, 0xc0, 0xf, 0x80, 0x1f, 0x0,
    0x3e, 0x0, 0x7c, 0x0, 0xf8, 0x1, 0xf0, 0x3,
    0xe0, 0x7, 0xc0, 0xf, 0x80, 0x1f, 0x0, 0x3e,
    0x0, 0x7c, 0x0, 0xf8, 0x1, 0xf0, 0x3, 0xe0,
    0x7, 0xc0, 0xf, 0x80, 0x1f, 0x0, 0x3e, 0x0,
    0x7c, 0x0, 0xf8, 0x1, 0xf0, 0x3, 0xe0, 0x7,
    0xc0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff,

    /* U+5C "\\" */
    0xf8, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0xf, 0x80,
    0x0, 0xf, 0x80, 0x0, 0xf, 0x80, 0x0, 0x7,
    0xc0, 0x0, 0x7, 0xc0, 0x0, 0x7, 0xc0, 0x0,
    0x3, 0xe0, 0x0, 0x3, 0xe0, 0x0, 0x1, 0xe0,
    0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7c,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0xf, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x7, 0x80, 0x0, 0x7, 0x80, 0x0,
    0x7, 0xc0, 0x0, 0x3, 0xc0, 0x0, 0x3, 0xc0,
    0x0, 0x3, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x1,
    0xe0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x1f, 0x0, 0x0, 0xf,

    /* U+5D "]" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x3, 0xe0, 0x7, 0xc0, 0xf, 0x80, 0x1f, 0x0,
    0x3e, 0x0, 0x7c, 0x0, 0xf8, 0x1, 0xf0, 0x3,
    0xe0, 0x7, 0xc0, 0xf, 0x80, 0x1f, 0x0, 0x3e,
    0x0, 0x7c, 0x0, 0xf8, 0x1, 0xf0, 0x3, 0xe0,
    0x7, 0xc0, 0xf, 0x80, 0x1f, 0x0, 0x3e, 0x0,
    0x7c, 0x0, 0xf8, 0x1, 0xf0, 0x3, 0xe0, 0x7,
    0xc0, 0xf, 0x80, 0x1f, 0x0, 0x3e, 0x0, 0x7c,
    0x0, 0xf8, 0x1, 0xf0, 0x3, 0xe0, 0x7, 0xc0,
    0xf, 0x80, 0x1f, 0x0, 0x3e, 0x0, 0x7c, 0x0,
    0xf8, 0x1, 0xf0, 0x3, 0xe0, 0x7, 0xc0, 0xf,
    0x80, 0x1f, 0x0, 0x3e, 0x0, 0x7c, 0x0, 0xf8,
    0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff,

    /* U+5E "^" */
    0x0, 0x1f, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x0,
    0xfe, 0x0, 0x0, 0x3f, 0xe0, 0x0, 0x7, 0xfc,
    0x0, 0x1, 0xff, 0xc0, 0x0, 0x7e, 0xfc, 0x0,
    0xf, 0x8f, 0x80, 0x3, 0xf1, 0xf8, 0x0, 0x7c,
    0x1f, 0x0, 0x1f, 0x83, 0xf0, 0x3, 0xe0, 0x3e,
    0x0, 0xfc, 0x7, 0xe0, 0x3f, 0x0, 0x7e, 0x7,
    0xc0, 0x7, 0xc1, 0xf8, 0x0, 0xfc, 0x3e, 0x0,
    0xf, 0x8f, 0xc0, 0x1, 0xf9, 0xf0, 0x0, 0x1f,
    0x7c, 0x0, 0x1, 0xf7, 0x80, 0x0, 0x3c, 0x20,
    0x0, 0x2, 0x0,

    /* U+5F "_" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+60 "`" */
    0x10, 0x7, 0x1, 0xf0, 0x7e, 0x7, 0xe0, 0x7e,
    0x7, 0xe0, 0x7e, 0x3, 0xe0, 0x38, 0x2, 0x0,

    /* U+61 "a" */
    0x1, 0xff, 0x0, 0x1f, 0xff, 0xe0, 0x1f, 0xff,
    0xf8, 0x1f, 0xff, 0xfc, 0x1f, 0xff, 0xfe, 0xc,
    0x1, 0xfe, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x3f,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x1f, 0x0, 0xff, 0x9f, 0x7,
    0xff, 0xff, 0x1f, 0xff, 0xff, 0x3f, 0xff, 0xff,
    0x7f, 0x80, 0x3f, 0x7e, 0x0, 0x1f, 0xfc, 0x0,
    0x1f, 0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8,
    0x0, 0x1f, 0xfc, 0x0, 0x1f, 0xfc, 0x0, 0x1f,
    0x7f, 0x80, 0x1f, 0x7f, 0xff, 0xff, 0x3f, 0xff,
    0xff, 0x1f, 0xff, 0xff, 0x7, 0xff, 0xff, 0x0,
    0xff, 0xf0,

    /* U+62 "b" */
    0x18, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0xf8, 0xfe, 0x0, 0xfb, 0xff, 0x80,
    0xff, 0xff, 0xe0, 0xff, 0xff, 0xf0, 0xff, 0xff,
    0xf8, 0xff, 0x3, 0xfc, 0xfc, 0x0, 0xfc, 0xf8,
    0x0, 0x7e, 0xf8, 0x0, 0x7e, 0xf8, 0x0, 0x3e,
    0xf8, 0x0, 0x3f, 0xf8, 0x0, 0x1f, 0xf8, 0x0,
    0x1f, 0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8,
    0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f,
    0xf8, 0x0, 0x3f, 0xf8, 0x0, 0x3e, 0xf8, 0x0,
    0x3e, 0xf8, 0x0, 0x7e, 0xf8, 0x0, 0xfc, 0xf8,
    0x1, 0xfc, 0xf8, 0x7, 0xf8, 0xff, 0xff, 0xf8,
    0xff, 0xff, 0xf0, 0xff, 0xff, 0xc0, 0xff, 0xff,
    0x80, 0xf, 0xfc, 0x0,

    /* U+63 "c" */
    0x0, 0xf, 0xfc, 0x0, 0x1f, 0xff, 0xf0, 0x1f,
    0xff, 0xfc, 0x1f, 0xff, 0xfe, 0xf, 0xff, 0xff,
    0x87, 0xfe, 0x0, 0xe3, 0xfc, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x7e, 0x0, 0x0, 0x1f, 0x80, 0x0,
    0x7, 0xc0, 0x0, 0x3, 0xf0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0xf, 0x80, 0x0,
    0x3, 0xe0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0xf, 0xc0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x1f, 0x80, 0x0, 0x3,
    0xf0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x1f, 0xf0,
    0x1, 0x83, 0xff, 0xff, 0xf0, 0x7f, 0xff, 0xfc,
    0xf, 0xff, 0xff, 0x0, 0xff, 0xff, 0xc0, 0x3,
    0xff, 0x0,

    /* U+64 "d" */
    0x0, 0x0, 0x3, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x1f, 0x0, 0x7f, 0x1f, 0x1, 0xff, 0xdf,
    0x7, 0xff, 0xff, 0xf, 0xff, 0xff, 0x1f, 0xff,
    0xff, 0x3f, 0xc0, 0xff, 0x3f, 0x0, 0x3f, 0x7e,
    0x0, 0x1f, 0x7e, 0x0, 0x1f, 0x7c, 0x0, 0x1f,
    0xfc, 0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8, 0x0,
    0x1f, 0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8,
    0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f,
    0xfc, 0x0, 0x1f, 0x7c, 0x0, 0x1f, 0x7c, 0x0,
    0x1f, 0x7e, 0x0, 0x1f, 0x3f, 0x0, 0x1f, 0x3f,
    0x80, 0x1f, 0x1f, 0xe0, 0x1f, 0x1f, 0xff, 0xff,
    0xf, 0xff, 0xff, 0x3, 0xff, 0xff, 0x1, 0xff,
    0xff, 0x0, 0x3f, 0xf0,

    /* U+65 "e" */
    0x0, 0x3f, 0x80, 0x0, 0x3f, 0xfc, 0x0, 0x3f,
    0xff, 0xc0, 0x1f, 0xff, 0xf8, 0xf, 0xff, 0xff,
    0x7, 0xf8, 0x3f, 0xc3, 0xf8, 0x3, 0xf8, 0xf8,
    0x0, 0x7e, 0x7e, 0x0, 0xf, 0x9f, 0x0, 0x1,
    0xf7, 0xc0, 0x0, 0x7f, 0xe0, 0x0, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0xf, 0xc0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x1f, 0x80, 0x0, 0x3,
    0xf0, 0x0, 0x0, 0xfe, 0x0, 0x0, 0x1f, 0xf0,
    0x2, 0x3, 0xff, 0xff, 0xc0, 0x7f, 0xff, 0xf0,
    0xf, 0xff, 0xfc, 0x0, 0xff, 0xff, 0x0, 0x7,
    0xfc, 0x0,

    /* U+66 "f" */
    0x0, 0x3, 0xfc, 0x0, 0x3, 0xff, 0xf8, 0x0,
    0xff, 0xff, 0x80, 0x3f, 0xff, 0xf0, 0xf, 0xff,
    0xfe, 0x3, 0xfc, 0x7, 0x80, 0x7e, 0x0, 0x10,
    0xf, 0x80, 0x0, 0x3, 0xf0, 0x0, 0x0, 0x7c,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x3f,
    0xff, 0xff, 0xc7, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0x1f, 0xff, 0xff, 0xe0, 0xf, 0x80, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x7,
    0xc0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0xf, 0x80, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x1, 0xf0, 0x0, 0x0,

    /* U+67 "g" */
    0x0, 0x3f, 0xe0, 0x1, 0xff, 0xff, 0x7, 0xff,
    0xff, 0xf, 0xff, 0xff, 0x1f, 0xff, 0xff, 0x1f,
    0xe0, 0x3f, 0x3f, 0x80, 0x1f, 0x7e, 0x0, 0x1f,
    0x7e, 0x0, 0x1f, 0x7c, 0x0, 0x1f, 0xfc, 0x0,
    0x1f, 0xfc, 0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8,
    0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f,
    0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xfc, 0x0,
    0x1f, 0x7c, 0x0, 0x1f, 0x7c, 0x0, 0x1f, 0x7e,
    0x0, 0x1f, 0x3f, 0x0, 0x1f, 0x3f, 0xc0, 0xff,
    0x1f, 0xff, 0xff, 0xf, 0xff, 0xff, 0x7, 0xff,
    0xff, 0x3, 0xff, 0xff, 0x0, 0x7f, 0x1f, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x3f,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0x7e, 0x10, 0x0,
    0xfe, 0x1e, 0x1, 0xfc, 0x3f, 0xff, 0xfc, 0x3f,
    0xff, 0xf8, 0x3f, 0xff, 0xf0, 0x1f, 0xff, 0xc0,
    0x3, 0xff, 0x0,

    /* U+68 "h" */
    0x18, 0x0, 0x1, 0xf0, 0x0, 0x3, 0xe0, 0x0,
    0x7, 0xc0, 0x0, 0xf, 0x80, 0x0, 0x1f, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xf8,
    0x0, 0x1, 0xf0, 0x0, 0x3, 0xe0, 0x0, 0x7,
    0xc0, 0x0, 0xf, 0x80, 0x0, 0x1f, 0x0, 0x0,
    0x3e, 0x7f, 0x80, 0x7f, 0xff, 0xe0, 0xff, 0xff,
    0xe1, 0xff, 0xff, 0xe3, 0xff, 0xff, 0xe7, 0xf0,
    0x3f, 0xef, 0x80, 0x1f, 0xdf, 0x0, 0x1f, 0xbe,
    0x0, 0x1f, 0xfc, 0x0, 0x3f, 0xf8, 0x0, 0x3f,
    0xf0, 0x0, 0x7f, 0xe0, 0x0, 0xff, 0xc0, 0x1,
    0xff, 0x80, 0x3, 0xff, 0x0, 0x7, 0xfe, 0x0,
    0xf, 0xfc, 0x0, 0x1f, 0xf8, 0x0, 0x3f, 0xf0,
    0x0, 0x7f, 0xe0, 0x0, 0xff, 0xc0, 0x1, 0xff,
    0x80, 0x3, 0xff, 0x0, 0x7, 0xfe, 0x0, 0xf,
    0xfc, 0x0, 0x1f, 0xf8, 0x0, 0x3f, 0xf0, 0x0,
    0x7f, 0xe0, 0x0, 0xff, 0xc0, 0x1, 0xf0,

    /* U+69 "i" */
    0x0, 0x70, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x1f,
    0xc0, 0x0, 0x7, 0xf0, 0x0, 0x1, 0xfc, 0x0,
    0x0, 0x7f, 0x0, 0x0, 0xf, 0x80, 0x0, 0x1,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0x0, 0xf, 0xff, 0xc0,
    0x3, 0xff, 0xf0, 0x0, 0xff, 0xfc, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x7, 0xc0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x7c,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x7, 0xc0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x7,
    0xc0, 0x0, 0x1, 0xf8, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0xf, 0xe0, 0x20, 0x3, 0xff, 0xfc, 0x0,
    0x7f, 0xff, 0x0, 0xf, 0xff, 0xc0, 0x1, 0xff,
    0xf0, 0x0, 0x1f, 0xe0,

    /* U+6A "j" */
    0x0, 0x3, 0x80, 0x0, 0x3e, 0x0, 0x3, 0xf8,
    0x0, 0x1f, 0xc0, 0x0, 0xfe, 0x0, 0x7, 0xf0,
    0x0, 0x1f, 0x0, 0x0, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xfc, 0x7f, 0xff, 0xe3,
    0xff, 0xff, 0x1f, 0xff, 0xf8, 0x0, 0x7, 0xc0,
    0x0, 0x3e, 0x0, 0x1, 0xf0, 0x0, 0xf, 0x80,
    0x0, 0x7c, 0x0, 0x3, 0xe0, 0x0, 0x1f, 0x0,
    0x0, 0xf8, 0x0, 0x7, 0xc0, 0x0, 0x3e, 0x0,
    0x1, 0xf0, 0x0, 0xf, 0x80, 0x0, 0x7c, 0x0,
    0x3, 0xe0, 0x0, 0x1f, 0x0, 0x0, 0xf8, 0x0,
    0x7, 0xc0, 0x0, 0x3e, 0x0, 0x1, 0xf0, 0x0,
    0xf, 0x80, 0x0, 0x7c, 0x0, 0x3, 0xe0, 0x0,
    0x1f, 0x0, 0x0, 0xf8, 0x0, 0x7, 0xc0, 0x0,
    0x3e, 0x0, 0x1, 0xf0, 0x0, 0xf, 0x80, 0x0,
    0x7c, 0x0, 0x7, 0xe4, 0x0, 0x7e, 0x7c, 0x7,
    0xf3, 0xff, 0xff, 0x3f, 0xff, 0xf9, 0xff, 0xff,
    0x83, 0xff, 0xf0, 0x3, 0xfe, 0x0,

    /* U+6B "k" */
    0x18, 0x0, 0x0, 0x3e, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0xf, 0x80, 0x0, 0x3, 0xe0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x3, 0xe0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0xf, 0x80, 0x7,
    0xfb, 0xe0, 0x3, 0xfc, 0xf8, 0x0, 0xfe, 0x3e,
    0x0, 0x7f, 0xf, 0x80, 0x3f, 0x83, 0xe0, 0x1f,
    0xc0, 0xf8, 0xf, 0xe0, 0x3e, 0xf, 0xf0, 0xf,
    0x87, 0xf8, 0x3, 0xe3, 0xfc, 0x0, 0xf9, 0xfe,
    0x0, 0x3e, 0xff, 0x0, 0xf, 0xff, 0x0, 0x3,
    0xff, 0x80, 0x0, 0xff, 0xe0, 0x0, 0x3f, 0xfc,
    0x0, 0xf, 0xbf, 0xc0, 0x3, 0xe7, 0xf8, 0x0,
    0xf8, 0x7f, 0x0, 0x3e, 0xf, 0xe0, 0xf, 0x81,
    0xfc, 0x3, 0xe0, 0x3f, 0x80, 0xf8, 0x7, 0xf0,
    0x3e, 0x0, 0xfe, 0xf, 0x80, 0x1f, 0xc3, 0xe0,
    0x3, 0xf8, 0xf8, 0x0, 0x7e, 0x3e, 0x0, 0x1f,
    0xcf, 0x80, 0x3, 0xfb, 0xe0, 0x0, 0x7f,

    /* U+6C "l" */
    0xff, 0xfc, 0x0, 0x3f, 0xff, 0x0, 0xf, 0xff,
    0xc0, 0x3, 0xff, 0xf0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x1,
    0xf0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x1, 0xf0, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x7, 0xc0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x7c,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x7, 0xc0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x7,
    0xc0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x7e, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x3, 0xf0, 0x8, 0x0,
    0xff, 0xff, 0x0, 0x1f, 0xff, 0xc0, 0x3, 0xff,
    0xf0, 0x0, 0x7f, 0xfc, 0x0, 0x7, 0xf8,

    /* U+6D "m" */
    0x1f, 0xc0, 0x7c, 0x1f, 0xff, 0x3f, 0xe3, 0xff,
    0xff, 0xfe, 0x7f, 0xff, 0xff, 0xef, 0xff, 0xff,
    0xfd, 0xf0, 0x7f, 0x1f, 0xbe, 0xf, 0xc1, 0xff,
    0xc0, 0xf8, 0x1f, 0xf8, 0x1f, 0x3, 0xff, 0x3,
    0xe0, 0x7f, 0xe0, 0x7c, 0xf, 0xfc, 0xf, 0x81,
    0xff, 0x81, 0xf0, 0x3f, 0xf0, 0x3e, 0x7, 0xfe,
    0x7, 0xc0, 0xff, 0xc0, 0xf8, 0x1f, 0xf8, 0x1f,
    0x3, 0xff, 0x3, 0xe0, 0x7f, 0xe0, 0x7c, 0xf,
    0xfc, 0x0, 0x1, 0xff, 0x80, 0x0, 0x3f, 0xf0,
    0x0, 0x7, 0xfe, 0x0, 0x0, 0xff, 0xc0, 0x0,
    0x1f, 0xf8, 0x0, 0x3, 0xff, 0x0, 0x0, 0x7f,
    0xe0, 0x0, 0xf, 0xfc, 0x0, 0x1, 0xff, 0x80,
    0x0, 0x3f, 0xf0, 0x0, 0x7, 0xc0,

    /* U+6E "n" */
    0x7, 0xfe, 0x1, 0xff, 0xff, 0x83, 0xff, 0xff,
    0x87, 0xff, 0xff, 0x8f, 0xff, 0xff, 0x9f, 0x80,
    0x7f, 0xbe, 0x0, 0x3f, 0x7c, 0x0, 0x3e, 0xf8,
    0x0, 0x7f, 0xf0, 0x0, 0xff, 0xe0, 0x0, 0xff,
    0xc0, 0x1, 0xff, 0x80, 0x3, 0xff, 0x0, 0x7,
    0xfe, 0x0, 0xf, 0xfc, 0x0, 0x1f, 0xf8, 0x0,
    0x3f, 0xf0, 0x0, 0x7f, 0xe0, 0x0, 0xff, 0xc0,
    0x1, 0xff, 0x80, 0x3, 0xff, 0x0, 0x7, 0xfe,
    0x0, 0xf, 0xfc, 0x0, 0x1f, 0xf8, 0x0, 0x3f,
    0xf0, 0x0, 0x7f, 0xe0, 0x0, 0xff, 0xc0, 0x1,
    0xff, 0x80, 0x3, 0xff, 0x0, 0x7, 0xc0,

    /* U+6F "o" */
    0x0, 0x3f, 0x0, 0x0, 0x7f, 0xf8, 0x0, 0x7f,
    0xff, 0x80, 0x3f, 0xff, 0xf0, 0x1f, 0xff, 0xfe,
    0x7, 0xf8, 0x7f, 0x83, 0xf8, 0x7, 0xf0, 0xf8,
    0x0, 0x7c, 0x7e, 0x0, 0x1f, 0x9f, 0x0, 0x3,
    0xe7, 0xc0, 0x0, 0xfb, 0xf0, 0x0, 0x3f, 0xf8,
    0x0, 0x7, 0xfe, 0x0, 0x1, 0xff, 0x80, 0x0,
    0x7f, 0xe0, 0x0, 0x1f, 0xf8, 0x0, 0x7, 0xfe,
    0x0, 0x1, 0xff, 0xc0, 0x0, 0xfd, 0xf0, 0x0,
    0x3e, 0x7c, 0x0, 0xf, 0x9f, 0x80, 0x7, 0xe3,
    0xe0, 0x1, 0xf0, 0xfe, 0x1, 0xfc, 0x1f, 0xc0,
    0xfe, 0x7, 0xff, 0xff, 0x80, 0xff, 0xff, 0xc0,
    0x1f, 0xff, 0xe0, 0x1, 0xff, 0xe0, 0x0, 0xf,
    0xc0, 0x0,

    /* U+70 "p" */
    0x7, 0xfc, 0x0, 0xff, 0xff, 0x80, 0xff, 0xff,
    0xc0, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xf8, 0xf8,
    0x7, 0xf8, 0xf8, 0x1, 0xfc, 0xf8, 0x0, 0xfc,
    0xf8, 0x0, 0x7e, 0xf8, 0x0, 0x3e, 0xf8, 0x0,
    0x3e, 0xf8, 0x0, 0x3f, 0xf8, 0x0, 0x1f, 0xf8,
    0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f,
    0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8, 0x0,
    0x1f, 0xf8, 0x0, 0x3f, 0xf8, 0x0, 0x3e, 0xf8,
    0x0, 0x7e, 0xf8, 0x0, 0x7e, 0xfc, 0x0, 0xfc,
    0xff, 0x3, 0xfc, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xf0, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xc0, 0xf8,
    0xfe, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0xf8, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x3f, 0xe0, 0x1, 0xff, 0xfe, 0x3, 0xff,
    0xff, 0xf, 0xff, 0xff, 0x1f, 0xff, 0xff, 0x1f,
    0xe0, 0x1f, 0x3f, 0x80, 0x1f, 0x3f, 0x0, 0x1f,
    0x7e, 0x0, 0x1f, 0x7c, 0x0, 0x1f, 0x7c, 0x0,
    0x1f, 0xfc, 0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8,
    0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f,
    0xf8, 0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xf8, 0x0,
    0x1f, 0xfc, 0x0, 0x1f, 0x7c, 0x0, 0x1f, 0x7e,
    0x0, 0x1f, 0x7e, 0x0, 0x1f, 0x3f, 0x0, 0x3f,
    0x3f, 0xc0, 0xff, 0x1f, 0xff, 0xff, 0xf, 0xff,
    0xff, 0x7, 0xff, 0xff, 0x1, 0xff, 0xff, 0x0,
    0x7f, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x1f,

    /* U+72 "r" */
    0x0, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x80, 0x1b,
    0xe0, 0x0, 0x1f, 0x0, 0x0, 0xf8, 0x0, 0x7,
    0xc0, 0x0, 0x3e, 0x0, 0x1, 0xf0, 0x0, 0xf,
    0x80, 0x0, 0x7c, 0x0, 0x3, 0xe0, 0x0, 0x1f,
    0x0, 0x0, 0xf8, 0x0, 0x7, 0xc0, 0x0, 0x3e,
    0x0, 0x1, 0xf0, 0x0, 0xf, 0x80, 0x0, 0x7c,
    0x0, 0x3, 0xe0, 0x0, 0x1f, 0x0, 0x0, 0xf8,
    0x0, 0x7, 0xc0, 0x0, 0x3e, 0x0, 0x1, 0xf0,
    0x0, 0xf, 0x80, 0x0, 0x7c, 0x0, 0x0,

    /* U+73 "s" */
    0x0, 0x7f, 0xe0, 0x7, 0xff, 0xfe, 0xf, 0xff,
    0xfe, 0x1f, 0xff, 0xfe, 0x3f, 0xff, 0xfe, 0x3f,
    0x80, 0x3c, 0x7e, 0x0, 0x4, 0x7c, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x7f, 0x0,
    0x0, 0x3f, 0xc0, 0x0, 0x1f, 0xfc, 0x0, 0xf,
    0xff, 0x0, 0x7, 0xff, 0xc0, 0x1, 0xff, 0xf0,
    0x0, 0x7f, 0xfc, 0x0, 0xf, 0xfe, 0x0, 0x1,
    0xfe, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x3f, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x1f, 0x60, 0x0, 0x3f,
    0x7c, 0x0, 0xfe, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xfc, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0xf0, 0x7,
    0xff, 0x80,

    /* U+74 "t" */
    0x0, 0x60, 0x0, 0x1, 0xf0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0xf, 0x80, 0x0, 0x7, 0xc0,
    0x0, 0x3, 0xe0, 0x0, 0x7f, 0xff, 0xff, 0xbf,
    0xff, 0xff, 0xdf, 0xff, 0xff, 0xef, 0xff, 0xff,
    0xf0, 0x1f, 0x0, 0x0, 0xf, 0x80, 0x0, 0x7,
    0xc0, 0x0, 0x3, 0xe0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0xf, 0x80, 0x0,
    0x7, 0xc0, 0x0, 0x3, 0xe0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x1f, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x7, 0xe0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0xfe, 0x0, 0x80, 0x7f, 0xff, 0xe0, 0x1f, 0xff,
    0xf0, 0x7, 0xff, 0xf8, 0x1, 0xff, 0xfc, 0x0,
    0x1f, 0xf0,

    /* U+75 "u" */
    0xf8, 0x0, 0x3f, 0xf0, 0x0, 0x7f, 0xe0, 0x0,
    0xff, 0xc0, 0x1, 0xff, 0x80, 0x3, 0xff, 0x0,
    0x7, 0xfe, 0x0, 0xf, 0xfc, 0x0, 0x1f, 0xf8,
    0x0, 0x3f, 0xf0, 0x0, 0x7f, 0xe0, 0x0, 0xff,
    0xc0, 0x1, 0xff, 0x80, 0x3, 0xff, 0x0, 0x7,
    0xfe, 0x0, 0xf, 0xfc, 0x0, 0x1f, 0xf8, 0x0,
    0x3f, 0xf0, 0x0, 0x7f, 0xe0, 0x0, 0xff, 0xc0,
    0x1, 0xff, 0xc0, 0x3, 0xff, 0x80, 0x7, 0xdf,
    0x80, 0xf, 0xbf, 0x80, 0x1f, 0x7f, 0x80, 0x3e,
    0x7f, 0xff, 0xfc, 0x7f, 0xff, 0xf8, 0x7f, 0xff,
    0xf0, 0x7f, 0xff, 0xe0, 0x1f, 0xfc, 0x0,

    /* U+76 "v" */
    0xfc, 0x0, 0x3, 0xff, 0xc0, 0x0, 0x3f, 0x7c,
    0x0, 0x3, 0xe7, 0xc0, 0x0, 0x3e, 0x7e, 0x0,
    0x7, 0xe3, 0xe0, 0x0, 0x7c, 0x3e, 0x0, 0x7,
    0xc3, 0xf0, 0x0, 0xfc, 0x3f, 0x0, 0xf, 0x81,
    0xf0, 0x0, 0xf8, 0x1f, 0x80, 0x1f, 0x80, 0xf8,
    0x1, 0xf0, 0xf, 0x80, 0x1f, 0x0, 0xfc, 0x3,
    0xe0, 0x7, 0xc0, 0x3e, 0x0, 0x7e, 0x7, 0xe0,
    0x7, 0xe0, 0x7c, 0x0, 0x3e, 0x7, 0xc0, 0x3,
    0xf0, 0xf8, 0x0, 0x3f, 0xf, 0x80, 0x1, 0xf9,
    0xf8, 0x0, 0x1f, 0x9f, 0x0, 0x0, 0xf9, 0xf0,
    0x0, 0xf, 0xfe, 0x0, 0x0, 0xff, 0xe0, 0x0,
    0x7, 0xfc, 0x0, 0x0, 0x7f, 0xc0, 0x0, 0x3,
    0xf8, 0x0, 0x0, 0x3f, 0x80, 0x0, 0x1, 0xf0,
    0x0,

    /* U+77 "w" */
    0xf8, 0x0, 0x0, 0x7f, 0xe0, 0x0, 0x1, 0xff,
    0x80, 0x0, 0x7, 0xfe, 0x0, 0x0, 0x1f, 0xf8,
    0x0, 0x0, 0x7d, 0xf0, 0x0, 0x3, 0xe7, 0xc0,
    0x0, 0xf, 0x9f, 0x1, 0xe0, 0x3e, 0x7c, 0x7,
    0x80, 0xf9, 0xf0, 0x1e, 0x3, 0xe7, 0xc0, 0xfc,
    0xf, 0x9f, 0x3, 0xf0, 0x3e, 0x7c, 0xf, 0xc0,
    0xf8, 0xf0, 0x7f, 0x83, 0xc3, 0xe1, 0xfe, 0x1f,
    0xf, 0x87, 0x78, 0x7c, 0x3e, 0x3c, 0xf1, 0xf0,
    0xf8, 0xf3, 0xc7, 0xc3, 0xe7, 0x8f, 0x1f, 0x7,
    0x9e, 0x1e, 0x78, 0x1e, 0x78, 0x79, 0xe0, 0x7f,
    0xc1, 0xff, 0x81, 0xff, 0x3, 0xfe, 0x7, 0xfc,
    0xf, 0xf8, 0xf, 0xe0, 0x3f, 0xc0, 0x3f, 0x80,
    0x7f, 0x0, 0xfe, 0x1, 0xfc, 0x3, 0xf0, 0x3,
    0xf0, 0xf, 0xc0, 0xf, 0xc0, 0x1e, 0x0, 0x3e,
    0x0,

    /* U+78 "x" */
    0xfe, 0x0, 0xf, 0xe7, 0xe0, 0x0, 0xfc, 0x3f,
    0x0, 0x1f, 0x81, 0xf8, 0x3, 0xf8, 0x1f, 0xc0,
    0x3f, 0x0, 0xfc, 0x7, 0xe0, 0x7, 0xe0, 0xfc,
    0x0, 0x3f, 0xf, 0xc0, 0x3, 0xf1, 0xf8, 0x0,
    0x1f, 0xbf, 0x0, 0x0, 0xff, 0xf0, 0x0, 0x7,
    0xfe, 0x0, 0x0, 0x3f, 0xc0, 0x0, 0x3, 0xfc,
    0x0, 0x0, 0x1f, 0xc0, 0x0, 0x3, 0xfc, 0x0,
    0x0, 0x7f, 0xe0, 0x0, 0xf, 0xff, 0x0, 0x0,
    0xfb, 0xf8, 0x0, 0x1f, 0x9f, 0x80, 0x3, 0xf0,
    0xfc, 0x0, 0x7e, 0xf, 0xe0, 0x7, 0xc0, 0x7e,
    0x0, 0xfc, 0x3, 0xf0, 0x1f, 0x80, 0x3f, 0x83,
    0xf0, 0x1, 0xf8, 0x3e, 0x0, 0xf, 0xc7, 0xe0,
    0x0, 0xfe, 0x7c, 0x0, 0x7, 0xef, 0x80, 0x0,
    0x7f,

    /* U+79 "y" */
    0x7e, 0x0, 0x3, 0xef, 0xc0, 0x0, 0xfc, 0xf8,
    0x0, 0x1f, 0x1f, 0x0, 0x3, 0xe3, 0xf0, 0x0,
    0x7c, 0x3e, 0x0, 0x1f, 0x87, 0xc0, 0x3, 0xe0,
    0xf8, 0x0, 0x7c, 0xf, 0x80, 0xf, 0x81, 0xf0,
    0x3, 0xf0, 0x3e, 0x0, 0x7c, 0x3, 0xe0, 0xf,
    0x80, 0x7c, 0x1, 0xf0, 0xf, 0xc0, 0x7c, 0x0,
    0xf8, 0xf, 0x80, 0x1f, 0x1, 0xf0, 0x3, 0xf0,
    0x3e, 0x0, 0x3e, 0xf, 0x80, 0x7, 0xc1, 0xf0,
    0x0, 0x7c, 0x3e, 0x0, 0xf, 0x8f, 0x80, 0x0,
    0xf9, 0xf0, 0x0, 0x1f, 0x3e, 0x0, 0x3, 0xff,
    0x80, 0x0, 0x3f, 0xf0, 0x0, 0x7, 0xfc, 0x0,
    0x0, 0x7f, 0x80, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0xfc, 0x0, 0x0, 0x1f, 0x80, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0xf, 0x80, 0x0,
    0x3, 0xe0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x7f,
    0x0, 0x7, 0xff, 0xc0, 0x1, 0xff, 0xf0, 0x0,
    0x3f, 0xfc, 0x0, 0x7, 0xff, 0x0, 0x0, 0x7f,
    0x80, 0x0, 0x0,

    /* U+7A "z" */
    0x7f, 0xff, 0xfd, 0xff, 0xff, 0xf7, 0xff, 0xff,
    0xdf, 0xff, 0xff, 0x0, 0x1, 0xf8, 0x0, 0xf,
    0xc0, 0x0, 0x3f, 0x0, 0x1, 0xf8, 0x0, 0xf,
    0xc0, 0x0, 0x7e, 0x0, 0x1, 0xf0, 0x0, 0xf,
    0xc0, 0x0, 0x7e, 0x0, 0x3, 0xf0, 0x0, 0xf,
    0x80, 0x0, 0x7e, 0x0, 0x3, 0xf0, 0x0, 0xf,
    0x80, 0x0, 0x7c, 0x0, 0x3, 0xf0, 0x0, 0xf,
    0x80, 0x0, 0x7c, 0x0, 0x3, 0xf0, 0x0, 0xf,
    0x80, 0x0, 0x7e, 0x0, 0x1, 0xf0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0,

    /* U+7B "{" */
    0x0, 0x7, 0xfc, 0x0, 0xff, 0xf0, 0x7, 0xff,
    0xc0, 0x3f, 0xff, 0x0, 0xfc, 0x0, 0x3, 0xe0,
    0x0, 0x1f, 0x80, 0x0, 0x7c, 0x0, 0x1, 0xf0,
    0x0, 0x7, 0xc0, 0x0, 0x1f, 0x0, 0x0, 0x7c,
    0x0, 0x1, 0xf0, 0x0, 0x7, 0xc0, 0x0, 0x1f,
    0x0, 0x0, 0x7c, 0x0, 0x1, 0xf0, 0x0, 0x7,
    0xc0, 0x0, 0x1f, 0x0, 0x0, 0x7c, 0x0, 0x1,
    0xf0, 0x0, 0x7, 0xc0, 0x0, 0x1f, 0x0, 0x0,
    0xf8, 0x0, 0x3, 0xe0, 0x0, 0x1f, 0x0, 0xf,
    0xfc, 0x0, 0x3f, 0xe0, 0x0, 0xff, 0x0, 0x3,
    0xff, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xf8, 0x0,
    0x3, 0xe0, 0x0, 0x7, 0xc0, 0x0, 0x1f, 0x0,
    0x0, 0x7c, 0x0, 0x1, 0xf0, 0x0, 0x7, 0xc0,
    0x0, 0x1f, 0x0, 0x0, 0x7c, 0x0, 0x1, 0xf0,
    0x0, 0x7, 0xc0, 0x0, 0x1f, 0x0, 0x0, 0x7c,
    0x0, 0x1, 0xf0, 0x0, 0x7, 0xc0, 0x0, 0x1f,
    0x0, 0x0, 0x7c, 0x0, 0x1, 0xf0, 0x0, 0x7,
    0xe0, 0x0, 0xf, 0x80, 0x0, 0x3f, 0x0, 0x0,
    0xff, 0xfc, 0x1, 0xff, 0xf0, 0x3, 0xff, 0xc0,
    0x1, 0xff,

    /* U+7C "|" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff,

    /* U+7D "}" */
    0xff, 0x80, 0x3, 0xff, 0xc0, 0xf, 0xff, 0x80,
    0x3f, 0xff, 0x0, 0x0, 0xfc, 0x0, 0x1, 0xf0,
    0x0, 0x7, 0xe0, 0x0, 0xf, 0x80, 0x0, 0x3e,
    0x0, 0x0, 0xf8, 0x0, 0x3, 0xe0, 0x0, 0xf,
    0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0, 0x3,
    0xe0, 0x0, 0xf, 0x80, 0x0, 0x3e, 0x0, 0x0,
    0xf8, 0x0, 0x3, 0xe0, 0x0, 0xf, 0x80, 0x0,
    0x3e, 0x0, 0x0, 0xf8, 0x0, 0x3, 0xe0, 0x0,
    0x7, 0xc0, 0x0, 0x1f, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0xff, 0xc0, 0x1, 0xff, 0x0, 0x3, 0xfc,
    0x0, 0x3f, 0xf0, 0x1, 0xfc, 0x0, 0x7, 0xc0,
    0x0, 0x1f, 0x0, 0x0, 0xf8, 0x0, 0x3, 0xe0,
    0x0, 0xf, 0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8,
    0x0, 0x3, 0xe0, 0x0, 0xf, 0x80, 0x0, 0x3e,
    0x0, 0x0, 0xf8, 0x0, 0x3, 0xe0, 0x0, 0xf,
    0x80, 0x0, 0x3e, 0x0, 0x0, 0xf8, 0x0, 0x3,
    0xe0, 0x0, 0xf, 0x80, 0x0, 0x3e, 0x0, 0x1,
    0xf8, 0x0, 0x7, 0xc0, 0x0, 0x3f, 0x0, 0xff,
    0xfc, 0x3, 0xff, 0xe0, 0xf, 0xff, 0x0, 0x3f,
    0xe0, 0x0,

    /* U+7E "~" */
    0x7, 0xc0, 0x1, 0x81, 0xfe, 0x0, 0x3c, 0x7f,
    0xf0, 0xf, 0x9f, 0xff, 0x1, 0xe7, 0xff, 0xf8,
    0x7c, 0xf8, 0x7f, 0xff, 0x9e, 0x3, 0xff, 0xe7,
    0xc0, 0x3f, 0xf8, 0xf0, 0x1, 0xfe, 0x6, 0x0,
    0xf, 0x80
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_h = 0, .box_w = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 512, .box_h = 0, .box_w = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 512, .box_h = 40, .box_w = 9, .ofs_x = 12, .ofs_y = 0},
    {.bitmap_index = 45, .adv_w = 512, .box_h = 16, .box_w = 16, .ofs_x = 8, .ofs_y = 27},
    {.bitmap_index = 77, .adv_w = 512, .box_h = 40, .box_w = 28, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 217, .adv_w = 512, .box_h = 50, .box_w = 26, .ofs_x = 3, .ofs_y = -6},
    {.bitmap_index = 380, .adv_w = 512, .box_h = 40, .box_w = 30, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 530, .adv_w = 512, .box_h = 40, .box_w = 28, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 670, .adv_w = 512, .box_h = 17, .box_w = 5, .ofs_x = 13, .ofs_y = 26},
    {.bitmap_index = 681, .adv_w = 512, .box_h = 56, .box_w = 17, .ofs_x = 7, .ofs_y = -11},
    {.bitmap_index = 800, .adv_w = 512, .box_h = 56, .box_w = 17, .ofs_x = 8, .ofs_y = -11},
    {.bitmap_index = 919, .adv_w = 512, .box_h = 24, .box_w = 26, .ofs_x = 3, .ofs_y = 16},
    {.bitmap_index = 997, .adv_w = 512, .box_h = 28, .box_w = 27, .ofs_x = 3, .ofs_y = 3},
    {.bitmap_index = 1092, .adv_w = 512, .box_h = 18, .box_w = 12, .ofs_x = 10, .ofs_y = -9},
    {.bitmap_index = 1119, .adv_w = 512, .box_h = 5, .box_w = 14, .ofs_x = 9, .ofs_y = 14},
    {.bitmap_index = 1128, .adv_w = 512, .box_h = 9, .box_w = 9, .ofs_x = 11, .ofs_y = 0},
    {.bitmap_index = 1139, .adv_w = 512, .box_h = 56, .box_w = 24, .ofs_x = 4, .ofs_y = -11},
    {.bitmap_index = 1307, .adv_w = 512, .box_h = 40, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 1437, .adv_w = 512, .box_h = 40, .box_w = 23, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 1552, .adv_w = 512, .box_h = 40, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 1682, .adv_w = 512, .box_h = 40, .box_w = 24, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 1802, .adv_w = 512, .box_h = 40, .box_w = 28, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1942, .adv_w = 512, .box_h = 40, .box_w = 23, .ofs_x = 5, .ofs_y = 0},
    {.bitmap_index = 2057, .adv_w = 512, .box_h = 40, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 2187, .adv_w = 512, .box_h = 40, .box_w = 25, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 2312, .adv_w = 512, .box_h = 40, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 2442, .adv_w = 512, .box_h = 40, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 2572, .adv_w = 512, .box_h = 30, .box_w = 9, .ofs_x = 11, .ofs_y = 0},
    {.bitmap_index = 2606, .adv_w = 512, .box_h = 39, .box_w = 12, .ofs_x = 8, .ofs_y = -9},
    {.bitmap_index = 2665, .adv_w = 512, .box_h = 25, .box_w = 26, .ofs_x = 3, .ofs_y = 4},
    {.bitmap_index = 2747, .adv_w = 512, .box_h = 18, .box_w = 26, .ofs_x = 3, .ofs_y = 8},
    {.bitmap_index = 2806, .adv_w = 512, .box_h = 25, .box_w = 26, .ofs_x = 3, .ofs_y = 4},
    {.bitmap_index = 2888, .adv_w = 512, .box_h = 40, .box_w = 21, .ofs_x = 5, .ofs_y = 0},
    {.bitmap_index = 2993, .adv_w = 512, .box_h = 49, .box_w = 27, .ofs_x = 3, .ofs_y = -9},
    {.bitmap_index = 3159, .adv_w = 512, .box_h = 40, .box_w = 30, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3309, .adv_w = 512, .box_h = 40, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 3439, .adv_w = 512, .box_h = 40, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 3569, .adv_w = 512, .box_h = 40, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 3699, .adv_w = 512, .box_h = 40, .box_w = 23, .ofs_x = 6, .ofs_y = 0},
    {.bitmap_index = 3814, .adv_w = 512, .box_h = 40, .box_w = 22, .ofs_x = 6, .ofs_y = 0},
    {.bitmap_index = 3924, .adv_w = 512, .box_h = 40, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 4054, .adv_w = 512, .box_h = 40, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 4184, .adv_w = 512, .box_h = 40, .box_w = 21, .ofs_x = 5, .ofs_y = 0},
    {.bitmap_index = 4289, .adv_w = 512, .box_h = 40, .box_w = 24, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 4409, .adv_w = 512, .box_h = 40, .box_w = 27, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 4544, .adv_w = 512, .box_h = 40, .box_w = 23, .ofs_x = 6, .ofs_y = 0},
    {.bitmap_index = 4659, .adv_w = 512, .box_h = 40, .box_w = 28, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4799, .adv_w = 512, .box_h = 40, .box_w = 24, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 4919, .adv_w = 512, .box_h = 40, .box_w = 28, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5059, .adv_w = 512, .box_h = 40, .box_w = 24, .ofs_x = 5, .ofs_y = 0},
    {.bitmap_index = 5179, .adv_w = 512, .box_h = 50, .box_w = 28, .ofs_x = 2, .ofs_y = -10},
    {.bitmap_index = 5354, .adv_w = 512, .box_h = 40, .box_w = 26, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 5484, .adv_w = 512, .box_h = 40, .box_w = 25, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 5609, .adv_w = 512, .box_h = 40, .box_w = 27, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5744, .adv_w = 512, .box_h = 40, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 5874, .adv_w = 512, .box_h = 40, .box_w = 30, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6024, .adv_w = 512, .box_h = 40, .box_w = 29, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 6169, .adv_w = 512, .box_h = 40, .box_w = 28, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 6309, .adv_w = 512, .box_h = 40, .box_w = 31, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6464, .adv_w = 512, .box_h = 40, .box_w = 27, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 6599, .adv_w = 512, .box_h = 56, .box_w = 15, .ofs_x = 9, .ofs_y = -11},
    {.bitmap_index = 6704, .adv_w = 512, .box_h = 56, .box_w = 24, .ofs_x = 4, .ofs_y = -11},
    {.bitmap_index = 6872, .adv_w = 512, .box_h = 56, .box_w = 15, .ofs_x = 8, .ofs_y = -11},
    {.bitmap_index = 6977, .adv_w = 512, .box_h = 22, .box_w = 27, .ofs_x = 3, .ofs_y = 18},
    {.bitmap_index = 7052, .adv_w = 512, .box_h = 4, .box_w = 30, .ofs_x = 1, .ofs_y = -10},
    {.bitmap_index = 7067, .adv_w = 512, .box_h = 11, .box_w = 11, .ofs_x = 10, .ofs_y = 33},
    {.bitmap_index = 7083, .adv_w = 512, .box_h = 30, .box_w = 24, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 7173, .adv_w = 512, .box_h = 44, .box_w = 24, .ofs_x = 5, .ofs_y = 0},
    {.bitmap_index = 7305, .adv_w = 512, .box_h = 30, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 7403, .adv_w = 512, .box_h = 44, .box_w = 24, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 7535, .adv_w = 512, .box_h = 30, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 7633, .adv_w = 512, .box_h = 44, .box_w = 27, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 7782, .adv_w = 512, .box_h = 41, .box_w = 24, .ofs_x = 3, .ofs_y = -11},
    {.bitmap_index = 7905, .adv_w = 512, .box_h = 44, .box_w = 23, .ofs_x = 5, .ofs_y = 0},
    {.bitmap_index = 8032, .adv_w = 512, .box_h = 43, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 8172, .adv_w = 512, .box_h = 54, .box_w = 21, .ofs_x = 4, .ofs_y = -11},
    {.bitmap_index = 8314, .adv_w = 512, .box_h = 44, .box_w = 26, .ofs_x = 5, .ofs_y = 0},
    {.bitmap_index = 8457, .adv_w = 512, .box_h = 44, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 8600, .adv_w = 512, .box_h = 30, .box_w = 27, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 8702, .adv_w = 512, .box_h = 30, .box_w = 23, .ofs_x = 5, .ofs_y = 0},
    {.bitmap_index = 8789, .adv_w = 512, .box_h = 30, .box_w = 26, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 8887, .adv_w = 512, .box_h = 41, .box_w = 24, .ofs_x = 5, .ofs_y = -11},
    {.bitmap_index = 9010, .adv_w = 512, .box_h = 41, .box_w = 24, .ofs_x = 3, .ofs_y = -11},
    {.bitmap_index = 9133, .adv_w = 512, .box_h = 30, .box_w = 21, .ofs_x = 7, .ofs_y = 0},
    {.bitmap_index = 9212, .adv_w = 512, .box_h = 30, .box_w = 24, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 9302, .adv_w = 512, .box_h = 39, .box_w = 25, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 9424, .adv_w = 512, .box_h = 30, .box_w = 23, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 9511, .adv_w = 512, .box_h = 30, .box_w = 28, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 9616, .adv_w = 512, .box_h = 30, .box_w = 30, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9729, .adv_w = 512, .box_h = 30, .box_w = 28, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 9834, .adv_w = 512, .box_h = 41, .box_w = 27, .ofs_x = 2, .ofs_y = -11},
    {.bitmap_index = 9973, .adv_w = 512, .box_h = 30, .box_w = 22, .ofs_x = 5, .ofs_y = 0},
    {.bitmap_index = 10056, .adv_w = 512, .box_h = 56, .box_w = 22, .ofs_x = 5, .ofs_y = -11},
    {.bitmap_index = 10210, .adv_w = 512, .box_h = 56, .box_w = 5, .ofs_x = 14, .ofs_y = -11},
    {.bitmap_index = 10245, .adv_w = 512, .box_h = 56, .box_w = 22, .ofs_x = 5, .ofs_y = -11},
    {.bitmap_index = 10399, .adv_w = 512, .box_h = 10, .box_w = 27, .ofs_x = 2, .ofs_y = 12}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY,
        .glyph_id_start = 1, .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0
    }
};



/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .cmap_num = 1,
    .bpp = 1,

    .kern_scale = 0,
    .kern_dsc = NULL,
    .kern_classes = 0,
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t Ubuntu = {
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .line_height = 56,          /*The maximum line height required by the font*/
    .base_line = 11,             /*Baseline measured from the bottom of the line*/
};

#endif /*#if UBUNTU*/

