#pragma once

// !!!!BOARD !!!
// #define LILYGO_WATCH_2020_V1
// #define LILYGO_WATCH_BLOCK
// #define LILYGO_WATCH_2019_WITH_TOUCH
// #define LILYGO_WATCH_2019_NO_TOUCH

// => Options
// #define LILYGO_WATCH_HAS_SIM800L
// #define LILYGO_WATCH_HAS_SIM868
// #define LILYGO_WATCH_HAS_NFC
// #define LILYGO_WATCH_HAS_GPRS
// #define LILYGO_WATCH_HAS_GPS
// #define LILYGO_WATCH_HAS_LORA
// #define LILYGO_WATCH_HAS_BUZZER
// #define LILYGO_WATCH_HAS_MOTOR
// #define LILYGO_WATCH_HAS_BMA423
// #define LILYGO_WATCH_HAS_MPU6050
// #define LILYGO_WATCH_HAS_MAX301XX
// #define LILYGO_WATCH_HAS_PCF8563
// #define LILYGO_WATCH_HAS_SDCARD
// #define LILYGO_WATCH_HAS_BUTTON
// #define LILYGO_WATCH_HAS_MPR121
// #define LILYGO_WATCH_HAS_BBQ_KEYBOARD
// #define LILYGO_WATCH_HAS_S76_S78G
// #define LILYGO_WATCH_LVGL
// #define LILYGO_WATCH_HAS_TOUCH
// #define LILYGO_WATCH_HAS_BACKLIGHT
// #define LILYGO_WATCH_HAS_GAMEPAD
// #define LILYGO_WATCH_HAS_AXP202
// #define LILYGO_EINK_TOUCHSCREEN
// #define LILYGO_WATCH_HAS_DISPLAY
// #define LILYGO_WATCH_HAS_IRREMOTE
// #define LILYGO_WATCH_HAS_EINK

// #define LILYGO_BLOCK_ST7796S_MODULE
// #define LILYGO_BLOCK_ILI9488_MODULE

#if defined(LILYGO_WATCH_2019_WITH_TOUCH)
#include "board/twatch2019_with_touch.h"
// Has
#define LILYGO_WATCH_HAS_TOUCH
#define LILYGO_WATCH_HAS_DISPLAY
#define LILYGO_WATCH_HAS_PCF8563
#define LILYGO_WATCH_HAS_BMA423
#define LILYGO_WATCH_HAS_AXP202
#define LILYGO_WATCH_HAS_BACKLIGHT
#define LILYGO_WATCH_HAS_BUTTON

// => Options
// #define LILYGO_WATCH_HAS_SIM800L
// #define LILYGO_WATCH_HAS_SIM868
// #define LILYGO_WATCH_HAS_NFC
// #define LILYGO_WATCH_HAS_GPRS
// #define LILYGO_WATCH_HAS_GPS
// #define LILYGO_WATCH_HAS_LORA
// #define LILYGO_WATCH_HAS_BUZZER
// #define LILYGO_WATCH_HAS_MOTOR
// #define LILYGO_WATCH_HAS_MPU6050
// #define LILYGO_WATCH_HAS_MAX301XX
// #define LILYGO_WATCH_HAS_SDCARD
// #define LILYGO_WATCH_HAS_BUTTON
// #define LILYGO_WATCH_HAS_MPR121
// #define LILYGO_WATCH_HAS_BBQ_KEYBOARD
// #define LILYGO_WATCH_HAS_S76_S78G
// #define LILYGO_WATCH_LVGL
// #define LILYGO_WATCH_HAS_BACKLIGHT
// #define LILYGO_WATCH_HAS_GAMEPAD

// Hardware not support
#undef LILYGO_EINK_TOUCHSCREEN
#undef LILYGO_WATCH_HAS_IRREMOTE

#elif defined(LILYGO_WATCH_2019_NO_TOUCH)
#include "board/twatch2019_with_not_touch.h"
// Has
#define LILYGO_WATCH_HAS_DISPLAY
#define LILYGO_WATCH_HAS_PCF8563
#define LILYGO_WATCH_HAS_BMA423
#define LILYGO_WATCH_HAS_AXP202
#define LILYGO_WATCH_HAS_BACKLIGHT
#define LILYGO_WATCH_HAS_BUTTON

// => Options
// #define LILYGO_WATCH_HAS_SIM800L
// #define LILYGO_WATCH_HAS_SIM868
// #define LILYGO_WATCH_HAS_NFC
// #define LILYGO_WATCH_HAS_GPRS
// #define LILYGO_WATCH_HAS_GPS
// #define LILYGO_WATCH_HAS_LORA
// #define LILYGO_WATCH_HAS_BUZZER
// #define LILYGO_WATCH_HAS_MOTOR
// #define LILYGO_WATCH_HAS_MPU6050
// #define LILYGO_WATCH_HAS_MAX301XX
// #define LILYGO_WATCH_HAS_SDCARD
// #define LILYGO_WATCH_HAS_MPR121
// #define LILYGO_WATCH_HAS_BBQ_KEYBOARD
// #define LILYGO_WATCH_HAS_S76_S78G
// #define LILYGO_WATCH_LVGL
// #define LILYGO_WATCH_HAS_BACKLIGHT
// #define LILYGO_WATCH_HAS_GAMEPAD

// Hardware not support
#undef LILYGO_EINK_TOUCHSCREEN
#undef LILYGO_WATCH_HAS_IRREMOTE
#undef LILYGO_WATCH_HAS_TOUCH

#elif defined(LILYGO_WATCH_2020_V1)
#include "board/twatch2020_v1.h"
// Has
#define LILYGO_WATCH_HAS_TOUCH
#define LILYGO_WATCH_HAS_DISPLAY
#define LILYGO_WATCH_HAS_BUZZER
#define LILYGO_WATCH_HAS_MOTOR
#define LILYGO_WATCH_HAS_PCF8563
#define LILYGO_WATCH_HAS_BMA423
#define LILYGO_WATCH_HAS_AXP202
#define LILYGO_WATCH_HAS_IRREMOTE
#define LILYGO_WATCH_HAS_BACKLIGHT

// Hardware not support
#undef  LILYGO_WATCH_HAS_NFC
#undef  LILYGO_WATCH_HAS_GPRS
#undef  LILYGO_WATCH_HAS_GPS
#undef  LILYGO_WATCH_HAS_LORA
#undef  LILYGO_WATCH_HAS_MPU6050
#undef  LILYGO_WATCH_HAS_MAX301XX
#undef  LILYGO_WATCH_HAS_SDCARD
#undef  LILYGO_WATCH_HAS_BUTTON
#undef  LILYGO_WATCH_HAS_MPR121
#undef  LILYGO_WATCH_HAS_BBQ_KEYBOARD
#undef  LILYGO_WATCH_HAS_S76_S78G
#undef  LILYGO_WATCH_HAS_SIM800L
#undef  LILYGO_WATCH_HAS_SIM868

#elif defined(LILYGO_WATCH_2020_V2)
#include "board/twatch2020_v2.h"

#if defined(BOARD_HAS_PSRAM)
#error  "The version you choose is Twatch 2020 V2, this version is not configured with PSRAM, please select Disable in the PSRAM enable tab in Arduino IDE"
#endif

// Has
#define LILYGO_WATCH_HAS_TOUCH
#define LILYGO_WATCH_HAS_DISPLAY
// #define LILYGO_WATCH_HAS_BUZZER
// #define LILYGO_WATCH_HAS_MOTOR
#define LILYGO_WATCH_HAS_PCF8563
#define LILYGO_WATCH_HAS_BMA423
#define LILYGO_WATCH_HAS_AXP202
#define LILYGO_WATCH_HAS_IRREMOTE
#define LILYGO_WATCH_HAS_BACKLIGHT
#define LILYGO_WATCH_HAS_GPS

// Hardware not support
#undef  LILYGO_WATCH_HAS_NFC
#undef  LILYGO_WATCH_HAS_GPRS
// #undef  LILYGO_WATCH_HAS_GPS
#undef  LILYGO_WATCH_HAS_LORA
#undef  LILYGO_WATCH_HAS_MPU6050
#undef  LILYGO_WATCH_HAS_MAX301XX
#undef  LILYGO_WATCH_HAS_SDCARD
#undef  LILYGO_WATCH_HAS_BUTTON
#undef  LILYGO_WATCH_HAS_MPR121
#undef  LILYGO_WATCH_HAS_BBQ_KEYBOARD
#undef  LILYGO_WATCH_HAS_S76_S78G
#undef  LILYGO_WATCH_HAS_SIM800L
#undef  LILYGO_WATCH_HAS_SIM868


#elif defined(LILYGO_WATCH_BLOCK)
#include "board/twatch_block.h"

#define LILYGO_WATCH_HAS_PCF8563
#define LILYGO_WATCH_HAS_AXP202
#define LILYGO_WATCH_HAS_BUTTON
#define LILYGO_WATCH_HAS_MPU6050

// => Options
// #define LILYGO_WATCH_HAS_SIM800L
// #define LILYGO_WATCH_HAS_SIM868
// #define LILYGO_WATCH_HAS_NFC
// #define LILYGO_WATCH_HAS_GPRS
// #define LILYGO_WATCH_HAS_GPS
// #define LILYGO_WATCH_HAS_LORA
// #define LILYGO_WATCH_HAS_BUZZER
// #define LILYGO_WATCH_HAS_MOTOR
// #define LILYGO_WATCH_HAS_MPU6050
// #define LILYGO_WATCH_HAS_MAX301XX
// #define LILYGO_WATCH_HAS_SDCARD
// #define LILYGO_WATCH_HAS_MPR121
// #define LILYGO_WATCH_HAS_BBQ_KEYBOARD
// #define LILYGO_WATCH_HAS_S76_S78G
// #define LILYGO_WATCH_HAS_BACKLIGHT
// #define LILYGO_WATCH_HAS_GAMEPAD
// #define LILYGO_EINK_TOUCHSCREEN
// #define LILYGO_BLOCK_ST7796S_MODULE
// #define LILYGO_BLOCK_ILI9488_MODULE

#if defined(LILYGO_BLOCK_ST7796S_MODULE) || defined(LILYGO_BLOCK_ILI9488_MODULE) || defined(LILYGO_BLOCK_ILI9481_MODULE)

#define LILYGO_WATCH_HAS_TOUCH
#define LILYGO_WATCH_HAS_DISPLAY
#define LILYGO_WATCH_HAS_BACKLIGHT
#define LILYGO_TOUCHSCREEN_CALLBACK_METHOD

#elif defined(LILYGO_EINK_GDEW0371W7) || defined(LILYGO_EINK_GDEH0154D67_TP)
#define LILYGO_WATCH_HAS_EINK
#define LILYGO_WATCH_HAS_TOUCH
#define LILYGO_TOUCHSCREEN_CALLBACK_METHOD

#elif defined(LILYGO_EINK_GDEH0154D67_BL)
#define LILYGO_WATCH_HAS_EINK
#define LILYGO_WATCH_HAS_BACKLIGHT
#else

#undef LILYGO_WATCH_HAS_TOUCH
#undef LILYGO_WATCH_HAS_DISPLAY

#endif


#if defined(LILYGO_BLOCK_ILI9481_MODULE)
#define LILYGO_TOUCH_DRIVER_GTXXX
#else
#define LILYGO_TOUCH_DRIVER_FTXXX
#endif  /*LILYGO_BLOCK_ILI9481_MODULE*/


// Hardware not support
// #undef LILYGO_WATCH_LVGL
#undef LILYGO_WATCH_HAS_IRREMOTE
#undef LILYGO_WATCH_HAS_BMA423

#elif defined(LILYGO_LILYPI_V1)

#include "board/lilypi_v1.h"

#define LILYGO_WATCH_HAS_PCF8563
#define LILYGO_WATCH_HAS_ADC
#define LILYGO_WATCH_HAS_SDCARD

#if     defined(LILYGO_EINK_GDEW0371W7)
#define LILYGO_WATCH_HAS_EINK
#define LILYGO_WATCH_HAS_TOUCH
#define LILYGO_TOUCHSCREEN_CALLBACK_METHOD

#elif   defined(LILYGO_BLOCK_ST7796S_MODULE) || defined(LILYGO_BLOCK_ILI9481_MODULE)
#define LILYGO_WATCH_HAS_TOUCH
#define LILYGO_WATCH_HAS_DISPLAY
#define LILYGO_WATCH_HAS_BACKLIGHT
#define LILYGO_TOUCHSCREEN_CALLBACK_METHOD

#endif  /*LILYGO_EINK_GDEW0371W7*/

#if defined(LILYGO_BLOCK_ILI9481_MODULE)
#define LILYGO_TOUCH_DRIVER_GTXXX
#else
#define LILYGO_TOUCH_DRIVER_FTXXX
#endif  /*LILYGO_BLOCK_ILI9481_MODULE*/


#else

#error "Please define Watch model"
#endif

#include "TTGO.h"

