#include <lvgl/lvgl.h>

/*******************************************************************************
 * Size: 32 px
 * Bpp: 3
 * Opts: --font ../font/EUROSTARBLACKEXTENDED.TTF -r 0x20-0x7F --size 32 --format lvgl --bpp 3 --lv-include lvgl/lvgl.h  -o fn1_32.c
 ******************************************************************************/

#ifndef FN1_32
#define FN1_32 1
#endif

#if FN1_32

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x1f, 0xf9, 0x1, 0xf3, 0x3, 0xf8, 0x81, 0xff,
    0xc9, 0x20, 0x7f, 0xf1, 0x58, 0x1f, 0xfd, 0x39,
    0x3a, 0x80, 0x2d, 0xe4, 0x7, 0xfa, 0xdf, 0x10,
    0x97, 0x80, 0xff, 0xea, 0x80,

    /* U+22 "\"" */
    0xff, 0x31, 0xfe, 0x24, 0x4, 0x40, 0xf3, 0x2,
    0x60, 0x71, 0x3, 0xc4, 0xc, 0x40, 0x88, 0x60,
    0x6e, 0x7, 0xe2, 0x7, 0xc4, 0x3, 0x4, 0x1,
    0x1, 0xc0, 0xca, 0x48, 0x2, 0x92, 0x0,

    /* U+23 "#" */
    0x3, 0x9f, 0xf3, 0x1, 0x3f, 0x98, 0x1f, 0x70,
    0x22, 0x0, 0x81, 0x10, 0x3e, 0x20, 0x4c, 0x3,
    0x2, 0x40, 0x7c, 0x80, 0x88, 0x2, 0x7, 0xff,
    0x8, 0x80, 0x20, 0x44, 0xc, 0x5b, 0x80, 0xcd,
    0xa8, 0x19, 0xb2, 0x16, 0x48, 0x8, 0xc8, 0x60,
    0x46, 0x47, 0x8, 0xf, 0xfe, 0x21, 0x4, 0xf,
    0xfe, 0x27, 0x1f, 0xc4, 0xb, 0xf8, 0xd, 0xfc,
    0xc0, 0xc4, 0xf, 0xe2, 0x6, 0x2d, 0xc0, 0x45,
    0xb4, 0x3, 0x36, 0x42, 0xc9, 0x1, 0x19, 0xc,
    0x8, 0xc9, 0x4, 0x7, 0xff, 0x11, 0x82, 0x7,
    0xff, 0x13, 0xf, 0xe2, 0x5, 0xfc, 0x6, 0xfe,
    0x60, 0x62, 0x7, 0xf1, 0x3, 0xfe, 0x40, 0x10,
    0x13, 0x3, 0xe4, 0x4, 0x40, 0x10, 0x22, 0x7,
    0xc4, 0xb, 0x80, 0xe0, 0x5c, 0xf, 0xb8, 0x11,
    0x0, 0x80, 0x90, 0x1c,

    /* U+24 "$" */
    0x3, 0xff, 0x80, 0x76, 0x30, 0x3f, 0xf9, 0xac,
    0x97, 0x3, 0xff, 0x89, 0x37, 0xff, 0x50, 0xf,
    0xff, 0x6c, 0x84, 0xc, 0x7b, 0x20, 0x7f, 0xf1,
    0x49, 0x3d, 0x0, 0xb8, 0x1f, 0xfc, 0xc6, 0x81,
    0x20, 0x3f, 0xf9, 0xb8, 0x20, 0x39, 0x5d, 0xb4,
    0x0, 0xb6, 0xd5, 0x81, 0xc8, 0xf, 0xaa, 0x27,
    0x80, 0x13, 0xca, 0x20, 0x3d, 0xc0, 0xff, 0xe4,
    0xdf, 0xf6, 0x1c, 0xe, 0x80, 0x7f, 0xf2, 0x90,
    0x1c, 0xff, 0xea, 0x1, 0xff, 0xed, 0x91, 0x1,
    0x12, 0x3, 0xff, 0x90, 0x49, 0xda, 0x2, 0xe0,
    0x7f, 0xf3, 0x15, 0x0, 0x7c, 0x44, 0xf, 0xfe,
    0x4a, 0x3, 0x3b, 0xbf, 0xf5, 0x0, 0xff, 0xec,
    0x40, 0xe2, 0x97, 0x10, 0x3f, 0xf8, 0x67, 0x81,
    0xce, 0xde, 0x40, 0x7f, 0xf4, 0x28, 0x1f, 0xfc,
    0x44, 0x7, 0x88, 0x18, 0xe8, 0xd9, 0x26, 0x0,
    0x52, 0xce, 0x40, 0x1c, 0xd0, 0x1c, 0x5c, 0x8b,
    0x4c, 0x2, 0xb7, 0x46, 0x7, 0x8d, 0x3, 0xff,
    0x9c, 0xc1, 0xc4, 0xf, 0xfe, 0x5a, 0x80, 0xe,
    0xad, 0x10, 0x3f, 0xf8, 0x85, 0xda, 0x3, 0x94,
    0xbb, 0xfe, 0xa0, 0x1f, 0xff, 0x68, 0x80, 0xff,
    0xea, 0x0,

    /* U+25 "%" */
    0x6, 0x6f, 0xfd, 0xaa, 0x3, 0xfd, 0x7f, 0x20,
    0x3c, 0x73, 0x20, 0x78, 0xaa, 0x80, 0xfc, 0xd0,
    0x88, 0xf, 0x50, 0x22, 0x9b, 0x90, 0x17, 0x3,
    0xe5, 0x3, 0x60, 0x3e, 0x40, 0xe, 0xb2, 0x55,
    0x80, 0x60, 0x78, 0xd0, 0xa0, 0x1f, 0xf2, 0x3,
    0xdc, 0x1, 0x3, 0xd8, 0x1a, 0x7, 0xff, 0x43,
    0x0, 0xe0, 0x7f, 0xf0, 0x48, 0x1f, 0xfc, 0x2a,
    0x46, 0x20, 0x7f, 0xf0, 0x51, 0x3, 0x1a, 0x0,
    0x81, 0x44, 0x21, 0x3, 0xfe, 0x40, 0x5b, 0xfd,
    0x88, 0x4, 0x1, 0xb0, 0x6c, 0x7, 0xff, 0x2,
    0x10, 0x3f, 0xe8, 0x14, 0xa, 0x1, 0xff, 0xc2,
    0xd1, 0xa5, 0xe7, 0x38, 0x34, 0x1a, 0x1, 0x39,
    0x3c, 0xc8, 0x19, 0xcb, 0x7d, 0x18, 0xe, 0x3,
    0x3, 0xec, 0x6f, 0xd3, 0x40, 0x3f, 0xf8, 0x58,
    0x8c, 0x3, 0x81, 0xff, 0x32, 0x7, 0xff, 0x2,
    0x91, 0x48, 0x2, 0x1, 0x6f, 0xf5, 0x2, 0x40,
    0x7f, 0xcd, 0x8, 0x80, 0x10, 0x2e, 0x40, 0xc8,
    0x80, 0xe0, 0x7f, 0x94, 0xd, 0x80, 0xf9, 0x81,
    0xff, 0xc7, 0x34, 0x28, 0x7, 0xff, 0x43, 0x3,
    0x40, 0xfe, 0x40, 0x78, 0x81, 0xff, 0x60, 0x1c,
    0xf, 0x10, 0x29, 0x6f, 0x70, 0x2c, 0x7, 0xd4,
    0x8a, 0x40, 0xf9, 0x81, 0x25, 0xc0, 0x45, 0x1,
    0xe8, 0x84, 0x40, 0x7e, 0x8c, 0x81, 0xf1, 0x7c,
    0x0,

    /* U+26 "&" */
    0x3, 0x19, 0x77, 0xff, 0xed, 0x62, 0x3, 0xff,
    0x80, 0xb3, 0x44, 0xf, 0xf1, 0x4e, 0xf2, 0x7,
    0xfa, 0x1, 0xff, 0xc7, 0x80, 0x7f, 0x12, 0x3,
    0xff, 0x8e, 0x80, 0xfe, 0x60, 0x79, 0xdb, 0x6d,
    0x56, 0x7, 0xff, 0x25, 0xc4, 0xa2, 0x65, 0x18,
    0x1f, 0xfc, 0x26, 0x7, 0x32, 0x7, 0xec, 0x97,
    0x1, 0xfc, 0x48, 0xe, 0xd0, 0xf, 0x95, 0xbc,
    0x7, 0xfb, 0x20, 0x39, 0xf8, 0x7, 0xff, 0x21,
    0xd6, 0x7, 0xcf, 0xc0, 0x3c, 0x4f, 0x1, 0xeb,
    0x11, 0x3, 0xf9, 0xf8, 0x4, 0xb6, 0xe0, 0x39,
    0x20, 0x18, 0xea, 0x80, 0xf3, 0xf0, 0xf, 0xfe,
    0x6, 0x3, 0xb9, 0x57, 0x20, 0x3c, 0xfc, 0x3,
    0xfc, 0x40, 0xe2, 0x4, 0x6e, 0x40, 0x78, 0x81,
    0xff, 0xca, 0x37, 0x30, 0x3f, 0x88, 0x1f, 0xf2,
    0x3, 0xe3, 0x3b, 0x3, 0xe3, 0x48, 0x11, 0x3,
    0xac, 0x6c, 0x97, 0xd9, 0x81, 0xf2, 0xd4, 0x8e,
    0x7, 0x9c, 0x8b, 0x7f, 0x30, 0x3f, 0x96, 0x4c,
    0xf, 0xfe, 0x81, 0x43, 0x10, 0x3f, 0xf9, 0x17,
    0xb0, 0x28, 0x0, 0xec, 0x88, 0x90, 0x1f, 0xf1,
    0x57, 0xa1, 0x3b, 0x28, 0xc, 0x5d, 0xd9, 0xff,
    0xfd, 0xaa, 0x3, 0xa6, 0x0,

    /* U+27 "'" */
    0x1f, 0xe2, 0x7, 0xc4, 0x8, 0x81, 0xf3, 0x3,
    0x88, 0x2, 0x7, 0x30, 0x1c, 0xe, 0x52, 0x38,

    /* U+28 "(" */
    0x2, 0x77, 0x7f, 0xa8, 0xd, 0x11, 0x3, 0xd0,
    0x81, 0xfc, 0xc0, 0xfe, 0x40, 0x7c, 0x93, 0x10,
    0x38, 0xfb, 0x4c, 0xf, 0x50, 0x37, 0x3, 0x88,
    0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x44, 0xd,
    0xc0, 0xea, 0x6, 0x20, 0x71, 0xf6, 0x9a, 0x3,
    0xe4, 0x98, 0x30, 0x3f, 0xd0, 0x81, 0xfe, 0xd1,
    0x10, 0x38,

    /* U+29 ")" */
    0xbf, 0xf5, 0x60, 0x7f, 0x29, 0x80, 0xff, 0x18,
    0x7, 0xf9, 0x8c, 0x90, 0xf, 0x93, 0xb5, 0xc8,
    0x1c, 0x40, 0xd4, 0xe, 0xe0, 0x62, 0x7, 0xff,
    0xfc, 0xf, 0xff, 0xf8, 0x11, 0x3, 0xb8, 0x1a,
    0x81, 0xe7, 0x6b, 0x90, 0x38, 0xe4, 0x80, 0x7c,
    0x80, 0xfe, 0x40, 0x7f, 0x1a, 0x7, 0xca, 0x60,
    0x0,

    /* U+2A "*" */
    0x3, 0xdf, 0xc8, 0xf, 0xfe, 0xdb, 0x20, 0x7f,
    0x90, 0x14, 0xd9, 0x8, 0x11, 0x77, 0xd6, 0x18,
    0x2, 0xf0, 0x14, 0x84, 0x2, 0x80, 0x20, 0x7f,
    0xf0, 0x10, 0x7b, 0x21, 0x3, 0xce, 0xf8, 0x4,
    0x5c, 0x3, 0x94, 0x40, 0x78, 0xd0, 0x39, 0x30,
    0x3e, 0xe0, 0x58, 0x80, 0x84, 0xe, 0x84, 0x4,
    0x3c, 0xb, 0x81, 0xd8, 0x2, 0x60, 0xd0, 0x8,
    0xe, 0x5d, 0xd0, 0x24, 0xec, 0x2,

    /* U+2B "+" */
    0x3, 0xf9, 0xb9, 0x1, 0xff, 0xc4, 0x32, 0x5c,
    0xf, 0xff, 0xf8, 0x1f, 0xfe, 0xf5, 0xff, 0xd8,
    0x9, 0x7f, 0xf5, 0x3, 0xff, 0xbc, 0xc9, 0xfc,
    0x6, 0x27, 0xfb, 0x6f, 0xb8, 0x12, 0xdb, 0xe8,
    0x7, 0xff, 0xfc, 0xf, 0xff, 0x38,

    /* U+2C "," */
    0x1b, 0x79, 0x2, 0x7c, 0x7, 0xff, 0x5b, 0xe0,
    0x3e, 0x60, 0x71, 0x50, 0xc, 0xf5, 0x20, 0x62,
    0x7, 0xa0, 0x1c, 0xab, 0x0,

    /* U+2D "-" */
    0x4b, 0xfe, 0x16, 0xff, 0xc0, 0x7f, 0xf9, 0x40,

    /* U+2E "." */
    0x9b, 0x74, 0x27, 0xe0, 0x3f, 0xfa, 0x0,

    /* U+2F "/" */
    0x3, 0xff, 0x97, 0x7f, 0xb0, 0x1f, 0xfc, 0xb8,
    0x80, 0x1c, 0x7, 0xff, 0x29, 0xb0, 0x17, 0x3,
    0xff, 0x94, 0xa0, 0x15, 0x20, 0x7f, 0xf2, 0x4d,
    0x2, 0x88, 0xf, 0xfe, 0x56, 0x2, 0x6c, 0x7,
    0xff, 0x2b, 0x1, 0x28, 0x7, 0xff, 0x2a, 0x90,
    0x6, 0x81, 0xff, 0xca, 0x88, 0xb, 0x1, 0xff,
    0xca, 0x6c, 0x5, 0x80, 0xff, 0xe5, 0x28, 0x5,
    0x48, 0x1f, 0xfc, 0x93, 0x40, 0xa2, 0x3, 0xff,
    0x95, 0xc0, 0x9b, 0x1, 0xff, 0xca, 0xc4, 0x2,
    0x80, 0x7f, 0xf2, 0xa9, 0x0, 0x68, 0x1f, 0xfc,
    0xa8, 0x80, 0xb8, 0x1f, 0xfc, 0xa4, 0xc0, 0xb1,
    0x3, 0xff, 0x92, 0x68, 0x15, 0x20, 0x7f, 0xf2,
    0x4e, 0x2, 0x68, 0xf, 0xfe, 0x57, 0x2, 0x50,
    0xf, 0xfe, 0x56, 0x20, 0xd, 0x3, 0xff, 0x95,
    0x48, 0x16, 0x3, 0xff, 0x94, 0xd0, 0x16, 0x3,
    0xff, 0x94, 0xa0, 0x15, 0x20, 0x7f, 0xf2, 0x4d,
    0x2, 0x88, 0xf, 0xfe, 0x56, 0x2, 0x6c, 0x7,
    0xff, 0x2b, 0x1, 0x28, 0x7, 0xff, 0x28,

    /* U+30 "0" */
    0x3, 0x94, 0xd9, 0xff, 0xfb, 0x65, 0x64, 0xf,
    0x97, 0xac, 0x90, 0x1f, 0xe2, 0x4a, 0x6c, 0x20,
    0x67, 0x40, 0xff, 0xe4, 0x1c, 0x4, 0x60, 0x1f,
    0xfc, 0xb8, 0x1, 0x1, 0xff, 0xcc, 0x60, 0x30,
    0x1e, 0x77, 0xff, 0xea, 0x40, 0xf1, 0xc, 0xe,
    0x71, 0x1, 0xfc, 0xb0, 0x1e, 0x60, 0x81, 0xd8,
    0xf, 0xfe, 0x9, 0x3, 0x88, 0x1f, 0x30, 0x3f,
    0xf8, 0x2c, 0xf, 0xfe, 0x9, 0x3, 0xff, 0xfe,
    0x7, 0xe2, 0x7, 0xff, 0x3d, 0x81, 0xff, 0xc1,
    0x60, 0x7f, 0xf0, 0x70, 0x1f, 0xfc, 0x2, 0x40,
    0x71, 0x4, 0xe, 0x6c, 0x40, 0xf1, 0x25, 0x30,
    0x1e, 0x61, 0x1, 0xe9, 0xbf, 0xf6, 0xca, 0xc0,
    0xf8, 0x8c, 0x7, 0xff, 0x31, 0x0, 0x44, 0xf,
    0xfe, 0x5c, 0x2, 0xc4, 0xf, 0xfe, 0x4d, 0x20,
    0x6d, 0x5a, 0x20, 0x7f, 0xf0, 0xa, 0x77, 0xa0,
    0x0,

    /* U+31 "1" */
    0x3, 0xf3, 0xff, 0xf1, 0x3, 0xc6, 0xc0, 0x3f,
    0xf8, 0x4f, 0x20, 0x3f, 0xf8, 0x27, 0x40, 0x3f,
    0xf8, 0x4f, 0x10, 0x3f, 0xf8, 0x27, 0x40, 0x3c,
    0x68, 0x1f, 0x32, 0x7, 0x9e, 0x40, 0x7c, 0x90,
    0xe, 0xb0, 0xf, 0xf5, 0x2, 0x5d, 0x1, 0xff,
    0xc0, 0xa2, 0xd0, 0x1f, 0xfc, 0x25, 0xd0, 0x1f,
    0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xf7, 0xc0,

    /* U+32 "2" */
    0x2, 0x2e, 0xec, 0xff, 0xff, 0x83, 0xa1, 0x3,
    0x5d, 0x11, 0x20, 0x3f, 0xf8, 0x25, 0xe6, 0x2,
    0x20, 0x3f, 0xf9, 0x30, 0x3, 0x3, 0xff, 0x96,
    0xc0, 0xf8, 0xcb, 0xb7, 0xe8, 0x7, 0xb9, 0x3,
    0xd9, 0xa2, 0x7f, 0x38, 0x7, 0x10, 0x3c, 0x80,
    0xff, 0xe0, 0x10, 0x39, 0x96, 0xfb, 0x1, 0xff,
    0xc0, 0x20, 0x7d, 0x27, 0x30, 0x3f, 0x89, 0x38,
    0x7, 0x30, 0x38, 0xa7, 0x22, 0xec, 0xfe, 0xd9,
    0x0, 0xf1, 0x0, 0x6f, 0xd6, 0x36, 0x44, 0x80,
    0xff, 0xe0, 0x60, 0x72, 0x3, 0xff, 0x90, 0x90,
    0x40, 0x3f, 0xf9, 0x2e, 0x80, 0x40, 0x79, 0x37,
    0xff, 0x4b, 0xe0, 0x2, 0x7, 0xbd, 0x93, 0xfe,
    0x68, 0xf, 0xf2, 0x3, 0xff, 0x9a, 0xc9, 0xff,
    0xe3, 0x81, 0xe3, 0xb7, 0xff, 0x1b, 0x81, 0xff,
    0xff, 0x2,

    /* U+33 "3" */
    0x3, 0x29, 0x77, 0xff, 0xed, 0x95, 0x90, 0x39,
    0xfa, 0xd1, 0x3, 0xfc, 0x49, 0x4d, 0x80, 0x4e,
    0x1, 0xff, 0xc8, 0x38, 0x5, 0x3, 0xff, 0x94,
    0x48, 0x10, 0x38, 0xc9, 0xf9, 0xa0, 0x3e, 0x44,
    0xf, 0x66, 0xff, 0x4b, 0xc0, 0xf7, 0x60, 0x72,
    0x3, 0xff, 0x80, 0x80, 0xf3, 0x93, 0xb8, 0x1f,
    0xfc, 0x6e, 0x5b, 0xe4, 0x7, 0xf8, 0xb4, 0x7,
    0x20, 0x3f, 0xcb, 0xff, 0x68, 0x7, 0x32, 0x7,
    0xff, 0x24, 0xab, 0x0, 0xff, 0xe5, 0x10, 0x48,
    0xf, 0xfe, 0x5a, 0x98, 0x81, 0xfe, 0x5f, 0xfd,
    0x90, 0x1d, 0x23, 0xfe, 0x60, 0x7f, 0xc6, 0x1,
    0xc8, 0xf, 0x70, 0x3f, 0xf8, 0xc, 0xf, 0x70,
    0x39, 0xc4, 0xbf, 0x9c, 0xa0, 0x78, 0x81, 0xe7,
    0x6f, 0xf4, 0x60, 0x79, 0x21, 0x3, 0xff, 0x97,
    0xc7, 0x3, 0xff, 0x95, 0x10, 0x39, 0x90, 0x3f,
    0xf8, 0x65, 0x3c, 0xc0,

    /* U+34 "4" */
    0x3, 0xff, 0x84, 0xff, 0xfc, 0x7, 0xff, 0x10,
    0xe8, 0x7, 0xff, 0x2e, 0x62, 0x7, 0xff, 0x29,
    0x66, 0x7, 0xff, 0x2e, 0xd1, 0x3, 0xff, 0x94,
    0xfa, 0x3, 0xc7, 0x1, 0xff, 0xc2, 0x3a, 0x1,
    0xf4, 0xc4, 0xf, 0xfe, 0xc, 0xc4, 0xf, 0x2e,
    0xc0, 0xff, 0xe0, 0xac, 0xc0, 0xf1, 0xb4, 0x7,
    0xff, 0xa, 0x52, 0x7, 0x9e, 0x40, 0x7f, 0xf0,
    0xd8, 0x1e, 0x5a, 0x1, 0xff, 0xcb, 0xb4, 0x40,
    0xff, 0xe5, 0xc2, 0xdf, 0xf8, 0xf, 0x37, 0x10,
    0x3a, 0x4f, 0xfe, 0x0, 0x1e, 0x92, 0x40, 0x7f,
    0xff, 0xc0, 0xf7, 0xff, 0xfc, 0x50, 0x3d, 0xfc,
    0xc0, 0xff, 0xff, 0x81, 0xe0,

    /* U+35 "5" */
    0xf, 0xff, 0xfe, 0x58, 0x1f, 0xff, 0xf0, 0x3f,
    0xb8, 0x18, 0xed, 0xff, 0xc6, 0x3, 0xf8, 0x9f,
    0xfe, 0x30, 0x1f, 0xfc, 0x12, 0x7c, 0x7, 0xff,
    0x1a, 0x7e, 0xdb, 0xdf, 0xed, 0x8, 0x1f, 0xec,
    0xc0, 0xff, 0xe0, 0x17, 0xa0, 0x1f, 0x89, 0x1,
    0xff, 0xc4, 0x68, 0xf, 0xfe, 0x77, 0x3, 0xf4,
    0xff, 0xfd, 0x48, 0x1c, 0x80, 0x69, 0x35, 0x60,
    0x7f, 0x94, 0x3, 0xf2, 0x6f, 0x20, 0x3f, 0xf8,
    0x8, 0xf, 0x8b, 0x7c, 0x40, 0xff, 0xe0, 0x10,
    0x3e, 0x52, 0x78, 0xf, 0xfe, 0x2, 0x3, 0x88,
    0x20, 0x72, 0x8d, 0x2f, 0x37, 0x58, 0x7, 0x30,
    0x80, 0xf3, 0x96, 0xfa, 0x49, 0x1, 0xee, 0x1,
    0x81, 0xff, 0xca, 0x28, 0x4, 0x60, 0x7f, 0xf2,
    0x16, 0x3, 0x4f, 0x1a, 0x24, 0x7, 0xf1, 0x24,
    0xf5, 0x2,

    /* U+36 "6" */
    0x3, 0x9d, 0xd9, 0xff, 0xfb, 0x56, 0x40, 0xf5,
    0xf1, 0x12, 0x3, 0xfc, 0x54, 0xd4, 0xd, 0x90,
    0x1f, 0xfc, 0x75, 0x40, 0x42, 0x7, 0xff, 0x25,
    0x0, 0x60, 0x78, 0xb9, 0x2b, 0x74, 0x20, 0x78,
    0x81, 0xf4, 0xd1, 0xb9, 0x2c, 0xf2, 0x3, 0x99,
    0x3, 0xcc, 0xf, 0xfa, 0xff, 0xc8, 0xf, 0x10,
    0x31, 0x3f, 0xc0, 0x79, 0x81, 0xf4, 0xfd, 0xb7,
    0xf7, 0xd0, 0x81, 0xfd, 0x98, 0x1f, 0xfc, 0x2,
    0xf3, 0x3, 0xe2, 0x40, 0x7f, 0xf1, 0x21, 0x3,
    0xff, 0x9a, 0x98, 0x1e, 0x7b, 0xff, 0xea, 0x7,
    0xb8, 0x1f, 0x42, 0x7, 0xf2, 0x80, 0x71, 0x3,
    0xc4, 0xf, 0xfe, 0x1, 0x3, 0xc4, 0xe, 0x20,
    0x7f, 0xf0, 0x30, 0x1f, 0xfc, 0x1c, 0xd2, 0xf9,
    0xb5, 0x60, 0x71, 0x8, 0xe, 0x32, 0xdf, 0xa4,
    0x20, 0x3d, 0x84, 0x3, 0xff, 0x94, 0x50, 0x38,
    0x81, 0xff, 0xc7, 0x3c, 0x8, 0xec, 0x68, 0x81,
    0xff, 0x14, 0xee, 0x20,

    /* U+37 "7" */
    0x7f, 0xff, 0xf3, 0x40, 0xff, 0xff, 0x81, 0xff,
    0xd1, 0x7f, 0xff, 0xf1, 0x28, 0x1f, 0x50, 0x3f,
    0xf8, 0x86, 0x81, 0xe8, 0x80, 0xff, 0xe1, 0x9c,
    0x7, 0x9b, 0x1, 0xff, 0xc4, 0xe0, 0x79, 0x40,
    0x3f, 0xf8, 0x98, 0x81, 0xc6, 0x81, 0xff, 0xc4,
    0xa4, 0xe, 0x38, 0xf, 0xfe, 0x24, 0x40, 0x7b,
    0x81, 0xff, 0xc4, 0x6c, 0x7, 0xb1, 0x3, 0xff,
    0x86, 0xa0, 0x1e, 0xa4, 0xf, 0xfe, 0x19, 0xa0,
    0x7a, 0x20, 0x3f, 0xf8, 0x98, 0xf, 0x36, 0x3,
    0xff, 0x89, 0x80, 0xf2, 0x80, 0x7f, 0xf1, 0x29,
    0x3, 0x8d, 0x3, 0xff, 0x89, 0x50, 0x1c, 0x70,
    0x1f, 0xfc, 0x48, 0x80, 0xf7, 0x3, 0xff, 0x88,
    0xd8, 0xf, 0x62, 0x7, 0xff, 0x0,

    /* U+38 "8" */
    0x2, 0x9b, 0xff, 0xfe, 0x26, 0x84, 0xd, 0xd9,
    0x3, 0xff, 0x88, 0x5e, 0x40, 0x20, 0x1f, 0xfc,
    0xaa, 0x1, 0x81, 0xff, 0xcb, 0x60, 0x7c, 0xf7,
    0xff, 0xd4, 0xf, 0x72, 0x7, 0x18, 0x40, 0xfe,
    0x50, 0xf, 0x10, 0x3f, 0xf9, 0xc4, 0xc, 0x58,
    0x1f, 0xe5, 0x0, 0xec, 0x28, 0x1d, 0x3f, 0xff,
    0x50, 0x38, 0xa0, 0xe0, 0x1f, 0xfc, 0x75, 0x30,
    0x13, 0xcc, 0xf, 0xfe, 0x21, 0x4, 0xd, 0x73,
    0x3, 0xff, 0x88, 0x55, 0xa0, 0x15, 0x1, 0xa6,
    0xff, 0xfa, 0x81, 0xc9, 0x2, 0x3, 0x16, 0x40,
    0xfe, 0x50, 0xe, 0xc8, 0xe, 0x60, 0x7f, 0xf0,
    0x10, 0x1c, 0x40, 0xf3, 0x3, 0xff, 0x80, 0x80,
    0xe6, 0x7, 0x8e, 0x64, 0xf, 0x12, 0x70, 0xe,
    0x6c, 0x7, 0x8c, 0xdf, 0xfb, 0x64, 0x3, 0xd8,
    0x90, 0x1f, 0xfc, 0xb6, 0x20, 0x1f, 0xfc, 0xaa,
    0x1, 0x66, 0x7, 0xff, 0x10, 0xa9, 0xd0,

    /* U+39 "9" */
    0x3, 0x39, 0x77, 0xff, 0xf6, 0xac, 0xf, 0x2f,
    0x1a, 0x20, 0x7f, 0xc5, 0x4f, 0x0, 0x8d, 0x3,
    0xff, 0x90, 0xe8, 0x8, 0x7, 0xff, 0x29, 0x10,
    0x80, 0xf2, 0x93, 0xf9, 0x1, 0xe4, 0x7, 0xd6,
    0x9b, 0xfe, 0xac, 0xe, 0xe0, 0x7c, 0x80, 0xff,
    0xb0, 0x1c, 0x40, 0xf8, 0x81, 0xff, 0x10, 0x39,
    0x81, 0xf4, 0x20, 0x7e, 0x2a, 0x1, 0xf2, 0x3,
    0x96, 0xff, 0xf6, 0xa0, 0x7e, 0x80, 0x7f, 0xf3,
    0x4c, 0x3, 0xff, 0x88, 0x80, 0xfc, 0xfc, 0x44,
    0xf, 0xf1, 0xbc, 0xf, 0xf3, 0xbb, 0xff, 0xf6,
    0x40, 0x7f, 0xf5, 0x1a, 0xff, 0xa8, 0x1f, 0xfc,
    0xe, 0x7, 0x10, 0x3c, 0xb3, 0x4b, 0xf3, 0xa8,
    0xe, 0xec, 0xf, 0x19, 0x6f, 0xe8, 0x80, 0xf2,
    0x24, 0x7, 0xff, 0x29, 0x11, 0xc8, 0x1f, 0xfc,
    0x85, 0x40, 0x1d, 0x5a, 0x20, 0x7f, 0xf0, 0x4a,
    0xb4, 0x0,

    /* U+3A ":" */
    0xbf, 0xf5, 0x3, 0xff, 0xa0, 0x4f, 0xd3, 0x6e,
    0x80, 0x7f, 0xf0, 0xa6, 0xdd, 0x9, 0xf8, 0xf,
    0xfe, 0x80,

    /* U+3B ";" */
    0x1f, 0xf9, 0x1, 0xff, 0xd5, 0x27, 0xc0, 0x36,
    0xf2, 0x3, 0xff, 0x8b, 0xb7, 0x90, 0x27, 0xc0,
    0x7f, 0xf5, 0xbe, 0x3, 0xe6, 0x7, 0x15, 0x0,
    0xcf, 0x52, 0x6, 0x20, 0x7a, 0x1, 0xca, 0xb0,

    /* U+3C "<" */
    0x3, 0xff, 0x9c, 0xf0, 0x1f, 0xe7, 0xe1, 0x3,
    0xf3, 0xf0, 0xf, 0xe7, 0xe0, 0x18, 0x81, 0x9f,
    0x80, 0x63, 0x70, 0x7, 0xe0, 0x18, 0xdc, 0x83,
    0xf0, 0xc, 0xb6, 0x20, 0x28, 0x6, 0x5a, 0x90,
    0x3f, 0x95, 0x20, 0x7f, 0xcb, 0xc0, 0x3e, 0xcc,
    0xc, 0xfc, 0x3, 0x8c, 0xcc, 0xc, 0xfc, 0x20,
    0x63, 0x3b, 0x3, 0x3d, 0x48, 0x1d, 0x3b, 0x3,
    0x2c, 0x7, 0xd3, 0xb0, 0x3f, 0xf8, 0x33, 0xb0,
    0x3f, 0xf8, 0x33, 0xc0,

    /* U+3D "=" */
    0x5f, 0xff, 0xf1, 0xe8, 0x1f, 0xfd, 0xe6, 0x4f,
    0xff, 0x27, 0x6f, 0xfe, 0x3c, 0x3, 0xff, 0x92,
    0x76, 0xff, 0xe3, 0xc6, 0x4f, 0xff, 0x20, 0xf,
    0xfe, 0xf0,

    /* U+3E ">" */
    0x3, 0xff, 0x87, 0x18, 0x1f, 0xfc, 0x13, 0x3c,
    0x3, 0xff, 0x84, 0xfc, 0x3, 0xf8, 0x81, 0x9f,
    0x80, 0x7d, 0x32, 0x3, 0x3f, 0x0, 0xf1, 0xb9,
    0x1, 0x9f, 0x80, 0x78, 0xdc, 0xc0, 0xcf, 0xc0,
    0x3c, 0x67, 0x60, 0x66, 0x40, 0xfd, 0x20, 0xf,
    0xfe, 0x3, 0xd0, 0xf, 0xf3, 0xf0, 0x81, 0x1a,
    0x40, 0x9f, 0x80, 0x63, 0x72, 0x1, 0x3c, 0x3,
    0x2b, 0x90, 0x15, 0x60, 0x65, 0xaa, 0x3, 0xf9,
    0x6a, 0x40, 0xfe, 0x5a, 0x90, 0x3f, 0xb6, 0x52,
    0x7, 0xfc,

    /* U+3F "?" */
    0x2, 0x52, 0xef, 0xff, 0x6b, 0x10, 0x18, 0xea,
    0xd1, 0x3, 0xf1, 0x4e, 0xf4, 0x3, 0x10, 0x3f,
    0xf8, 0xb4, 0x30, 0x3f, 0xf9, 0x13, 0x1, 0xcf,
    0x7f, 0xed, 0x0, 0xe2, 0x7, 0x18, 0x40, 0xf1,
    0x68, 0xc, 0xd8, 0xc, 0xc0, 0xff, 0xe2, 0x4b,
    0x74, 0x3, 0xf1, 0x88, 0xc, 0xd2, 0xe2, 0x4,
    0x5d, 0xdf, 0x30, 0x38, 0x81, 0xfa, 0xe8, 0x88,
    0x1f, 0xa8, 0x1f, 0x44, 0x7, 0xfc, 0xc8, 0x1f,
    0x20, 0x3f, 0x8b, 0xd0, 0xf, 0xc4, 0xe, 0x77,
    0x7d, 0x8, 0x1f, 0xc9, 0x74, 0x84, 0x40, 0xff,
    0xe0, 0xdb, 0xcc, 0xf, 0xfe, 0x22, 0x5c, 0x40,
    0xff, 0xe1, 0xab, 0x7b, 0x81, 0xff, 0xff, 0x3,
    0xff, 0x94,

    /* U+40 "@" */
    0x3, 0xff, 0xb0, 0xee, 0xff, 0xff, 0x91, 0xb2,
    0xb0, 0x3b, 0xc4, 0x40, 0xff, 0xe4, 0x12, 0x53,
    0x90, 0x10, 0xf, 0xc4, 0xfe, 0x4a, 0x6c, 0x90,
    0x81, 0xdc, 0x2, 0x2, 0x57, 0xfb, 0x6f, 0xd6,
    0xd2, 0x2d, 0x6e, 0xc0, 0x88, 0x2, 0x5, 0x10,
    0x1f, 0xfc, 0x88, 0x80, 0x90, 0x1c, 0x40, 0xca,
    0x6f, 0xfb, 0x31, 0x7f, 0x80, 0xb0, 0x1f, 0xfc,
    0x19, 0x59, 0x3, 0x8c, 0xc0, 0x7c, 0x40, 0x88,
    0x1f, 0x8b, 0x2, 0x32, 0x73, 0x28, 0xf, 0xfe,
    0x3b, 0x2, 0x59, 0xbe, 0x98, 0xf, 0xfe, 0x21,
    0x2, 0x20, 0x58, 0xf, 0x89, 0x1, 0xff, 0xc7,
    0xe0, 0x44, 0xf, 0xcc, 0xf, 0x10, 0x3f, 0xf9,
    0xac, 0xf, 0xfe, 0x59, 0x3, 0xf1, 0x3, 0xdc,
    0xf, 0xcc, 0xb, 0x81, 0x46, 0x7, 0x1a, 0x6,
    0x60, 0xb0, 0x22, 0x6, 0x60, 0x4c, 0xd, 0x3f,
    0xec, 0x90, 0xa, 0x7c, 0x6, 0x40, 0x7f, 0x50,
    0x3f, 0xd6, 0x1, 0xfc, 0x80, 0xe2, 0x6, 0x5e,
    0x22, 0x72, 0x79, 0x1a, 0x89, 0xe5, 0x28, 0x1e,
    0x20, 0x73, 0xbb, 0x6b, 0x8, 0x5, 0x76, 0xea,
    0xc0, 0x88, 0x17, 0x40, 0x7f, 0xf2, 0x6f, 0xb0,
    0x8a, 0x4, 0x6f, 0xf6, 0xdf, 0xfc, 0x5e, 0x82,
    0x64, 0x34, 0x7, 0xc4, 0xff, 0xf1, 0x40, 0xd0,
    0xa, 0xd2, 0x24, 0x7, 0xff, 0x28, 0xc6, 0x0,

    /* U+41 "A" */
    0x3, 0xff, 0x81, 0xff, 0xf1, 0x3, 0xff, 0x95,
    0x40, 0xfe, 0xe0, 0x7f, 0xf2, 0x4a, 0x3, 0xf8,
    0xa0, 0x3f, 0xf9, 0x1c, 0xf, 0xfa, 0x1, 0xff,
    0xc7, 0x44, 0xf, 0xf8, 0xb0, 0x3f, 0xf8, 0xd4,
    0xf, 0x70, 0x3d, 0x0, 0xff, 0xe2, 0xb0, 0x3d,
    0x4, 0x3, 0xd0, 0xf, 0xfe, 0x24, 0x3, 0x8b,
    0xc, 0x81, 0xcc, 0xf, 0xfe, 0x1d, 0x3, 0xd0,
    0xa, 0x1, 0xea, 0x7, 0xff, 0x4, 0xa0, 0x38,
    0xa0, 0x24, 0x40, 0xe4, 0x40, 0xff, 0xe0, 0x70,
    0x3d, 0x0, 0xe8, 0x7, 0xb8, 0x1f, 0xf2, 0x20,
    0x71, 0x40, 0x72, 0x40, 0x38, 0xa0, 0x3f, 0xd4,
    0xf, 0x70, 0x3e, 0x80, 0x7a, 0x1, 0xfc, 0xc0,
    0xfb, 0x7f, 0xf6, 0x3, 0xc5, 0x81, 0xfa, 0x1,
    0xff, 0xcb, 0x80, 0x7d, 0x40, 0xff, 0xe6, 0xc0,
    0x38, 0xa0, 0x3f, 0xf9, 0xac, 0xe, 0xe0, 0x79,
    0xdb, 0xff, 0xc1, 0x40, 0x7a, 0x81, 0x22, 0x7,
    0xa2, 0x5f, 0xfc, 0x1a, 0x7, 0x91, 0x1, 0x40,
    0xf4, 0x3, 0xff, 0x87, 0x40, 0xf7, 0xc, 0xf,
    0x16, 0x7, 0xff, 0xd, 0x10, 0x38, 0xa0,

    /* U+42 "B" */
    0x3f, 0xff, 0xf2, 0x75, 0x60, 0x7f, 0xf3, 0x8a,
    0x98, 0xf, 0xfe, 0x81, 0xc0, 0x7f, 0xf4, 0x9,
    0x1, 0xf9, 0x2f, 0xfe, 0x1, 0x3, 0xe6, 0x7,
    0xeb, 0x7f, 0xf8, 0x1a, 0x81, 0xe2, 0x7, 0xff,
    0x25, 0x1, 0xe2, 0x7, 0xff, 0x26, 0x1, 0xe4,
    0x7, 0xef, 0xff, 0xf8, 0x2c, 0xe, 0x60, 0x7f,
    0xf3, 0x95, 0x80, 0x7f, 0xf3, 0x9e, 0x20, 0x7f,
    0xf3, 0x8b, 0xc8, 0xf, 0xdb, 0x7f, 0xf0, 0x68,
    0x1e, 0x80, 0x7e, 0x27, 0xff, 0x82, 0xa0, 0x1c,
    0x40, 0xff, 0xe5, 0x10, 0x3c, 0x40, 0xff, 0xe4,
    0xe0, 0x3f, 0xf8, 0x56, 0xff, 0xf0, 0x73, 0x3,
    0xc4, 0xf, 0x92, 0xff, 0xe0, 0x90, 0x3c, 0x40,
    0xff, 0xe8, 0x50, 0x3f, 0xf9, 0xe9, 0x81, 0xff,
    0xcc, 0x2a, 0xd0, 0x0,

    /* U+43 "C" */
    0x3, 0x17, 0x76, 0x7f, 0xff, 0x6b, 0x4c, 0xf,
    0xae, 0x88, 0x90, 0x1f, 0xf1, 0x49, 0x3a, 0x3,
    0x74, 0x7, 0xff, 0x26, 0xa0, 0x14, 0xf, 0xfe,
    0x64, 0x5, 0x1, 0xff, 0xcc, 0x21, 0x1, 0xf3,
    0xbb, 0x5f, 0xf6, 0xa4, 0xf, 0x1e, 0x7, 0xac,
    0x44, 0xc0, 0x71, 0x5c, 0xf, 0xfe, 0x12, 0x3,
    0xff, 0x80, 0x64, 0xf1, 0x20, 0x38, 0x81, 0xff,
    0xc2, 0x6f, 0xc0, 0x7f, 0xff, 0xc0, 0xff, 0x10,
    0x3f, 0xfa, 0xa4, 0xf, 0xfe, 0x16, 0xff, 0x9f,
    0x3, 0xc8, 0xf, 0xfe, 0x9, 0x3, 0xc4, 0xf,
    0x56, 0x40, 0xfc, 0x56, 0x3, 0xe4, 0x7, 0xd3,
    0x7f, 0xfb, 0x52, 0x7, 0x88, 0x40, 0x7f, 0xf3,
    0x50, 0x80, 0x7f, 0xf3, 0x10, 0x3, 0x88, 0x1f,
    0xfc, 0x95, 0x40, 0x8e, 0xad, 0x10, 0x3f, 0xf8,
    0x45, 0x5a, 0x0,

    /* U+44 "D" */
    0x3f, 0xff, 0xf2, 0x75, 0x84, 0xf, 0xfe, 0x71,
    0x4f, 0x50, 0x3f, 0xfa, 0x2b, 0x1, 0xff, 0xd1,
    0x2c, 0xf, 0xfe, 0x8e, 0x3, 0xf4, 0xdb, 0xfe,
    0xb0, 0xf, 0x90, 0x1f, 0x89, 0xff, 0xe0, 0x27,
    0xc8, 0x1f, 0xfd, 0x1a, 0x7, 0x88, 0x1f, 0xfc,
    0xa2, 0x7, 0x98, 0x1f, 0xfc, 0xa6, 0x7, 0xff,
    0xfc, 0xf, 0xfe, 0x13, 0x3, 0xff, 0xa2, 0x40,
    0xff, 0xe8, 0xe0, 0x3c, 0xc0, 0xff, 0xe4, 0x18,
    0x80, 0xf1, 0x3, 0xeb, 0xff, 0xff, 0x3, 0x30,
    0x3c, 0x40, 0xff, 0xe8, 0xd0, 0x3f, 0xfa, 0x5,
    0x81, 0xff, 0xcf, 0x38, 0xf, 0xfe, 0x69, 0x57,
    0x1, 0x0,

    /* U+45 "E" */
    0x3f, 0xff, 0xf2, 0xd8, 0x1f, 0xff, 0xf0, 0x3e,
    0x27, 0xff, 0x8c, 0x7, 0xdf, 0x6f, 0xfe, 0x22,
    0x3, 0xff, 0xdb, 0xbf, 0xff, 0xe1, 0xb0, 0x3f,
    0xff, 0xe0, 0x7e, 0xbb, 0x7f, 0xf0, 0xd8, 0x1f,
    0x99, 0x3f, 0xfc, 0x30, 0x3f, 0xfd, 0xff, 0x6f,
    0xfe, 0x23, 0x3, 0xe2, 0x7f, 0xf8, 0xb8, 0xf,
    0xff, 0xf8,

    /* U+46 "F" */
    0x3f, 0xff, 0xf2, 0x98, 0x1f, 0xff, 0xf0, 0x31,
    0x3f, 0xfc, 0x50, 0x3e, 0xfb, 0x7f, 0xf0, 0xd0,
    0x1f, 0xff, 0xf0, 0x36, 0xff, 0xff, 0x85, 0x0,
    0xff, 0xff, 0x81, 0xc4, 0xff, 0xf0, 0xf8, 0x1f,
    0xbe, 0xdf, 0xfc, 0x26, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xd0,

    /* U+47 "G" */
    0x3, 0x17, 0x76, 0x7f, 0xff, 0xc0, 0xd9, 0x18,
    0x1e, 0x3b, 0x22, 0x24, 0x7, 0xff, 0x0, 0x93,
    0x9d, 0x1, 0x1c, 0x40, 0xff, 0xe5, 0x52, 0x2,
    0x1, 0xff, 0xcd, 0x80, 0x10, 0x1f, 0xfc, 0xd4,
    0x10, 0x1e, 0x3b, 0xff, 0xfb, 0x10, 0x3e, 0x20,
    0x7b, 0x90, 0x3f, 0xe3, 0x40, 0xfb, 0x81, 0xe2,
    0x7, 0xff, 0x5, 0xed, 0xe0, 0x3f, 0xf9, 0x64,
    0xf8, 0x10, 0x38, 0x81, 0xe7, 0xff, 0xff, 0x8,
    0xf, 0xff, 0xa9, 0x3, 0xff, 0x94, 0x40, 0xff,
    0xe0, 0x3f, 0xfe, 0xc0, 0x7d, 0xc0, 0xf2, 0x3,
    0xff, 0x82, 0xc0, 0xf8, 0x81, 0xe8, 0x80, 0xff,
    0x8c, 0x3, 0xe6, 0x7, 0x8d, 0xfb, 0x7f, 0x7c,
    0x40, 0xe2, 0x9, 0x1, 0xf8, 0x9f, 0xe0, 0x3f,
    0x30, 0x1c, 0xf, 0xfe, 0x6f, 0x0, 0x71, 0x3,
    0xff, 0x95, 0x10, 0x11, 0xd5, 0xa2, 0x7, 0xff,
    0xc, 0xac, 0xc0, 0x0,

    /* U+48 "H" */
    0x3f, 0xf9, 0x1, 0xff, 0xc2, 0xff, 0xd0, 0xf,
    0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xfa, 0x64,
    0xff, 0xf0, 0xc0, 0xff, 0xe1, 0x4d, 0xbf, 0xf8,
    0x40, 0x7f, 0xff, 0xc0, 0xff, 0xf5, 0xdf, 0xff,
    0xf8, 0x40, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xf0,

    /* U+49 "I" */
    0x3f, 0xf9, 0x1, 0xff, 0xff, 0x3, 0xff, 0xfe,
    0x7, 0xf8,

    /* U+4A "J" */
    0x3, 0xff, 0x88, 0xff, 0xf0, 0x1f, 0xff, 0xf0,
    0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff, 0xee,
    0xff, 0xe4, 0x7, 0xff, 0x53, 0x81, 0xff, 0xc2,
    0x20, 0x7e, 0x20, 0x7f, 0xf0, 0xa3, 0x3, 0x8b,
    0x40, 0x71, 0x0, 0x40, 0xf4, 0xff, 0xb4, 0x3,
    0xcc, 0x2, 0x3, 0xff, 0x91, 0xc0, 0x40, 0x3f,
    0xf8, 0xed, 0x1, 0x62, 0x7, 0xff, 0x11, 0xc0,
    0x31, 0xd5, 0x90, 0x3f, 0x8a, 0x9e, 0x1, 0x0,

    /* U+4B "K" */
    0x3f, 0xf9, 0x1, 0xfe, 0x3f, 0xfe, 0xa0, 0x7f,
    0xf1, 0xce, 0x3, 0xe7, 0x40, 0xff, 0xe3, 0x2c,
    0x7, 0xd2, 0x0, 0xff, 0xe3, 0x3a, 0x7, 0xd5,
    0x81, 0xff, 0xc6, 0x90, 0x7, 0xd9, 0x1, 0xff,
    0xc6, 0xac, 0xf, 0x1e, 0x40, 0xff, 0xe3, 0x54,
    0x7, 0x96, 0x3, 0xff, 0x8c, 0x72, 0x3, 0xce,
    0x81, 0xff, 0xc4, 0xbf, 0xb1, 0x3, 0xd2, 0x0,
    0xff, 0xe7, 0xd6, 0x7, 0xff, 0x3e, 0x20, 0x3f,
    0xfa, 0x12, 0x0, 0xff, 0xe8, 0xba, 0x7, 0xff,
    0x1a, 0xff, 0x10, 0x3c, 0xb1, 0x3, 0xff, 0x91,
    0x90, 0x1e, 0x39, 0x1, 0xff, 0xc8, 0xb0, 0xf,
    0xac, 0x3, 0xff, 0x90, 0xe8, 0x1f, 0x3c, 0x7,
    0xff, 0x21, 0x62, 0x7, 0x8f, 0x20, 0x7f, 0xf1,
    0xce, 0x20, 0x7d, 0x98, 0x1f, 0xfc, 0x8c, 0xc0,
    0xfa, 0x50, 0x3f, 0xf9, 0x12, 0x0, 0xf9, 0x62,

    /* U+4C "L" */
    0x3f, 0xf9, 0x1, 0xff, 0xff, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xfd,
    0x12, 0x7f, 0xf8, 0x60, 0x7d, 0x36, 0xff, 0xe1,
    0x1, 0xff, 0xff, 0x3, 0xff, 0x82,

    /* U+4D "M" */
    0x3f, 0xff, 0x90, 0x1f, 0xfc, 0x2b, 0xff, 0xf6,
    0x3, 0xfe, 0xa0, 0x7f, 0xf0, 0x4a, 0x3, 0xff,
    0x94, 0xc0, 0xff, 0xe0, 0x70, 0x3f, 0xf9, 0x70,
    0xf, 0xf9, 0x10, 0x3f, 0xf9, 0x90, 0xf, 0xf4,
    0x3, 0xff, 0x8c, 0x50, 0x1c, 0xc8, 0x1f, 0x99,
    0x3, 0x98, 0x1f, 0xfc, 0x3, 0x0, 0xf4, 0x3,
    0xf4, 0x3, 0x8d, 0x3, 0xff, 0x82, 0x58, 0x1c,
    0x90, 0xf, 0x40, 0x3d, 0xc0, 0xff, 0xe1, 0xc0,
    0x3d, 0x0, 0xe2, 0xc0, 0xe4, 0x58, 0x1f, 0xfc,
    0x38, 0x7, 0x16, 0x6, 0x80, 0x7a, 0x81, 0xff,
    0xc5, 0x64, 0xe, 0x80, 0x45, 0x1, 0xd0, 0xf,
    0xfe, 0x3c, 0x3, 0xcc, 0x7, 0x3, 0x8b, 0x3,
    0xff, 0x8e, 0x90, 0xe, 0x81, 0x10, 0x3a, 0x1,
    0xff, 0xc9, 0x80, 0x7a, 0xc0, 0x39, 0x20, 0x1f,
    0xfc, 0x92, 0xc0, 0xe4, 0x40, 0xe8, 0x6, 0x20,
    0x7f, 0xf1, 0xa0, 0x1f, 0xf3, 0x20, 0x7f, 0xf3,
    0x20, 0x1f, 0xe8, 0x7, 0xff, 0x35, 0x90, 0x3f,
    0x40, 0x3f, 0xf9, 0xf0, 0xf, 0x8b, 0x3, 0xff,
    0x9e, 0x90, 0xf, 0x70, 0x3f, 0xfa, 0x30, 0xe,
    0x44, 0xf, 0xfe, 0x10,

    /* U+4E "N" */
    0x3f, 0xff, 0x98, 0x1f, 0xf1, 0xff, 0xc0, 0x7f,
    0xd1, 0x1, 0xff, 0xd1, 0xa4, 0xf, 0xe2, 0x7,
    0xff, 0x1f, 0x81, 0xff, 0xd1, 0x34, 0xf, 0xfe,
    0x51, 0x3, 0xca, 0x1, 0xff, 0xc8, 0x3c, 0xf,
    0x9a, 0x3, 0xff, 0x90, 0x68, 0x1f, 0x52, 0x7,
    0xff, 0x21, 0x30, 0x3e, 0xc0, 0x7f, 0xf1, 0x88,
    0x8, 0x80, 0xfb, 0x1, 0xff, 0xc9, 0xa4, 0xf,
    0x18, 0x7, 0xff, 0x27, 0x81, 0xf3, 0x60, 0x3f,
    0xf9, 0x6, 0x81, 0xf4, 0x20, 0x7f, 0xf2, 0x14,
    0x3, 0xec, 0x7, 0xff, 0x25, 0xa0, 0x3e, 0xc0,
    0x7f, 0xf2, 0x69, 0x3, 0xc6, 0x81, 0xff, 0xc9,
    0xe0, 0x7c, 0x80, 0xff, 0xe4, 0x9a, 0x7, 0xff,
    0x45, 0x40, 0x3f, 0xfa, 0x2d, 0x1, 0xff, 0xd1,
    0xa4, 0xf, 0xf0,

    /* U+4F "O" */
    0x3, 0x17, 0x76, 0x7f, 0xff, 0xc0, 0xd9, 0x61,
    0x3, 0xeb, 0xa2, 0x24, 0x7, 0xff, 0x0, 0x92,
    0x7a, 0x90, 0x23, 0xd0, 0x1f, 0xfc, 0xa5, 0xc0,
    0xa0, 0x1f, 0xfc, 0xd3, 0x0, 0x20, 0x3f, 0xf9,
    0xcc, 0x30, 0x3e, 0x52, 0xd6, 0xdf, 0xab, 0x3,
    0xe3, 0xc0, 0xf3, 0xad, 0x21, 0x3f, 0x94, 0x60,
    0x79, 0x81, 0xf5, 0x3, 0xff, 0x85, 0x40, 0xf1,
    0x20, 0x3c, 0x40, 0xff, 0xe1, 0x10, 0x3f, 0xff,
    0xe0, 0x7f, 0xfa, 0x8, 0x1f, 0xfc, 0x92, 0x7,
    0xff, 0x9, 0x81, 0xff, 0xc2, 0xa0, 0x78, 0xf0,
    0x3d, 0x20, 0x81, 0xfc, 0x54, 0x60, 0x79, 0xa0,
    0x3e, 0x7b, 0xff, 0xed, 0x58, 0x1f, 0x13, 0x1,
    0xff, 0xce, 0x60, 0x20, 0x1f, 0xfc, 0xd3, 0x0,
    0x28, 0x7, 0xff, 0x2d, 0x60, 0x33, 0xcd, 0x10,
    0x3f, 0xf8, 0x44, 0x94, 0xd4, 0x8,

    /* U+50 "P" */
    0x3f, 0xff, 0xf2, 0x35, 0x40, 0x7f, 0xf3, 0xa,
    0xb4, 0x7, 0xff, 0x39, 0x40, 0x3f, 0xf9, 0xcc,
    0xf, 0xfe, 0x7a, 0x3, 0xeb, 0xff, 0xfa, 0x90,
    0x3c, 0x40, 0xf9, 0x81, 0xfe, 0x5c, 0xf, 0x70,
    0x3f, 0xf8, 0xe4, 0xf, 0xff, 0x87, 0x3, 0xe6,
    0x7, 0xf1, 0x58, 0xf, 0x10, 0x3e, 0xbf, 0xff,
    0x6a, 0x40, 0xf3, 0x3, 0xff, 0x9c, 0x40, 0xff,
    0xe6, 0xc0, 0x3f, 0xf9, 0xa9, 0x81, 0xff, 0xca,
    0x2e, 0xd0, 0x1f, 0xdb, 0xff, 0xfe, 0xe, 0x88,
    0xf, 0xff, 0xf8, 0x1f, 0xfd, 0x80,

    /* U+51 "Q" */
    0x3, 0x17, 0x76, 0x7f, 0xff, 0xc3, 0xd0, 0x81,
    0xfa, 0xe8, 0x89, 0x1, 0xff, 0xc3, 0x2f, 0x30,
    0x3d, 0xd0, 0x1f, 0xfc, 0xb8, 0x40, 0xd4, 0xf,
    0xfe, 0x74, 0x3, 0x20, 0x3f, 0xf9, 0xc8, 0x9,
    0x1, 0xf3, 0xdf, 0xff, 0xb4, 0x3, 0xe4, 0x0,
    0x81, 0xe7, 0x8, 0x1f, 0xe2, 0xe0, 0x1e, 0x20,
    0x38, 0x1e, 0xa0, 0x7f, 0xf0, 0x98, 0x1f, 0xc4,
    0xf, 0x10, 0x3f, 0x5c, 0x40, 0xff, 0xe8, 0x24,
    0x39, 0x81, 0xff, 0xcf, 0xa0, 0x53, 0x10, 0x3f,
    0xf9, 0x90, 0xe, 0x3a, 0x1, 0xff, 0xcb, 0xa8,
    0xf, 0x30, 0x3f, 0xf9, 0x66, 0xd1, 0x3, 0xff,
    0x84, 0x40, 0xf3, 0x3, 0xf2, 0xd4, 0x81, 0xfc,
    0x40, 0x70, 0x3d, 0x18, 0x1f, 0xcb, 0x30, 0x3f,
    0x60, 0x4, 0xf, 0xa7, 0xff, 0xf3, 0x3, 0xf3,
    0xed, 0x1, 0xff, 0xd2, 0xc2, 0x1, 0xff, 0xd1,
    0x81, 0xb0, 0x1f, 0xfc, 0xb4, 0xc0, 0x32, 0x2,
    0x66, 0x40, 0xff, 0xe2, 0x15, 0x35, 0x94, 0x40,
    0x31, 0x9b, 0xff, 0xfe, 0x26, 0xac, 0x80, 0x5c,
    0x0,

    /* U+52 "R" */
    0x3f, 0xff, 0xf2, 0x75, 0x60, 0x7f, 0xf3, 0x4a,
    0x98, 0xf, 0xfe, 0x79, 0xc0, 0x7f, 0xf3, 0xc9,
    0x1, 0xff, 0xcf, 0x40, 0x7d, 0x76, 0xff, 0xa9,
    0x3, 0xdc, 0xf, 0x99, 0x3f, 0xf2, 0xc0, 0x78,
    0x81, 0xff, 0xeb, 0x20, 0x7f, 0xf3, 0xf0, 0x1f,
    0x32, 0x7f, 0xe5, 0x40, 0xf2, 0x3, 0xeb, 0xb7,
    0xfd, 0x50, 0x1d, 0x40, 0xff, 0xe6, 0x29, 0xd0,
    0x1f, 0xfc, 0xb2, 0xeb, 0x3, 0xff, 0x98, 0x4d,
    0x28, 0x1f, 0xfc, 0xf4, 0x7, 0xed, 0xff, 0xfd,
    0x88, 0x1e, 0x40, 0x7f, 0xf1, 0xcc, 0x3, 0xff,
    0x9e, 0xc0, 0xf1, 0x3, 0xff, 0xd8,

    /* U+53 "S" */
    0x3, 0x39, 0x77, 0xff, 0xfc, 0xd, 0x61, 0x3,
    0xa7, 0x8d, 0x10, 0x3f, 0xf8, 0x5, 0x3d, 0x0,
    0xab, 0x3, 0xff, 0x92, 0xd8, 0x14, 0x7, 0xff,
    0x2e, 0x84, 0x7, 0x8a, 0x6f, 0xf2, 0x20, 0x78,
    0x8e, 0x7, 0xb5, 0x93, 0xf5, 0xcc, 0xf, 0x88,
    0x1c, 0x40, 0xff, 0xe0, 0x49, 0xf0, 0x20, 0x71,
    0x60, 0x7f, 0xf0, 0x1b, 0xf0, 0x1f, 0xa7, 0xff,
    0xfc, 0x2d, 0x50, 0xa, 0x7, 0xff, 0x24, 0xab,
    0x1, 0x40, 0x7f, 0xf2, 0xd9, 0x15, 0x1, 0xff,
    0xcb, 0xa0, 0x2f, 0xb1, 0xbf, 0xf9, 0x20, 0x1f,
    0x20, 0x32, 0x72, 0x7f, 0xd6, 0xb9, 0x3, 0x8b,
    0xdb, 0xa8, 0x1f, 0xfc, 0x1a, 0x7, 0xb9, 0x3c,
    0x80, 0xff, 0xe0, 0xe0, 0x3f, 0xf8, 0x3a, 0x4f,
    0xfb, 0x20, 0x38, 0xe0, 0x3c, 0x5b, 0xff, 0x88,
    0x1e, 0xa8, 0xf, 0xfe, 0x6b, 0x18, 0xf, 0xfe,
    0x51, 0xc0, 0xf, 0xad, 0x10, 0x3f, 0xe2, 0x49,
    0xcd, 0x84, 0x0,

    /* U+54 "T" */
    0x3f, 0xff, 0xf3, 0x50, 0x1f, 0xff, 0xf0, 0x3f,
    0xfa, 0xa7, 0x6f, 0xe4, 0x7, 0xb6, 0xfe, 0x40,
    0x9f, 0xe0, 0x3c, 0x4f, 0xf8, 0xf, 0xff, 0xf8,
    0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xff,
    0xc0, 0xff, 0xff, 0x81, 0x80,

    /* U+55 "U" */
    0x5f, 0xf8, 0x81, 0xff, 0xc1, 0x7f, 0xf8, 0xf,
    0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0,
    0x7f, 0xff, 0xc0, 0xff, 0xf6, 0x30, 0x3f, 0xf8,
    0x3c, 0xf, 0x98, 0x1e, 0xe0, 0x7f, 0xf0, 0x50,
    0x1f, 0x10, 0x3c, 0xaa, 0x20, 0x7c, 0x56, 0x20,
    0x71, 0x0, 0x40, 0xf2, 0xbb, 0xff, 0xb5, 0x20,
    0x79, 0x0, 0x40, 0x7f, 0xf3, 0x68, 0x8, 0x40,
    0xff, 0xe5, 0xb2, 0x5, 0x90, 0x1f, 0xfc, 0x99,
    0x0, 0x75, 0xcd, 0x10, 0x3f, 0xf8, 0x25, 0x4e,
    0xc0, 0xf8, 0xcb, 0xbf, 0xff, 0xe0, 0xea, 0xc0,
    0xe0,

    /* U+56 "V" */
    0x5f, 0xfb, 0x1, 0xff, 0xc4, 0xbf, 0xfa, 0x22,
    0x7, 0x14, 0x7, 0xff, 0x8, 0xa0, 0x3d, 0x7,
    0x3, 0xd4, 0xf, 0xfe, 0x14, 0x3, 0xd0, 0x1,
    0x40, 0x79, 0x81, 0xff, 0xc0, 0x48, 0x7, 0x16,
    0x5, 0x0, 0xf4, 0x3, 0xff, 0x81, 0x0, 0xf4,
    0x3, 0x16, 0x7, 0x98, 0x1f, 0xe6, 0x40, 0xe4,
    0x80, 0x74, 0x3, 0xd0, 0xf, 0xf4, 0x3, 0xd0,
    0xf, 0x98, 0x1e, 0x80, 0x7e, 0x60, 0x79, 0x10,
    0x3e, 0x80, 0x79, 0x81, 0xfa, 0x1, 0xea, 0x7,
    0xf4, 0x3, 0xd0, 0xf, 0x40, 0x3c, 0xc0, 0xff,
    0x32, 0x7, 0x32, 0x7, 0x30, 0x3d, 0x0, 0xff,
    0xa0, 0x1e, 0x80, 0x6a, 0x7, 0xa0, 0x1f, 0xfc,
    0x4, 0x40, 0xe4, 0x40, 0x14, 0x7, 0x16, 0x7,
    0xff, 0x6, 0x1, 0xe8, 0x2, 0x1, 0xe8, 0x7,
    0xff, 0x9, 0x20, 0x1c, 0x96, 0x3, 0x92, 0x1,
    0xff, 0xc3, 0x80, 0x7a, 0x40, 0x1e, 0x80, 0x7f,
    0xf1, 0xa, 0x3, 0x89, 0x1, 0xcc, 0x81, 0xff,
    0xc5, 0x80, 0x7f, 0xf0, 0x20, 0x1f, 0xfc, 0x62,
    0xc0, 0xff, 0x40, 0x3f, 0xf9, 0x10, 0xf, 0xe2,
    0xc0, 0xff, 0xe4, 0xc0, 0x3f, 0x40, 0x3f, 0xe0,

    /* U+57 "W" */
    0x1f, 0xfa, 0x81, 0xff, 0x7f, 0xf8, 0x81, 0xfe,
    0x7f, 0xf8, 0x86, 0x7, 0x20, 0x3f, 0xc8, 0xf,
    0xd4, 0xf, 0xf5, 0x3, 0x91, 0x10, 0xf, 0x30,
    0x3f, 0xb8, 0x1f, 0x90, 0x1f, 0xc8, 0x81, 0xdc,
    0x9, 0x1, 0xd4, 0xf, 0xe4, 0x7, 0xe2, 0x40,
    0x7e, 0xe0, 0x79, 0x1, 0x70, 0x38, 0x90, 0x1f,
    0x20, 0x3f, 0xd4, 0xf, 0xc8, 0xe, 0x80, 0x64,
    0x40, 0xea, 0x7, 0xdc, 0xf, 0xf2, 0x3, 0xe6,
    0x7, 0x98, 0x1d, 0x40, 0xe6, 0x7, 0xc8, 0xe,
    0x40, 0x62, 0x40, 0x7a, 0x81, 0xc8, 0xf, 0x30,
    0x3c, 0xc0, 0xe6, 0x7, 0x3c, 0x7, 0x50, 0x38,
    0x90, 0x1d, 0x0, 0xf9, 0x1, 0xd4, 0xe, 0xc0,
    0x75, 0x60, 0x72, 0x3, 0xa0, 0x1c, 0x48, 0xf,
    0xa0, 0x1c, 0x48, 0xc, 0x80, 0xe2, 0x8, 0x18,
    0x90, 0x19, 0x1, 0xd0, 0xf, 0xc4, 0x80, 0xea,
    0x4, 0xc0, 0xe6, 0x2, 0x81, 0xd4, 0x9, 0x81,
    0xe4, 0x7, 0xf5, 0x3, 0x98, 0x15, 0x3, 0xa8,
    0x4, 0x7, 0x20, 0x2a, 0x7, 0x30, 0x3f, 0xcc,
    0xf, 0x20, 0x48, 0xe, 0x20, 0x9, 0x1, 0x89,
    0x2, 0x40, 0x74, 0x3, 0xfe, 0x60, 0x77, 0x8,
    0xe, 0x60, 0x64, 0x7, 0x51, 0x0, 0xe4, 0x7,
    0xff, 0x2, 0x81, 0xc8, 0x50, 0x3b, 0x1, 0xa8,
    0x1c, 0x82, 0x3, 0xb8, 0x1f, 0xfc, 0x2, 0x40,
    0x75, 0x20, 0x72, 0x3, 0x10, 0x38, 0xd0, 0x38,
    0xa0, 0x3f, 0xf8, 0x30, 0xe, 0x40, 0x73, 0x3,
    0xcc, 0xe, 0x40, 0x75, 0x3, 0xff, 0x84, 0x80,
    0xff, 0xb0, 0x1e, 0xc0, 0x7f, 0xcc, 0xf, 0xfe,
    0x1b, 0x3, 0xfc, 0x80, 0xf2, 0x3, 0xfc, 0xc0,
    0xff, 0xe2, 0x50, 0x3f, 0x98, 0x1f, 0x90, 0x1f,
    0xd4, 0xf, 0xfe, 0x21, 0x40, 0x7e, 0xc0, 0x7e,
    0xe0, 0x7e, 0x44, 0xf, 0xc0,

    /* U+58 "X" */
    0x7, 0xff, 0xcc, 0xf, 0xfe, 0x5, 0xff, 0xea,
    0x0, 0xe0, 0x3e, 0x88, 0xf, 0xf4, 0x40, 0x79,
    0x50, 0x23, 0x40, 0xfa, 0xa0, 0x3f, 0x46, 0x7,
    0x95, 0x3, 0x95, 0x3, 0xea, 0x40, 0xf3, 0x60,
    0x3c, 0xa8, 0x1f, 0x2a, 0x7, 0xd8, 0x81, 0x9c,
    0x3, 0xc6, 0x81, 0xfc, 0xa8, 0x1f, 0x60, 0x25,
    0x0, 0xf1, 0xc0, 0x7f, 0xca, 0x1, 0xf6, 0xa,
    0x81, 0xe3, 0x80, 0xff, 0xe0, 0xb8, 0x7, 0x8e,
    0xa0, 0x78, 0xe0, 0x3f, 0xf8, 0x6e, 0x1, 0xe2,
    0x7, 0x8e, 0x3, 0xff, 0x8a, 0xd8, 0xf, 0xfe,
    0x6, 0x3, 0xff, 0x8f, 0x8, 0x1f, 0xea, 0x7,
    0xff, 0x22, 0x10, 0x3f, 0xd4, 0x81, 0xff, 0xc6,
    0x8c, 0xf, 0xfe, 0x6, 0x40, 0x7f, 0xf1, 0x23,
    0x3, 0xc4, 0xf, 0xaa, 0x3, 0xff, 0x85, 0x18,
    0x1e, 0x3b, 0x0, 0xfa, 0xa0, 0x3f, 0xf8, 0x11,
    0x81, 0xe3, 0x81, 0xa0, 0x7d, 0x50, 0x1f, 0xe8,
    0xc0, 0xf1, 0xc0, 0x4a, 0x81, 0xf5, 0x40, 0x7e,
    0x8c, 0xf, 0x1c, 0x7, 0x2a, 0x7, 0xd5, 0x1,
    0xe8, 0xc0, 0xfb, 0x1, 0xf2, 0x80, 0x7d, 0x50,
    0x1a, 0x30, 0x3e, 0xc0, 0x7f, 0x38, 0x7, 0xd5,
    0x0, 0x8c, 0xf, 0xb1, 0x3, 0xfc, 0xe0, 0x1f,
    0x54,

    /* U+59 "Y" */
    0x3f, 0xfe, 0x20, 0x7f, 0xf0, 0x17, 0xff, 0x50,
    0x68, 0x1f, 0x60, 0x3f, 0xe3, 0x40, 0xf1, 0xa0,
    0x15, 0x3, 0xec, 0x7, 0xfb, 0x1, 0xf6, 0x3,
    0x28, 0x7, 0x8c, 0x3, 0xf6, 0x3, 0xec, 0x7,
    0x9b, 0x1, 0xe6, 0xc0, 0x7a, 0x90, 0x3d, 0x48,
    0x1f, 0x44, 0x7, 0xa2, 0x3, 0x34, 0x7, 0xaa,
    0x3, 0xfa, 0x90, 0x3d, 0x48, 0x5, 0x0, 0xf4,
    0x40, 0x7f, 0xd8, 0x81, 0xee, 0xd, 0x3, 0xcd,
    0x80, 0xff, 0xe0, 0xe0, 0x3c, 0x77, 0x3, 0xca,
    0x1, 0xff, 0xc3, 0xc0, 0x78, 0x90, 0x1c, 0x68,
    0x1f, 0xfc, 0x43, 0x40, 0xff, 0xe0, 0x60, 0x3f,
    0xf8, 0xca, 0x81, 0xfe, 0xc0, 0x7f, 0xf2, 0x14,
    0x3, 0xf5, 0x20, 0x7f, 0xf2, 0x5b, 0x1, 0xe8,
    0x80, 0xff, 0xe5, 0xf0, 0x3c, 0x80, 0xff, 0xff,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xd4,

    /* U+5A "Z" */
    0x1b, 0xff, 0xfe, 0x63, 0x3, 0xff, 0xfe, 0x7,
    0xc8, 0x9f, 0xfe, 0x18, 0x1f, 0xf4, 0xdb, 0xff,
    0x83, 0xc8, 0x1f, 0xa3, 0x3, 0xff, 0x85, 0x30,
    0x1f, 0x1c, 0xc0, 0xff, 0xe0, 0x9c, 0xc0, 0xf9,
    0xe2, 0x7, 0xff, 0x5, 0xe2, 0x7, 0xd6, 0x1,
    0xff, 0xc2, 0xb0, 0xf, 0x97, 0x40, 0x7f, 0xf0,
    0x57, 0x40, 0x7d, 0x68, 0xf, 0xfe, 0x14, 0xa0,
    0x7c, 0x7a, 0x3, 0xff, 0x82, 0x73, 0x3, 0xe9,
    0x80, 0xff, 0xe1, 0x3c, 0x40, 0xf1, 0xcc, 0xf,
    0xfe, 0x15, 0x80, 0x7c, 0xf1, 0x3, 0xff, 0x82,
    0xba, 0x3, 0xeb, 0x0, 0xff, 0xe1, 0x1a, 0x7,
    0xe3, 0x36, 0xff, 0xe1, 0x40, 0x3f, 0xc4, 0xff,
    0xf1, 0x40, 0xff, 0xff, 0x81, 0xe0,

    /* U+5B "[" */
    0x3f, 0xff, 0x88, 0x1f, 0xfd, 0xe9, 0xb6, 0x20,
    0x79, 0x13, 0x80, 0xff, 0xff, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xe2, 0x89, 0xc0, 0x7d, 0x36, 0xc4,
    0xf, 0xfe, 0xc0,

    /* U+5C "\\" */
    0x9f, 0xe0, 0x3f, 0xf9, 0x71, 0x1, 0x60, 0x3f,
    0xf9, 0x74, 0x80, 0x34, 0xf, 0xfe, 0x5e, 0x2,
    0x50, 0xf, 0xfe, 0x5e, 0x2, 0x6c, 0x7, 0xff,
    0x28, 0xd0, 0x28, 0x80, 0xff, 0xe5, 0x28, 0x5,
    0x48, 0x1f, 0xfc, 0xa6, 0xc0, 0x5c, 0xf, 0xfe,
    0x5c, 0x40, 0xe, 0x3, 0xff, 0x97, 0x48, 0x3,
    0x40, 0xff, 0xe5, 0xf0, 0x25, 0x0, 0xff, 0xe5,
    0x1c, 0x4, 0xd0, 0x1f, 0xfc, 0xa3, 0x40, 0xa9,
    0x3, 0xff, 0x94, 0xa0, 0x16, 0x20, 0x7f, 0xf2,
    0x9a, 0x2, 0xe0, 0x7f, 0xf2, 0xe9, 0x0, 0x70,
    0x1f, 0xfc, 0xbc, 0x40, 0x1a, 0x7, 0xff, 0x2f,
    0x81, 0x26, 0x7, 0xff, 0x28, 0xd0, 0x28, 0x80,
    0xff, 0xe5, 0x28, 0x5, 0x48, 0x1f, 0xfc, 0xa6,
    0xc0, 0x58, 0x81, 0xff, 0xca, 0x88, 0xb, 0x81,
    0xff, 0xcb, 0xa4, 0x1, 0xa0, 0x7f, 0xf2, 0xf0,
    0x12, 0x80, 0x7f, 0xf2, 0xf0, 0x13, 0x60, 0x3f,
    0xf9, 0x46, 0x81, 0x44, 0x7, 0xff, 0x29, 0x40,
    0x2a, 0x40,

    /* U+5D "]" */
    0x9f, 0xff, 0x60, 0x3f, 0xfa, 0xb3, 0x6c, 0x80,
    0xf1, 0x38, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0,
    0x3f, 0xfc, 0x4, 0xe0, 0x3d, 0x36, 0xc8, 0xf,
    0xfe, 0xd0,

    /* U+5E "^" */
    0x3, 0x94, 0x99, 0x1, 0xfe, 0xad, 0xea, 0x7,
    0xf4, 0x3, 0xd0, 0xf, 0xcc, 0xf, 0x30, 0x3e,
    0x80, 0x4d, 0x80, 0xa0, 0x1e, 0x60, 0x52, 0x0,
    0x98, 0x1d, 0x0, 0x98, 0x6, 0x5, 0x0, 0xcc,
    0xa, 0x0, 0x80, 0x4c, 0x9, 0x81, 0x30, 0x33,
    0x2, 0x80, 0x20, 0x14, 0x3, 0x40, 0x26, 0x18,
    0x13, 0x3, 0xcc, 0xa, 0x0,

    /* U+5F "_" */
    0x6f, 0xff, 0x89, 0x27, 0xff, 0x10, 0xf, 0xfe,
    0xa0,

    /* U+60 "`" */
    0x0, 0x80, 0xfc, 0x6e, 0x40, 0x7a, 0x83, 0x72,
    0x3, 0x20, 0x23, 0x71, 0x1, 0xaa, 0x2, 0x38,
    0x80, 0x57, 0xd6, 0x9, 0x1, 0xca, 0x7e, 0x0,

    /* U+61 "a" */
    0x3, 0x3b, 0xbf, 0xfd, 0xab, 0x20, 0x67, 0xe2,
    0x20, 0x7e, 0x2a, 0x66, 0x0, 0xc0, 0x3f, 0xf8,
    0x91, 0xa, 0x7, 0x39, 0x39, 0x90, 0x3b, 0x8b,
    0xb7, 0x46, 0xfa, 0x62, 0x6, 0x60, 0x92, 0x9b,
    0x3f, 0xf5, 0x20, 0x71, 0x7, 0xc4, 0x7, 0xe5,
    0x80, 0xfb, 0x81, 0xff, 0xc1, 0x20, 0x71, 0x20,
    0x31, 0xdf, 0xfa, 0x1, 0xe6, 0x7, 0x72, 0x7,
    0x9a, 0x3, 0xfe, 0x60, 0x7e, 0x60, 0x73, 0x3,
    0xac, 0x69, 0x4d, 0xb1, 0x3, 0x88, 0x1e, 0x72,
    0xda, 0x41, 0x20, 0x3d, 0x40, 0xff, 0xe0, 0x34,
    0x7, 0x96, 0x68, 0x81, 0xe5, 0x60, 0x1e,

    /* U+62 "b" */
    0xbf, 0xec, 0x7, 0xff, 0xfc, 0xf, 0xff, 0x7b,
    0xbf, 0xfb, 0x44, 0x7, 0xf1, 0xf1, 0x1, 0xe2,
    0xee, 0x20, 0x7d, 0xc0, 0xff, 0xe0, 0x1e, 0x7,
    0x89, 0x1, 0xff, 0xc1, 0x28, 0xf, 0xa6, 0xff,
    0xa9, 0x3, 0xb0, 0x1e, 0x8c, 0x81, 0xcb, 0x1,
    0xc4, 0xf, 0x30, 0x3f, 0x88, 0x19, 0x81, 0xff,
    0xc4, 0x60, 0x7f, 0xf2, 0x58, 0x1f, 0xf2, 0x3,
    0xf8, 0x81, 0xff, 0x56, 0x40, 0xc5, 0xe0, 0x39,
    0x81, 0xf4, 0xdf, 0xed, 0x8, 0x1d, 0x80, 0xe2,
    0x40, 0x7f, 0xf0, 0x98, 0x1e, 0xe0, 0x7f, 0xf0,
    0xe, 0x3, 0xe3, 0xd9, 0x3, 0xc5, 0xdc, 0x40,

    /* U+63 "c" */
    0x3, 0x29, 0x77, 0xff, 0x6a, 0xc8, 0x1c, 0x7d,
    0x68, 0x81, 0xf1, 0x53, 0x40, 0x23, 0x80, 0xff,
    0xe2, 0x38, 0x2, 0x1, 0xff, 0xc6, 0x60, 0x10,
    0x1d, 0x37, 0xfd, 0x40, 0xf1, 0x20, 0x39, 0xb1,
    0x3, 0x95, 0x27, 0x80, 0xfb, 0x1, 0xf9, 0x6d,
    0xc5, 0x81, 0xff, 0xc9, 0x60, 0x7f, 0xf3, 0xf0,
    0x1f, 0x97, 0xfc, 0xc8, 0x1c, 0xd8, 0x81, 0xca,
    0x1, 0xc4, 0x20, 0x3a, 0x6f, 0xfa, 0x90, 0x39,
    0x8, 0x7, 0xff, 0x19, 0x80, 0x38, 0xf, 0xfe,
    0x23, 0x80, 0x47, 0xd6, 0x88, 0x1f, 0x15, 0x34,
    0x0,

    /* U+64 "d" */
    0x3, 0xff, 0x88, 0xff, 0xe0, 0x3f, 0xff, 0xe0,
    0x7f, 0xf8, 0x5d, 0xdf, 0xf6, 0x84, 0xf, 0xf3,
    0xf1, 0x10, 0x38, 0xbd, 0x0, 0xfc, 0xe0, 0x1f,
    0xfc, 0x7, 0x80, 0xfa, 0x81, 0xff, 0xc2, 0x40,
    0x7c, 0x40, 0xe9, 0xbf, 0xec, 0xc0, 0xf8, 0x81,
    0xcd, 0x88, 0x1c, 0x62, 0x3, 0xcc, 0xe, 0xc0,
    0x7f, 0x60, 0x3f, 0xf9, 0x44, 0xf, 0xfe, 0x51,
    0x3, 0xcc, 0xe, 0xc0, 0x7f, 0x60, 0x3f, 0xf8,
    0xd, 0x88, 0x18, 0xa8, 0x80, 0xf1, 0x3, 0xd3,
    0x7f, 0xb5, 0x60, 0x7e, 0x80, 0x7f, 0xf0, 0x98,
    0x1f, 0x36, 0x3, 0xff, 0x81, 0x30, 0x1f, 0xa6,
    0x88, 0x81, 0xc5, 0x66, 0x7, 0xc0,

    /* U+65 "e" */
    0x3, 0x3b, 0xbf, 0xfe, 0xac, 0xe, 0x5e, 0x22,
    0x7, 0xf2, 0x9d, 0x0, 0x34, 0xf, 0xfe, 0x25,
    0x1, 0x0, 0xe7, 0x2d, 0xe6, 0x7, 0x30, 0x80,
    0xd2, 0x1a, 0x5d, 0x10, 0x1b, 0x10, 0x3a, 0x7f,
    0xf9, 0x1, 0x9b, 0x1, 0xff, 0xe3, 0xbf, 0xff,
    0xf0, 0x73, 0x3, 0xff, 0x86, 0x4f, 0x80, 0xee,
    0x7, 0xeb, 0xb6, 0xe1, 0x1, 0x96, 0x69, 0x75,
    0x40, 0x64, 0x20, 0x1c, 0x65, 0xbc, 0x80, 0xea,
    0xd, 0x3, 0xff, 0x89, 0x48, 0x5, 0xe2, 0x24,
    0x7, 0xc5, 0x4e, 0x80,

    /* U+66 "f" */
    0x3, 0xd3, 0x7f, 0xe2, 0x6, 0x5d, 0x90, 0x3f,
    0xea, 0x7, 0xff, 0x5, 0x1, 0xe4, 0x8d, 0x88,
    0x11, 0x3, 0xad, 0xa4, 0x1, 0xb8, 0x1c, 0x80,
    0xe9, 0xf9, 0x81, 0xdf, 0xf4, 0x3, 0xff, 0xa5,
    0x92, 0x10, 0x39, 0x2e, 0xca, 0xd2, 0x3, 0xad,
    0xe4, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8,

    /* U+67 "g" */
    0x3, 0x3b, 0xbf, 0xf6, 0x61, 0x7f, 0xc0, 0x4f,
    0xc4, 0x40, 0xf1, 0x94, 0xf, 0xce, 0x1, 0xff,
    0xc0, 0x58, 0xf, 0xa8, 0x1f, 0xfc, 0x26, 0x7,
    0xc4, 0xe, 0x9b, 0xfe, 0xcc, 0xf, 0x88, 0x1c,
    0xd8, 0x81, 0xc6, 0x20, 0x3c, 0xc0, 0xec, 0x7,
    0xf6, 0x3, 0xff, 0xc3, 0xc0, 0xf3, 0x3, 0xb0,
    0x1f, 0xc8, 0xf, 0x10, 0x39, 0xb1, 0x3, 0x15,
    0x8, 0x1f, 0x20, 0x3a, 0x6f, 0xf6, 0xac, 0xf,
    0xdc, 0xf, 0xfe, 0x12, 0x3, 0xe5, 0x0, 0xff,
    0xe0, 0x3e, 0x7, 0xe7, 0xe2, 0x20, 0x71, 0x56,
    0x1, 0xff, 0x3b, 0xbf, 0xed, 0x50, 0x1f, 0xc9,
    0xbc, 0x80, 0xfe, 0xc0, 0x7d, 0xa4, 0xd5, 0x81,
    0xf3, 0x60, 0x31, 0x1, 0x80, 0xe9, 0xf6, 0xef,
    0x0, 0xea, 0x1, 0x10, 0x3c, 0x4f, 0x1, 0xe2,
    0xc0, 0xb1, 0x3, 0xff, 0x86, 0xf0, 0x1d, 0xab,
    0x20, 0x7c, 0x49, 0x4f, 0x0, 0x80,

    /* U+68 "h" */
    0xbf, 0xec, 0x7, 0xff, 0xfc, 0xf, 0xff, 0x41,
    0x9b, 0xfd, 0xab, 0x3, 0xfc, 0x73, 0x20, 0x62,
    0xa7, 0x60, 0x7e, 0xe0, 0x7f, 0xd1, 0x81, 0xe2,
    0x40, 0x7f, 0xf0, 0x20, 0x1f, 0x9d, 0xdb, 0x40,
    0x3c, 0x80, 0xf4, 0x84, 0x4e, 0x78, 0xe, 0xc0,
    0x79, 0x81, 0xf1, 0x3, 0xff, 0x92, 0x40, 0xc4,
    0xe, 0x20, 0x7f, 0xff, 0xc0, 0xff, 0xfb, 0x0,

    /* U+69 "i" */
    0xbf, 0xec, 0x7, 0xff, 0x0, 0x81, 0xd3, 0xfd,
    0x80, 0xf5, 0xff, 0x60, 0x3f, 0xff, 0xe0, 0x7f,
    0x0,

    /* U+6A "j" */
    0x0, 0xbf, 0xe2, 0x7, 0xff, 0x45, 0x7f, 0xc4,
    0xf, 0xf9, 0x7f, 0xc4, 0xf, 0xff, 0x91, 0x3,
    0xff, 0xea, 0x40, 0xfd, 0xc0, 0xf4, 0xac, 0xf,
    0x34, 0x7, 0x10, 0x3f, 0x40, 0x40, 0x8b, 0xc8,
    0x0,

    /* U+6B "k" */
    0xbf, 0xec, 0x7, 0xff, 0xfc, 0xf, 0xff, 0x61,
    0xff, 0xe2, 0x7, 0xfc, 0x70, 0x1e, 0xc4, 0xf,
    0xf1, 0xc0, 0x71, 0xc4, 0xf, 0xf1, 0xc0, 0x71,
    0xc4, 0xf, 0xf1, 0xc0, 0x71, 0xc0, 0x7f, 0x8e,
    0xc0, 0x39, 0x60, 0x3f, 0xf8, 0x4, 0xe, 0x54,
    0xf, 0xfe, 0x3e, 0x3, 0xff, 0x91, 0x20, 0xf,
    0xfe, 0x1, 0xf8, 0xe, 0x74, 0xf, 0xfe, 0x9,
    0xc0, 0x72, 0xc0, 0x7f, 0xf0, 0x4e, 0x3, 0x8e,
    0x3, 0xff, 0x82, 0x70, 0x1c, 0x79, 0x3, 0xff,
    0x80, 0x70, 0x1e, 0xc8, 0xf, 0xfe, 0x1, 0xc0,
    0x7a, 0xa0,

    /* U+6C "l" */
    0xbf, 0xec, 0x7, 0xff, 0xfc, 0xf, 0xff, 0x8,

    /* U+6D "m" */
    0xbf, 0xea, 0xc, 0xdf, 0xed, 0x8, 0x19, 0xdf,
    0xfa, 0xb2, 0x7, 0xf2, 0xcc, 0x81, 0x8b, 0xd0,
    0x6, 0x88, 0xe, 0x53, 0x40, 0x3f, 0x50, 0x3f,
    0xce, 0x52, 0x7, 0xf9, 0xb0, 0x1e, 0x40, 0x7f,
    0xf0, 0x1a, 0x3, 0xff, 0x81, 0x0, 0xfc, 0xed,
    0x6b, 0x0, 0xfc, 0xed, 0x6a, 0xc0, 0xf2, 0x3,
    0xd2, 0x12, 0x14, 0xf0, 0x1e, 0xb1, 0x21, 0x52,
    0x81, 0xd8, 0xf, 0x30, 0x3c, 0x48, 0xe, 0x40,
    0x79, 0x1, 0xff, 0x10, 0x3f, 0xf8, 0x24, 0xf,
    0xfe, 0x9, 0x3, 0xff, 0x8e, 0xc0, 0xff, 0xff,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xf0,

    /* U+6E "n" */
    0xbf, 0xea, 0x1, 0xdf, 0xfa, 0xc2, 0x7, 0xf1,
    0xf1, 0x1, 0xc9, 0xe8, 0x7, 0xee, 0x7, 0xfc,
    0xe0, 0x1e, 0x44, 0xf, 0xfe, 0x3, 0x3, 0xf2,
    0x97, 0x65, 0x60, 0x79, 0x1, 0xe7, 0x5a, 0x24,
    0xa5, 0x3, 0xb0, 0x1e, 0x80, 0x7c, 0x80, 0xff,
    0xe4, 0x90, 0x31, 0x3, 0x88, 0x1f, 0xff, 0xf0,
    0x3f, 0xfe, 0xc0,

    /* U+6F "o" */
    0x3, 0x3b, 0xbf, 0xfd, 0xb2, 0x30, 0x3d, 0x3c,
    0x44, 0xf, 0xc4, 0x9c, 0xec, 0x9, 0xb0, 0x1f,
    0xfc, 0x58, 0x80, 0x40, 0x3f, 0xf8, 0xfc, 0xf,
    0xd3, 0x7f, 0xd9, 0x81, 0xcc, 0x10, 0x39, 0xb1,
    0x3, 0x8c, 0x20, 0x62, 0x18, 0x1d, 0x80, 0xfe,
    0x40, 0x7f, 0xf0, 0x18, 0x1f, 0xfc, 0xa6, 0x7,
    0xff, 0x28, 0x81, 0xfc, 0x80, 0xf3, 0x3, 0xa3,
    0x20, 0x71, 0x84, 0xc, 0x41, 0x3, 0xd3, 0x7f,
    0xd9, 0x81, 0xcc, 0x4, 0x3, 0xff, 0x8f, 0x0,
    0x36, 0x3, 0xff, 0x8b, 0x48, 0x14, 0xf1, 0x12,
    0x3, 0xf1, 0x77, 0xa0, 0x0,

    /* U+70 "p" */
    0xbf, 0xec, 0xd, 0xdf, 0xf6, 0xb0, 0x81, 0xfc,
    0x72, 0x20, 0x71, 0x4f, 0x61, 0x3, 0xee, 0x7,
    0xff, 0x0, 0xe0, 0x3c, 0x48, 0xf, 0xfe, 0x12,
    0x3, 0xc6, 0xef, 0xfa, 0x90, 0x3b, 0x1, 0xee,
    0x88, 0x1c, 0xb8, 0x1c, 0x40, 0xf1, 0x3, 0xf1,
    0x3, 0x98, 0x1f, 0xfe, 0x62, 0x7, 0xe2, 0x7,
    0x30, 0x3d, 0xd9, 0x20, 0x22, 0xb8, 0x1c, 0x40,
    0xf1, 0x9b, 0x3f, 0xb5, 0x20, 0x76, 0x3, 0x88,
    0x1f, 0xfc, 0x22, 0x80, 0xf5, 0x3, 0xff, 0x80,
    0x78, 0x1f, 0x2c, 0xc8, 0x1c, 0x53, 0xb8, 0x81,
    0xf8, 0xcd, 0xff, 0x6b, 0x10, 0x1f, 0xff, 0xf0,
    0x3f, 0xfb, 0x40,

    /* U+71 "q" */
    0x3, 0x3b, 0xbf, 0xed, 0x58, 0x5f, 0xf0, 0x9,
    0xe2, 0x20, 0x71, 0x52, 0x81, 0xf3, 0x60, 0x3f,
    0xf8, 0xb, 0x1, 0xea, 0x7, 0xff, 0x9, 0x81,
    0xe2, 0x7, 0x3d, 0xff, 0x64, 0x7, 0x88, 0x1c,
    0xa1, 0x3, 0x8d, 0x3, 0xcc, 0xe, 0xe0, 0x7f,
    0x20, 0x3f, 0xf9, 0x24, 0xf, 0xfe, 0x7b, 0x3,
    0xb0, 0x1f, 0xc8, 0xf, 0xf9, 0xb1, 0x3, 0x8c,
    0x20, 0x71, 0x3, 0xd3, 0x7f, 0xd9, 0x81, 0xf4,
    0x3, 0xff, 0x84, 0x40, 0xf3, 0x60, 0x3f, 0xf8,
    0x11, 0x1, 0xf4, 0xcc, 0x81, 0xe2, 0xf3, 0x3,
    0xf8, 0xcd, 0xff, 0xb4, 0x20, 0x7f, 0xff, 0xc0,
    0xff, 0xef, 0x0,

    /* U+72 "r" */
    0xbf, 0xea, 0xc, 0xdf, 0xda, 0xa0, 0x3f, 0x2c,
    0xc8, 0x11, 0x56, 0x1, 0xf5, 0x3, 0xf9, 0x90,
    0x39, 0x1, 0xff, 0x20, 0x3e, 0x56, 0xc8, 0xe,
    0xc0, 0x7a, 0x54, 0xaa, 0x80, 0xff, 0x98, 0x1d,
    0x89, 0xe0, 0x3f, 0xf8, 0xf, 0x6d, 0x0, 0xe2,
    0x7, 0xff, 0xfc, 0xf, 0xff, 0x8,

    /* U+73 "s" */
    0x2, 0x73, 0x67, 0xff, 0xb5, 0x84, 0xc, 0x7c,
    0x64, 0x80, 0xfc, 0x53, 0xd0, 0xb, 0x81, 0xff,
    0xc5, 0x64, 0x1, 0x3, 0x9c, 0xb7, 0x42, 0x7,
    0x20, 0x40, 0xe7, 0x1a, 0x59, 0xe9, 0x39, 0x1,
    0xf3, 0xfb, 0x7d, 0x77, 0xc, 0x82, 0x7, 0xc4,
    0xfe, 0x4e, 0x72, 0x2, 0x81, 0xff, 0xc6, 0xe0,
    0x17, 0x68, 0x81, 0xff, 0xc2, 0x24, 0x5, 0x2e,
    0xff, 0xf9, 0x1, 0xcd, 0x7f, 0xcc, 0xf, 0xdc,
    0xf, 0x30, 0x3a, 0x56, 0x96, 0x72, 0x81, 0xcc,
    0x81, 0xe5, 0x2d, 0xd1, 0x81, 0xc4, 0x85, 0x3,
    0xff, 0x8a, 0x78, 0x5, 0x91, 0x3, 0xfc, 0x53,
    0xb8, 0x80,

    /* U+74 "t" */
    0x2, 0x72, 0x64, 0x7, 0xff, 0x2, 0x37, 0xb8,
    0x1f, 0xfe, 0x1b, 0xf8, 0xe, 0x5f, 0xfe, 0xa0,
    0x7f, 0xf6, 0x32, 0x40, 0x3c, 0x97, 0xec, 0xed,
    0x1, 0xca, 0xdf, 0xcc, 0xf, 0xff, 0xba, 0xb6,
    0x60, 0x7e, 0x60, 0x6c, 0x95, 0x80, 0x88, 0x18,
    0xa0, 0x24, 0x7, 0xcc, 0xe, 0xbf, 0xc4, 0x8,
    0x81, 0x70, 0x3f, 0xf8, 0x38, 0x9, 0x30, 0x3f,
    0xe4, 0x80, 0x69, 0x99, 0x3, 0x8a, 0xb4, 0x0,

    /* U+75 "u" */
    0xbf, 0xec, 0x7, 0xf6, 0xff, 0x50, 0x3f, 0xff,
    0xe0, 0x7f, 0xfd, 0x88, 0x1c, 0x40, 0xc4, 0xf,
    0xfe, 0x4a, 0x3, 0xe8, 0x7, 0xb8, 0x1d, 0x62,
    0x24, 0x9d, 0x60, 0x79, 0x81, 0xe7, 0x76, 0x58,
    0x80, 0xfc, 0xc0, 0xff, 0xe0, 0x14, 0x7, 0xa3,
    0x3, 0xfe, 0xe0, 0x7e, 0x99, 0xa0, 0x39, 0x4e,
    0x40, 0xf0,

    /* U+76 "v" */
    0x1f, 0xf8, 0x81, 0xfa, 0xff, 0xcc, 0x30, 0x3a,
    0x1, 0xf1, 0x40, 0x73, 0x10, 0xe, 0x40, 0x7d,
    0x40, 0xe6, 0x4, 0xc0, 0xe8, 0x7, 0x98, 0x1d,
    0x0, 0xa0, 0x1c, 0xc0, 0xe6, 0x7, 0x30, 0x39,
    0x81, 0xcc, 0xd, 0x40, 0xe8, 0x7, 0x40, 0x3a,
    0x81, 0x22, 0x6, 0x60, 0x7c, 0xc0, 0xc5, 0x0,
    0x80, 0x74, 0x3, 0xe8, 0x7, 0x70, 0x48, 0xc,
    0xc0, 0xfe, 0x60, 0x64, 0x60, 0x1d, 0x0, 0xfe,
    0x80, 0x74, 0x40, 0x66, 0x7, 0xfc, 0xc0, 0xc8,
    0xe, 0x80, 0x7f, 0xd4, 0xf, 0xe6, 0x7, 0xff,
    0x0, 0xb0, 0x3f, 0x50, 0x3f, 0xf8, 0x34, 0xf,
    0x91, 0x3, 0xc0,

    /* U+77 "w" */
    0xdf, 0xf0, 0x1f, 0x5f, 0xf8, 0xf, 0xaf, 0xfc,
    0x68, 0x1c, 0xc0, 0xf2, 0x3, 0x90, 0x1e, 0x40,
    0x62, 0x4c, 0xe, 0xc0, 0x73, 0x3, 0xdc, 0xe,
    0x40, 0x75, 0x0, 0x80, 0xc8, 0xe, 0xa0, 0x79,
    0x1, 0xdc, 0xe, 0x60, 0x38, 0x1c, 0x80, 0x89,
    0x1, 0xf3, 0x3, 0x20, 0x32, 0x2, 0x40, 0x77,
    0x2, 0x40, 0x7e, 0xa0, 0x48, 0xe, 0xe0, 0x66,
    0x6, 0x40, 0x54, 0xc, 0x40, 0x89, 0x0, 0xc0,
    0x72, 0x3, 0x50, 0x38, 0x82, 0x40, 0x4a, 0x1,
    0xa8, 0x6, 0x6, 0x60, 0x71, 0x20, 0x35, 0x14,
    0xd, 0xd0, 0x19, 0x82, 0x7, 0x50, 0x3d, 0x40,
    0xc8, 0x30, 0x32, 0x8, 0xc, 0xa8, 0x18, 0x90,
    0x1e, 0x60, 0x63, 0x0, 0xc8, 0x7, 0x3, 0x76,
    0x6, 0xa0, 0x7e, 0x40, 0x66, 0x6, 0xe0, 0x10,
    0x19, 0x1, 0xc8, 0xf, 0xdc, 0xf, 0xe4, 0x4,
    0x80, 0xfc, 0x48, 0xf, 0xc8, 0xf, 0xc8, 0xd,
    0xc0, 0xfd, 0x40, 0xff, 0x30, 0x3e, 0xe0, 0x64,
    0x7, 0xe6, 0x7, 0x0,

    /* U+78 "x" */
    0x7, 0xff, 0x80, 0xe7, 0xff, 0xa0, 0x3, 0x40,
    0xf5, 0x2, 0x50, 0xe, 0x50, 0x9, 0x40, 0x39,
    0x30, 0x14, 0xe, 0x34, 0xe, 0x6c, 0x7, 0x43,
    0x80, 0xe3, 0x80, 0xfa, 0x20, 0x3b, 0x10, 0x3b,
    0x81, 0xfd, 0x48, 0x1f, 0xec, 0x40, 0xff, 0x70,
    0x3f, 0xa9, 0x3, 0xfe, 0x24, 0x7, 0xe2, 0x7,
    0xff, 0x2, 0x10, 0x3f, 0x44, 0x7, 0xf9, 0xb0,
    0x1f, 0xea, 0x40, 0xfc, 0xa0, 0x1d, 0xd0, 0x1d,
    0xc0, 0xf8, 0xd0, 0x3a, 0x8a, 0x7, 0x1a, 0x7,
    0xb0, 0x1c, 0xd0, 0xa, 0x7, 0x28, 0x6, 0xc0,
    0x71, 0x80, 0x49, 0x81, 0xcd, 0x0, 0xa4, 0xe,
    0xe0, 0x74, 0x20, 0x75, 0x20,

    /* U+79 "y" */
    0x1f, 0xf8, 0xf, 0xc7, 0xff, 0x0, 0x60, 0x73,
    0x3, 0xea, 0x7, 0x30, 0x14, 0xe, 0xa0, 0x7c,
    0xc0, 0xe8, 0x0, 0xa0, 0x31, 0x20, 0x39, 0x81,
    0xcc, 0xd, 0x0, 0xe8, 0x7, 0x40, 0x3a, 0x1,
    0x89, 0x1, 0x90, 0x19, 0x1, 0xcc, 0xf, 0x40,
    0x39, 0x81, 0x40, 0x3a, 0x81, 0xe4, 0x40, 0xd4,
    0x1, 0x20, 0x32, 0x20, 0x7d, 0x40, 0xc4, 0x84,
    0x3, 0xa0, 0x1f, 0x98, 0x1d, 0x42, 0x3, 0x22,
    0x7, 0xf3, 0x3, 0x38, 0x7, 0x40, 0x3f, 0xd0,
    0xe, 0x60, 0x62, 0x40, 0x7f, 0xc8, 0xf, 0xe8,
    0x7, 0xff, 0x2, 0x1, 0xf8, 0xa0, 0x3f, 0xf8,
    0x5, 0x1, 0xf4, 0x3, 0xff, 0x85, 0x7d, 0x3,
    0x14, 0x7, 0xff, 0x12, 0x1, 0xa8, 0x1f, 0xfc,
    0x33, 0x48, 0x19, 0x81, 0xff, 0xc1, 0xdf, 0x20,
    0x34, 0x3, 0xff, 0x94, 0xc0, 0xff, 0xe4, 0xe0,
    0x3f, 0xf8, 0x69, 0x67, 0x39, 0x3, 0xfc,

    /* U+7A "z" */
    0x1b, 0xff, 0xfe, 0x22, 0x3, 0xff, 0xb6, 0x97,
    0xf0, 0x1f, 0xe9, 0x6f, 0xc0, 0x7e, 0x48, 0x7,
    0xc7, 0x20, 0x3d, 0x28, 0x1f, 0x2c, 0x40, 0xf5,
    0x60, 0x7d, 0x28, 0x1e, 0x5d, 0x1, 0xf6, 0x60,
    0x79, 0xd0, 0x3e, 0x5c, 0x81, 0xeb, 0x0, 0xf9,
    0xd0, 0x3c, 0x7a, 0x3, 0xe7, 0x0, 0xf9, 0xdb,
    0xf9, 0xf0, 0x3f, 0x25, 0xfd, 0x80, 0xff, 0xed,
    0x0,

    /* U+7B "{" */
    0x2, 0x37, 0xfe, 0x60, 0x16, 0x40, 0x7e, 0xe0,
    0x7f, 0x90, 0x1f, 0xfc, 0x33, 0x73, 0x3, 0xea,
    0x88, 0x1f, 0xfe, 0x24, 0x7, 0x10, 0x25, 0x40,
    0xe6, 0x5, 0x0, 0xe2, 0x40, 0x7e, 0x3c, 0xf,
    0xfe, 0x41, 0xe0, 0x6c, 0x80, 0xc4, 0x80, 0xd0,
    0xe, 0x60, 0x62, 0x7, 0x10, 0x3f, 0xfd, 0x55,
    0x20, 0x1f, 0x8d, 0xa6, 0x0, 0x81, 0xfe, 0x80,
    0x7f, 0x96, 0x40, 0x78,

    /* U+7C "|" */
    0x1f, 0xf8, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0,
    0x3f, 0xfd, 0x1b, 0x78, 0x0,

    /* U+7D "}" */
    0x9f, 0xed, 0x48, 0x1f, 0x8a, 0xc4, 0xf, 0xf4,
    0x3, 0xfc, 0x80, 0x4d, 0x40, 0xfe, 0x29, 0x81,
    0xfe, 0xe0, 0x7f, 0xf9, 0x48, 0x18, 0x81, 0xdd,
    0x1, 0x20, 0x38, 0xf0, 0x36, 0x3, 0xff, 0x93,
    0x80, 0xfe, 0x40, 0x72, 0xa0, 0x44, 0xe, 0x80,
    0x7f, 0x88, 0x1f, 0xfd, 0x9e, 0x7, 0xe2, 0xd8,
    0xf, 0xa6, 0x80, 0x7f, 0xf1, 0x10, 0x1f, 0xe8,
    0x7, 0xe5, 0x88, 0x0,

    /* U+7E "~" */
    0x3, 0xff, 0x90, 0xf7, 0xea, 0xc8, 0x12, 0xcc,
    0xa, 0x41, 0x0, 0xa6, 0xcb, 0xa9, 0x84, 0x26,
    0x7, 0xc5, 0x10, 0xc, 0x88, 0x0, 0xa2, 0x7,
    0xc6, 0x0, 0x41, 0x6b, 0xbd, 0x44, 0x19, 0x80,
    0xa6, 0xa0, 0x65, 0x77, 0xcc, 0x8
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 128, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 164, .box_w = 8, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 29, .adv_w = 198, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 12},
    {.bitmap_index = 60, .adv_w = 365, .box_w = 19, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 176, .adv_w = 487, .box_w = 29, .box_h = 25, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 338, .adv_w = 556, .box_w = 33, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 523, .adv_w = 523, .box_w = 31, .box_h = 22, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 688, .adv_w = 131, .box_w = 6, .box_h = 9, .ofs_x = 1, .ofs_y = 12},
    {.bitmap_index = 704, .adv_w = 224, .box_w = 11, .box_h = 28, .ofs_x = 2, .ofs_y = -7},
    {.bitmap_index = 754, .adv_w = 224, .box_w = 11, .box_h = 28, .ofs_x = 1, .ofs_y = -7},
    {.bitmap_index = 803, .adv_w = 341, .box_w = 16, .box_h = 14, .ofs_x = 3, .ofs_y = 7},
    {.bitmap_index = 865, .adv_w = 471, .box_w = 21, .box_h = 19, .ofs_x = 4, .ofs_y = 2},
    {.bitmap_index = 903, .adv_w = 164, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 924, .adv_w = 177, .box_w = 12, .box_h = 6, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 932, .adv_w = 177, .box_w = 7, .box_h = 6, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 939, .adv_w = 388, .box_w = 29, .box_h = 27, .ofs_x = -5, .ofs_y = -6},
    {.bitmap_index = 1082, .adv_w = 487, .box_w = 28, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1203, .adv_w = 487, .box_w = 18, .box_h = 21, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 1259, .adv_w = 487, .box_w = 26, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1373, .adv_w = 487, .box_w = 26, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1497, .adv_w = 487, .box_w = 27, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1590, .adv_w = 487, .box_w = 27, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1704, .adv_w = 487, .box_w = 26, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1836, .adv_w = 487, .box_w = 26, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1938, .adv_w = 487, .box_w = 26, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2065, .adv_w = 487, .box_w = 26, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2187, .adv_w = 177, .box_w = 7, .box_h = 15, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2205, .adv_w = 164, .box_w = 8, .box_h = 21, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 2237, .adv_w = 256, .box_w = 14, .box_h = 18, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 2305, .adv_w = 471, .box_w = 21, .box_h = 10, .ofs_x = 4, .ofs_y = 6},
    {.bitmap_index = 2331, .adv_w = 488, .box_w = 15, .box_h = 18, .ofs_x = 8, .ofs_y = 2},
    {.bitmap_index = 2405, .adv_w = 402, .box_w = 22, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2503, .adv_w = 566, .box_w = 33, .box_h = 23, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 2687, .adv_w = 525, .box_w = 33, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2838, .adv_w = 522, .box_w = 29, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2946, .adv_w = 510, .box_w = 28, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3061, .adv_w = 539, .box_w = 30, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3151, .adv_w = 459, .box_w = 25, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3201, .adv_w = 433, .box_w = 24, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3243, .adv_w = 520, .box_w = 29, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3367, .adv_w = 533, .box_w = 29, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3409, .adv_w = 193, .box_w = 8, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3419, .adv_w = 413, .box_w = 24, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3483, .adv_w = 513, .box_w = 30, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3603, .adv_w = 394, .box_w = 22, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3633, .adv_w = 666, .box_w = 37, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3789, .adv_w = 557, .box_w = 30, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3896, .adv_w = 541, .box_w = 30, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4014, .adv_w = 486, .box_w = 27, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4092, .adv_w = 544, .box_w = 32, .box_h = 22, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 4237, .adv_w = 516, .box_w = 28, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4323, .adv_w = 500, .box_w = 27, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4454, .adv_w = 436, .box_w = 27, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4491, .adv_w = 524, .box_w = 29, .box_h = 22, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 4572, .adv_w = 517, .box_w = 32, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4732, .adv_w = 740, .box_w = 46, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4977, .adv_w = 539, .box_w = 33, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5146, .adv_w = 506, .box_w = 32, .box_h = 21, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5264, .adv_w = 472, .box_w = 27, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5366, .adv_w = 217, .box_w = 12, .box_h = 28, .ofs_x = 2, .ofs_y = -7},
    {.bitmap_index = 5393, .adv_w = 388, .box_w = 28, .box_h = 27, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 5531, .adv_w = 217, .box_w = 11, .box_h = 28, .ofs_x = 0, .ofs_y = -7},
    {.bitmap_index = 5557, .adv_w = 256, .box_w = 16, .box_h = 11, .ofs_x = 0, .ofs_y = 11},
    {.bitmap_index = 5610, .adv_w = 256, .box_w = 16, .box_h = 4, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 5619, .adv_w = 256, .box_w = 10, .box_h = 7, .ofs_x = 2, .ofs_y = 16},
    {.bitmap_index = 5643, .adv_w = 388, .box_w = 21, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5730, .adv_w = 408, .box_w = 22, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5818, .adv_w = 388, .box_w = 22, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5899, .adv_w = 407, .box_w = 23, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5993, .adv_w = 377, .box_w = 21, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6069, .adv_w = 263, .box_w = 15, .box_h = 21, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6116, .adv_w = 407, .box_w = 23, .box_h = 22, .ofs_x = 1, .ofs_y = -7},
    {.bitmap_index = 6242, .adv_w = 400, .box_w = 21, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 6298, .adv_w = 163, .box_w = 6, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 6315, .adv_w = 184, .box_w = 9, .box_h = 27, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 6348, .adv_w = 367, .box_w = 21, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 6430, .adv_w = 163, .box_w = 6, .box_h = 21, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 6438, .adv_w = 608, .box_w = 34, .box_h = 15, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 6524, .adv_w = 400, .box_w = 21, .box_h = 15, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 6575, .adv_w = 396, .box_w = 23, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6660, .adv_w = 408, .box_w = 22, .box_h = 21, .ofs_x = 2, .ofs_y = -6},
    {.bitmap_index = 6751, .adv_w = 404, .box_w = 22, .box_h = 21, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 6842, .adv_w = 326, .box_w = 18, .box_h = 15, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 6888, .adv_w = 384, .box_w = 22, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6978, .adv_w = 328, .box_w = 18, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7042, .adv_w = 400, .box_w = 21, .box_h = 15, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 7092, .adv_w = 376, .box_w = 23, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7183, .adv_w = 551, .box_w = 33, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7323, .adv_w = 377, .box_w = 23, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7416, .adv_w = 368, .box_w = 23, .box_h = 22, .ofs_x = 0, .ofs_y = -7},
    {.bitmap_index = 7543, .adv_w = 338, .box_w = 19, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7600, .adv_w = 223, .box_w = 11, .box_h = 28, .ofs_x = 2, .ofs_y = -7},
    {.bitmap_index = 7660, .adv_w = 256, .box_w = 8, .box_h = 27, .ofs_x = 4, .ofs_y = -6},
    {.bitmap_index = 7673, .adv_w = 223, .box_w = 11, .box_h = 28, .ofs_x = 1, .ofs_y = -7},
    {.bitmap_index = 7733, .adv_w = 341, .box_w = 17, .box_h = 7, .ofs_x = 2, .ofs_y = 17}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Pair left and right glyphs for kerning*/
static const uint8_t kern_pair_glyph_ids[] =
{
    13, 18,
    14, 34,
    14, 53,
    14, 55,
    14, 56,
    14, 58,
    15, 18,
    17, 18,
    17, 21,
    17, 24,
    18, 13,
    18, 15,
    18, 17,
    18, 18,
    18, 19,
    18, 20,
    18, 21,
    18, 22,
    18, 23,
    18, 24,
    18, 25,
    18, 26,
    19, 18,
    19, 21,
    19, 24,
    20, 18,
    20, 24,
    21, 18,
    21, 21,
    21, 24,
    22, 18,
    22, 21,
    22, 24,
    23, 18,
    23, 21,
    23, 24,
    24, 13,
    24, 15,
    24, 18,
    24, 21,
    24, 23,
    24, 24,
    24, 27,
    25, 18,
    25, 21,
    25, 24,
    26, 18,
    26, 21,
    26, 24,
    34, 13,
    34, 14,
    34, 15,
    34, 36,
    34, 40,
    34, 48,
    34, 50,
    34, 53,
    34, 54,
    34, 55,
    34, 56,
    34, 58,
    34, 66,
    34, 67,
    34, 68,
    34, 69,
    34, 70,
    34, 72,
    34, 80,
    34, 82,
    34, 85,
    34, 86,
    34, 87,
    34, 88,
    34, 90,
    35, 34,
    35, 48,
    35, 55,
    35, 56,
    35, 58,
    36, 34,
    36, 41,
    36, 44,
    36, 48,
    37, 34,
    37, 43,
    37, 53,
    37, 55,
    37, 56,
    37, 57,
    37, 58,
    39, 13,
    39, 14,
    39, 15,
    39, 34,
    39, 43,
    39, 48,
    39, 66,
    39, 70,
    39, 75,
    39, 80,
    39, 83,
    39, 86,
    40, 34,
    40, 53,
    40, 55,
    40, 56,
    40, 58,
    43, 34,
    44, 14,
    44, 36,
    44, 40,
    44, 48,
    44, 52,
    44, 53,
    44, 66,
    44, 70,
    44, 80,
    44, 86,
    44, 90,
    45, 14,
    45, 34,
    45, 36,
    45, 40,
    45, 48,
    45, 52,
    45, 53,
    45, 54,
    45, 55,
    45, 56,
    45, 58,
    45, 86,
    45, 90,
    47, 13,
    47, 15,
    47, 34,
    47, 36,
    47, 40,
    47, 48,
    47, 66,
    47, 70,
    47, 80,
    47, 86,
    48, 34,
    48, 53,
    48, 55,
    48, 56,
    48, 57,
    48, 58,
    49, 13,
    49, 14,
    49, 15,
    49, 34,
    49, 43,
    49, 66,
    49, 70,
    49, 80,
    51, 14,
    51, 36,
    51, 40,
    51, 48,
    51, 53,
    51, 54,
    51, 55,
    51, 56,
    51, 58,
    51, 66,
    51, 70,
    51, 80,
    51, 86,
    51, 90,
    52, 53,
    52, 55,
    52, 56,
    52, 58,
    52, 85,
    53, 13,
    53, 14,
    53, 15,
    53, 27,
    53, 28,
    53, 34,
    53, 36,
    53, 40,
    53, 43,
    53, 48,
    53, 52,
    53, 55,
    53, 56,
    53, 58,
    53, 66,
    53, 68,
    53, 70,
    53, 72,
    53, 74,
    53, 75,
    53, 80,
    53, 83,
    53, 84,
    53, 86,
    53, 87,
    53, 88,
    53, 90,
    54, 13,
    54, 15,
    54, 34,
    54, 78,
    54, 79,
    54, 81,
    54, 83,
    55, 13,
    55, 14,
    55, 15,
    55, 27,
    55, 28,
    55, 34,
    55, 36,
    55, 40,
    55, 48,
    55, 52,
    55, 53,
    55, 66,
    55, 70,
    55, 72,
    55, 74,
    55, 80,
    55, 83,
    55, 86,
    55, 90,
    56, 13,
    56, 14,
    56, 15,
    56, 27,
    56, 28,
    56, 34,
    56, 36,
    56, 40,
    56, 48,
    56, 52,
    56, 53,
    56, 66,
    56, 70,
    56, 72,
    56, 74,
    56, 80,
    56, 83,
    56, 86,
    56, 90,
    57, 14,
    57, 36,
    57, 48,
    57, 50,
    57, 66,
    57, 70,
    57, 80,
    57, 86,
    57, 90,
    58, 13,
    58, 14,
    58, 15,
    58, 27,
    58, 28,
    58, 34,
    58, 36,
    58, 40,
    58, 48,
    58, 52,
    58, 53,
    58, 66,
    58, 70,
    58, 72,
    58, 74,
    58, 80,
    58, 81,
    58, 86,
    58, 87,
    59, 87,
    59, 90,
    66, 75,
    66, 87,
    66, 88,
    66, 90,
    67, 87,
    67, 88,
    67, 90,
    68, 73,
    68, 76,
    70, 85,
    70, 87,
    70, 88,
    70, 89,
    70, 90,
    71, 66,
    71, 70,
    71, 71,
    71, 74,
    71, 75,
    71, 77,
    71, 80,
    71, 84,
    71, 85,
    72, 66,
    72, 70,
    72, 77,
    72, 83,
    73, 90,
    74, 53,
    74, 75,
    76, 13,
    76, 14,
    76, 15,
    76, 66,
    76, 70,
    76, 72,
    76, 80,
    76, 84,
    76, 86,
    77, 87,
    77, 90,
    78, 81,
    78, 87,
    78, 88,
    78, 90,
    79, 53,
    79, 81,
    79, 87,
    79, 88,
    79, 90,
    80, 53,
    80, 85,
    80, 87,
    80, 88,
    80, 89,
    80, 90,
    81, 85,
    81, 90,
    82, 68,
    82, 86,
    83, 13,
    83, 14,
    83, 15,
    83, 27,
    83, 28,
    83, 66,
    83, 68,
    83, 69,
    83, 70,
    83, 71,
    83, 72,
    83, 73,
    83, 74,
    83, 75,
    83, 76,
    83, 77,
    83, 78,
    83, 79,
    83, 80,
    83, 81,
    83, 82,
    83, 83,
    83, 84,
    83, 85,
    83, 86,
    83, 87,
    83, 88,
    83, 89,
    83, 90,
    83, 91,
    84, 85,
    85, 27,
    85, 28,
    85, 52,
    85, 66,
    85, 70,
    85, 73,
    85, 80,
    87, 13,
    87, 14,
    87, 15,
    87, 27,
    87, 28,
    87, 66,
    87, 68,
    87, 70,
    87, 72,
    87, 77,
    87, 80,
    87, 84,
    88, 13,
    88, 14,
    88, 15,
    88, 27,
    88, 28,
    88, 66,
    88, 68,
    88, 70,
    88, 72,
    88, 77,
    88, 80,
    88, 84,
    89, 66,
    89, 68,
    89, 70,
    89, 80,
    89, 82,
    90, 13,
    90, 14,
    90, 15,
    90, 27,
    90, 28,
    90, 66,
    90, 68,
    90, 70,
    90, 72,
    90, 77,
    90, 80,
    90, 84
};

/* Kerning between the respective left and right glyphs
 * 4.4 format which needs to scaled with `kern_scale`*/
static const int8_t kern_pair_values[] =
{
    -65, 16, -37, -14, -6, -45, -68, -15,
    4, -2, -43, -47, -48, -72, -53, -55,
    -54, -55, -54, -57, -54, -56, -19, -1,
    -5, -21, -6, -41, 4, -27, -37, 0,
    -11, -23, -2, -8, -64, -68, -25, -32,
    -7, -3, -13, -21, -1, -6, -20, -1,
    -5, 21, 17, 15, -5, -4, -5, -5,
    -41, -7, -52, -40, -61, 6, 10, -1,
    1, -1, -2, 1, 2, -15, -6, -30,
    -22, -29, 0, -2, -6, -7, -11, 0,
    -2, -2, -1, -5, 9, 8, -6, -7,
    -17, -12, -2, 19, -6, -16, 9, 3,
    -5, -1, -10, -1, -6, -6, -1, 10,
    -1, -2, -6, -7, -5, -13, -12, -15,
    -5, 17, -1, -11, -7, -15, -33, 32,
    29, 10, 10, 10, 12, -51, 8, -40,
    -27, -69, 7, -15, 8, 4, 12, 0,
    0, 0, -3, -1, 0, -3, -7, 10,
    -4, -4, -16, -8, -6, 20, -10, -21,
    9, -2, 1, 1, 16, -3, -3, -2,
    9, -4, -3, -4, -8, -5, -6, -4,
    -6, 5, 5, -5, -7, -10, -3, -52,
    -37, -56, -56, -52, -43, 9, 9, -29,
    10, 11, 26, 23, 26, -65, -64, -64,
    -64, 6, -4, -62, -61, -63, -65, -57,
    -60, -57, 0, -3, -7, -3, -3, -3,
    -3, -47, -17, -50, -14, -11, -55, -6,
    -6, -4, -2, 26, -31, -31, -27, 9,
    -28, -18, -19, -5, -35, -8, -38, -11,
    -7, -42, -6, -6, -5, -3, 22, -25,
    -24, -22, 5, -23, -15, -16, -2, -2,
    -16, -18, -18, -3, -13, -9, -16, -32,
    -69, -44, -73, -30, -27, -63, -11, -11,
    -9, -6, 26, -50, -50, -45, 9, -48,
    -33, -35, -22, -2, 0, -15, -10, -10,
    -10, -7, -7, -7, -5, -5, 1, -7,
    -7, -11, -8, 0, 3, 7, 0, -10,
    0, 4, 5, 9, -4, -3, -3, -3,
    -14, 7, -13, 17, -3, 12, -2, -12,
    -14, -8, -4, -1, 2, 2, -5, -14,
    -14, -14, -65, -5, -13, -13, -13, -62,
    1, -6, -6, -13, -6, 1, -7, -4,
    -5, -41, 27, -45, 8, 11, 3, 8,
    8, 8, 9, 8, 3, 3, -7, 3,
    3, 3, 3, 8, 3, 8, 3, 8,
    11, 3, 5, 4, -4, 4, 4, -2,
    2, 4, -1, -1, -1, -3, -1, -22,
    7, -25, 7, 10, -9, -9, -9, -5,
    2, -7, -4, -17, 8, -21, 4, 7,
    -10, -9, -9, -6, -1, -7, -5, -8,
    -16, -16, -14, -13, -22, 6, -25, 5,
    9, -10, -10, -9, -6, 2, -7, -5
};

/*Collect the kern pair's data in one place*/
static const lv_font_fmt_txt_kern_pair_t kern_pairs =
{
    .glyph_ids = kern_pair_glyph_ids,
    .values = kern_pair_values,
    .pair_cnt = 416,
    .glyph_ids_size = 0
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_pairs,
    .kern_scale = 16,
    .cmap_num = 1,
    .bpp = 3,
    .kern_classes = 0,
    .bitmap_format = 1
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t fn1_32 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 31,          /*The maximum line height required by the font*/
    .base_line = 7,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if FN1_32*/

