#include <lvgl/lvgl.h>

/*******************************************************************************
 * Size: 24 px
 * Bpp: 3
 * Opts: --font ../font/new/Digital-Play-St/Digital-Play-St-3.ttf -r 0x20-0x7F --size 24 --format lvgl --bpp 3 --lv-include lvgl/lvgl.h  -o digital_play_st_24.c
 ******************************************************************************/

#ifndef DIGITAL_PLAY_ST_24
#define DIGITAL_PLAY_ST_24 1
#endif

#if DIGITAL_PLAY_ST_24

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x9d, 0x6, 0x29, 0x2, 0x40, 0x7f, 0xf0, 0xc9,
    0x8, 0xb6, 0x30, 0x4, 0x8, 0x80, 0xd8, 0xc1,
    0x11, 0x1, 0x10, 0x3f, 0xf8, 0x69, 0x8a, 0x67,
    0x40, 0x71, 0x6c, 0x3c, 0x84, 0x40, 0x36, 0x14,
    0x80,

    /* U+22 "\"" */
    0xbf, 0x88, 0x3, 0xfa, 0x20, 0xc, 0x2, 0x0,
    0xc0, 0x34, 0x1, 0xa0, 0x1a, 0x40, 0x1a, 0xcc,
    0x58, 0x1e, 0x66, 0xfe, 0x20, 0xf, 0xea, 0x80,
    0x20, 0x8, 0x2, 0x40, 0x3f, 0x2a, 0x49, 0x80,
    0x41, 0x50,

    /* U+23 "#" */
    0x3, 0xff, 0x86, 0x7e, 0x3, 0xf9, 0x78, 0x7,
    0xff, 0x23, 0x2, 0x40, 0x7c, 0x68, 0x60, 0x7f,
    0xf1, 0xc8, 0x11, 0x3, 0xe6, 0x7, 0xff, 0x28,
    0xd9, 0x40, 0xfc, 0xa4, 0x60, 0x3f, 0xf8, 0xe6,
    0x48, 0xf, 0xce, 0xca, 0x7, 0xff, 0x4, 0xfa,
    0x5, 0x88, 0x21, 0x78, 0x4, 0xa1, 0x8, 0xfc,
    0x7, 0xf1, 0xc1, 0x41, 0x80, 0x91, 0xa1, 0xc0,
    0x68, 0x15, 0xc0, 0xd0, 0x3f, 0x14, 0x2, 0xc2,
    0x0, 0xd2, 0x80, 0x51, 0xc0, 0x9b, 0x40, 0x1c,
    0xf, 0xeb, 0x31, 0x60, 0x5c, 0x5, 0x98, 0x98,
    0x2, 0x81, 0xda, 0x40, 0x7f, 0x99, 0x3, 0x52,
    0x4, 0xc8, 0x20, 0xd, 0x2, 0x48, 0x7, 0xff,
    0x1, 0x21, 0xd, 0x1, 0xe6, 0x51, 0xe0, 0x7f,
    0xf1, 0x5d, 0xba, 0x1, 0xeb, 0x34, 0xc4, 0xf,
    0xfe, 0x2d, 0x1, 0x50, 0x1e, 0x28, 0x5, 0x3,
    0xff, 0x8a, 0xf5, 0x7, 0x1, 0xe9, 0x20, 0xe0,
    0x1f, 0xf1, 0x40, 0x4a, 0x1d, 0xf3, 0x20, 0x66,
    0xc8, 0x7a, 0xc0, 0xff, 0x2d, 0x58, 0x34, 0x3,
    0x16, 0x62, 0x1, 0x40, 0x1c, 0xe9, 0x40, 0xfe,
    0xe0, 0x20, 0xe0, 0x50, 0xa0, 0x14, 0x1a, 0x5,
    0x28, 0x4, 0x40, 0xfd, 0x48, 0xd4, 0x80, 0x88,
    0xd0, 0xe1, 0xc0, 0x54, 0x44, 0x31, 0x3, 0xfb,
    0x76, 0x80, 0x26, 0x1, 0x78, 0x10, 0x14, 0x40,
    0x2f, 0x20, 0x7f, 0xf0, 0x11, 0x4e, 0x81, 0xf2,
    0x29, 0xb0, 0x1f, 0xfc, 0x79, 0xa8, 0x1f, 0x8d,
    0xd0, 0xf, 0xfe, 0x3a, 0xb3, 0x1, 0xf9, 0xc8,
    0xa0, 0x7f, 0xf2, 0x88, 0x1f, 0xb8, 0x2, 0x7,
    0xff, 0x1d, 0x12, 0xc0, 0x7e, 0xa1, 0x40, 0x3f,
    0xf8, 0x80,

    /* U+24 "$" */
    0x1, 0xbf, 0xff, 0xb0, 0x11, 0x20, 0x3f, 0xe2,
    0x40, 0x4c, 0xf, 0xf9, 0x91, 0xb0, 0x49, 0xfe,
    0xb0, 0x1, 0xc, 0xb7, 0x59, 0x9b, 0x90, 0x1e,
    0x20, 0x11, 0x8, 0x81, 0xff, 0xe2, 0x60, 0x44,
    0xf, 0xe4, 0x0, 0xc5, 0x40, 0xf9, 0x8b, 0xbf,
    0xa2, 0xbf, 0xd8, 0xa, 0x78, 0x7, 0xf8, 0xd0,
    0x33, 0x3, 0xfe, 0x20, 0x6b, 0x27, 0xfa, 0xef,
    0x0, 0x9b, 0xc3, 0x96, 0xf5, 0xc, 0xf, 0x18,
    0xe8, 0x15, 0x3, 0xf9, 0x81, 0x10, 0x3f, 0xfc,
    0x48, 0x84, 0x40, 0x70, 0x3c, 0xe4, 0x93, 0x32,
    0x41, 0x84, 0x2, 0x43, 0x7f, 0xd3, 0xea, 0x13,
    0x3, 0xfe, 0x80, 0x48, 0x81, 0xff, 0x12, 0x0,

    /* U+25 "%" */
    0x9f, 0x8c, 0xfc, 0x40, 0xd7, 0x90, 0xc0, 0x26,
    0x1, 0x1, 0x54, 0x28, 0x21, 0x3c, 0x0, 0x81,
    0x30, 0x1c, 0x79, 0x41, 0xd5, 0x1, 0x69, 0xc,
    0x58, 0x80, 0x4a, 0x40, 0xad, 0x42, 0x18, 0xa6,
    0xa0, 0x80, 0x54, 0x42, 0x4, 0x2, 0x60, 0x8,
    0x68, 0x9, 0x8d, 0x2b, 0xf2, 0xa4, 0x80, 0x58,
    0x9, 0xa0, 0x5a, 0x18, 0xa, 0x10, 0x3f, 0xf8,
    0x29, 0x81, 0xfc, 0x5f, 0x1, 0x40, 0xfe, 0x3a,
    0x6b, 0x80, 0xff, 0x50, 0x9, 0x90, 0x3f, 0xa7,
    0x42, 0x90, 0x3f, 0xb3, 0x97, 0xa0, 0x3f, 0xa9,
    0x3, 0xff, 0x82, 0xd0, 0x1e, 0x20, 0x44, 0x1,
    0x80, 0x58, 0x7, 0xdc, 0xfd, 0xc7, 0x2, 0x84,
    0x10, 0x3e, 0x2c, 0x3, 0x60, 0x4, 0x86, 0x38,
    0x12, 0x8e, 0x40, 0x1b, 0xd2, 0xd, 0x83, 0x38,
    0x80, 0x8e, 0xb0, 0x3b, 0x44, 0x9, 0x81, 0xe6,
    0xa0, 0x12, 0x18, 0x81, 0x12, 0x5, 0x10, 0x48,

    /* U+26 "&" */
    0x1, 0xbf, 0xff, 0xb0, 0x1f, 0x12, 0x3, 0xfe,
    0x24, 0x7, 0xcc, 0xf, 0xf9, 0x90, 0x3b, 0x60,
    0x93, 0xfd, 0x60, 0x1e, 0x21, 0x96, 0xff, 0x91,
    0xcc, 0xf, 0x88, 0x1f, 0xc7, 0x1a, 0x7, 0xff,
    0x15, 0x0, 0x20, 0x7f, 0xf9, 0x48, 0x1f, 0xc4,
    0xf, 0x90, 0xa5, 0xbf, 0xe3, 0x43, 0x3, 0x5f,
    0xd2, 0x7f, 0xdf, 0xa0, 0x1e, 0x60, 0x7f, 0xcc,
    0xf, 0x4f, 0x0, 0xff, 0x19, 0xd8, 0x19, 0x8b,
    0xbf, 0xff, 0x51, 0x0, 0x32, 0x4, 0x80, 0xfe,
    0x40, 0x6b, 0x30, 0x1f, 0xfc, 0x1e, 0x4, 0xd0,
    0x1f, 0xfc, 0x74, 0x1, 0x81, 0xff, 0xc1, 0xe0,
    0x47, 0xf4, 0x2, 0x20, 0x7f, 0x10, 0x23, 0xfa,
    0x11, 0x3, 0x7f, 0xc1, 0x84, 0x80, 0x1e, 0xcf,
    0x64, 0xfe, 0xa3, 0x56, 0x80, 0x9b, 0x1, 0xff,
    0x30, 0x2b, 0x30, 0x44, 0xf, 0xf8, 0x90, 0x13,
    0x20,

    /* U+27 "'" */
    0xbf, 0x8a, 0x0, 0xc0, 0x24, 0xd2, 0x82, 0xc0,
    0x5f, 0xc5, 0x0, 0x48, 0x5, 0x49, 0x30,

    /* U+28 "(" */
    0x1, 0xbf, 0xff, 0xa8, 0x4, 0x40, 0xff, 0x90,
    0x4, 0xc0, 0xff, 0xa0, 0x9a, 0xc9, 0xfe, 0xac,
    0x33, 0x93, 0x7f, 0xc8, 0xe, 0x40, 0x7f, 0xf8,
    0xd0, 0x1f, 0xfc, 0x4, 0x31, 0x3, 0xff, 0x81,
    0x79, 0x3, 0xff, 0x83, 0x79, 0x3, 0xff, 0x82,
    0x86, 0x20, 0x7f, 0xf0, 0xd0, 0x1f, 0xfe, 0x34,
    0x7, 0xff, 0x1, 0x9c, 0x40, 0xff, 0xe0, 0x70,
    0x3f, 0xf8, 0x70, 0xe0, 0x3f, 0xf8, 0x8c, 0xf,
    0xff, 0x19, 0x3, 0xff, 0x80, 0x85, 0x2d, 0xff,
    0x20, 0x17, 0xf4, 0x9f, 0xeb, 0x0, 0x24, 0x3,
    0xfe, 0x64, 0x22, 0x7, 0xfc, 0x88,

    /* U+29 ")" */
    0xbf, 0xff, 0xf0, 0x8, 0x4, 0x7, 0xff, 0x1,
    0x0, 0xa0, 0x7f, 0xc9, 0x80, 0x56, 0x4f, 0xf5,
    0xb0, 0x4, 0xdf, 0xfb, 0x24, 0x20, 0x7f, 0xc8,
    0x81, 0xff, 0xe2, 0x40, 0x7f, 0xf1, 0x30, 0x24,
    0x7, 0xff, 0x0, 0xfc, 0x7, 0xff, 0x4, 0xfa,
    0x7, 0xff, 0x7, 0x4, 0x40, 0xff, 0x90, 0x1f,
    0xfe, 0x34, 0x40, 0xff, 0xe1, 0xe2, 0x88, 0x1f,
    0xfc, 0x16, 0x40, 0xff, 0xe0, 0xe4, 0xc0, 0xff,
    0xe0, 0x22, 0x7, 0xff, 0x89, 0x81, 0xc9, 0xbf,
    0xe5, 0x81, 0xa, 0xc9, 0xff, 0x7c, 0x28, 0x1f,
    0xf2, 0x60, 0x18, 0x1f, 0xfc, 0x4, 0x0,

    /* U+2A "*" */
    0x3, 0xff, 0x9d, 0xf8, 0x81, 0xff, 0xc2, 0x20,
    0x10, 0x1f, 0xcf, 0xe0, 0x4, 0x16, 0x3, 0x76,
    0x6, 0xc0, 0x90, 0xf, 0x80, 0x12, 0x18, 0xd,
    0x48, 0x20, 0x78, 0x83, 0x40, 0xed, 0x9f, 0x90,
    0x5, 0xfb, 0x60, 0x1f, 0xec, 0x3, 0x1, 0xff,
    0x18, 0x2, 0xd7, 0x14, 0x85, 0x4f, 0xf1, 0xf,
    0x94, 0x83, 0xa0, 0x6a, 0xe0, 0x44, 0x8, 0x80,
    0x20, 0x7d, 0x95, 0x0, 0xfe, 0xfc, 0x3b, 0x7,
    0xf6, 0x35, 0x3, 0x6, 0x1, 0x84, 0x20, 0x7f,
    0xd8, 0x6, 0x3, 0xfd, 0xb3, 0xf2, 0x0, 0xbf,
    0x6c, 0x3, 0xa9, 0x4, 0xf, 0x10, 0x68, 0x1b,
    0x82, 0x40, 0x3f, 0x0, 0x24, 0x38, 0x19, 0x7c,
    0x1, 0x80, 0x20, 0x37, 0x40, 0x7f, 0x20, 0x4,
    0xf, 0x80,

    /* U+2B "+" */
    0x3, 0xdb, 0xe0, 0x3f, 0xe2, 0x40, 0x90, 0x1f,
    0xe2, 0x7, 0xff, 0xf, 0x2, 0x40, 0x7f, 0xc7,
    0xe0, 0x3d, 0x7f, 0xff, 0xe0, 0x94, 0x7, 0xff,
    0x5, 0x50, 0x3f, 0xf8, 0x9, 0xab, 0x27, 0x39,
    0x3a, 0x80, 0x4d, 0xea, 0xd3, 0x78, 0xf, 0x89,
    0xc, 0x7, 0xff, 0xc, 0x81, 0xfe, 0x24, 0x9,
    0x1, 0xc0,

    /* U+2C "," */
    0x2, 0x48, 0x4, 0x92, 0xd2, 0x1a, 0xe8, 0xd8,
    0xb, 0x3b, 0xa7, 0x60, 0xa0, 0xce, 0xb8, 0x2a,
    0x6, 0x55, 0x4, 0xf1, 0x2, 0x6c, 0x80, 0xd8,
    0x60, 0x34, 0x8a, 0x4,

    /* U+2D "-" */
    0x5, 0xbf, 0xf8, 0x2, 0xd2, 0x7f, 0xd4, 0x50,
    0x3f, 0xf8, 0x9, 0x40, 0x7f, 0xf0, 0x58,

    /* U+2E "." */
    0x2, 0x48, 0x6, 0x56, 0x90, 0x78, 0x90, 0x14,
    0x23, 0x64, 0x55, 0x20, 0x46, 0x2f, 0xb0, 0x5,
    0x2, 0x2b, 0xb0, 0xae, 0x20, 0x0,

    /* U+2F "/" */
    0x3, 0xff, 0x81, 0x79, 0x3, 0xfe, 0xa8, 0x50,
    0x3f, 0xe6, 0x3, 0x81, 0xff, 0x79, 0xc, 0xf,
    0xfa, 0xec, 0x3, 0xfe, 0x8d, 0x23, 0x3, 0xf9,
    0x30, 0x24, 0x7, 0xe3, 0x40, 0xa9, 0x3, 0xf5,
    0x2, 0x68, 0xf, 0xfe, 0x2, 0x80, 0x7e, 0x2f,
    0x80, 0xa0, 0x7e, 0x3a, 0x6b, 0xc0, 0xfe, 0xa0,
    0x13, 0x3, 0xf1, 0xa1, 0xa, 0x40, 0xfd, 0xd3,
    0xbd, 0x1, 0xfa, 0x90, 0x3f, 0xf8, 0x11, 0x0,
    0x20, 0x7f, 0x26, 0x5, 0xc0, 0xfe, 0xa0, 0x58,
    0x81, 0xfc, 0xc9, 0x52, 0x7, 0xfa, 0xd4, 0x40,
    0x7f, 0xda, 0x54, 0x7, 0xff, 0x9, 0x81, 0xff,
    0x21, 0x88, 0x1f, 0xf0,

    /* U+30 "0" */
    0x1, 0xbf, 0xff, 0xb0, 0x12, 0x20, 0x7f, 0xc4,
    0x80, 0x36, 0x3, 0xfe, 0x80, 0x36, 0x79, 0x3f,
    0xd7, 0xea, 0x44, 0x2d, 0xff, 0x16, 0x10, 0x11,
    0x3, 0xfb, 0x81, 0xff, 0xed, 0x60, 0x7f, 0x50,
    0x5, 0x8c, 0x6, 0xde, 0x1, 0x1a, 0x2c, 0xe4,
    0x9, 0x10, 0xc0, 0xcb, 0xb0, 0x3f, 0xf8, 0xb7,
    0xa0, 0x25, 0x1d, 0x3, 0x3f, 0x10, 0xa8, 0x9,
    0xc4, 0x4, 0xa0, 0x60, 0x44, 0xf, 0xec, 0x7,
    0xff, 0xb4, 0x81, 0xfd, 0xc0, 0x88, 0x85, 0xbf,
    0xe2, 0xc2, 0xd9, 0xe4, 0xff, 0x5f, 0x68, 0x36,
    0x3, 0xfe, 0x8c, 0x2, 0x20, 0x7f, 0xc4, 0x80,

    /* U+31 "1" */
    0x1b, 0x9c, 0x42, 0x20, 0x7f, 0xf4, 0xe0, 0x13,
    0x8d, 0x97, 0x82, 0xbc, 0x4, 0x58, 0x1f, 0xfd,
    0x34, 0x83, 0x10,

    /* U+32 "2" */
    0x1, 0xbf, 0xff, 0xb0, 0x11, 0x20, 0x3f, 0xe2,
    0x40, 0xb, 0x3, 0xfe, 0x80, 0x69, 0x3f, 0xeb,
    0xf5, 0x2, 0x6f, 0xfc, 0x58, 0x40, 0x7f, 0xf0,
    0x78, 0x1f, 0xff, 0x7a, 0x0, 0x80, 0x3f, 0xff,
    0xd4, 0x50, 0x1c, 0xf, 0xf1, 0xfc, 0xc0, 0x30,
    0x3f, 0xe2, 0x2, 0xfe, 0x93, 0xfd, 0x60, 0x4,
    0x29, 0x6f, 0xf9, 0x1, 0xe2, 0x7, 0xff, 0xdc,
    0x81, 0xff, 0xc1, 0x22, 0x16, 0xff, 0x90, 0x16,
    0xcf, 0x27, 0xfa, 0xb0, 0x26, 0xc0, 0x7f, 0xd0,
    0x80, 0x44, 0xf, 0xf8, 0x90,

    /* U+33 "3" */
    0x9f, 0xff, 0xf0, 0x8, 0x6, 0x7, 0xff, 0x1,
    0x0, 0xa0, 0x7f, 0xc5, 0x0, 0x56, 0x4f, 0xfb,
    0x70, 0x9, 0xbf, 0xe5, 0x40, 0x10, 0x3f, 0xff,
    0xe4, 0x80, 0xd7, 0xff, 0xf4, 0x28, 0xc4, 0x7,
    0xfa, 0xfa, 0x38, 0x1f, 0xf1, 0x2, 0x76, 0x4f,
    0xf7, 0xd8, 0x1, 0x37, 0xfe, 0xc0, 0x90, 0x1f,
    0xf1, 0x3, 0xff, 0xe6, 0x40, 0xe2, 0xdf, 0xfa,
    0x80, 0x2b, 0x49, 0xfe, 0xfb, 0x8a, 0x7, 0xfc,
    0x90, 0x3, 0x3, 0xff, 0x80, 0x80, 0x0,

    /* U+34 "4" */
    0xbd, 0x1, 0xff, 0x3f, 0x10, 0xa4, 0xf, 0xe5,
    0x3, 0x2, 0x40, 0x7f, 0x60, 0x3f, 0xff, 0xe0,
    0x7f, 0xf5, 0x58, 0x1f, 0xd4, 0x1, 0x62, 0xff,
    0xff, 0x51, 0x67, 0x80, 0x7f, 0x8c, 0xec, 0x3,
    0x3, 0xfe, 0x40, 0x6b, 0x27, 0xfa, 0xfe, 0x80,
    0x4d, 0xff, 0x8c, 0xc, 0xf, 0xfe, 0xf, 0x3,
    0xff, 0xfe, 0x7, 0xff, 0x7f, 0x1, 0xff, 0xc4,
    0x54, 0x40,

    /* U+35 "5" */
    0x1, 0xbf, 0xff, 0xb0, 0x11, 0x20, 0x3f, 0xe2,
    0x40, 0x4c, 0xf, 0xfa, 0x11, 0xb3, 0xc9, 0xfe,
    0xac, 0x1, 0x10, 0xb7, 0xfc, 0x80, 0xf1, 0x3,
    0xff, 0xee, 0x80, 0xff, 0xe0, 0xb1, 0x77, 0xff,
    0xd8, 0xa, 0x78, 0x7, 0xf8, 0xd0, 0x33, 0x3,
    0xfe, 0x20, 0x6b, 0x27, 0xfa, 0xfe, 0x80, 0x4d,
    0xff, 0x84, 0xc, 0xf, 0xfe, 0xe, 0x3, 0xff,
    0xef, 0xc0, 0xf3, 0x7f, 0xe2, 0xc2, 0x1, 0x27,
    0xfd, 0x7d, 0xa0, 0x98, 0x1f, 0xf4, 0x60, 0x11,
    0x3, 0xfe, 0x24, 0x0,

    /* U+36 "6" */
    0x1, 0xbf, 0xff, 0xb0, 0x12, 0x20, 0x7f, 0xc4,
    0x80, 0x36, 0x3, 0xfe, 0x84, 0x6c, 0xf2, 0x7f,
    0xab, 0x0, 0x44, 0x2d, 0xff, 0x20, 0x3c, 0x40,
    0xff, 0xfb, 0xb0, 0x3f, 0xf8, 0x2c, 0x5f, 0xff,
    0xd8, 0xa, 0x78, 0x7, 0xf8, 0xd0, 0x33, 0x3,
    0xfe, 0x20, 0x2f, 0xe9, 0x3f, 0xd7, 0xf4, 0x42,
    0x96, 0xff, 0x84, 0xc, 0x8, 0x81, 0xfd, 0x80,
    0xff, 0xf6, 0x90, 0x3f, 0xb8, 0x11, 0x10, 0xb7,
    0xfc, 0x58, 0x5b, 0x3c, 0x9f, 0xeb, 0xed, 0x6,
    0xc0, 0x7f, 0xd1, 0x80, 0x44, 0xf, 0xf8, 0x90,

    /* U+37 "7" */
    0xbf, 0xff, 0xf0, 0x8, 0x4, 0x7, 0xff, 0x1,
    0x0, 0xa0, 0x7f, 0xc5, 0x80, 0x56, 0x4f, 0xf7,
    0xec, 0x1, 0x37, 0xfe, 0xc0, 0x90, 0x1f, 0xf1,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0x60, 0x90, 0x1f,
    0xfc, 0x3c, 0x51, 0x3, 0xff, 0x83, 0xa8, 0x1f,
    0xfc, 0x22, 0x7, 0xff, 0x9, 0x6e, 0x7, 0xff,
    0x0, 0xd0, 0x4, 0xf, 0xff, 0xf9, 0x20, 0x3f,
    0xf8, 0x78, 0x98,

    /* U+38 "8" */
    0x1, 0xbf, 0xff, 0xb0, 0x11, 0x20, 0x3f, 0xe2,
    0x40, 0x4c, 0xf, 0xfa, 0x0, 0xd9, 0xe4, 0xff,
    0x5f, 0xa9, 0x10, 0xb7, 0xfc, 0x58, 0x40, 0x44,
    0xf, 0xee, 0x7, 0xff, 0xb5, 0x1, 0xfd, 0x40,
    0x16, 0x2e, 0xff, 0xfd, 0x45, 0x9e, 0x1, 0xfe,
    0x3f, 0x98, 0x6, 0x7, 0xfc, 0x40, 0x5f, 0xd2,
    0x7f, 0xaf, 0xe8, 0x85, 0x2d, 0xff, 0x8, 0x18,
    0x11, 0x3, 0xfb, 0x1, 0xff, 0xed, 0x20, 0x7f,
    0x70, 0x22, 0x21, 0x6f, 0xf8, 0xb0, 0xb6, 0x79,
    0x3f, 0xd7, 0xda, 0xd, 0x80, 0xff, 0xa3, 0x0,
    0x88, 0x1f, 0xf1, 0x20,

    /* U+39 "9" */
    0x1, 0xbf, 0xff, 0xb0, 0x12, 0x20, 0x7f, 0xc4,
    0x80, 0x36, 0x3, 0xfe, 0x80, 0x36, 0x79, 0x3f,
    0xd7, 0xea, 0x44, 0x2d, 0xff, 0x16, 0x10, 0x11,
    0x3, 0xfb, 0x81, 0xff, 0xed, 0x60, 0x7f, 0x50,
    0x5, 0x8b, 0xff, 0xfd, 0x45, 0x9e, 0x1, 0xfe,
    0x3f, 0x98, 0x6, 0x7, 0xfc, 0x40, 0xd6, 0x4f,
    0xf5, 0xfd, 0x0, 0x9b, 0xff, 0x8, 0x18, 0x1f,
    0xfc, 0x1c, 0x7, 0xff, 0xdf, 0x81, 0xe6, 0xff,
    0xc5, 0x84, 0x2, 0x4f, 0xfa, 0xfb, 0x41, 0x30,
    0x3f, 0xe8, 0xc0, 0x22, 0x7, 0xfc, 0x48, 0x0,

    /* U+3A ":" */
    0x2, 0x48, 0x6, 0x36, 0x90, 0x79, 0x10, 0x28,
    0x46, 0xfc, 0xa1, 0x61, 0xa8, 0xff, 0x50, 0x14,
    0x30, 0x8f, 0x61, 0x4a, 0x80, 0xcd, 0x1, 0xff,
    0xf9, 0xdc, 0x9, 0xb1, 0x8, 0x68, 0x34, 0x21,
    0x84, 0x4a, 0x5b, 0x24, 0x21, 0x83, 0x29, 0x98,
    0x32, 0x91, 0x80,

    /* U+3B ";" */
    0x3, 0xfd, 0xb0, 0x9, 0xb1, 0x24, 0x34, 0x1a,
    0x10, 0xc2, 0x25, 0x2d, 0xc8, 0x86, 0xb, 0xa6,
    0xe0, 0xca, 0x50, 0x16, 0xa0, 0x7f, 0xfe, 0xf,
    0xe2, 0xd, 0x40, 0x18, 0xc8, 0x7b, 0x8b, 0x8,
    0x3, 0xf3, 0x7a, 0x43, 0x8, 0xa3, 0xa8, 0x65,
    0xa2, 0x0, 0xba, 0x6, 0xaa, 0x1, 0xee, 0x6,
    0x9d, 0x1, 0x0,

    /* U+3C "<" */
    0x3, 0xc7, 0xd0, 0x3e, 0xe1, 0x10, 0x39, 0x10,
    0x3c, 0xf9, 0xb2, 0x90, 0xe, 0xa, 0x9a, 0x3,
    0xcc, 0xc, 0xea, 0x91, 0x40, 0xd1, 0x66, 0xc0,
    0x7f, 0xf0, 0xc8, 0xa9, 0x81, 0xdb, 0x9b, 0x28,
    0x1f, 0xcc, 0xf, 0x38, 0x11, 0x68, 0xc, 0xfd,
    0xd2, 0x90, 0x38, 0x90, 0x1f, 0xd8, 0x12, 0x3,
    0xef, 0x80,

    /* U+3D "=" */
    0x2d, 0xff, 0xf0, 0x46, 0x93, 0xff, 0x82, 0x90,
    0xf, 0xfe, 0xb, 0xa4, 0xf, 0xfa, 0x91, 0xbf,
    0xff, 0x90, 0x2, 0xdf, 0xfc, 0x1, 0x69, 0x3f,
    0xea, 0x28, 0x1f, 0xfc, 0x4, 0xd0, 0x1f, 0xfc,
    0x14,

    /* U+3E ">" */
    0x9d, 0x1, 0xf3, 0x14, 0x81, 0xfc, 0x80, 0xf6,
    0x90, 0x7d, 0x3, 0x16, 0xd8, 0x2a, 0x7, 0xb8,
    0x1f, 0xce, 0x4e, 0x3, 0x9b, 0x46, 0xc4, 0xf,
    0x30, 0x3e, 0x6d, 0xc0, 0x10, 0x27, 0x25, 0xf8,
    0xd, 0x80, 0x10, 0x22, 0xd7, 0xe, 0x1, 0x69,
    0x47, 0x80, 0x7c, 0xc0, 0xf3, 0x18, 0x81, 0xe0,

    /* U+3F "?" */
    0x0, 0xbf, 0xff, 0xe0, 0x30, 0x36, 0x3, 0xff,
    0x81, 0x40, 0xd0, 0x81, 0xff, 0x42, 0x6, 0xd2,
    0x7f, 0xac, 0xc8, 0xc, 0xdf, 0xfb, 0x91, 0x80,
    0xff, 0xe1, 0x30, 0x3f, 0xff, 0x6c, 0xf, 0x9b,
    0xff, 0x74, 0x30, 0x3, 0xe4, 0xff, 0x5f, 0xc8,
    0xf, 0xfe, 0x19, 0x1, 0x38, 0xa0, 0x7f, 0x9b,
    0x0, 0x63, 0x2f, 0xff, 0xd0, 0xf, 0x20, 0x3f,
    0xfd, 0x2c, 0xf, 0xfe, 0x13, 0x38, 0x81, 0xff,
    0xc2, 0x98, 0x81, 0xff, 0xc3, 0x91, 0x80, 0xff,
    0xe1, 0xfa, 0x80, 0xff, 0xe1, 0xfa, 0xc8, 0x1f,
    0xfc, 0x20,

    /* U+40 "@" */
    0x1, 0xbf, 0xff, 0xe0, 0xb0, 0x32, 0x20, 0x7f,
    0xf0, 0x68, 0x19, 0x20, 0x1f, 0xfc, 0x18, 0x5,
    0xbe, 0x93, 0xff, 0x81, 0x9e, 0xe4, 0x84, 0x2d,
    0xff, 0xc7, 0x10, 0xc0, 0x88, 0x3f, 0xa1, 0xfd,
    0x0, 0xff, 0xe0, 0x20, 0xd, 0x0, 0x60, 0x7f,
    0xf0, 0x8, 0xc, 0xd0, 0x20, 0x7f, 0xf0, 0x14,
    0xc4, 0x59, 0xc0, 0xff, 0xe0, 0xc8, 0x0, 0x62,
    0x3, 0xf8, 0xb0, 0xc2, 0x63, 0x8, 0x4, 0xc0,
    0xa1, 0xc0, 0x74, 0x60, 0x8, 0x14, 0x45, 0x72,
    0x40, 0x1c, 0x8c, 0xe4, 0x70, 0x3e, 0x63, 0x10,
    0x18, 0x10, 0xb2, 0x2, 0xa8, 0xa0, 0x24, 0x1a,
    0x8c, 0x65, 0x0, 0x90, 0x1f, 0xf7, 0x3, 0xff,
    0x88, 0x41, 0x82, 0x4, 0x7, 0xff, 0x1, 0x7c,
    0x1, 0xfa, 0x7, 0xff, 0x49, 0x1, 0xff, 0xc4,
    0x42, 0xa6, 0xff, 0xe3, 0xc8, 0x77, 0xf4, 0x9f,
    0xfc, 0xc, 0xb7, 0x21, 0x20, 0x1f, 0xfc, 0x18,
    0x6, 0x44, 0xf, 0xfe, 0xd, 0x2,

    /* U+41 "A" */
    0x1, 0xbf, 0xff, 0xb0, 0x12, 0x20, 0x7f, 0xc4,
    0x80, 0x36, 0x3, 0xfe, 0x60, 0x36, 0x79, 0x3f,
    0xd4, 0x6a, 0x44, 0x2d, 0xff, 0x16, 0x10, 0x11,
    0x3, 0xff, 0x9d, 0xc0, 0xff, 0xea, 0xf0, 0x3c,
    0x40, 0xfe, 0x20, 0x48, 0x52, 0xdf, 0xf0, 0xa1,
    0x5f, 0xd2, 0x7f, 0xae, 0xf4, 0x3, 0x3, 0xfe,
    0x40, 0x1f, 0x80, 0x7f, 0x8c, 0xee, 0xb, 0xff,
    0xfd, 0x45, 0x2, 0x60, 0x7f, 0x20, 0x4, 0xf,
    0xfe, 0xf, 0x3, 0xff, 0xef, 0xc0, 0xff, 0xe5,
    0xa0, 0x3f, 0x88, 0x13, 0x14, 0x81, 0xfc, 0xa8,
    0x60,

    /* U+42 "B" */
    0x1, 0xbf, 0xff, 0xb0, 0x12, 0x20, 0x7f, 0xc4,
    0x80, 0x36, 0x3, 0xfe, 0x60, 0x36, 0x79, 0x3f,
    0xd4, 0x6a, 0x44, 0x2d, 0xff, 0x16, 0x10, 0x11,
    0x3, 0xff, 0x9d, 0xc0, 0xff, 0xea, 0xf0, 0x3c,
    0x40, 0xfe, 0x20, 0x48, 0x52, 0xdf, 0xf0, 0xa1,
    0x5f, 0xd2, 0x7f, 0xaf, 0xea, 0x1, 0x81, 0xff,
    0x30, 0x13, 0xc0, 0x3f, 0xc6, 0x76, 0xc2, 0xff,
    0xff, 0x51, 0x0, 0x98, 0x1f, 0xc8, 0xf, 0xfe,
    0xaf, 0x3, 0xff, 0x89, 0xc0, 0xf1, 0x3, 0xff,
    0x82, 0x44, 0xd, 0xff, 0x16, 0x16, 0xcf, 0x64,
    0xfe, 0xbf, 0x50, 0xd8, 0xf, 0xfa, 0x1, 0x22,
    0x7, 0xfc, 0x48, 0x0,

    /* U+43 "C" */
    0x1, 0xbf, 0xff, 0xe0, 0xb0, 0x88, 0x1f, 0xfc,
    0x1a, 0x12, 0x1, 0xff, 0xc1, 0x97, 0xf4, 0x9f,
    0xfc, 0xc, 0x90, 0x52, 0xdf, 0xfc, 0x40, 0xc4,
    0xf, 0xff, 0xf8, 0x1f, 0xc8, 0xf, 0xfe, 0xb,
    0x18, 0x81, 0xff, 0xd2, 0x63, 0x10, 0x3f, 0xf8,
    0x88, 0xf, 0xff, 0xf8, 0x1f, 0xc4, 0xf, 0xfe,
    0xa, 0x14, 0xb7, 0xff, 0x11, 0x7f, 0x49, 0xff,
    0xc0, 0xc8, 0x24, 0x3, 0xff, 0x83, 0x2, 0x20,
    0x7f, 0xf0, 0x68,

    /* U+44 "D" */
    0xb, 0xff, 0xfe, 0x6, 0x3, 0xff, 0x88, 0x48,
    0x2, 0x40, 0x3f, 0xe6, 0x47, 0xf4, 0x9f, 0xeb,
    0xfa, 0x0, 0xa5, 0xbf, 0xe3, 0x3, 0x2, 0x20,
    0x7f, 0x70, 0x3f, 0xff, 0xc8, 0xf, 0xea, 0x7,
    0x62, 0x7, 0xf1, 0xa2, 0x1, 0xff, 0xc7, 0xc4,
    0xf, 0xe3, 0x44, 0x2, 0x40, 0x7f, 0x50, 0x3f,
    0xff, 0xc4, 0xf, 0xec, 0x7, 0x52, 0xdf, 0xf0,
    0x81, 0xff, 0x49, 0xfe, 0xbf, 0xa0, 0x48, 0x7,
    0xfc, 0xc8, 0x1f, 0xfc, 0x32, 0x40,

    /* U+45 "E" */
    0x1, 0xbf, 0xff, 0xe0, 0xc0, 0x88, 0x1f, 0xfc,
    0x14, 0x1b, 0x1, 0xff, 0xc1, 0xfb, 0x3c, 0x9f,
    0xfc, 0xc, 0x48, 0x42, 0xdf, 0xfc, 0x40, 0xc4,
    0xf, 0xff, 0xb9, 0x3, 0xff, 0x82, 0x85, 0x2d,
    0xff, 0x20, 0x2b, 0xfa, 0x4f, 0xf5, 0xa0, 0x33,
    0x3, 0xfe, 0x60, 0x27, 0x80, 0x7f, 0x8e, 0x0,
    0xc5, 0xff, 0xfd, 0x80, 0xf3, 0x3, 0xff, 0xee,
    0x40, 0xff, 0xe0, 0x91, 0x3, 0x7f, 0xf1, 0x1b,
    0x3d, 0x93, 0xfe, 0xc4, 0x36, 0x3, 0xff, 0x83,
    0xc2, 0x20, 0x7f, 0xf0, 0x50,

    /* U+46 "F" */
    0x1, 0xbf, 0xff, 0xe0, 0xc0, 0x48, 0xf, 0xfe,
    0xb, 0x0, 0xc0, 0xff, 0xe0, 0xed, 0x7b, 0x27,
    0xfd, 0x89, 0x8, 0x1b, 0xff, 0x88, 0x18, 0x81,
    0xff, 0xf7, 0x20, 0x7f, 0xf0, 0x50, 0xa5, 0xbf,
    0xe4, 0x5, 0x7f, 0x49, 0xfe, 0xb0, 0xc, 0xc0,
    0xff, 0x90, 0x7, 0xe0, 0x1f, 0xe3, 0x80, 0x41,
    0x7f, 0xff, 0x60, 0x3c, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xdf, 0x40, 0x7f, 0xf0, 0x58, 0xa4, 0xf,
    0xfe, 0x8,

    /* U+47 "G" */
    0x1, 0xbf, 0xff, 0xb0, 0x12, 0x20, 0x7f, 0xc4,
    0x80, 0x24, 0x3, 0xfe, 0x64, 0x5f, 0xd2, 0x7f,
    0xf0, 0x0, 0x21, 0x4b, 0x7f, 0xe0, 0x3c, 0x40,
    0xff, 0xff, 0x81, 0xf8, 0xb0, 0x3b, 0xfe, 0xa0,
    0x20, 0xc0, 0x74, 0x3, 0x91, 0x5, 0x1, 0xea,
    0x40, 0xc8, 0x8a, 0xb0, 0x1c, 0x74, 0x95, 0xde,
    0x80, 0x2c, 0xf, 0x37, 0x8, 0x10, 0x1f, 0xfc,
    0x12, 0x7, 0xff, 0x13, 0x81, 0xff, 0xd5, 0xe0,
    0x78, 0x81, 0xfc, 0x40, 0x88, 0x86, 0x4f, 0xe2,
    0xc2, 0xd9, 0xe3, 0x7f, 0xd3, 0xea, 0x1b, 0x1,
    0xff, 0x40, 0x3f, 0xf8, 0x84, 0x80,

    /* U+48 "H" */
    0x9d, 0x1, 0xff, 0x2f, 0x18, 0xa4, 0xf, 0xe3,
    0x43, 0x2, 0x40, 0x7f, 0x20, 0x3f, 0xff, 0xe0,
    0x7f, 0xf5, 0x48, 0x1f, 0xc4, 0x9, 0xa, 0x5b,
    0xfe, 0x14, 0x2b, 0xfa, 0x4f, 0xf5, 0xde, 0x80,
    0x60, 0x7f, 0xc8, 0x3, 0xf0, 0xf, 0xf1, 0x9d,
    0xc1, 0x7f, 0xff, 0xa8, 0x80, 0x4c, 0xf, 0xe4,
    0x7, 0xff, 0x13, 0x81, 0xff, 0xf7, 0xe0, 0x7f,
    0xf2, 0xd0, 0x1f, 0xc4, 0x9, 0x8a, 0x40, 0xfe,
    0x54, 0x30,

    /* U+49 "I" */
    0xbc, 0x84, 0x31, 0x2, 0x40, 0x7f, 0xf4, 0x8b,
    0xaf, 0x5, 0xe0, 0x71, 0xb4, 0x3, 0xff, 0xa6,
    0x80, 0xaa, 0x8,

    /* U+4A "J" */
    0x3, 0xff, 0x84, 0xbc, 0x3, 0xff, 0x82, 0x68,
    0x60, 0x7f, 0xf0, 0x50, 0x1f, 0xff, 0xf0, 0x3f,
    0xb8, 0x1f, 0xfc, 0x4e, 0x7, 0xff, 0x55, 0x90,
    0x40, 0xff, 0xe1, 0x67, 0xc0, 0xff, 0xe1, 0x12,
    0x77, 0xa0, 0x3f, 0xc7, 0x28, 0x85, 0x20, 0x7f,
    0x20, 0x4, 0x9, 0x1, 0xff, 0xce, 0xe0, 0x7f,
    0xf1, 0x38, 0x1f, 0xfc, 0xb2, 0x7, 0xf1, 0x2,
    0x22, 0x6, 0xff, 0x83, 0xb, 0x67, 0xb2, 0x7f,
    0x51, 0xa8, 0x6c, 0x7, 0xfc, 0xc0, 0x91, 0x3,
    0xff, 0x84,

    /* U+4B "K" */
    0x3, 0xff, 0x8b, 0x3a, 0x3, 0xfc, 0xaf, 0xc,
    0x52, 0x7, 0xf5, 0x40, 0x81, 0x20, 0x3f, 0x40,
    0x26, 0x7, 0xfc, 0x58, 0x4, 0x80, 0x7f, 0xdc,
    0xa, 0x1, 0xff, 0x22, 0x1, 0x90, 0x3f, 0xe8,
    0x5, 0x0, 0xff, 0x91, 0x1, 0x0, 0xff, 0xe0,
    0x20, 0x26, 0x7, 0x88, 0x1e, 0x97, 0x81, 0x90,
    0xa1, 0xbf, 0x2, 0xd0, 0x15, 0xfd, 0x64, 0xfe,
    0xb4, 0x6, 0x60, 0x7f, 0xcc, 0x3, 0xf0, 0xf,
    0xfa, 0x77, 0x5, 0xdf, 0xff, 0x6a, 0x20, 0x12,
    0x3, 0xf9, 0x1, 0xff, 0xc4, 0xe0, 0x7f, 0xfd,
    0xf8, 0x1f, 0xfc, 0xb4, 0x7, 0xf2, 0x2, 0x62,
    0x90, 0x3f, 0x8d, 0xc,

    /* U+4C "L" */
    0xbc, 0x81, 0xff, 0xc1, 0x43, 0x10, 0x3f, 0xf8,
    0x68, 0xf, 0xff, 0xf8, 0x1f, 0xfe, 0x72, 0xc0,
    0xff, 0xe0, 0x57, 0x80, 0xff, 0xe0, 0xe6, 0x40,
    0xff, 0xe0, 0xb1, 0x88, 0x1f, 0xfc, 0x34, 0x7,
    0xff, 0xfc, 0xc, 0x40, 0xff, 0xe0, 0x21, 0x4b,
    0x7f, 0xc8, 0x5, 0xfd, 0x27, 0xfa, 0xc0, 0x9,
    0x0, 0xff, 0x99, 0x3, 0xff, 0x84, 0x48,

    /* U+4D "M" */
    0x9d, 0x1, 0xff, 0xc3, 0x5e, 0x6, 0x29, 0x3,
    0xff, 0x82, 0x68, 0x60, 0x64, 0xfc, 0x20, 0x71,
    0x9e, 0x20, 0x3f, 0x50, 0xf8, 0x1d, 0xd8, 0x40,
    0x7f, 0x50, 0x5, 0x1, 0x22, 0x2, 0x81, 0xfc,
    0xc0, 0xb8, 0x17, 0x2, 0x60, 0x7f, 0x98, 0x4,
    0x40, 0x20, 0x8, 0xf, 0xfa, 0x81, 0x51, 0x0,
    0xa0, 0x1f, 0xf1, 0x40, 0x18, 0x60, 0x9, 0x1,
    0xff, 0xc0, 0xe0, 0x7d, 0x0, 0xfe, 0x2c, 0x2,
    0x21, 0x86, 0xa, 0x0, 0xc8, 0x15, 0x58, 0xd,
    0xdd, 0xd8, 0xf8, 0x1b, 0x2a, 0x0, 0x81, 0xc6,
    0x73, 0x68, 0x81, 0xc4, 0x5, 0x78, 0xf, 0x10,
    0x3f, 0x67, 0x40, 0x8b, 0x3, 0xb5, 0xc4, 0xc,
    0xc8, 0x1f, 0xfc, 0x2, 0x88, 0x1f, 0xff, 0xf0,
    0x3f, 0xff, 0x44, 0xf, 0xfe, 0xa, 0x3, 0x31,
    0x50, 0x1f, 0xfc, 0x13, 0x43, 0x0,

    /* U+4E "N" */
    0x9d, 0x3, 0x48, 0x1f, 0x2f, 0x18, 0xa6, 0x2e,
    0x7, 0x8d, 0xc, 0xa, 0xa0, 0x50, 0x1c, 0x80,
    0xf7, 0x2, 0xe0, 0x7f, 0xf0, 0x58, 0x4, 0x40,
    0xff, 0xe0, 0x50, 0x2a, 0x7, 0xff, 0x0, 0xa0,
    0xc, 0xf, 0xfe, 0xf, 0x2, 0x60, 0x7f, 0xf0,
    0x11, 0x1, 0x80, 0xff, 0xe0, 0xe8, 0x78, 0x1f,
    0xc5, 0x81, 0x3c, 0x80, 0x99, 0x1, 0x56, 0x3,
    0xb5, 0x20, 0x59, 0x50, 0x40, 0xe6, 0x56, 0x20,
    0x45, 0xd7, 0x80, 0xc8, 0x9, 0x0, 0xcf, 0x0,
    0x2c, 0x8, 0x90, 0xa, 0x19, 0x3, 0xfd, 0x40,
    0x12, 0x3, 0xff, 0x80, 0xc0, 0xaf, 0x3, 0xff,
    0x80, 0x80, 0x30, 0x3f, 0xf8, 0x3c, 0x8, 0x81,
    0xff, 0xc0, 0x40, 0x9, 0x1, 0xff, 0xc1, 0x87,
    0xf0, 0x1f, 0xfc, 0x17, 0x88, 0x1f, 0x20, 0x3f,
    0x88, 0x13, 0x14, 0x81, 0xfc, 0xa8, 0x60,

    /* U+4F "O" */
    0x1, 0xbf, 0xff, 0xb0, 0x12, 0x20, 0x7f, 0xc4,
    0x80, 0x36, 0x3, 0xfe, 0x80, 0x36, 0x79, 0x3f,
    0xd7, 0xea, 0x44, 0x2d, 0xff, 0x16, 0x10, 0x11,
    0x3, 0xfb, 0x81, 0xff, 0xed, 0x40, 0x7f, 0x60,
    0x24, 0x29, 0x3, 0xf9, 0x50, 0xef, 0x40, 0x7f,
    0xcb, 0xc0, 0x3f, 0xf8, 0xb3, 0x90, 0x3f, 0xe5,
    0xe3, 0x18, 0x81, 0xfc, 0xa8, 0x60, 0x48, 0xf,
    0xec, 0x7, 0xff, 0xb4, 0x81, 0xfd, 0xc0, 0x88,
    0x81, 0xbf, 0xe2, 0xc2, 0xd9, 0xec, 0x9f, 0xd7,
    0xda, 0xd, 0x80, 0xff, 0xa3, 0x0, 0x88, 0x1f,
    0xf1, 0x20,

    /* U+50 "P" */
    0x1, 0xbf, 0xff, 0xb0, 0x11, 0x20, 0x3f, 0xe2,
    0x40, 0x4c, 0xf, 0xfa, 0x0, 0xd9, 0xe4, 0xff,
    0x5f, 0xa9, 0x10, 0xb7, 0xfc, 0x58, 0x40, 0x44,
    0xf, 0xfe, 0x77, 0x3, 0xff, 0x89, 0xc0, 0xff,
    0xe5, 0xa0, 0x3f, 0x90, 0x14, 0x17, 0x7f, 0xfe,
    0xa2, 0x3f, 0x0, 0xff, 0x19, 0xd8, 0x6, 0x7,
    0xfc, 0xc0, 0x5f, 0xd2, 0x7f, 0xad, 0x0, 0x42,
    0x96, 0xff, 0x90, 0x1e, 0x20, 0x7f, 0xff, 0xc0,
    0xff, 0xef, 0xa0, 0x3f, 0xf8, 0x2c, 0x62, 0x7,
    0xff, 0x4,

    /* U+51 "Q" */
    0x1, 0xbf, 0xff, 0xb0, 0x12, 0x20, 0x7f, 0xc4,
    0x80, 0x36, 0x3, 0xfe, 0x80, 0x36, 0x79, 0x3f,
    0xd7, 0xea, 0x44, 0x2d, 0xff, 0x16, 0x10, 0x11,
    0x3, 0xfb, 0x81, 0xff, 0xed, 0x40, 0x7f, 0x60,
    0x24, 0x31, 0x3, 0xf9, 0x40, 0xef, 0x20, 0x7f,
    0xcf, 0xc0, 0x3f, 0xf8, 0xb3, 0x90, 0x3f, 0xe5,
    0xdb, 0xc, 0x40, 0xfe, 0x54, 0x40, 0x24, 0x7,
    0xf6, 0x3, 0xfc, 0x90, 0xf, 0xfe, 0x11, 0xb4,
    0xc0, 0xff, 0xe0, 0xb0, 0x10, 0xf, 0xf1, 0x0,
    0x88, 0x40, 0x5c, 0x8, 0x86, 0x5b, 0xac, 0xcd,
    0xc1, 0x85, 0xb0, 0x49, 0xff, 0x7b, 0x41, 0xb0,
    0x1f, 0xf4, 0x60, 0x11, 0x3, 0xfe, 0x24, 0x5,
    0xbf, 0xd6, 0x6f, 0xf6, 0x3, 0xf1, 0xb3, 0x1,
    0xff, 0xc1, 0x60, 0x8, 0x1f, 0xfc, 0x14, 0x4b,
    0x1, 0xf0,

    /* U+52 "R" */
    0x1, 0xbf, 0xff, 0xa8, 0x12, 0x20, 0x7f, 0xc8,
    0x80, 0x48, 0x7, 0xfc, 0xc8, 0xbf, 0xac, 0x9f,
    0xd7, 0xf4, 0x42, 0x86, 0xff, 0x8c, 0xc, 0x8,
    0x81, 0xfd, 0xc0, 0xff, 0xf6, 0xa0, 0x3f, 0xb8,
    0x12, 0x15, 0x37, 0xfc, 0x48, 0x1b, 0x84, 0x9f,
    0xeb, 0x4b, 0x82, 0x40, 0x7f, 0xd2, 0x9b, 0xd4,
    0x3, 0xfc, 0x40, 0x21, 0x97, 0xff, 0xa6, 0xc0,
    0x39, 0x1, 0xf4, 0x8c, 0x40, 0xff, 0xe2, 0x62,
    0x7, 0xff, 0x13, 0x1, 0xff, 0xc0, 0x88, 0xa,
    0x81, 0xff, 0xc0, 0xa4, 0xf, 0xfe, 0x26, 0x8e,
    0x1, 0xff, 0xc1, 0x71, 0xf0, 0x24, 0x7, 0xf7,
    0x0, 0x50, 0xc4, 0xf, 0xea, 0x1, 0x80,

    /* U+53 "S" */
    0x1, 0xbf, 0xff, 0xe0, 0xc0, 0x48, 0xf, 0xfe,
    0xa, 0x1, 0x0, 0xff, 0xe0, 0xfd, 0x9e, 0xc9,
    0xff, 0x62, 0x41, 0x86, 0xff, 0xe2, 0x6, 0x20,
    0x7f, 0xfd, 0xd0, 0x1f, 0xfc, 0x18, 0x2e, 0xff,
    0xfc, 0x4, 0xfc, 0x3, 0xfe, 0xc0, 0x66, 0x7,
    0xfc, 0xc0, 0xd6, 0x4f, 0xf5, 0xfd, 0x40, 0x9b,
    0xff, 0xa, 0x10, 0x1f, 0xfc, 0x12, 0x7, 0xff,
    0xdc, 0x81, 0x93, 0x7f, 0xf1, 0x60, 0xab, 0x27,
    0xff, 0x0, 0x5d, 0x40, 0xff, 0xe0, 0xb6, 0xc,
    0xf, 0xfe, 0x9, 0x20,

    /* U+54 "T" */
    0xbf, 0xff, 0xf0, 0xda, 0x3, 0xff, 0x87, 0x68,
    0xf, 0xfe, 0x1f, 0x56, 0x4f, 0xfe, 0xe, 0x21,
    0x37, 0xe4, 0xdf, 0x88, 0x1f, 0x96, 0xe0, 0x7f,
    0xf0, 0x4d, 0x3, 0xff, 0x86, 0xc0, 0xff, 0xe4,
    0x10, 0x3f, 0xfa, 0xa4, 0xf, 0xfe, 0x8a, 0x3,
    0xff, 0x8b, 0x82, 0x3, 0xff, 0x87, 0xa8, 0x1f,
    0xfc, 0x13, 0xb0, 0x81, 0xff, 0xc1, 0x60, 0x30,
    0x1f, 0xfe, 0x72, 0x7, 0xff, 0x10, 0x81, 0xff,
    0xd4, 0x20, 0x7f, 0xf0, 0x51, 0x2c, 0x7, 0xc0,

    /* U+55 "U" */
    0xbc, 0x81, 0xff, 0x3e, 0xd0, 0xc4, 0xf, 0xe5,
    0x5, 0x2, 0x40, 0x7f, 0x70, 0x3f, 0xff, 0xe0,
    0x7f, 0xf7, 0xc8, 0x1c, 0x58, 0x1f, 0xd4, 0xa,
    0xbc, 0x7, 0xf8, 0xe7, 0xf3, 0x20, 0x7f, 0xcd,
    0xe1, 0x88, 0x1f, 0xca, 0x88, 0x4, 0x80, 0xfe,
    0xc0, 0x7f, 0xff, 0x88, 0x1f, 0xd8, 0x9, 0xa,
    0x5b, 0xfe, 0x10, 0x2b, 0xfa, 0x4f, 0xf5, 0x1e,
    0x4, 0x80, 0x7f, 0xd0, 0x9, 0x1, 0xff, 0xc0,
    0x40, 0x0,

    /* U+56 "V" */
    0xbc, 0x81, 0xff, 0x2f, 0x10, 0xc4, 0xf, 0xe5,
    0x43, 0x2, 0x40, 0x7f, 0x60, 0x3f, 0xff, 0xe0,
    0x7f, 0xf9, 0x4b, 0x3, 0xfa, 0x10, 0x6b, 0xc0,
    0x7f, 0xd9, 0xf5, 0x40, 0xff, 0xe0, 0xd3, 0xb3,
    0xc0, 0x3f, 0xaf, 0xd4, 0x80, 0x68, 0xf, 0xa2,
    0x2, 0xa0, 0x54, 0x81, 0xc9, 0x81, 0x55, 0x0,
    0xb8, 0x18, 0xd0, 0x2a, 0x1, 0xa0, 0x6, 0x81,
    0x70, 0x28, 0x80, 0xa9, 0x0, 0x90, 0x32, 0x1,
    0x30, 0x3b, 0x81, 0x30, 0x40, 0x1a, 0x7, 0x8d,
    0x0, 0x49, 0x80, 0xe0, 0x7e, 0x5b, 0x26, 0x7b,
    0x90, 0x3f, 0x8b, 0x61, 0x48, 0x1f, 0xfc, 0x4,
    0x42, 0x3, 0xe0,

    /* U+57 "W" */
    0xbc, 0x81, 0xff, 0x2f, 0x0, 0xff, 0xb7, 0x8,
    0x62, 0x7, 0xf2, 0xa1, 0x81, 0xfe, 0xc4, 0x20,
    0x24, 0x7, 0xf6, 0x3, 0xff, 0x82, 0x40, 0xff,
    0xff, 0x81, 0xff, 0xff, 0x3, 0xff, 0xf8, 0x58,
    0x1f, 0xfc, 0xb8, 0x5, 0x5e, 0x3, 0xff, 0x98,
    0xe4, 0x24, 0xa0, 0x7f, 0xdc, 0xf, 0xfe, 0x12,
    0x41, 0xb3, 0xc0, 0x3f, 0x99, 0x4, 0xf, 0xe5,
    0xf6, 0x12, 0x0, 0xd0, 0x1f, 0xda, 0x60, 0x3f,
    0x1a, 0x6, 0xa0, 0x54, 0x81, 0xc6, 0x54, 0xe4,
    0x20, 0x3d, 0xc0, 0x99, 0x50, 0xb, 0x81, 0x8e,
    0x6a, 0x37, 0x54, 0x6, 0xa4, 0x2, 0x80, 0x1a,
    0x0, 0x68, 0x17, 0x2, 0xa8, 0xa, 0x90, 0xd,
    0x0, 0x34, 0xd, 0x48, 0x4, 0x81, 0x90, 0x9,
    0x98, 0x5, 0x0, 0x40, 0x2e, 0x7, 0xb8, 0x13,
    0x4, 0x1, 0xa0, 0x1a, 0x3, 0xf5, 0x20, 0x78,
    0xd0, 0x4, 0x98, 0xe, 0x6, 0xa4, 0x12, 0x8,
    0x34, 0x7, 0xe5, 0xb2, 0x67, 0xb9, 0x3, 0xb5,
    0xad, 0x97, 0x40, 0x3f, 0xc5, 0xb0, 0xa4, 0xf,
    0xcb, 0x83, 0x8, 0x1f, 0xfc, 0x4, 0x42, 0x3,
    0xfd, 0x40, 0x50, 0x3e,

    /* U+58 "X" */
    0xbd, 0x1, 0xfd, 0x79, 0x42, 0x90, 0x3e, 0x88,
    0x52, 0x1, 0x81, 0xf2, 0x1, 0xfa, 0x54, 0x7,
    0xda, 0x43, 0x5b, 0x10, 0x1f, 0x4d, 0x4d, 0x4e,
    0x90, 0x3a, 0x34, 0x55, 0x2, 0xe0, 0x64, 0xc0,
    0x93, 0x40, 0xc, 0x0, 0x68, 0x15, 0x22, 0x81,
    0x32, 0x28, 0x13, 0x40, 0x58, 0x8, 0x81, 0x8c,
    0x3, 0x18, 0x0, 0xbe, 0x3, 0x1, 0xe7, 0xae,
    0x9a, 0xf0, 0x3f, 0x1c, 0x1, 0x30, 0x3f, 0x1a,
    0x10, 0x92, 0x3, 0xee, 0x9d, 0xe1, 0x36, 0x3,
    0xa9, 0x0, 0x47, 0x1, 0x10, 0x14, 0x40, 0x9,
    0xc, 0x5, 0x48, 0x4c, 0xb, 0x80, 0x4c, 0xb,
    0x8a, 0x5, 0x88, 0x14, 0x40, 0xb, 0x60, 0x69,
    0x3, 0xaa, 0x24, 0xac, 0x84, 0x7, 0xd6, 0xc7,
    0xca, 0x80, 0xfb, 0x48, 0x64, 0x3, 0x3, 0xe4,
    0x3, 0xb1, 0x48, 0x1f, 0x44, 0x28,

    /* U+59 "Y" */
    0xbd, 0x1, 0xff, 0x2e, 0xd0, 0xa4, 0xf, 0xe5,
    0x45, 0x20, 0x18, 0x1f, 0xc4, 0x3, 0xf2, 0xa0,
    0x3f, 0x9c, 0x8b, 0x2f, 0x40, 0x7f, 0x3b, 0x1a,
    0x2a, 0x90, 0x3e, 0x50, 0x8d, 0x0, 0xb8, 0x1e,
    0x34, 0xa, 0x34, 0x0, 0xd0, 0x3b, 0x81, 0x42,
    0x29, 0x0, 0x98, 0x15, 0x20, 0x13, 0x2, 0xe0,
    0x50, 0x84, 0x80, 0xd, 0x3, 0x1a, 0x4, 0xc0,
    0xee, 0x7, 0x93, 0x0, 0xc8, 0x15, 0x20, 0x7d,
    0x21, 0xec, 0x91, 0x50, 0x1f, 0xcf, 0x0, 0x2d,
    0x1, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x40, 0xff,
    0xe0, 0xa2, 0x58, 0xf, 0x80,

    /* U+5A "Z" */
    0xbf, 0xff, 0xf0, 0xe2, 0x3, 0xff, 0x86, 0xa8,
    0x1f, 0xfc, 0x3e, 0xac, 0x9f, 0xfc, 0x1c, 0x42,
    0x6f, 0xfb, 0xd8, 0x8, 0x1f, 0xf4, 0x64, 0x60,
    0x3f, 0xe4, 0xc0, 0xa0, 0x1f, 0xe3, 0x40, 0xa9,
    0x3, 0xfd, 0x80, 0x9a, 0x3, 0xff, 0x84, 0xa0,
    0x1f, 0xfc, 0x2, 0xd, 0x3, 0xfc, 0x5b, 0x57,
    0x80, 0xff, 0x1d, 0x23, 0x40, 0x3f, 0xec, 0x4,
    0x40, 0xff, 0xb0, 0x11, 0x80, 0x7f, 0xa1, 0x2,
    0xc0, 0x7f, 0x9b, 0x1, 0x60, 0x3f, 0xea, 0x5,
    0x48, 0x1f, 0xfc, 0x28, 0x80, 0xff, 0xe0, 0x20,
    0x98, 0x1f, 0xfc, 0x1d, 0x33, 0x7f, 0xf1, 0xa,
    0xc9, 0xff, 0xc1, 0xc6, 0x81, 0xff, 0xc3, 0xe8,
    0xf, 0xfe, 0x1d,

    /* U+5B "[" */
    0x1, 0xbf, 0xff, 0xa8, 0x4, 0x40, 0xff, 0x90,
    0x4, 0xc0, 0xff, 0xa0, 0x9a, 0xc9, 0xfe, 0xac,
    0x33, 0x93, 0x7f, 0xc8, 0xe, 0x40, 0x7f, 0xf8,
    0xd0, 0x1f, 0xfc, 0x4, 0x31, 0x3, 0xff, 0x81,
    0x79, 0x3, 0xff, 0x83, 0x79, 0x3, 0xff, 0x82,
    0x86, 0x20, 0x7f, 0xf0, 0xd0, 0x1f, 0xfe, 0x34,
    0x7, 0xff, 0x1, 0x9c, 0x40, 0xff, 0xe0, 0x70,
    0x3f, 0xf8, 0x70, 0xe0, 0x3f, 0xf8, 0x8c, 0xf,
    0xff, 0x19, 0x3, 0xff, 0x80, 0x85, 0x2d, 0xff,
    0x20, 0x17, 0xf4, 0x9f, 0xeb, 0x0, 0x24, 0x3,
    0xfe, 0x64, 0x22, 0x7, 0xfc, 0x88,

    /* U+5C "\\" */
    0xbd, 0x1, 0xff, 0xc0, 0x42, 0x90, 0x3f, 0xe2,
    0x1, 0x81, 0xff, 0x79, 0x50, 0x1f, 0xf5, 0xae,
    0x80, 0xff, 0x91, 0x55, 0x1, 0xfe, 0x80, 0x54,
    0xf, 0xf2, 0x60, 0x58, 0xf, 0xf4, 0x40, 0x9,
    0x1, 0xfe, 0xa4, 0x1, 0x3, 0xfe, 0xe9, 0xde,
    0x40, 0xfe, 0x34, 0x21, 0x80, 0xff, 0xa8, 0x4,
    0x40, 0xff, 0x1d, 0x3e, 0xe0, 0x7f, 0x8b, 0x20,
    0x30, 0x1f, 0xf7, 0x0, 0x60, 0x1f, 0xea, 0x4,
    0xd0, 0x1f, 0xc6, 0x81, 0x52, 0x7, 0xf2, 0x60,
    0x48, 0xf, 0xf4, 0x68, 0xa0, 0x3f, 0xea, 0x69,
    0x3, 0xfe, 0xee, 0x30, 0x3f, 0xe4, 0x3, 0x81,
    0xff, 0x44, 0x28,

    /* U+5D "]" */
    0xbf, 0xff, 0xf0, 0x8, 0x4, 0x7, 0xff, 0x1,
    0x0, 0xa0, 0x7f, 0xc9, 0x80, 0x56, 0x4f, 0xf5,
    0xb0, 0x4, 0xdf, 0xfb, 0x24, 0x20, 0x7f, 0xc8,
    0x81, 0xff, 0xe2, 0x40, 0x7f, 0xf1, 0x30, 0x24,
    0x7, 0xff, 0x0, 0xfc, 0x7, 0xff, 0x4, 0xfa,
    0x7, 0xff, 0x7, 0x4, 0x40, 0xff, 0x90, 0x1f,
    0xfe, 0x34, 0x40, 0xff, 0xe1, 0xe2, 0x88, 0x1f,
    0xfc, 0x16, 0x40, 0xff, 0xe0, 0xe4, 0xc0, 0xff,
    0xe0, 0x22, 0x7, 0xff, 0x89, 0x81, 0xc9, 0xbf,
    0xe5, 0x81, 0xa, 0xc9, 0xff, 0x7c, 0x28, 0x1f,
    0xf2, 0x60, 0x18, 0x1f, 0xfc, 0x4, 0x0,

    /* U+5E "^" */
    0x3, 0xff, 0x95, 0xfc, 0x80, 0xff, 0xe1, 0x90,
    0x3f, 0xda, 0xc0, 0x9f, 0x80, 0x7d, 0x8a, 0x4f,
    0x58, 0x6c, 0x7, 0x12, 0x3, 0xf5, 0x3, 0x24,
    0xb2, 0x90, 0xe, 0x47, 0x80, 0x15, 0x85, 0xa0,
    0x33, 0x68, 0xf0, 0xa0, 0x7f, 0xcc, 0x18, 0xc0,
    0x20, 0x3f, 0x50, 0x18,

    /* U+5F "_" */
    0x9, 0xbf, 0xf8, 0x2, 0xb2, 0x7f, 0xd4, 0x50,
    0x3f, 0xf8, 0x9, 0x40, 0x7f, 0xf0, 0x58,

    /* U+60 "`" */
    0xbc, 0x81, 0x90, 0xc4, 0xf, 0x30, 0x2d, 0x28,
    0x60, 0xb, 0x6b, 0x18, 0x13, 0x1, 0x0, 0x91,
    0x8, 0x0,

    /* U+61 "a" */
    0x1, 0xbf, 0xff, 0xb0, 0x12, 0x20, 0x7f, 0xc4,
    0x80, 0x36, 0x3, 0xfe, 0x60, 0x36, 0x79, 0x3f,
    0xd4, 0x6a, 0x44, 0x2d, 0xff, 0x16, 0x10, 0x11,
    0x3, 0xff, 0x9d, 0xc0, 0xff, 0xea, 0xf0, 0x3c,
    0x40, 0xfe, 0x20, 0x48, 0x52, 0xdf, 0xf0, 0xa1,
    0x5f, 0xd2, 0x7f, 0xae, 0xf4, 0x3, 0x3, 0xfe,
    0x40, 0x1f, 0x80, 0x7f, 0x8c, 0xee, 0xb, 0xff,
    0xfd, 0x45, 0x2, 0x60, 0x7f, 0x20, 0x4, 0xf,
    0xfe, 0xf, 0x3, 0xff, 0xef, 0xc0, 0xff, 0xe5,
    0xa0, 0x3f, 0x88, 0x13, 0x14, 0x81, 0xfc, 0xa8,
    0x60,

    /* U+62 "b" */
    0x1, 0xbf, 0xff, 0xb0, 0x12, 0x20, 0x7f, 0xc4,
    0x80, 0x36, 0x3, 0xfe, 0x60, 0x36, 0x79, 0x3f,
    0xd4, 0x6a, 0x44, 0x2d, 0xff, 0x16, 0x10, 0x11,
    0x3, 0xff, 0x9d, 0xc0, 0xff, 0xea, 0xf0, 0x3c,
    0x40, 0xfe, 0x20, 0x48, 0x52, 0xdf, 0xf0, 0xa1,
    0x5f, 0xd2, 0x7f, 0xaf, 0xea, 0x1, 0x81, 0xff,
    0x30, 0x13, 0xc0, 0x3f, 0xc6, 0x76, 0xc2, 0xff,
    0xff, 0x51, 0x0, 0x98, 0x1f, 0xc8, 0xf, 0xfe,
    0xaf, 0x3, 0xff, 0x89, 0xc0, 0xf1, 0x3, 0xff,
    0x82, 0x44, 0xd, 0xff, 0x16, 0x16, 0xcf, 0x64,
    0xfe, 0xbf, 0x50, 0xd8, 0xf, 0xfa, 0x1, 0x22,
    0x7, 0xfc, 0x48, 0x0,

    /* U+63 "c" */
    0x1, 0xbf, 0xff, 0xe0, 0xb0, 0x88, 0x1f, 0xfc,
    0x1a, 0x12, 0x1, 0xff, 0xc1, 0x97, 0xf4, 0x9f,
    0xfc, 0xc, 0x90, 0x52, 0xdf, 0xfc, 0x40, 0xc4,
    0xf, 0xff, 0xf8, 0x1f, 0xc8, 0xf, 0xfe, 0xb,
    0x18, 0x81, 0xff, 0xd2, 0x63, 0x10, 0x3f, 0xf8,
    0x88, 0xf, 0xff, 0xf8, 0x1f, 0xc4, 0xf, 0xfe,
    0xa, 0x14, 0xb7, 0xff, 0x11, 0x7f, 0x49, 0xff,
    0xc0, 0xc8, 0x24, 0x3, 0xff, 0x83, 0x2, 0x20,
    0x7f, 0xf0, 0x68,

    /* U+64 "d" */
    0xb, 0xff, 0xfe, 0x6, 0x3, 0xff, 0x88, 0x48,
    0x2, 0x40, 0x3f, 0xe6, 0x47, 0xf4, 0x9f, 0xeb,
    0xfa, 0x0, 0xa5, 0xbf, 0xe3, 0x3, 0x2, 0x20,
    0x7f, 0x70, 0x3f, 0xff, 0xc8, 0xf, 0xea, 0x7,
    0x62, 0x7, 0xf1, 0xa2, 0x1, 0xff, 0xc7, 0xc4,
    0xf, 0xe3, 0x44, 0x2, 0x40, 0x7f, 0x50, 0x3f,
    0xff, 0xc4, 0xf, 0xec, 0x7, 0x52, 0xdf, 0xf0,
    0x81, 0xff, 0x49, 0xfe, 0xbf, 0xa0, 0x48, 0x7,
    0xfc, 0xc8, 0x1f, 0xfc, 0x32, 0x40,

    /* U+65 "e" */
    0x1, 0xbf, 0xff, 0xe0, 0xc0, 0x88, 0x1f, 0xfc,
    0x14, 0x1b, 0x1, 0xff, 0xc1, 0xfb, 0x3c, 0x9f,
    0xfc, 0xc, 0x48, 0x42, 0xdf, 0xfc, 0x40, 0xc4,
    0xf, 0xff, 0xb9, 0x3, 0xff, 0x82, 0x85, 0x2d,
    0xff, 0x20, 0x2b, 0xfa, 0x4f, 0xf5, 0xa0, 0x33,
    0x3, 0xfe, 0x60, 0x27, 0x80, 0x7f, 0x8e, 0x0,
    0xc5, 0xff, 0xfd, 0x80, 0xf3, 0x3, 0xff, 0xee,
    0x40, 0xff, 0xe0, 0x91, 0x3, 0x7f, 0xf1, 0x1b,
    0x3d, 0x93, 0xfe, 0xc4, 0x36, 0x3, 0xff, 0x83,
    0xc2, 0x20, 0x7f, 0xf0, 0x50,

    /* U+66 "f" */
    0x1, 0xbf, 0xff, 0xe0, 0xc0, 0x48, 0xf, 0xfe,
    0xb, 0x0, 0xc0, 0xff, 0xe0, 0xed, 0x7b, 0x27,
    0xfd, 0x89, 0x8, 0x1b, 0xff, 0x88, 0x18, 0x81,
    0xff, 0xf7, 0x20, 0x7f, 0xf0, 0x50, 0xa5, 0xbf,
    0xe4, 0x5, 0x7f, 0x49, 0xfe, 0xb0, 0xc, 0xc0,
    0xff, 0x90, 0x7, 0xe0, 0x1f, 0xe3, 0x80, 0x41,
    0x7f, 0xff, 0x60, 0x3c, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xdf, 0x40, 0x7f, 0xf0, 0x58, 0xa4, 0xf,
    0xfe, 0x8,

    /* U+67 "g" */
    0x1, 0xbf, 0xff, 0xb0, 0x12, 0x20, 0x7f, 0xc4,
    0x80, 0x24, 0x3, 0xfe, 0x64, 0x5f, 0xd2, 0x7f,
    0xf0, 0x0, 0x21, 0x4b, 0x7f, 0xe0, 0x3c, 0x40,
    0xff, 0xff, 0x81, 0xf8, 0xb0, 0x3b, 0xfe, 0xa0,
    0x20, 0xc0, 0x74, 0x3, 0x91, 0x5, 0x1, 0xea,
    0x40, 0xc8, 0x8a, 0xb0, 0x1c, 0x74, 0x95, 0xde,
    0x80, 0x2c, 0xf, 0x37, 0x8, 0x10, 0x1f, 0xfc,
    0x12, 0x7, 0xff, 0x13, 0x81, 0xff, 0xd5, 0xe0,
    0x78, 0x81, 0xfc, 0x40, 0x88, 0x86, 0x4f, 0xe2,
    0xc2, 0xd9, 0xe3, 0x7f, 0xd3, 0xea, 0x1b, 0x1,
    0xff, 0x40, 0x3f, 0xf8, 0x84, 0x80,

    /* U+68 "h" */
    0x9d, 0x1, 0xff, 0x2f, 0x18, 0xa4, 0xf, 0xe3,
    0x43, 0x2, 0x40, 0x7f, 0x20, 0x3f, 0xff, 0xe0,
    0x7f, 0xf5, 0x48, 0x1f, 0xc4, 0x9, 0xa, 0x5b,
    0xfe, 0x14, 0x2b, 0xfa, 0x4f, 0xf5, 0xde, 0x80,
    0x60, 0x7f, 0xc8, 0x3, 0xf0, 0xf, 0xf1, 0x9d,
    0xc1, 0x7f, 0xff, 0xa8, 0x80, 0x4c, 0xf, 0xe4,
    0x7, 0xff, 0x13, 0x81, 0xff, 0xf7, 0xe0, 0x7f,
    0xf2, 0xd0, 0x1f, 0xc4, 0x9, 0x8a, 0x40, 0xfe,
    0x54, 0x30,

    /* U+69 "i" */
    0xbc, 0x84, 0x31, 0x2, 0x40, 0x7f, 0xf4, 0x8b,
    0xaf, 0x5, 0xe0, 0x71, 0xb4, 0x3, 0xff, 0xa6,
    0x80, 0xaa, 0x8,

    /* U+6A "j" */
    0x3, 0xff, 0x84, 0xbc, 0x3, 0xff, 0x82, 0x68,
    0x60, 0x7f, 0xf0, 0x50, 0x1f, 0xff, 0xf0, 0x3f,
    0xb8, 0x1f, 0xfc, 0x4e, 0x7, 0xff, 0x55, 0x90,
    0x40, 0xff, 0xe1, 0x67, 0xc0, 0xff, 0xe1, 0x12,
    0x77, 0xa0, 0x3f, 0xc7, 0x28, 0x85, 0x20, 0x7f,
    0x20, 0x4, 0x9, 0x1, 0xff, 0xce, 0xe0, 0x7f,
    0xf1, 0x38, 0x1f, 0xfc, 0xb2, 0x7, 0xf1, 0x2,
    0x22, 0x6, 0xff, 0x83, 0xb, 0x67, 0xb2, 0x7f,
    0x51, 0xa8, 0x6c, 0x7, 0xfc, 0xc0, 0x91, 0x3,
    0xff, 0x84,

    /* U+6B "k" */
    0x3, 0xff, 0x8b, 0x3a, 0x3, 0xfc, 0xaf, 0xc,
    0x52, 0x7, 0xf5, 0x40, 0x81, 0x20, 0x3f, 0x40,
    0x26, 0x7, 0xfc, 0x58, 0x4, 0x80, 0x7f, 0xdc,
    0xa, 0x1, 0xff, 0x22, 0x1, 0x90, 0x3f, 0xe8,
    0x5, 0x0, 0xff, 0x91, 0x1, 0x0, 0xff, 0xe0,
    0x20, 0x26, 0x7, 0x88, 0x1e, 0x97, 0x81, 0x90,
    0xa1, 0xbf, 0x2, 0xd0, 0x15, 0xfd, 0x64, 0xfe,
    0xb4, 0x6, 0x60, 0x7f, 0xcc, 0x3, 0xf0, 0xf,
    0xfa, 0x77, 0x5, 0xdf, 0xff, 0x6a, 0x20, 0x12,
    0x3, 0xf9, 0x1, 0xff, 0xc4, 0xe0, 0x7f, 0xfd,
    0xf8, 0x1f, 0xfc, 0xb4, 0x7, 0xf2, 0x2, 0x62,
    0x90, 0x3f, 0x8d, 0xc,

    /* U+6C "l" */
    0xbc, 0x81, 0xff, 0xc1, 0x43, 0x10, 0x3f, 0xf8,
    0x68, 0xf, 0xff, 0xf8, 0x1f, 0xfe, 0x72, 0xc0,
    0xff, 0xe0, 0x57, 0x80, 0xff, 0xe0, 0xe6, 0x40,
    0xff, 0xe0, 0xb1, 0x88, 0x1f, 0xfc, 0x34, 0x7,
    0xff, 0xfc, 0xc, 0x40, 0xff, 0xe0, 0x21, 0x4b,
    0x7f, 0xc8, 0x5, 0xfd, 0x27, 0xfa, 0xc0, 0x9,
    0x0, 0xff, 0x99, 0x3, 0xff, 0x84, 0x48,

    /* U+6D "m" */
    0x9d, 0x1, 0xff, 0xc3, 0x5e, 0x6, 0x29, 0x3,
    0xff, 0x82, 0x68, 0x60, 0x64, 0xfc, 0x20, 0x71,
    0x9e, 0x20, 0x3f, 0x50, 0xf8, 0x1d, 0xd8, 0x40,
    0x7f, 0x50, 0x5, 0x1, 0x22, 0x2, 0x81, 0xfc,
    0xc0, 0xb8, 0x17, 0x2, 0x60, 0x7f, 0x98, 0x4,
    0x40, 0x20, 0x8, 0xf, 0xfa, 0x81, 0x51, 0x0,
    0xa0, 0x1f, 0xf1, 0x40, 0x18, 0x60, 0x9, 0x1,
    0xff, 0xc0, 0xe0, 0x7d, 0x0, 0xfe, 0x2c, 0x2,
    0x21, 0x86, 0xa, 0x0, 0xc8, 0x15, 0x58, 0xd,
    0xdd, 0xd8, 0xf8, 0x1b, 0x2a, 0x0, 0x81, 0xc6,
    0x73, 0x68, 0x81, 0xc4, 0x5, 0x78, 0xf, 0x10,
    0x3f, 0x67, 0x40, 0x8b, 0x3, 0xb5, 0xc4, 0xc,
    0xc8, 0x1f, 0xfc, 0x2, 0x88, 0x1f, 0xff, 0xf0,
    0x3f, 0xff, 0x44, 0xf, 0xfe, 0xa, 0x3, 0x31,
    0x50, 0x1f, 0xfc, 0x13, 0x43, 0x0,

    /* U+6E "n" */
    0x9d, 0x3, 0x48, 0x1f, 0x2f, 0x18, 0xa6, 0x2e,
    0x7, 0x8d, 0xc, 0xa, 0xa0, 0x50, 0x1c, 0x80,
    0xf7, 0x2, 0xe0, 0x7f, 0xf0, 0x58, 0x4, 0x40,
    0xff, 0xe0, 0x50, 0x2a, 0x7, 0xff, 0x0, 0xa0,
    0xc, 0xf, 0xfe, 0xf, 0x2, 0x60, 0x7f, 0xf0,
    0x11, 0x1, 0x80, 0xff, 0xe0, 0xe8, 0x78, 0x1f,
    0xc5, 0x81, 0x3c, 0x80, 0x99, 0x1, 0x56, 0x3,
    0xb5, 0x20, 0x59, 0x50, 0x40, 0xe6, 0x56, 0x20,
    0x45, 0xd7, 0x80, 0xc8, 0x9, 0x0, 0xcf, 0x0,
    0x2c, 0x8, 0x90, 0xa, 0x19, 0x3, 0xfd, 0x40,
    0x12, 0x3, 0xff, 0x80, 0xc0, 0xaf, 0x3, 0xff,
    0x80, 0x80, 0x30, 0x3f, 0xf8, 0x3c, 0x8, 0x81,
    0xff, 0xc0, 0x40, 0x9, 0x1, 0xff, 0xc1, 0x87,
    0xf0, 0x1f, 0xfc, 0x17, 0x88, 0x1f, 0x20, 0x3f,
    0x88, 0x13, 0x14, 0x81, 0xfc, 0xa8, 0x60,

    /* U+6F "o" */
    0x1, 0xbf, 0xff, 0xb0, 0x12, 0x20, 0x7f, 0xc4,
    0x80, 0x36, 0x3, 0xfe, 0x80, 0x36, 0x79, 0x3f,
    0xd7, 0xea, 0x44, 0x2d, 0xff, 0x16, 0x10, 0x11,
    0x3, 0xfb, 0x81, 0xff, 0xed, 0x40, 0x7f, 0x60,
    0x24, 0x29, 0x3, 0xf9, 0x50, 0xef, 0x40, 0x7f,
    0xcb, 0xc0, 0x3f, 0xf8, 0xb3, 0x90, 0x3f, 0xe5,
    0xe3, 0x18, 0x81, 0xfc, 0xa8, 0x60, 0x48, 0xf,
    0xec, 0x7, 0xff, 0xb4, 0x81, 0xfd, 0xc0, 0x88,
    0x81, 0xbf, 0xe2, 0xc2, 0xd9, 0xec, 0x9f, 0xd7,
    0xda, 0xd, 0x80, 0xff, 0xa3, 0x0, 0x88, 0x1f,
    0xf1, 0x20,

    /* U+70 "p" */
    0x1, 0xbf, 0xff, 0xb0, 0x11, 0x20, 0x3f, 0xe2,
    0x40, 0x4c, 0xf, 0xfa, 0x0, 0xd9, 0xe4, 0xff,
    0x5f, 0xa9, 0x10, 0xb7, 0xfc, 0x58, 0x40, 0x44,
    0xf, 0xfe, 0x77, 0x3, 0xff, 0x89, 0xc0, 0xff,
    0xe5, 0xa0, 0x3f, 0x90, 0x14, 0x17, 0x7f, 0xfe,
    0xa2, 0x3f, 0x0, 0xff, 0x19, 0xd8, 0x6, 0x7,
    0xfc, 0xc0, 0x5f, 0xd2, 0x7f, 0xad, 0x0, 0x42,
    0x96, 0xff, 0x90, 0x1e, 0x20, 0x7f, 0xff, 0xc0,
    0xff, 0xef, 0xa0, 0x3f, 0xf8, 0x2c, 0x62, 0x7,
    0xff, 0x4,

    /* U+71 "q" */
    0x1, 0xbf, 0xff, 0xb0, 0x12, 0x20, 0x7f, 0xc4,
    0x80, 0x36, 0x3, 0xfe, 0x80, 0x36, 0x79, 0x3f,
    0xd7, 0xea, 0x44, 0x2d, 0xff, 0x16, 0x10, 0x11,
    0x3, 0xfb, 0x81, 0xff, 0xed, 0x40, 0x7f, 0x60,
    0x24, 0x31, 0x3, 0xf9, 0x40, 0xef, 0x20, 0x7f,
    0xcf, 0xc0, 0x3f, 0xf8, 0xb3, 0x90, 0x3f, 0xe5,
    0xdb, 0xc, 0x40, 0xfe, 0x54, 0x40, 0x24, 0x7,
    0xf6, 0x3, 0xfc, 0x90, 0xf, 0xfe, 0x11, 0xb4,
    0xc0, 0xff, 0xe0, 0xb0, 0x10, 0xf, 0xf1, 0x0,
    0x88, 0x40, 0x5c, 0x8, 0x86, 0x5b, 0xac, 0xcd,
    0xc1, 0x85, 0xb0, 0x49, 0xff, 0x7b, 0x41, 0xb0,
    0x1f, 0xf4, 0x60, 0x11, 0x3, 0xfe, 0x24, 0x5,
    0xbf, 0xd6, 0x6f, 0xf6, 0x3, 0xf1, 0xb3, 0x1,
    0xff, 0xc1, 0x60, 0x8, 0x1f, 0xfc, 0x14, 0x4b,
    0x1, 0xf0,

    /* U+72 "r" */
    0x1, 0xbf, 0xff, 0xa8, 0x12, 0x20, 0x7f, 0xc8,
    0x80, 0x48, 0x7, 0xfc, 0xc8, 0xbf, 0xac, 0x9f,
    0xd7, 0xf4, 0x42, 0x86, 0xff, 0x8c, 0xc, 0x8,
    0x81, 0xfd, 0xc0, 0xff, 0xf6, 0xa0, 0x3f, 0xb8,
    0x12, 0x15, 0x37, 0xfc, 0x48, 0x1b, 0x84, 0x9f,
    0xeb, 0x4b, 0x82, 0x40, 0x7f, 0xd2, 0x9b, 0xd4,
    0x3, 0xfc, 0x40, 0x21, 0x97, 0xff, 0xa6, 0xc0,
    0x39, 0x1, 0xf4, 0x8c, 0x40, 0xff, 0xe2, 0x62,
    0x7, 0xff, 0x13, 0x1, 0xff, 0xc0, 0x88, 0xa,
    0x81, 0xff, 0xc0, 0xa4, 0xf, 0xfe, 0x26, 0x8e,
    0x1, 0xff, 0xc1, 0x71, 0xf0, 0x24, 0x7, 0xf7,
    0x0, 0x50, 0xc4, 0xf, 0xea, 0x1, 0x80,

    /* U+73 "s" */
    0x1, 0xbf, 0xff, 0xe0, 0xc0, 0x48, 0xf, 0xfe,
    0xa, 0x1, 0x0, 0xff, 0xe0, 0xfd, 0x9e, 0xc9,
    0xff, 0x62, 0x41, 0x86, 0xff, 0xe2, 0x6, 0x20,
    0x7f, 0xfd, 0xd0, 0x1f, 0xfc, 0x18, 0x2e, 0xff,
    0xfc, 0x4, 0xfc, 0x3, 0xfe, 0xc0, 0x66, 0x7,
    0xfc, 0xc0, 0xd6, 0x4f, 0xf5, 0xfd, 0x40, 0x9b,
    0xff, 0xa, 0x10, 0x1f, 0xfc, 0x12, 0x7, 0xff,
    0xdc, 0x81, 0x93, 0x7f, 0xf1, 0x60, 0xab, 0x27,
    0xff, 0x0, 0x5d, 0x40, 0xff, 0xe0, 0xb6, 0xc,
    0xf, 0xfe, 0x9, 0x20,

    /* U+74 "t" */
    0xbf, 0xff, 0xf0, 0xda, 0x3, 0xff, 0x87, 0x68,
    0xf, 0xfe, 0x1f, 0x56, 0x4f, 0xfe, 0xe, 0x21,
    0x37, 0xe4, 0xdf, 0x88, 0x1f, 0x96, 0xe0, 0x7f,
    0xf0, 0x4d, 0x3, 0xff, 0x86, 0xc0, 0xff, 0xe4,
    0x10, 0x3f, 0xfa, 0xa4, 0xf, 0xfe, 0x8a, 0x3,
    0xff, 0x8b, 0x82, 0x3, 0xff, 0x87, 0xa8, 0x1f,
    0xfc, 0x13, 0xb0, 0x81, 0xff, 0xc1, 0x60, 0x30,
    0x1f, 0xfe, 0x72, 0x7, 0xff, 0x10, 0x81, 0xff,
    0xd4, 0x20, 0x7f, 0xf0, 0x51, 0x2c, 0x7, 0xc0,

    /* U+75 "u" */
    0xbc, 0x81, 0xff, 0x3e, 0xd0, 0xc4, 0xf, 0xe5,
    0x5, 0x2, 0x40, 0x7f, 0x70, 0x3f, 0xff, 0xe0,
    0x7f, 0xf7, 0xc8, 0x1c, 0x58, 0x1f, 0xd4, 0xa,
    0xbc, 0x7, 0xf8, 0xe7, 0xf3, 0x20, 0x7f, 0xcd,
    0xe1, 0x88, 0x1f, 0xca, 0x88, 0x4, 0x80, 0xfe,
    0xc0, 0x7f, 0xff, 0x88, 0x1f, 0xd8, 0x9, 0xa,
    0x5b, 0xfe, 0x10, 0x2b, 0xfa, 0x4f, 0xf5, 0x1e,
    0x4, 0x80, 0x7f, 0xd0, 0x9, 0x1, 0xff, 0xc0,
    0x40, 0x0,

    /* U+76 "v" */
    0xbc, 0x81, 0xff, 0x2f, 0x10, 0xc4, 0xf, 0xe5,
    0x43, 0x2, 0x40, 0x7f, 0x60, 0x3f, 0xff, 0xe0,
    0x7f, 0xf9, 0x4b, 0x3, 0xfa, 0x10, 0x6b, 0xc0,
    0x7f, 0xd9, 0xf5, 0x40, 0xff, 0xe0, 0xd3, 0xb3,
    0xc0, 0x3f, 0xaf, 0xd4, 0x80, 0x68, 0xf, 0xa2,
    0x2, 0xa0, 0x54, 0x81, 0xc9, 0x81, 0x55, 0x0,
    0xb8, 0x18, 0xd0, 0x2a, 0x1, 0xa0, 0x6, 0x81,
    0x70, 0x28, 0x80, 0xa9, 0x0, 0x90, 0x32, 0x1,
    0x30, 0x3b, 0x81, 0x30, 0x40, 0x1a, 0x7, 0x8d,
    0x0, 0x49, 0x80, 0xe0, 0x7e, 0x5b, 0x26, 0x7b,
    0x90, 0x3f, 0x8b, 0x61, 0x48, 0x1f, 0xfc, 0x4,
    0x42, 0x3, 0xe0,

    /* U+77 "w" */
    0xbc, 0x81, 0xff, 0x2f, 0x0, 0xff, 0xb7, 0x8,
    0x62, 0x7, 0xf2, 0xa1, 0x81, 0xfe, 0xc4, 0x20,
    0x24, 0x7, 0xf6, 0x3, 0xff, 0x82, 0x40, 0xff,
    0xff, 0x81, 0xff, 0xff, 0x3, 0xff, 0xf8, 0x58,
    0x1f, 0xfc, 0xb8, 0x5, 0x5e, 0x3, 0xff, 0x98,
    0xe4, 0x24, 0xa0, 0x7f, 0xdc, 0xf, 0xfe, 0x12,
    0x41, 0xb3, 0xc0, 0x3f, 0x99, 0x4, 0xf, 0xe5,
    0xf6, 0x12, 0x0, 0xd0, 0x1f, 0xda, 0x60, 0x3f,
    0x1a, 0x6, 0xa0, 0x54, 0x81, 0xc6, 0x54, 0xe4,
    0x20, 0x3d, 0xc0, 0x99, 0x50, 0xb, 0x81, 0x8e,
    0x6a, 0x37, 0x54, 0x6, 0xa4, 0x2, 0x80, 0x1a,
    0x0, 0x68, 0x17, 0x2, 0xa8, 0xa, 0x90, 0xd,
    0x0, 0x34, 0xd, 0x48, 0x4, 0x81, 0x90, 0x9,
    0x98, 0x5, 0x0, 0x40, 0x2e, 0x7, 0xb8, 0x13,
    0x4, 0x1, 0xa0, 0x1a, 0x3, 0xf5, 0x20, 0x78,
    0xd0, 0x4, 0x98, 0xe, 0x6, 0xa4, 0x12, 0x8,
    0x34, 0x7, 0xe5, 0xb2, 0x67, 0xb9, 0x3, 0xb5,
    0xad, 0x97, 0x40, 0x3f, 0xc5, 0xb0, 0xa4, 0xf,
    0xcb, 0x83, 0x8, 0x1f, 0xfc, 0x4, 0x42, 0x3,
    0xfd, 0x40, 0x50, 0x3e,

    /* U+78 "x" */
    0xbd, 0x1, 0xfd, 0x79, 0x42, 0x90, 0x3e, 0x88,
    0x52, 0x1, 0x81, 0xf2, 0x1, 0xfa, 0x54, 0x7,
    0xda, 0x43, 0x5b, 0x10, 0x1f, 0x4d, 0x4d, 0x4e,
    0x90, 0x3a, 0x34, 0x55, 0x2, 0xe0, 0x64, 0xc0,
    0x93, 0x40, 0xc, 0x0, 0x68, 0x15, 0x22, 0x81,
    0x32, 0x28, 0x13, 0x40, 0x58, 0x8, 0x81, 0x8c,
    0x3, 0x18, 0x0, 0xbe, 0x3, 0x1, 0xe7, 0xae,
    0x9a, 0xf0, 0x3f, 0x1c, 0x1, 0x30, 0x3f, 0x1a,
    0x10, 0x92, 0x3, 0xee, 0x9d, 0xe1, 0x36, 0x3,
    0xa9, 0x0, 0x47, 0x1, 0x10, 0x14, 0x40, 0x9,
    0xc, 0x5, 0x48, 0x4c, 0xb, 0x80, 0x4c, 0xb,
    0x8a, 0x5, 0x88, 0x14, 0x40, 0xb, 0x60, 0x69,
    0x3, 0xaa, 0x24, 0xac, 0x84, 0x7, 0xd6, 0xc7,
    0xca, 0x80, 0xfb, 0x48, 0x64, 0x3, 0x3, 0xe4,
    0x3, 0xb1, 0x48, 0x1f, 0x44, 0x28,

    /* U+79 "y" */
    0xbd, 0x1, 0xff, 0x2e, 0xd0, 0xa4, 0xf, 0xe5,
    0x45, 0x20, 0x18, 0x1f, 0xc4, 0x3, 0xf2, 0xa0,
    0x3f, 0x9c, 0x8b, 0x2f, 0x40, 0x7f, 0x3b, 0x1a,
    0x2a, 0x90, 0x3e, 0x50, 0x8d, 0x0, 0xb8, 0x1e,
    0x34, 0xa, 0x34, 0x0, 0xd0, 0x3b, 0x81, 0x42,
    0x29, 0x0, 0x98, 0x15, 0x20, 0x13, 0x2, 0xe0,
    0x50, 0x84, 0x80, 0xd, 0x3, 0x1a, 0x4, 0xc0,
    0xee, 0x7, 0x93, 0x0, 0xc8, 0x15, 0x20, 0x7d,
    0x21, 0xec, 0x91, 0x50, 0x1f, 0xcf, 0x0, 0x2d,
    0x1, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x40, 0xff,
    0xe0, 0xa2, 0x58, 0xf, 0x80,

    /* U+7A "z" */
    0xbf, 0xff, 0xf0, 0xe2, 0x3, 0xff, 0x86, 0xa8,
    0x1f, 0xfc, 0x3e, 0xac, 0x9f, 0xfc, 0x1c, 0x42,
    0x6f, 0xfb, 0xd8, 0x8, 0x1f, 0xf4, 0x64, 0x60,
    0x3f, 0xe4, 0xc0, 0xa0, 0x1f, 0xe3, 0x40, 0xa9,
    0x3, 0xfd, 0x80, 0x9a, 0x3, 0xff, 0x84, 0xa0,
    0x1f, 0xfc, 0x2, 0xd, 0x3, 0xfc, 0x5b, 0x57,
    0x80, 0xff, 0x1d, 0x23, 0x40, 0x3f, 0xec, 0x4,
    0x40, 0xff, 0xb0, 0x11, 0x80, 0x7f, 0xa1, 0x2,
    0xc0, 0x7f, 0x9b, 0x1, 0x60, 0x3f, 0xea, 0x5,
    0x48, 0x1f, 0xfc, 0x28, 0x80, 0xff, 0xe0, 0x20,
    0x98, 0x1f, 0xfc, 0x1d, 0x33, 0x7f, 0xf1, 0xa,
    0xc9, 0xff, 0xc1, 0xc6, 0x81, 0xff, 0xc3, 0xe8,
    0xf, 0xfe, 0x1d,

    /* U+7B "{" */
    0x3, 0xd3, 0xff, 0xfe, 0x1, 0x3, 0xcc, 0xf,
    0xfe, 0x5, 0x3, 0xd8, 0xf, 0xf8, 0xc0, 0x31,
    0xcb, 0x49, 0xfe, 0xc0, 0x74, 0x31, 0x37, 0xfe,
    0x3, 0xfa, 0x81, 0xff, 0xef, 0x40, 0x7f, 0xf1,
    0x38, 0x70, 0xf, 0xfe, 0x22, 0xf0, 0xf, 0xfe,
    0x2a, 0xf0, 0xf, 0xfe, 0x2f, 0xe, 0x1, 0xff,
    0xc0, 0xbf, 0x88, 0x12, 0x3, 0xff, 0x80, 0x80,
    0x20, 0x3f, 0xf8, 0xe4, 0xf, 0xfe, 0x26, 0x95,
    0x10, 0x14, 0xf, 0xfe, 0x1, 0x68, 0x51, 0x18,
    0x1f, 0xfc, 0x52, 0x7, 0xff, 0x1a, 0x98, 0xc0,
    0xff, 0xe3, 0xd0, 0x3f, 0xfd, 0xec, 0xf, 0xfe,
    0x26, 0xa, 0x37, 0xfe, 0x3, 0xcb, 0xf6, 0x93,
    0xfd, 0x80, 0xfa, 0x81, 0xff, 0x18, 0x7, 0x98,
    0x1f, 0xfc, 0xa,

    /* U+7C "|" */
    0x17, 0x9a, 0x82, 0x40, 0x3f, 0xe4, 0x5, 0x51,
    0x71, 0xf0, 0xce, 0x20, 0x48, 0xf, 0xf9, 0x20,
    0xa6, 0xf4, 0x2, 0xe1, 0x51, 0x68, 0xf, 0xf9,
    0x1, 0x52, 0x4c, 0x6c, 0x17, 0xa0, 0x85, 0x20,
    0x48, 0xf, 0xf9, 0x43, 0x88,

    /* U+7D "}" */
    0xbf, 0xff, 0xf0, 0x8, 0x1e, 0x40, 0x7f, 0xf0,
    0x10, 0x1e, 0xa0, 0x7f, 0xc9, 0x81, 0xe5, 0x64,
    0xff, 0x5b, 0x1, 0xe4, 0xdf, 0xfb, 0x24, 0x20,
    0x7f, 0xf0, 0xd1, 0x3, 0xff, 0xdc, 0x80, 0xff,
    0xe4, 0x60, 0x48, 0xf, 0xfe, 0x21, 0xf8, 0xf,
    0xfe, 0x29, 0xf8, 0xf, 0xfe, 0x2e, 0x4, 0x80,
    0xff, 0xe1, 0xa0, 0x34, 0xfc, 0x40, 0xff, 0xe2,
    0x30, 0x14, 0xf, 0xfe, 0x21, 0x1, 0xc0, 0xff,
    0x91, 0x2, 0xd2, 0x18, 0x1f, 0xfc, 0xc, 0x51,
    0xd, 0x80, 0xff, 0xe1, 0x90, 0x3f, 0xf8, 0xb8,
    0xb0, 0x3f, 0xf8, 0x88, 0x81, 0xff, 0xee, 0x60,
    0x7f, 0x26, 0xff, 0x96, 0x4, 0xe, 0x76, 0x4f,
    0xfb, 0xe0, 0x3a, 0x1, 0xff, 0x26, 0x7, 0x98,
    0x1f, 0xfc, 0x4, 0x7, 0x80,

    /* U+7E "~" */
    0x2, 0x3f, 0xd, 0x80, 0x7e, 0x7d, 0x1, 0x60,
    0x59, 0x2c, 0x7, 0x9c, 0x1c, 0x1, 0x2, 0x20,
    0x8, 0x1e, 0xe0, 0x64, 0x96, 0x65, 0x66, 0x64,
    0xa, 0x69, 0x15, 0x58, 0x19, 0x9, 0xa9, 0x90,
    0xae, 0xb6, 0x14, 0x1, 0x3, 0xf5, 0x68, 0xe,
    0x60, 0x10, 0x1c, 0x80, 0x34, 0x1, 0x81, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 110, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 92, .box_w = 4, .box_h = 25, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33, .adv_w = 197, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 15},
    {.bitmap_index = 67, .adv_w = 582, .box_w = 35, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 293, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 389, .adv_w = 281, .box_w = 16, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 517, .adv_w = 373, .box_w = 21, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 638, .adv_w = 92, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 15},
    {.bitmap_index = 653, .adv_w = 280, .box_w = 16, .box_h = 28, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 739, .adv_w = 280, .box_w = 16, .box_h = 28, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 826, .adv_w = 323, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 932, .adv_w = 269, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 982, .adv_w = 149, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1010, .adv_w = 268, .box_w = 15, .box_h = 4, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 1025, .adv_w = 149, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1047, .adv_w = 270, .box_w = 15, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1139, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1227, .adv_w = 92, .box_w = 4, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1246, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1323, .adv_w = 281, .box_w = 16, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1394, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1452, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1528, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1608, .adv_w = 281, .box_w = 16, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1667, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1751, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1831, .adv_w = 149, .box_w = 7, .box_h = 25, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1874, .adv_w = 149, .box_w = 7, .box_h = 29, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1925, .adv_w = 185, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 1975, .adv_w = 269, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 2008, .adv_w = 185, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 2056, .adv_w = 318, .box_w = 18, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2138, .adv_w = 346, .box_w = 20, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2272, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2353, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2445, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2512, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2582, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2659, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2725, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2811, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2877, .adv_w = 92, .box_w = 4, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2896, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2970, .adv_w = 308, .box_w = 17, .box_h = 25, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3062, .adv_w = 281, .box_w = 16, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3117, .adv_w = 374, .box_w = 22, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3235, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3354, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3436, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3510, .adv_w = 308, .box_w = 17, .box_h = 28, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3624, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3719, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3795, .adv_w = 307, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3867, .adv_w = 307, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3933, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4024, .adv_w = 523, .box_w = 31, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4180, .adv_w = 270, .box_w = 15, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4298, .adv_w = 307, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4383, .adv_w = 307, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4482, .adv_w = 280, .box_w = 16, .box_h = 28, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4568, .adv_w = 270, .box_w = 15, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4659, .adv_w = 280, .box_w = 16, .box_h = 28, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4746, .adv_w = 288, .box_w = 16, .box_h = 10, .ofs_x = 0, .ofs_y = 17},
    {.bitmap_index = 4790, .adv_w = 268, .box_w = 15, .box_h = 4, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4805, .adv_w = 136, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 25},
    {.bitmap_index = 4823, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4904, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4996, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5063, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5133, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5210, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5276, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5362, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5428, .adv_w = 92, .box_w = 4, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5447, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5521, .adv_w = 308, .box_w = 17, .box_h = 25, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5613, .adv_w = 281, .box_w = 16, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5668, .adv_w = 374, .box_w = 22, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5786, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5905, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5987, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6061, .adv_w = 308, .box_w = 17, .box_h = 28, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6175, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6270, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6346, .adv_w = 307, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6418, .adv_w = 307, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6484, .adv_w = 308, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6575, .adv_w = 523, .box_w = 31, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6731, .adv_w = 270, .box_w = 15, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6849, .adv_w = 307, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6934, .adv_w = 307, .box_w = 17, .box_h = 24, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7033, .adv_w = 350, .box_w = 20, .box_h = 28, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7140, .adv_w = 93, .box_w = 4, .box_h = 30, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 7177, .adv_w = 350, .box_w = 20, .box_h = 28, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7286, .adv_w = 353, .box_w = 20, .box_h = 7, .ofs_x = 0, .ofs_y = 17}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};



/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 1,
    .bpp = 3,
    .kern_classes = 0,
    .bitmap_format = 1
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t digital_play_st_24 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 38,          /*The maximum line height required by the font*/
    .base_line = 6,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if DIGITAL_PLAY_ST_24*/

