#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 128 px
 * Bpp: 3
 * Opts: --font ../font/EUROSTARBLACKEXTENDED.TTF --symbols 1234567890 --size 128 --format lvgl --bpp 3 --lv-include lvgl/lvgl.h -o Number_128.c
 ******************************************************************************/

#ifndef NUMBER_128
#define NUMBER_128 1
#endif

#if NUMBER_128

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+30 "0" */
    0x3, 0xff, 0xa0, 0x53, 0x69, 0x16, 0xdb, 0x77,
    0xff, 0xfc, 0xbd, 0xb5, 0xb4, 0x86, 0xc9, 0x8,
    0x1f, 0xfe, 0x62, 0xe6, 0xfd, 0xac, 0x86, 0xc9,
    0x44, 0xf0, 0x1f, 0xfc, 0xb2, 0x72, 0x53, 0x69,
    0x16, 0xb7, 0xf6, 0xb1, 0x90, 0x3f, 0xfb, 0x6a,
    0xfd, 0x19, 0x3, 0xff, 0xd8, 0x53, 0x9b, 0xd6,
    0x40, 0xff, 0xea, 0x2b, 0xea, 0x3, 0xff, 0xee,
    0xa6, 0xc6, 0x7, 0xff, 0x41, 0xea, 0x80, 0xff,
    0xfe, 0x99, 0xd8, 0x1f, 0xfc, 0xc5, 0xa1, 0x3,
    0xff, 0xfe, 0x5, 0x3a, 0x3, 0xff, 0x93, 0x68,
    0x81, 0xff, 0xff, 0x3, 0xeb, 0x0, 0xff, 0xe3,
    0x2e, 0x80, 0xff, 0xff, 0x81, 0xfe, 0x78, 0xf,
    0xfe, 0x22, 0xa0, 0x7f, 0xff, 0xc0, 0xff, 0xe0,
    0x9c, 0x7, 0xff, 0x9, 0x50, 0x3f, 0xff, 0xe0,
    0x7f, 0xf0, 0xcd, 0x3, 0xff, 0x80, 0x68, 0x1f,
    0xff, 0xf0, 0x3f, 0xf8, 0xa9, 0x81, 0xff, 0x70,
    0x3f, 0xff, 0xe0, 0x7f, 0xf1, 0xe1, 0x3, 0xfa,
    0x10, 0x3f, 0xff, 0xe0, 0x7f, 0xf2, 0x20, 0x1f,
    0x8b, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x25, 0x10,
    0x3e, 0xa0, 0x7f, 0xff, 0xc0, 0xff, 0xe5, 0xc0,
    0x3e, 0x60, 0x7f, 0xff, 0xc0, 0xff, 0xe5, 0xa0,
    0x3c, 0x80, 0xff, 0xff, 0x81, 0xff, 0xcd, 0x60,
    0x77, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x37, 0x1,
    0xc8, 0xf, 0xff, 0xf8, 0x1f, 0xfc, 0xd4, 0x6,
    0x20, 0x7f, 0xf9, 0x9, 0xf0, 0x1f, 0xfe, 0x42,
    0x4, 0x80, 0xff, 0xeb, 0x94, 0xe5, 0xd9, 0xff,
    0xb6, 0xf7, 0xff, 0xb6, 0x5a, 0x8d, 0x10, 0x3f,
    0xfa, 0x88, 0xb, 0x81, 0xff, 0xd3, 0x77, 0x7d,
    0x63, 0x44, 0x80, 0xff, 0xe4, 0x12, 0x48, 0xe5,
    0xde, 0xa0, 0x3f, 0xfa, 0x3c, 0x9, 0x1, 0xff,
    0xd0, 0x5b, 0xc4, 0x40, 0xff, 0xec, 0xab, 0x88,
    0x1f, 0xfc, 0xf2, 0x4, 0x40, 0xff, 0xe7, 0x2d,
    0x48, 0x1f, 0xfd, 0xf3, 0x98, 0x1f, 0xfc, 0xe4,
    0x7, 0xff, 0x45, 0xd2, 0x7, 0xff, 0x8e, 0x30,
    0x3f, 0xfa, 0x4, 0xf, 0xfe, 0x69, 0x80, 0x7f,
    0xf9, 0xa1, 0x3, 0xff, 0x9a, 0x43, 0x3, 0xff,
    0x9b, 0x0, 0xff, 0xf4, 0x40, 0x3f, 0xf9, 0xe4,
    0xf, 0xfe, 0x6a, 0x3, 0xff, 0xd0, 0x88, 0x1f,
    0xfc, 0xc6, 0x38, 0x1f, 0xfc, 0xc4, 0x7, 0xff,
    0xa9, 0x1, 0xff, 0xcc, 0x20, 0x81, 0xff, 0xcc,
    0xc0, 0x7f, 0xfa, 0xb0, 0x1f, 0xfe, 0x72, 0x7,
    0xff, 0xa9, 0x1, 0xff, 0xcc, 0xe1, 0x81, 0xff,
    0xcc, 0x40, 0x7f, 0xff, 0xc0, 0xc4, 0xf, 0xff,
    0xf8, 0x1f, 0xfd, 0x52, 0x7, 0xff, 0x2c, 0x81,
    0xff, 0xec, 0x20, 0x7f, 0xf9, 0x58, 0x1f, 0xff,
    0xf0, 0x39, 0x81, 0xff, 0xff, 0x3, 0xe6, 0x7,
    0xff, 0x94, 0x81, 0xff, 0xff, 0x3, 0xff, 0xa7,
    0xc0, 0xff, 0xff, 0x81, 0xe2, 0x7, 0xff, 0xfc,
    0xf, 0x10, 0x3f, 0xf9, 0x64, 0xf, 0xff, 0xf8,
    0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xf0,
    0x88, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f,
    0xff, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xff, 0x3,
    0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8,
    0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xff,
    0xc0, 0xc4, 0xf, 0xfe, 0x69, 0x3, 0xff, 0xfe,
    0x7, 0x88, 0x1f, 0xff, 0xf0, 0x3c, 0x40, 0xff,
    0xf2, 0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0,
    0xff, 0xf9, 0x90, 0x3f, 0xfd, 0x8c, 0xf, 0xfe,
    0x5b, 0x3, 0xff, 0x9a, 0xc0, 0xff, 0xf6, 0x10,
    0x3f, 0xfc, 0xa4, 0xf, 0xff, 0x59, 0x3, 0xff,
    0x98, 0x41, 0x3, 0xff, 0xfe, 0x6, 0x40, 0x7f,
    0xf9, 0xd0, 0x1f, 0xfe, 0xac, 0x7, 0xff, 0x33,
    0x86, 0x7, 0xff, 0x33, 0x1, 0xff, 0xea, 0x40,
    0x7f, 0xf9, 0xd0, 0x1f, 0xfe, 0x96, 0x7, 0xff,
    0x34, 0x82, 0x7, 0xff, 0x30, 0x90, 0x1f, 0xfe,
    0x88, 0x7, 0xff, 0x35, 0x81, 0xff, 0xcf, 0x80,
    0x7f, 0xf9, 0xe8, 0x1f, 0xfd, 0xe, 0x7, 0xff,
    0x35, 0x20, 0x1f, 0xfe, 0x5a, 0x80, 0xff, 0xe7,
    0x10, 0x40, 0xff, 0xe7, 0x54, 0x7, 0xff, 0x84,
    0xce, 0x80, 0xff, 0xe8, 0xb0, 0x3f, 0xf9, 0xf6,
    0x90, 0x1f, 0xfd, 0xb2, 0xa6, 0xc6, 0x7, 0xff,
    0x40, 0x80, 0x20, 0x7f, 0xf4, 0x15, 0xf5, 0xa2,
    0x7, 0xff, 0x30, 0x99, 0x36, 0x97, 0x7d, 0x59,
    0x3, 0xff, 0xa4, 0x80, 0x88, 0x1f, 0xfd, 0x25,
    0x2e, 0xff, 0xff, 0x99, 0xb5, 0x64, 0x34, 0x40,
    0xff, 0xeb, 0xf0, 0x26, 0x7, 0xff, 0xfc, 0xf,
    0xfe, 0x79, 0x2, 0xc0, 0x7f, 0xff, 0xc0, 0xff,
    0xe7, 0xa0, 0x24, 0x7, 0xff, 0xfc, 0xf, 0xfe,
    0x71, 0x3, 0x10, 0x3f, 0xff, 0xe0, 0x7f, 0xf3,
    0xa8, 0x1c, 0x80, 0xff, 0xff, 0x81, 0xff, 0xcd,
    0x40, 0x77, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x30,
    0x90, 0x1c, 0x80, 0xff, 0xff, 0x81, 0xff, 0xcc,
    0x80, 0x7d, 0x0, 0xff, 0xff, 0x81, 0xff, 0xcb,
    0x40, 0x7c, 0xc8, 0x1f, 0xff, 0xf0, 0x3f, 0xf9,
    0x34, 0xf, 0xe8, 0x7, 0xff, 0xfc, 0xf, 0xfe,
    0x42, 0x40, 0x3f, 0x92, 0x1, 0xff, 0xff, 0x3,
    0xff, 0x8f, 0x40, 0xff, 0xa9, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0x17, 0x1, 0xff, 0xc1, 0xe0, 0x7f,
    0xff, 0xc0, 0xff, 0xe2, 0x62, 0x7, 0xff, 0x4,
    0xf2, 0x7, 0xff, 0xfc, 0xf, 0xfe, 0x1, 0xc4,
    0xf, 0xfe, 0x26, 0x40, 0x7f, 0xff, 0xc0, 0xff,
    0x3c, 0x40, 0xff, 0xe3, 0x5a, 0x20, 0x7f, 0xff,
    0xc0, 0xf2, 0xd0, 0xf, 0xfe, 0x4a, 0xd4, 0x81,
    0xff, 0xff, 0x0, 0xf5, 0x20, 0x7f, 0xf3, 0x16,
    0xc8, 0x80, 0xff, 0xfd, 0x29, 0xbc, 0x20, 0x7f,
    0xf4, 0xb, 0xbf, 0x58, 0xd1, 0x20, 0x3f, 0xfd,
    0x45, 0x39, 0x77, 0xea, 0xc8, 0x1f, 0xfd, 0x72,
    0x9c, 0xbb, 0x3f, 0xdb, 0x2d, 0xd2, 0x66, 0xff,
    0xc9, 0x7f, 0x9b, 0xfa, 0x4d, 0x6d, 0xb3, 0xfd,
    0xac, 0x68, 0x81, 0xff, 0xc9,

    /* U+31 "1" */
    0x3, 0xff, 0xae, 0xb7, 0xff, 0xfd, 0x2a, 0x7,
    0xff, 0x5a, 0x52, 0x7, 0xff, 0xcd, 0x66, 0x7,
    0xff, 0xd2, 0x52, 0x7, 0xff, 0xcd, 0x66, 0x7,
    0xff, 0xd2, 0x52, 0x7, 0xff, 0xcd, 0x66, 0x7,
    0xff, 0xd2, 0x52, 0x7, 0xff, 0xcd, 0x76, 0x7,
    0xff, 0xd2, 0x50, 0x3f, 0xfe, 0x8b, 0xb0, 0x3f,
    0xfe, 0x92, 0x81, 0xff, 0xf4, 0x5d, 0x81, 0xff,
    0xf4, 0x94, 0xf, 0xff, 0xa2, 0xec, 0xf, 0xff,
    0xa4, 0xa0, 0x7f, 0xfd, 0x17, 0x60, 0x7f, 0xfd,
    0x25, 0x3, 0xff, 0xe8, 0xbb, 0x3, 0xff, 0xe9,
    0x28, 0x1f, 0xff, 0x45, 0xd8, 0x1f, 0xfd, 0x55,
    0x40, 0xff, 0xe8, 0xca, 0x7, 0xff, 0x5a, 0xd0,
    0x1f, 0xfd, 0x5, 0xd8, 0x1f, 0xfd, 0x55, 0xd0,
    0x1f, 0xfd, 0x9, 0x40, 0xff, 0xeb, 0x4a, 0x7,
    0xff, 0x46, 0x30, 0x3f, 0xfa, 0xa7, 0x30, 0x3f,
    0xfa, 0x50, 0x81, 0xff, 0xd4, 0x78, 0x81, 0xff,
    0xd4, 0xe0, 0x7f, 0xf4, 0x8e, 0x80, 0x7f, 0xf5,
    0x8b, 0x3, 0xff, 0xa0, 0xf1, 0x3, 0xff, 0xb1,
    0x8, 0x1f, 0xfc, 0xeb, 0x0, 0xff, 0xed, 0xf0,
    0x3f, 0xf9, 0x8b, 0xa0, 0x3f, 0xfb, 0x85, 0x81,
    0xff, 0xca, 0x94, 0xf, 0xfe, 0xfc, 0x20, 0x7f,
    0xf1, 0xce, 0x60, 0x7f, 0xf8, 0x78, 0x1f, 0xfc,
    0x69, 0x88, 0x1f, 0xfe, 0x22, 0xc0, 0xff, 0xe1,
    0x9c, 0xc0, 0xff, 0xf2, 0xc2, 0x7, 0xff, 0x5,
    0xe2, 0x7, 0xff, 0x9f, 0x81, 0xff, 0xc0, 0xb0,
    0xf, 0xff, 0x49, 0x60, 0x7f, 0x2e, 0x80, 0xff,
    0xf5, 0xc2, 0x7, 0xd6, 0x80, 0xff, 0xf7, 0x70,
    0x39, 0x74, 0x7, 0xff, 0xbc, 0xc0, 0x29, 0x40,
    0xff, 0xf9, 0x32, 0x59, 0x81, 0xff, 0xf4, 0xd8,
    0x40, 0xff, 0xff, 0x81, 0xff, 0xff, 0x3, 0xff,
    0xfe, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f,
    0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0,
    0xff, 0xff, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff,
    0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff,
    0xff, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0,
    0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff, 0xff,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f,
    0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc,
    0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff,
    0xe0, 0x7f, 0xfa, 0x40,

    /* U+32 "2" */
    0x3, 0xff, 0x96, 0x49, 0x23, 0x69, 0x2b, 0x6d,
    0xb7, 0xff, 0xfd, 0xad, 0x96, 0x34, 0x40, 0xff,
    0xea, 0x14, 0xee, 0xfe, 0xd9, 0x6a, 0x43, 0x72,
    0x51, 0x38, 0xf, 0xfe, 0xd1, 0x24, 0xe5, 0xdf,
    0x44, 0x7, 0xff, 0x35, 0x5f, 0xac, 0x44, 0xf,
    0xff, 0xa9, 0x77, 0xd4, 0x7, 0xff, 0x1c, 0xdf,
    0x50, 0x1f, 0xff, 0xf5, 0x68, 0x81, 0xff, 0xc4,
    0xb9, 0x1, 0xff, 0xff, 0x3, 0x96, 0x40, 0x7f,
    0xf0, 0x57, 0x40, 0x7f, 0xff, 0xc0, 0xfe, 0xac,
    0xf, 0xfa, 0x50, 0x3f, 0xff, 0xe0, 0x7f, 0xf0,
    0x22, 0x3, 0xf9, 0xb0, 0x1f, 0xff, 0xf0, 0x3f,
    0xf8, 0x54, 0xf, 0xca, 0x1, 0xff, 0xff, 0x3,
    0xff, 0x89, 0x40, 0xfa, 0x81, 0xff, 0xff, 0x3,
    0xff, 0x8a, 0x88, 0x1d, 0x0, 0xff, 0xff, 0x81,
    0xff, 0xc7, 0xa0, 0x73, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0x1d, 0x81, 0x98, 0x1f, 0xff, 0xf0, 0x3f,
    0xf9, 0x28, 0xb, 0x1, 0xff, 0xff, 0x3, 0xff,
    0x93, 0xc0, 0x90, 0x1f, 0xff, 0xf0, 0x3f, 0xf9,
    0x28, 0x1, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x2c,
    0x86, 0x7, 0xff, 0x84, 0x9f, 0xfe, 0x0, 0x1f,
    0xfd, 0xd6, 0x8, 0x1f, 0xfd, 0x24, 0xe5, 0xad,
    0x9f, 0xfe, 0xdb, 0xff, 0x81, 0xff, 0xfb, 0x56,
    0x40, 0xff, 0xe7, 0xe1, 0xc0, 0xff, 0xe7, 0xbd,
    0xec, 0x69, 0x9, 0x1, 0xff, 0xd2, 0x2a, 0x6a,
    0x7, 0xff, 0x38, 0x82, 0x7, 0xff, 0x34, 0xe8,
    0x40, 0xff, 0xef, 0x2c, 0x7, 0xff, 0x35, 0x81,
    0xff, 0xcf, 0xc4, 0xf, 0xff, 0x9, 0xa0, 0x7f,
    0xf3, 0x98, 0x1f, 0xfc, 0xca, 0x7, 0xff, 0x91,
    0x10, 0x3f, 0xf9, 0x64, 0xf, 0xfe, 0x69, 0x40,
    0x7f, 0xf9, 0x68, 0x1f, 0xfe, 0x5a, 0x7, 0xff,
    0x99, 0x1, 0xff, 0xe5, 0x40, 0x7f, 0xf9, 0x88,
    0x1f, 0xfe, 0x52, 0x7, 0xff, 0xfc, 0xf, 0xfe,
    0x61, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xfd, 0x48,
    0xf, 0xfe, 0x6a, 0x27, 0xff, 0x94, 0x80, 0xff,
    0xf3, 0xe0, 0x3f, 0xf9, 0xb3, 0x6f, 0xfe, 0x54,
    0x3, 0xff, 0xce, 0xc0, 0xff, 0xff, 0x81, 0xff,
    0xcc, 0x80, 0x7f, 0xf3, 0x8, 0x1f, 0xff, 0xe6,
    0xc0, 0x7f, 0xff, 0xc0, 0xff, 0xe5, 0x2d, 0x0,
    0xff, 0xe6, 0xb0, 0x3f, 0xfe, 0xa5, 0x39, 0x7f,
    0x52, 0x7, 0xff, 0x38, 0x81, 0xff, 0xe8, 0x24,
    0x9b, 0x4b, 0x5b, 0x3f, 0xb5, 0x8d, 0x1, 0xff,
    0xd2, 0xc0, 0x7f, 0xf6, 0xc9, 0x26, 0xd2, 0xd6,
    0xcf, 0xed, 0x96, 0x43, 0x48, 0x48, 0xf, 0xfe,
    0xd3, 0x3, 0xff, 0x9c, 0x49, 0x36, 0x96, 0xb6,
    0x7f, 0x6c, 0xb2, 0x1a, 0x42, 0x40, 0x7f, 0xf9,
    0xc8, 0x1f, 0xfc, 0x72, 0xe5, 0xdf, 0xb6, 0x59,
    0xd, 0x21, 0x20, 0x3f, 0xfe, 0x68, 0xf, 0xfe,
    0x19, 0x77, 0xf6, 0x8d, 0x10, 0x3f, 0xff, 0xfc,
    0xf, 0xfe, 0x1, 0x9f, 0x44, 0x7, 0xff, 0xfc,
    0xf, 0x90, 0x1f, 0xe3, 0x73, 0x3, 0xff, 0xfe,
    0x7, 0xfa, 0x1, 0xfe, 0x79, 0x1, 0xff, 0xff,
    0x3, 0xfe, 0x2c, 0xf, 0xeb, 0x0, 0xff, 0xff,
    0x81, 0xff, 0xc1, 0xe0, 0x7f, 0x64, 0x7, 0xff,
    0xfc, 0xf, 0xfe, 0xc, 0x20, 0x7e, 0xa4, 0xf,
    0xff, 0xf8, 0x1f, 0xfc, 0x16, 0xc0, 0x7e, 0x68,
    0xf, 0xff, 0xf8, 0x1f, 0xfc, 0x19, 0x0, 0x7f,
    0x40, 0x3f, 0xff, 0xe0, 0x7f, 0xf0, 0x6b, 0x3,
    0xfa, 0x1, 0xff, 0xff, 0x3, 0xff, 0x80, 0xfa,
    0x3, 0xfc, 0xc0, 0xff, 0xff, 0x81, 0xfe, 0x7e,
    0x1, 0xff, 0x30, 0x3f, 0xff, 0xe0, 0x7e, 0x77,
    0xc0, 0x3f, 0xf8, 0x34, 0xf, 0xff, 0xf8, 0x2,
    0xa5, 0xfd, 0x10, 0x1f, 0xfc, 0x32, 0x7, 0xff,
    0xd8, 0x92, 0x47, 0x22, 0xef, 0xda, 0xb4, 0x7,
    0xff, 0x19, 0x1, 0xff, 0xe8, 0x24, 0x91, 0xb4,
    0x8b, 0x5b, 0x3f, 0xb6, 0x5a, 0x8d, 0x91, 0x3,
    0xff, 0x98, 0x40, 0xff, 0xec, 0x92, 0x48, 0xda,
    0x45, 0xad, 0x9f, 0xdb, 0x2d, 0x48, 0x6c, 0x90,
    0x90, 0x1f, 0xfd, 0x8e, 0x7, 0xff, 0x40, 0xb9,
    0x6b, 0x7f, 0x6c, 0xb5, 0x21, 0xb2, 0x42, 0x40,
    0x7f, 0xf9, 0xc8, 0x1f, 0xfc, 0xd3, 0x7e, 0x8d,
    0x21, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x11, 0x64,
    0x7, 0xff, 0xf5, 0x81, 0xff, 0xcb, 0x34, 0xf,
    0xff, 0xf8, 0x1f, 0xfc, 0xc8, 0x7, 0xff, 0xfc,
    0xf, 0xfe, 0x6a, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0x30, 0x81, 0xff, 0xff, 0x3, 0xff, 0x9a, 0xc0,
    0xff, 0xff, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xfd,
    0x6, 0x4f, 0xff, 0xfc, 0x81, 0xff, 0xcc, 0x3b,
    0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xf0, 0x3f, 0xff,
    0xe0, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81, 0xff,
    0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0,
    0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf, 0xff,
    0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f,
    0xff, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xff, 0x3,
    0xff, 0xbc,

    /* U+33 "3" */
    0x3, 0xff, 0x9a, 0x52, 0x39, 0x6d, 0xb6, 0xff,
    0xff, 0x9d, 0xb6, 0xb6, 0x90, 0xd9, 0x21, 0x3,
    0xff, 0xc4, 0xa5, 0xdf, 0x5a, 0x8d, 0x28, 0x9c,
    0x7, 0xff, 0x38, 0x9c, 0x94, 0xda, 0x45, 0xad,
    0xfb, 0x58, 0xd1, 0x3, 0xff, 0xac, 0xa6, 0xf5,
    0xa2, 0x7, 0xff, 0xac, 0xa7, 0x2e, 0xf6, 0x10,
    0x3f, 0xf9, 0xea, 0xfa, 0xc8, 0x1f, 0xff, 0x74,
    0xf7, 0x84, 0xf, 0xfe, 0x53, 0xd5, 0x1, 0xff,
    0xff, 0x7a, 0x81, 0xff, 0xc7, 0x5a, 0x10, 0x3f,
    0xff, 0xe0, 0x65, 0xd0, 0x1f, 0xfc, 0x49, 0x48,
    0x1f, 0xff, 0xf0, 0x3f, 0x58, 0x7, 0xff, 0xa,
    0xb0, 0x3f, 0xff, 0xe0, 0x7f, 0xce, 0x1, 0xff,
    0xc0, 0xa8, 0xf, 0xff, 0xf8, 0x1f, 0xfc, 0x16,
    0xc0, 0x7f, 0xa2, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0xe, 0x10, 0x3f, 0x16, 0x7, 0xff, 0xfc, 0xf,
    0xfe, 0x2c, 0x3, 0xf4, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0x19, 0x10, 0x3e, 0x40, 0x7f, 0xff, 0xc0,
    0xff, 0xe3, 0xd0, 0x3c, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xc8, 0x60, 0x7b, 0x1, 0xff, 0xff, 0x3,
    0xff, 0x92, 0x40, 0xe4, 0x7, 0xff, 0xfc, 0xf,
    0xfe, 0x4a, 0x3, 0x10, 0x3f, 0xff, 0xe0, 0x7f,
    0xf2, 0xb8, 0x19, 0x1, 0xff, 0xff, 0x3, 0xff,
    0x94, 0x40, 0xdc, 0xf, 0xfe, 0x7b, 0xbb, 0xff,
    0xfe, 0x86, 0xd5, 0xa8, 0xd1, 0x3, 0xff, 0xa4,
    0x80, 0xc4, 0xf, 0xfe, 0x6b, 0xf1, 0x10, 0x3f,
    0xfa, 0x4, 0xc9, 0x1c, 0xbb, 0xc2, 0x7, 0xff,
    0x51, 0x81, 0xff, 0xcc, 0x90, 0x7, 0xff, 0x79,
    0xe8, 0x7, 0xff, 0x4c, 0x81, 0xff, 0xcb, 0x4c,
    0xf, 0xff, 0xb, 0xa0, 0x7f, 0xfa, 0xa0, 0x1f,
    0xfe, 0x34, 0xc0, 0xff, 0xe6, 0x90, 0x3f, 0xf9,
    0xc4, 0x80, 0xff, 0xf2, 0x40, 0x3f, 0xfd, 0xc,
    0xf, 0xff, 0x32, 0x3, 0xff, 0x9e, 0x40, 0xff,
    0xe5, 0x90, 0x3f, 0xfc, 0xd8, 0xf, 0xfe, 0x61,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0xa8, 0x81, 0xff,
    0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x3c, 0x81,
    0x1d, 0xbf, 0xf9, 0x74, 0xf, 0xff, 0x36, 0x3,
    0xff, 0x96, 0xc0, 0xc4, 0xff, 0xf2, 0xc0, 0xff,
    0xf3, 0xa0, 0x3f, 0xf9, 0x64, 0xf, 0xff, 0xf8,
    0x8, 0x7, 0xff, 0x33, 0x1, 0xff, 0xff, 0x9,
    0x81, 0xff, 0xcc, 0x40, 0x7f, 0xff, 0x8c, 0xa0,
    0x7f, 0xf3, 0x18, 0x1f, 0xff, 0x92, 0x49, 0xdd,
    0x8c, 0xf, 0xfe, 0x6d, 0x3, 0xff, 0xc3, 0xff,
    0xff, 0x33, 0x65, 0x88, 0x81, 0xff, 0xce, 0x44,
    0xf, 0xff, 0xf8, 0x1f, 0xfc, 0xe8, 0x7, 0xff,
    0xfc, 0xf, 0xfe, 0x75, 0x20, 0x7f, 0xff, 0xc0,
    0xff, 0xe6, 0xd4, 0x7, 0xff, 0xfc, 0xf, 0xfe,
    0x61, 0xc8, 0xf, 0xff, 0xf8, 0x1f, 0xfc, 0xb3,
    0x71, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x25, 0x4d,
    0x88, 0xf, 0xff, 0xf8, 0x1f, 0xfc, 0x54, 0xe5,
    0xfd, 0x59, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x18,
    0x8e, 0x58, 0x1f, 0xff, 0xf0, 0x3f, 0xf9, 0x65,
    0x4b, 0xbe, 0x88, 0xf, 0xff, 0xf8, 0x1f, 0xfc,
    0xd2, 0xef, 0xd0, 0x81, 0xff, 0xff, 0x3, 0xff,
    0x9a, 0x5e, 0xc4, 0x7, 0xff, 0xfc, 0xf, 0xfe,
    0x71, 0xb4, 0x7, 0xff, 0xfc, 0xf, 0xfe, 0x7a,
    0xc0, 0x7f, 0xff, 0xc0, 0xff, 0xe7, 0x9c, 0x7,
    0xff, 0xfc, 0xf, 0xfe, 0x79, 0x60, 0x7f, 0xf8,
    0x36, 0xff, 0xe6, 0xda, 0x90, 0xd0, 0x1f, 0xfc,
    0xf8, 0x7, 0xff, 0x80, 0x9f, 0xfe, 0x6a, 0x46,
    0xd2, 0xfa, 0x40, 0xff, 0xe6, 0xa0, 0x3f, 0xff,
    0xeb, 0x20, 0x3f, 0xf9, 0x9c, 0xf, 0xff, 0xf8,
    0xa, 0x40, 0xff, 0xe5, 0xa0, 0x4, 0xff, 0xf2,
    0xc0, 0xff, 0xf4, 0xd0, 0x3f, 0xf9, 0x84, 0x6d,
    0xff, 0xcb, 0x80, 0x7f, 0xfa, 0x18, 0x1f, 0xfc,
    0xc4, 0x7, 0xff, 0xfc, 0x8, 0x81, 0xff, 0xcb,
    0xe4, 0xf, 0xff, 0xf8, 0x6, 0x7, 0xff, 0x2c,
    0x81, 0xff, 0xcc, 0x20, 0x7f, 0xfa, 0x48, 0x1f,
    0xfc, 0xb6, 0x7, 0xff, 0xfc, 0xf, 0xff, 0x43,
    0x3, 0xff, 0xd2, 0x40, 0xff, 0xe5, 0x90, 0x3f,
    0xf9, 0x84, 0xf, 0xff, 0x4a, 0x3, 0xff, 0xca,
    0x40, 0xff, 0xf3, 0x90, 0x3f, 0xfc, 0xd4, 0xf,
    0xff, 0x3c, 0x3, 0xff, 0x9a, 0x40, 0xff, 0xe6,
    0x34, 0x7, 0xff, 0x95, 0xa0, 0x3f, 0xf9, 0x84,
    0xf, 0xfe, 0x75, 0x60, 0x7f, 0xf8, 0xe4, 0x1,
    0xff, 0xcf, 0x20, 0x7f, 0xf3, 0x66, 0x64, 0xf,
    0xfe, 0xea, 0x9d, 0x81, 0xff, 0xce, 0x61, 0x81,
    0xff, 0xce, 0x33, 0x7d, 0x64, 0x37, 0xff, 0xcb,
    0x93, 0xd6, 0xdb, 0x3f, 0x56, 0x7, 0xff, 0x40,
    0x82, 0x7, 0xff, 0x48, 0xa6, 0xd2, 0x7f, 0xf2,
    0xdb, 0xf2, 0x51, 0x20, 0x3f, 0xfa, 0x98, 0x60,
    0x3f, 0xff, 0xe0, 0x7f, 0xf3, 0x50, 0x40, 0x7f,
    0xff, 0xc0, 0xff, 0xe6, 0x10, 0x22, 0x7, 0xff,
    0xfc, 0xf, 0xfe, 0x5a, 0x2, 0xa0, 0x7f, 0xff,
    0xc0, 0xff, 0xe5, 0xd0, 0x26, 0x7, 0xff, 0xfc,
    0xf, 0xfe, 0x52, 0x20, 0x66, 0x7, 0xff, 0xfc,
    0xf, 0xfe, 0x4c, 0x3, 0xa0, 0x1f, 0xff, 0xf0,
    0x3f, 0xf9, 0x8, 0x81, 0xe6, 0x7, 0xff, 0xfc,
    0xf, 0xfe, 0x3d, 0x3, 0xe8, 0x40, 0xff, 0xff,
    0x81, 0xff, 0xc5, 0xc0, 0x7f, 0x60, 0x3f, 0xff,
    0xe0, 0x7f, 0xf1, 0x29, 0x3, 0xfd, 0x80, 0xff,
    0xff, 0x81, 0xff, 0xc2, 0xc8, 0xf, 0xf8, 0xe2,
    0x7, 0xff, 0xfc, 0xf, 0xf2, 0xe4, 0xf, 0xfe,
    0x9, 0xcc, 0xf, 0xff, 0xf8, 0x1f, 0x2d, 0x40,
    0xff, 0xe2, 0xcc, 0xc0, 0xff, 0xff, 0x81, 0x3d,
    0x48, 0x1f, 0xfc, 0x73, 0x3d, 0x64, 0xf, 0xff,
    0xc9, 0x73, 0x78, 0x40, 0xff, 0xe6, 0x29, 0xbe,
    0xb1, 0xa4, 0x24, 0x7, 0xff, 0x78, 0x9e, 0x4a,
    0x6e, 0x91, 0x76, 0x7e, 0xd1, 0x90, 0x3f, 0xf8,
    0x40,

    /* U+34 "4" */
    0x3, 0xff, 0xe0, 0x77, 0xff, 0xfd, 0x20, 0x3f,
    0xff, 0xb3, 0x10, 0x3f, 0xff, 0xe0, 0x7f, 0xf3,
    0x97, 0x60, 0x7f, 0xff, 0xc0, 0xff, 0xe7, 0xda,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0x3d, 0xf4, 0x7,
    0xff, 0xfc, 0xf, 0xfe, 0x71, 0xd0, 0xf, 0xff,
    0xf8, 0x1f, 0xfc, 0xf9, 0x88, 0x1f, 0xff, 0xf0,
    0x3f, 0xf9, 0xc7, 0x30, 0x3f, 0xff, 0xe0, 0x7f,
    0xf3, 0xe6, 0x20, 0x7f, 0xff, 0xc0, 0xff, 0xe7,
    0x2e, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xcf, 0xb4,
    0x7, 0xff, 0xfc, 0xf, 0xfe, 0x7b, 0xe8, 0xf,
    0xff, 0xf8, 0x1f, 0xfc, 0xe3, 0xa0, 0x1f, 0xff,
    0xf0, 0x3f, 0xf9, 0xf3, 0x10, 0x3f, 0xff, 0xe0,
    0x7f, 0xf3, 0x96, 0x60, 0x7f, 0xff, 0xc0, 0xff,
    0xe7, 0xda, 0x20, 0x7f, 0xff, 0xc0, 0xff, 0xe7,
    0x2e, 0x80, 0xff, 0xff, 0x81, 0xff, 0xce, 0x36,
    0x80, 0xff, 0xff, 0x81, 0xff, 0xcf, 0x79, 0x1,
    0xff, 0xff, 0x3, 0xff, 0x9c, 0x74, 0x3, 0xff,
    0xae, 0x40, 0xff, 0xfb, 0x4c, 0x40, 0xff, 0xeb,
    0x3e, 0xc0, 0xff, 0xfa, 0x2e, 0xc0, 0xff, 0xeb,
    0x1d, 0x0, 0xff, 0xfa, 0xda, 0x3, 0xff, 0xae,
    0xf1, 0x3, 0xff, 0xe8, 0xfa, 0x3, 0xff, 0xac,
    0xb4, 0x3, 0xff, 0xe8, 0x74, 0x3, 0xff, 0xaf,
    0x29, 0x3, 0xff, 0xe9, 0x31, 0x3, 0xff, 0xac,
    0xbb, 0x3, 0xff, 0xe8, 0x73, 0x3, 0xff, 0xac,
    0x6d, 0x1, 0xff, 0xf5, 0x98, 0x81, 0xff, 0xd6,
    0x79, 0x1, 0xff, 0xf4, 0x5d, 0x81, 0xff, 0xd6,
    0x3a, 0x1, 0xff, 0xf5, 0xb4, 0x7, 0xff, 0x5e,
    0x62, 0x7, 0xff, 0xd1, 0xf4, 0x7, 0xff, 0x59,
    0x76, 0x7, 0xff, 0xd0, 0xe8, 0x7, 0xff, 0x58,
    0xda, 0x3, 0xff, 0xeb, 0x31, 0x3, 0xff, 0xac,
    0xf2, 0x3, 0xff, 0xe8, 0xb3, 0x3, 0xff, 0xac,
    0x74, 0x3, 0xff, 0xeb, 0x68, 0x81, 0xff, 0xd6,
    0x98, 0x81, 0xff, 0xf4, 0x5d, 0x1, 0xff, 0xd6,
    0x5d, 0x81, 0xff, 0xf4, 0x36, 0x80, 0xff, 0xeb,
    0x1b, 0x40, 0x7f, 0xfd, 0x5e, 0x40, 0x7f, 0xf5,
    0x9e, 0x40, 0x7f, 0xfd, 0xe, 0x80, 0x7f, 0xf5,
    0x8e, 0x80, 0x7f, 0xfd, 0xa9, 0x3, 0xff, 0xad,
    0x31, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x39, 0x76,
    0x7, 0xff, 0xfc, 0xf, 0xfe, 0x7d, 0xa0, 0x3f,
    0xff, 0xe0, 0x7f, 0xf3, 0xdf, 0x40, 0x7f, 0xff,
    0xc0, 0xff, 0xe7, 0x1d, 0x0, 0xff, 0xff, 0x81,
    0xff, 0xcf, 0x98, 0x81, 0xff, 0xff, 0x3, 0xff,
    0x9c, 0xbb, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x3e,
    0xd0, 0x1f, 0xff, 0xf0, 0x3f, 0xf9, 0xef, 0xa0,
    0x3f, 0xff, 0xe0, 0x7f, 0xf3, 0x8e, 0x80, 0x7f,
    0xff, 0xc0, 0xff, 0xe7, 0xcc, 0x40, 0xff, 0xff,
    0x81, 0xff, 0xce, 0x5d, 0x81, 0xff, 0xff, 0x3,
    0xff, 0xa0, 0xbf, 0xff, 0xf2, 0xa0, 0x3f, 0xf9,
    0x7f, 0xff, 0xf0, 0x70, 0x1f, 0xff, 0xf0, 0x3f,
    0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc,
    0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff,
    0xe0, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81, 0xff,
    0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0,
    0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0x8b, 0x93, 0xff,
    0xf7, 0x3, 0xff, 0x99, 0x6f, 0xff, 0x6, 0x3d,
    0xbf, 0xfe, 0xe8, 0xf, 0xfe, 0x5a, 0x5f, 0xfc,
    0x20, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff,
    0xff, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0,
    0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff, 0xff,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f,
    0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xc,

    /* U+35 "5" */
    0x3, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x80,
    0xff, 0xff, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff,
    0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff,
    0xff, 0x81, 0xff, 0xeb, 0x20, 0x7f, 0xff, 0xc0,
    0xff, 0xff, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff,
    0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff,
    0xff, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0x8f, 0x6f, 0xff, 0xe8, 0x1f, 0xfd, 0x22,
    0x7f, 0xff, 0xa0, 0x7f, 0xff, 0xc0, 0xff, 0xff,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f,
    0xff, 0xe0, 0x7f, 0xf3, 0x88, 0x1f, 0xff, 0xf0,
    0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff, 0xe0,
    0x95, 0x2d, 0xb6, 0xfe, 0xff, 0xed, 0xbf, 0x5b,
    0xa4, 0x9b, 0x24, 0x20, 0x7f, 0xfb, 0x95, 0xfa,
    0xb4, 0xa2, 0x7f, 0x80, 0xf8, 0x9f, 0xc9, 0x66,
    0xe9, 0x16, 0xb7, 0xf6, 0xb1, 0xa0, 0x3f, 0xfc,
    0x93, 0xd4, 0x7, 0xff, 0x88, 0xa7, 0x2f, 0xd1,
    0x1, 0xff, 0xde, 0x7d, 0x81, 0xff, 0xeb, 0x2e,
    0xf8, 0x7, 0xff, 0x6e, 0xc0, 0x3f, 0xfe, 0x2f,
    0xb0, 0x3f, 0xfb, 0x15, 0x1, 0xff, 0xf4, 0x94,
    0xf, 0xf9, 0x81, 0xff, 0xca, 0x88, 0xf, 0xff,
    0xb2, 0xc0, 0x7f, 0xf5, 0x13, 0x3, 0xff, 0xf0,
    0x70, 0x1f, 0xfd, 0x38, 0x7, 0xff, 0xe8, 0xd0,
    0x3f, 0xfa, 0x44, 0xf, 0xff, 0xda, 0x60, 0x7f,
    0xff, 0xc0, 0xff, 0xe7, 0xc0, 0x3f, 0xff, 0xe0,
    0x7f, 0xf4, 0x20, 0x1f, 0xff, 0xf0, 0x3f, 0xf9,
    0xec, 0xf, 0xff, 0xf8, 0x1f, 0xfd, 0x6, 0x7,
    0x10, 0x3f, 0xff, 0xe0, 0x7f, 0xf2, 0x70, 0x1f,
    0xff, 0xf0, 0x3f, 0xf9, 0xe8, 0xf, 0xff, 0xf8,
    0x1f, 0xfd, 0x2, 0x7, 0xff, 0x4d, 0x4d, 0xff,
    0xff, 0x57, 0x65, 0x88, 0x81, 0xff, 0xd1, 0x40,
    0x7f, 0xf4, 0x67, 0xac, 0x81, 0xff, 0xd5, 0x24,
    0x9d, 0xd8, 0xc0, 0xff, 0xe7, 0xf0, 0x3f, 0xf9,
    0xe7, 0x30, 0x3f, 0xfb, 0xe6, 0x50, 0x3f, 0xf9,
    0xc4, 0xf, 0xfe, 0x7f, 0x20, 0x7f, 0xf8, 0x95,
    0x3, 0xff, 0x9a, 0xc0, 0xff, 0xe7, 0x32, 0x7,
    0xff, 0x91, 0x20, 0x1f, 0xfc, 0xc2, 0x7, 0xff,
    0x3a, 0x81, 0xff, 0xe6, 0x80, 0x7f, 0xf4, 0x5f,
    0xff, 0xfc, 0x92, 0x7, 0xff, 0x98, 0x90, 0x1f,
    0xff, 0xf0, 0x3f, 0xf9, 0xe8, 0xf, 0xff, 0xf8,
    0x1f, 0xfc, 0xfe, 0x7, 0xff, 0xfc, 0xf, 0xfe,
    0x79, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0,
    0x7f, 0xfc, 0x8a, 0x5f, 0xfc, 0xa2, 0x7, 0xff,
    0xa4, 0x81, 0xff, 0xcd, 0x96, 0xff, 0xf2, 0xb0,
    0x1f, 0xfe, 0x9e, 0x7, 0xff, 0x2c, 0x86, 0x7,
    0xff, 0xfc, 0x10, 0x3f, 0xf9, 0x6c, 0xf, 0xfe,
    0x69, 0x3, 0xff, 0xd0, 0x80, 0xff, 0xe5, 0x90,
    0x3f, 0xf9, 0xa8, 0xf, 0xff, 0x3a, 0x3, 0xff,
    0x9c, 0xc0, 0xff, 0xe5, 0xc0, 0x3f, 0xfc, 0xf0,
    0xf, 0xfe, 0x66, 0x3, 0xff, 0x9d, 0x40, 0xff,
    0xf2, 0xc2, 0x7, 0xff, 0x31, 0x82, 0x7, 0xff,
    0x31, 0x62, 0x7, 0xff, 0x84, 0xd6, 0x7, 0xff,
    0x34, 0x8e, 0x7, 0xff, 0x34, 0xec, 0x64, 0xf,
    0xfe, 0xe2, 0xb9, 0x1, 0xff, 0xcd, 0x20, 0x8,
    0x1f, 0xfc, 0xf3, 0x37, 0xed, 0x96, 0xa4, 0x9b,
    0xc9, 0x7f, 0xf1, 0xdb, 0x48, 0xbb, 0xf5, 0x40,
    0x7f, 0xf3, 0xd0, 0x4, 0x7, 0xff, 0x50, 0x92,
    0x46, 0xe9, 0x35, 0xbf, 0xfc, 0x79, 0xd, 0x91,
    0x3, 0xff, 0xa7, 0x80, 0x88, 0x1f, 0xff, 0xf0,
    0x3f, 0xf9, 0x68, 0x9, 0x1, 0xff, 0xff, 0x3,
    0xff, 0x94, 0xc0, 0xd4, 0xf, 0xff, 0xf8, 0x1f,
    0xfc, 0xaa, 0x6, 0x28, 0xf, 0xff, 0xf8, 0x1f,
    0xfc, 0x84, 0x40, 0xee, 0x7, 0xff, 0xfc, 0xf,
    0xfe, 0x44, 0x3, 0xc9, 0x0, 0xff, 0xff, 0x81,
    0xff, 0xc6, 0x84, 0xf, 0xa8, 0x1f, 0xff, 0xf0,
    0x3f, 0xf8, 0xa5, 0x81, 0xfd, 0x80, 0xff, 0xff,
    0x81, 0xff, 0xc3, 0x38, 0xf, 0xf1, 0xa0, 0x7f,
    0xff, 0xc0, 0xff, 0xe1, 0x70, 0x3f, 0xf8, 0xb,
    0x1, 0xff, 0xff, 0x3, 0xfe, 0x3c, 0x81, 0xff,
    0xc1, 0x3d, 0x1, 0xff, 0xff, 0x3, 0xf3, 0xc0,
    0x7f, 0xf1, 0x6e, 0x20, 0x7f, 0xff, 0xc0, 0xc7,
    0x40, 0x3f, 0xf8, 0xe7, 0x63, 0x20, 0x7f, 0xff,
    0x8d, 0xc4, 0xf, 0xfe, 0x51, 0x9b, 0x22, 0x20,
    0x7f, 0xfd, 0xcc, 0xd8, 0x80, 0xff, 0xe7, 0x97,
    0x77, 0xd6, 0x24, 0x20, 0x7f, 0xfa, 0x89, 0x39,
    0x7e, 0x64, 0xf, 0xfe, 0xb1, 0x4e, 0xd6, 0xfd,
    0xb2, 0xc8, 0x6c, 0x94, 0x4e, 0x3, 0xff, 0x92,
    0x4e, 0x4a, 0x6e, 0x91, 0x76, 0x7e, 0xd9, 0x1a,
    0x3, 0xff, 0x8e,

    /* U+36 "6" */
    0x3, 0xff, 0xa0, 0x52, 0x39, 0x16, 0xb6, 0xdf,
    0xff, 0xf3, 0x36, 0xd6, 0xd2, 0x1a, 0x20, 0x7f,
    0xf8, 0xd3, 0xbb, 0xf6, 0xb5, 0x1b, 0x24, 0x27,
    0x1, 0xff, 0xcc, 0x27, 0x25, 0x36, 0x97, 0x7e,
    0xd6, 0x22, 0x7, 0xff, 0x61, 0x4d, 0xec, 0x44,
    0xf, 0xff, 0x41, 0x4e, 0xef, 0x59, 0x3, 0xff,
    0xa2, 0xa7, 0xac, 0x81, 0xff, 0xf3, 0x53, 0x78,
    0x40, 0xff, 0xe6, 0x3d, 0x58, 0x1f, 0xff, 0xb7,
    0xaa, 0x3, 0xff, 0x90, 0xfc, 0x20, 0x7f, 0xff,
    0xd5, 0xa0, 0x3f, 0xf8, 0xa7, 0x40, 0x3f, 0xff,
    0xe0, 0x72, 0xc4, 0xf, 0xfe, 0x12, 0xc4, 0xf,
    0xff, 0xf8, 0x1f, 0x1c, 0x7, 0xff, 0x5, 0xd0,
    0x3f, 0xff, 0xe0, 0x7f, 0xd4, 0xf, 0xf9, 0xc0,
    0x3f, 0xff, 0xe0, 0x7f, 0xf0, 0x12, 0x1, 0xfc,
    0xa0, 0x1f, 0xff, 0xf0, 0x3f, 0xf8, 0x50, 0xf,
    0xea, 0x7, 0xff, 0xfc, 0xf, 0xfe, 0x19, 0x40,
    0x7d, 0x40, 0xff, 0xff, 0x81, 0xff, 0xc5, 0xe0,
    0x78, 0xa0, 0x3f, 0xff, 0xe0, 0x7f, 0xf1, 0x50,
    0x1e, 0xa0, 0x7f, 0xff, 0xc0, 0xff, 0xe3, 0x90,
    0x39, 0x81, 0xff, 0xff, 0x3, 0xff, 0x8e, 0x80,
    0xc8, 0xf, 0xff, 0xf8, 0x1f, 0xfc, 0x8c, 0x6,
    0xc0, 0x7f, 0xf7, 0x49, 0xe4, 0xbf, 0xf8, 0xa0,
    0x7f, 0xf5, 0x18, 0x18, 0x81, 0xff, 0xd3, 0x29,
    0xcb, 0xbf, 0xdb, 0x75, 0xbf, 0xfc, 0x5f, 0xda,
    0x10, 0x3f, 0xf9, 0xe4, 0xc, 0x80, 0xff, 0xe8,
    0x3b, 0xf5, 0x8d, 0x10, 0x3f, 0xfa, 0x5, 0xec,
    0x40, 0x7f, 0xfb, 0x67, 0x88, 0xf, 0xfe, 0xd1,
    0xb0, 0xf, 0xfe, 0x81, 0x3, 0xff, 0x9d, 0x98,
    0x1f, 0xfd, 0xf7, 0x0, 0xff, 0xe6, 0x10, 0xc,
    0xf, 0xfe, 0x6d, 0x20, 0x7f, 0xf8, 0x59, 0x3,
    0xff, 0x9c, 0x40, 0xff, 0xe6, 0x14, 0x7, 0xff,
    0x8e, 0x81, 0xff, 0xce, 0xe0, 0x7f, 0xf3, 0x28,
    0x1f, 0xfe, 0x47, 0x6f, 0xff, 0x2c, 0x80, 0x20,
    0x7f, 0xf3, 0x10, 0x1f, 0xfe, 0x54, 0xbf, 0xf9,
    0x60, 0x7f, 0xf4, 0x8, 0x1f, 0xff, 0xf6, 0x7,
    0xff, 0x2d, 0x1, 0xff, 0xff, 0x3, 0xff, 0x9a,
    0x40, 0xff, 0xff, 0x82, 0x7, 0xff, 0x2f, 0x81,
    0xff, 0xff, 0x3, 0xff, 0x9a, 0x40, 0xff, 0xff,
    0x81, 0xff, 0xcd, 0x60, 0x7f, 0xff, 0xc0, 0xff,
    0xe6, 0x90, 0x3f, 0xe2, 0xe4, 0x5a, 0xda, 0xff,
    0xff, 0x9b, 0xb7, 0x5a, 0x8d, 0x10, 0x3f, 0xfd,
    0x2f, 0x7d, 0x1b, 0x24, 0x26, 0x3, 0xff, 0x9a,
    0x4f, 0x24, 0x72, 0xef, 0xa2, 0x3, 0xff, 0xc4,
    0x67, 0x84, 0xf, 0xff, 0x19, 0x77, 0xe6, 0x40,
    0xff, 0xee, 0xcc, 0xc0, 0xff, 0xf5, 0x19, 0xaa,
    0x3, 0xff, 0xb5, 0x98, 0x1f, 0xfe, 0xf5, 0x68,
    0x81, 0xff, 0xd7, 0xc4, 0xf, 0xff, 0x92, 0xcc,
    0xf, 0xfe, 0xae, 0x20, 0x7f, 0xfd, 0x65, 0x3,
    0xff, 0xa7, 0x48, 0x1f, 0xff, 0x75, 0x40, 0xff,
    0xe8, 0xa4, 0x3, 0xff, 0xf2, 0x98, 0x1f, 0xfd,
    0x8, 0x7, 0xff, 0xee, 0x1, 0xff, 0xd0, 0x20,
    0x7f, 0xff, 0x20, 0x1f, 0xff, 0xf0, 0x3f, 0xf9,
    0xac, 0xf, 0xff, 0xf8, 0x1f, 0xfc, 0xe4, 0x7,
    0xff, 0xfc, 0xf, 0xfe, 0x6e, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0x35, 0x1, 0xff, 0xff, 0x3, 0xff,
    0x9a, 0x40, 0xff, 0xff, 0x81, 0xff, 0xce, 0x20,
    0x7f, 0xf4, 0xca, 0x72, 0x2d, 0xdb, 0x7b, 0xff,
    0xfe, 0xe, 0xdf, 0x5b, 0x44, 0x7, 0xff, 0x45,
    0x81, 0xff, 0xd1, 0x9b, 0x2c, 0x6c, 0x96, 0x27,
    0xc0, 0x7f, 0xf0, 0x49, 0xf9, 0x29, 0xdf, 0x40,
    0xff, 0xe7, 0x90, 0x3f, 0xf9, 0xeb, 0xb2, 0x7,
    0xff, 0x75, 0x74, 0x7, 0xff, 0x37, 0x81, 0xff,
    0xce, 0x34, 0xf, 0xff, 0x15, 0x40, 0x7f, 0xf9,
    0xf8, 0x1f, 0xfe, 0x4a, 0x7, 0xff, 0x30, 0x81,
    0xff, 0xcd, 0x44, 0xf, 0xff, 0x2b, 0x3, 0xff,
    0xcb, 0xc0, 0xff, 0xf3, 0x60, 0x3f, 0xfc, 0xa8,
    0xf, 0xff, 0x32, 0x3, 0xff, 0x9a, 0x40, 0xff,
    0xff, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xfc, 0x3, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0x34, 0x81, 0xff, 0xcb, 0x20, 0x7f, 0xf9, 0x88,
    0x1f, 0xfe, 0x54, 0x7, 0xff, 0x99, 0x1, 0xff,
    0xcb, 0x23, 0x81, 0xff, 0xcb, 0xc0, 0x7f, 0xf9,
    0xa0, 0x1f, 0xfc, 0xd2, 0x7, 0xff, 0x2d, 0x10,
    0x3f, 0xfc, 0x90, 0xf, 0xfe, 0x67, 0xc, 0xf,
    0xfe, 0x66, 0x3, 0xff, 0xc6, 0xd8, 0xf, 0xfe,
    0x61, 0x4, 0xf, 0xfe, 0x6f, 0x40, 0x7f, 0xf7,
    0xcd, 0x80, 0x7f, 0xf4, 0x8, 0x1f, 0xfc, 0xdb,
    0xa2, 0x20, 0x7f, 0xf5, 0xca, 0x7b, 0x10, 0x1f,
    0xfc, 0xe4, 0x1, 0x1, 0xff, 0xce, 0x2e, 0xef,
    0xda, 0xd4, 0x9f, 0xfc, 0x6b, 0x7d, 0xb5, 0xfd,
    0xac, 0x20, 0x7f, 0xf4, 0xf8, 0x1f, 0xfd, 0x42,
    0x91, 0xbf, 0xfe, 0x32, 0x5e, 0x26, 0x3, 0xff,
    0xac, 0x40, 0x98, 0x1f, 0xff, 0xf0, 0x3f, 0xf9,
    0x28, 0xc, 0x40, 0xff, 0xff, 0x81, 0xff, 0xc8,
    0xc0, 0x6a, 0x7, 0xff, 0xfc, 0xf, 0xfe, 0x42,
    0x3, 0x30, 0x3f, 0xff, 0xe0, 0x7f, 0xf1, 0xd0,
    0x1e, 0xa0, 0x7f, 0xff, 0xc0, 0xff, 0xe3, 0x40,
    0x3c, 0x90, 0xf, 0xff, 0xf8, 0x1f, 0xfc, 0x44,
    0x40, 0xfa, 0x90, 0x3f, 0xff, 0xe0, 0x7f, 0xf0,
    0xe8, 0x1f, 0xd8, 0x81, 0xff, 0xff, 0x3, 0xff,
    0x83, 0x40, 0xff, 0xb1, 0x3, 0xff, 0xfe, 0x7,
    0xfd, 0x10, 0x1f, 0xfc, 0xc, 0xc0, 0xff, 0xff,
    0x81, 0xfd, 0x18, 0x1f, 0xfc, 0x29, 0x88, 0x1f,
    0xff, 0xf0, 0x38, 0xe6, 0x7, 0xff, 0x10, 0xe8,
    0x40, 0xff, 0xff, 0x80, 0x78, 0x81, 0xff, 0xc7,
    0x7a, 0xa0, 0x3f, 0xff, 0xaf, 0xc0, 0x3f, 0xf9,
    0x6a, 0xf8, 0x80, 0xff, 0xfb, 0xab, 0xe0, 0x1f,
    0xfd, 0x7, 0x7e, 0x88, 0x81, 0xff, 0xeb, 0x24,
    0xe5, 0xfd, 0x50, 0x1f, 0xfd, 0x52, 0xee, 0xfa,
    0xc8, 0x6c, 0x90, 0x9e, 0x3, 0xff, 0x9a, 0x4e,
    0x4a, 0x6d, 0x22, 0xd6, 0xfd, 0xb2, 0x34, 0x7,
    0xff, 0x14,

    /* U+37 "7" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x3a, 0x81, 0xff,
    0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0,
    0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf, 0xff,
    0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f,
    0xff, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xff, 0x3,
    0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8,
    0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xff,
    0xc0, 0xff, 0xff, 0x81, 0xff, 0xff, 0x3, 0xff,
    0xe5, 0xa3, 0x7f, 0xff, 0x90, 0x3f, 0xfa, 0x49,
    0xb4, 0x9f, 0xff, 0x8e, 0x7, 0xff, 0x44, 0xd0,
    0x3f, 0xff, 0x2a, 0x1, 0xff, 0xd0, 0x38, 0xf,
    0xff, 0xc9, 0xa0, 0x7f, 0xf4, 0x78, 0x1f, 0xff,
    0xac, 0x7, 0xff, 0x47, 0x10, 0x3f, 0xff, 0x38,
    0xf, 0xfe, 0x8d, 0x20, 0x7f, 0xfe, 0x69, 0x3,
    0xff, 0xa0, 0xd0, 0x1f, 0xff, 0x98, 0x80, 0xff,
    0xe8, 0x28, 0x7, 0xff, 0xe5, 0xb0, 0x1f, 0xfd,
    0x3, 0x40, 0xff, 0xfc, 0xa8, 0x7, 0xff, 0x40,
    0xe0, 0x3f, 0xff, 0x26, 0x81, 0xff, 0xd1, 0xe0,
    0x7f, 0xfe, 0x4e, 0x3, 0xff, 0xa3, 0x88, 0x1f,
    0xff, 0x9e, 0x7, 0xff, 0x46, 0x90, 0x3f, 0xff,
    0x38, 0x81, 0xff, 0xd0, 0x88, 0xf, 0xff, 0xcd,
    0x20, 0x7f, 0xf4, 0x1b, 0x1, 0xff, 0xf9, 0x88,
    0xf, 0xfe, 0x82, 0x80, 0x7f, 0xfe, 0x5b, 0x1,
    0xff, 0xd0, 0x34, 0xf, 0xff, 0xca, 0x80, 0x7f,
    0xf4, 0x70, 0x1f, 0xff, 0x93, 0x40, 0xff, 0xe8,
    0xe0, 0x3f, 0xff, 0x58, 0xf, 0xfe, 0x8d, 0x20,
    0x7f, 0xfe, 0x70, 0x1f, 0xfd, 0x18, 0x80, 0xff,
    0xfc, 0xd2, 0x7, 0xff, 0x41, 0xb0, 0x1f, 0xff,
    0x98, 0x80, 0xff, 0xe8, 0x28, 0x7, 0xff, 0xe5,
    0xb0, 0x1f, 0xfd, 0x3, 0x40, 0xff, 0xfc, 0xa8,
    0x7, 0xff, 0x47, 0x1, 0xff, 0xf9, 0x34, 0xf,
    0xfe, 0x8e, 0x3, 0xff, 0xf5, 0x80, 0xff, 0xe8,
    0xd2, 0x7, 0xff, 0xe7, 0x1, 0xff, 0xd1, 0x88,
    0xf, 0xff, 0xcd, 0x20, 0x7f, 0xf4, 0x1b, 0x1,
    0xff, 0xf9, 0x88, 0xf, 0xfe, 0x82, 0x80, 0x7f,
    0xfe, 0x5b, 0x1, 0xff, 0xd0, 0x34, 0xf, 0xff,
    0xca, 0x80, 0x7f, 0xf4, 0x70, 0x1f, 0xff, 0x93,
    0x40, 0xff, 0xe8, 0xe0, 0x3f, 0xff, 0x27, 0x1,
    0xff, 0xd1, 0xa4, 0xf, 0xff, 0xcf, 0x3, 0xff,
    0xa3, 0x10, 0x1f, 0xff, 0x9c, 0x40, 0xff, 0xe8,
    0x36, 0x3, 0xff, 0xf3, 0x48, 0x1f, 0xfd, 0x5,
    0x0, 0xff, 0xfc, 0xc4, 0x7, 0xff, 0x40, 0xd0,
    0x3f, 0xff, 0x2d, 0x80, 0xff, 0xe8, 0x1c, 0x7,
    0xff, 0xe5, 0x40, 0x3f, 0xfa, 0x3c, 0xf, 0xff,
    0xc9, 0xa0, 0x7f, 0xf4, 0x71, 0x3, 0xff, 0xf3,
    0x80, 0xff, 0xe8, 0xd2, 0x7, 0xff, 0xe7, 0x1,
    0xff, 0xd1, 0x68, 0xf, 0xff, 0xcd, 0x20, 0x7f,
    0xf4, 0x14, 0x3, 0xff, 0xf3, 0x10, 0x1f, 0xfd,
    0x3, 0x40, 0xff, 0xfc, 0xb6, 0x3, 0xff, 0xa0,
    0x70, 0x1f, 0xff, 0x95, 0x0, 0xff, 0xe8, 0xf0,
    0x3f, 0xff, 0x26, 0x81, 0xff, 0xd1, 0xc4, 0xf,
    0xff, 0xc1, 0xc0, 0x7f, 0xf4, 0x69, 0x3, 0xff,
    0xf3, 0xc0, 0xff, 0xe8, 0xc4, 0x7, 0xff, 0xe7,
    0x10, 0x3f, 0xfa, 0xd, 0x80, 0xff, 0xfc, 0xd2,
    0x7, 0xff, 0x41, 0x40, 0x3f, 0xff, 0x31, 0x1,
    0xff, 0xd0, 0x34, 0xf, 0xff, 0xca, 0x60, 0x7f,
    0xf4, 0x70, 0x1f, 0xff, 0x95, 0x40, 0xff, 0xe8,
    0xe0, 0x3f, 0xff, 0x26, 0x81, 0xff, 0xd1, 0xa4,
    0xf, 0xff, 0xcf, 0x3, 0xff, 0xa3, 0x10, 0x1f,
    0xff, 0x9c, 0x40, 0xff, 0xe8, 0x36, 0x3, 0xff,
    0xf3, 0x48, 0x1f, 0xfd, 0x5, 0x0, 0xff, 0xfc,
    0xc4, 0x7, 0xff, 0x40, 0xd0, 0x3f, 0xff, 0x2d,
    0x80, 0xff, 0xe8, 0xe0, 0x3f, 0xff, 0x2a, 0x1,
    0xff, 0xd1, 0xc0, 0x7f, 0xfe, 0x4d, 0x3, 0xff,
    0xa3, 0x48, 0x1f, 0xff, 0x9c, 0x7, 0xff, 0x46,
    0x20, 0x3f, 0xff, 0x38, 0xf, 0xfe, 0x8b, 0x60,
    0x3f, 0xfd, 0x60,

    /* U+38 "8" */
    0x3, 0xff, 0x88, 0x54, 0xb5, 0xb3, 0xff, 0xff,
    0x4e, 0xcb, 0x51, 0xa2, 0x7, 0xff, 0x49, 0x4d,
    0xf5, 0x69, 0x9, 0x1, 0xff, 0xe9, 0x24, 0x91,
    0xcb, 0xbe, 0x88, 0xf, 0xfe, 0x63, 0xf5, 0x90,
    0x3f, 0xff, 0x45, 0xdf, 0x50, 0x1f, 0xfc, 0x75,
    0xe0, 0x1f, 0xff, 0xf0, 0x25, 0x72, 0x3, 0xff,
    0x89, 0x28, 0x1f, 0xff, 0xf0, 0x3e, 0x36, 0x1,
    0xff, 0xc2, 0xac, 0xf, 0xff, 0xf8, 0x1f, 0xe7,
    0x80, 0xff, 0xe0, 0x44, 0x7, 0xff, 0xfc, 0xf,
    0xfe, 0x1, 0xc0, 0x7f, 0x8b, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0x8, 0xd0, 0x3f, 0xb8, 0x1f, 0xff,
    0xf0, 0x3f, 0xf8, 0x89, 0x0, 0xf9, 0x10, 0x3f,
    0xff, 0xe0, 0x7f, 0xf1, 0x68, 0x1f, 0x40, 0x3f,
    0xff, 0xe0, 0x7f, 0xf1, 0xd0, 0x1e, 0x20, 0x7f,
    0xff, 0xc0, 0xff, 0xe3, 0xc0, 0x39, 0x81, 0xff,
    0xff, 0x3, 0xff, 0x90, 0x40, 0xec, 0x7, 0xff,
    0xfc, 0xf, 0xfe, 0x4b, 0x3, 0x20, 0x3f, 0xff,
    0xe0, 0x7f, 0xf2, 0x70, 0x1f, 0xff, 0xf0, 0x3f,
    0xf9, 0xcc, 0x8, 0x81, 0xff, 0xd2, 0x29, 0x1b,
    0x49, 0xad, 0xff, 0xe4, 0xc9, 0x9b, 0x22, 0x7,
    0xff, 0x44, 0x81, 0x30, 0x3f, 0xf9, 0xe6, 0x7d,
    0x6a, 0x43, 0x79, 0x2f, 0xfe, 0x4b, 0x7a, 0x45,
    0xde, 0x10, 0x3f, 0xf9, 0xe4, 0x1, 0x3, 0xff,
    0x9d, 0x73, 0x3, 0xff, 0xb8, 0xf4, 0x3, 0xff,
    0x9c, 0xc0, 0x70, 0x3f, 0xf9, 0xb9, 0x1, 0xff,
    0xe0, 0x74, 0xf, 0xff, 0x4e, 0x20, 0x7f, 0xf8,
    0x94, 0x3, 0xff, 0xce, 0x88, 0x1f, 0xfe, 0x46,
    0x7, 0xff, 0x30, 0x81, 0xff, 0xce, 0xe0, 0x7f,
    0xf9, 0x90, 0x1f, 0xfe, 0x66, 0x7, 0xff, 0x9b,
    0x1, 0xff, 0xe6, 0x20, 0x7f, 0xff, 0x88, 0xe,
    0x7, 0xff, 0xfc, 0xf, 0xfe, 0x71, 0x3, 0xff,
    0xfd, 0xc0, 0xff, 0xe5, 0xb0, 0xc, 0xf, 0xfe,
    0x5a, 0x3, 0xff, 0xcc, 0x40, 0xff, 0xe5, 0x90,
    0x4, 0xf, 0xfe, 0x5e, 0x3, 0xff, 0xcc, 0x80,
    0xff, 0xe7, 0x90, 0x3f, 0xf9, 0x4c, 0xf, 0xff,
    0x2c, 0x3, 0xff, 0x96, 0x80, 0xc8, 0xf, 0xfe,
    0x5d, 0x3, 0xff, 0xc6, 0x98, 0x1f, 0xfc, 0xbc,
    0x6, 0xa0, 0x7f, 0xf2, 0xd4, 0x3, 0xff, 0xc2,
    0xe8, 0x1f, 0xfc, 0xc4, 0x6, 0x24, 0x7, 0xff,
    0x2d, 0xe4, 0x7, 0xff, 0x75, 0x68, 0x7, 0xff,
    0x30, 0x90, 0x1d, 0x0, 0xff, 0xe6, 0x1b, 0xec,
    0x6c, 0x97, 0xc4, 0xff, 0xf2, 0x92, 0x36, 0x9b,
    0xd2, 0x7, 0xff, 0x36, 0x81, 0xe4, 0x40, 0xff,
    0xe7, 0x27, 0x22, 0xdf, 0xb6, 0xff, 0xe5, 0x5a,
    0x90, 0xc8, 0x1f, 0xfd, 0x6, 0x7, 0xdc, 0xf,
    0xff, 0xf8, 0x1f, 0xfc, 0x5a, 0x7, 0xe3, 0x40,
    0xff, 0xff, 0x81, 0xff, 0xc3, 0x68, 0xf, 0xe5,
    0x40, 0xff, 0xff, 0x81, 0xff, 0xc1, 0x70, 0xf,
    0xf9, 0x62, 0x7, 0xff, 0xfc, 0xf, 0xf5, 0x80,
    0x7f, 0xf0, 0x4e, 0x84, 0xf, 0xff, 0xf8, 0x1c,
    0x67, 0x40, 0x7f, 0xf1, 0x1e, 0xc6, 0x40, 0xff,
    0xfe, 0x97, 0x7e, 0x60, 0x7f, 0xf2, 0xc, 0xdf,
    0xad, 0x46, 0x40, 0xff, 0xf8, 0x97, 0x2f, 0xd1,
    0x1, 0xff, 0xd1, 0xd5, 0x90, 0x3f, 0xfd, 0xe9,
    0xdc, 0x90, 0xf, 0xfe, 0x81, 0x9b, 0xd6, 0x40,
    0xff, 0xf8, 0xa7, 0x2e, 0xfd, 0xa2, 0x3, 0xff,
    0x94, 0xfe, 0x64, 0xf, 0xff, 0xe1, 0x77, 0xd4,
    0x7, 0xff, 0x16, 0x78, 0x7, 0xff, 0xfc, 0xe,
    0x57, 0x10, 0x3f, 0xf8, 0x2b, 0xb0, 0x3f, 0xff,
    0xe0, 0x7f, 0x1c, 0xc0, 0xff, 0xa5, 0x3, 0xff,
    0xfe, 0x7, 0xff, 0x6, 0x40, 0x1f, 0xcd, 0x80,
    0xff, 0xff, 0x81, 0xff, 0xc3, 0x6c, 0x7, 0xc6,
    0x1, 0xff, 0xff, 0x3, 0xff, 0x8b, 0x8, 0x1e,
    0xe0, 0x7f, 0xf3, 0x93, 0x91, 0x6b, 0x6d, 0xff,
    0xff, 0x2f, 0x6d, 0x6a, 0x30, 0x3f, 0xf9, 0xf0,
    0xe, 0x44, 0xf, 0xfe, 0x59, 0xde, 0xc6, 0xc9,
    0x9, 0xc0, 0x7f, 0xf2, 0xc9, 0xc9, 0x1c, 0xf9,
    0x1, 0xff, 0xcc, 0x44, 0xd, 0x0, 0xff, 0xe5,
    0xbc, 0x40, 0xff, 0xef, 0x9b, 0x0, 0xff, 0xe6,
    0x50, 0x31, 0x3, 0xff, 0x94, 0x60, 0x1f, 0xfe,
    0x36, 0xc0, 0x7f, 0xf2, 0xd8, 0x13, 0x3, 0xff,
    0x97, 0x0, 0xff, 0xf2, 0xc0, 0x3f, 0xf9, 0x84,
    0x6, 0x3, 0xff, 0x96, 0x80, 0xff, 0xf3, 0x40,
    0x3f, 0xf9, 0x68, 0x3, 0x3, 0xff, 0x94, 0x80,
    0xff, 0xf3, 0xa0, 0x3f, 0xf9, 0x78, 0x1, 0x3,
    0xff, 0x94, 0x40, 0xff, 0xf3, 0x90, 0x3f, 0xf9,
    0x6c, 0x10, 0x3f, 0xff, 0xe0, 0x7f, 0xf3, 0x8,
    0x1f, 0xff, 0xf0, 0x3f, 0xfa, 0xc, 0xf, 0xff,
    0xf8, 0x1f, 0xfc, 0xe2, 0x7, 0xff, 0x2d, 0x1,
    0xff, 0xff, 0x4, 0xf, 0xfe, 0x61, 0x20, 0x3f,
    0xfc, 0xc8, 0xf, 0xff, 0x37, 0x3, 0xff, 0xcd,
    0xc0, 0xff, 0xf3, 0x1a, 0x7, 0xff, 0x90, 0xa0,
    0x3f, 0xf9, 0x84, 0xf, 0xfe, 0x72, 0xc4, 0xf,
    0xff, 0x9, 0xc0, 0x7f, 0xf3, 0x88, 0x1f, 0xfc,
    0xe3, 0xa1, 0x3, 0xff, 0xbc, 0xf0, 0x1f, 0xfe,
    0xc7, 0xb2, 0x22, 0x7, 0xff, 0x54, 0xa7, 0x7c,
    0x3, 0xff, 0xa0, 0xc0, 0xff, 0xe9, 0x17, 0x77,
    0xed, 0x96, 0xff, 0xf2, 0xb6, 0xbf, 0xda, 0xc4,
    0x7, 0xff, 0x41, 0x2, 0x7, 0xff, 0x60, 0x92,
    0x5f, 0xfc, 0xa2, 0x60, 0x3f, 0xfb, 0x4, 0xf,
    0xff, 0xf8, 0x1f, 0xfc, 0xec, 0x1, 0x1, 0xff,
    0xff, 0x3, 0xff, 0x96, 0x80, 0x60, 0x3f, 0xff,
    0xe0, 0x7f, 0xf2, 0x90, 0x13, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0x2b, 0x81, 0x88, 0x1f, 0xff, 0xf0,
    0x3f, 0xf9, 0x28, 0xd, 0x0, 0xff, 0xff, 0x81,
    0xff, 0xc8, 0xa0, 0x72, 0x20, 0x7f, 0xff, 0xc0,
    0xff, 0xe3, 0x14, 0x7, 0xb8, 0x1f, 0xff, 0xf0,
    0x3f, 0xf8, 0xdc, 0xf, 0x8c, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0x13, 0x10, 0x3f, 0x36, 0x3, 0xff,
    0xfe, 0x7, 0xff, 0xb, 0x10, 0x3f, 0xd2, 0x0,
    0xff, 0xff, 0x81, 0xff, 0x2e, 0x40, 0xff, 0xe0,
    0x3a, 0x40, 0xff, 0xff, 0x81, 0xf1, 0x94, 0xf,
    0xfe, 0x1a, 0xd0, 0xf, 0xff, 0xf8, 0x19, 0x5c,
    0xc0, 0xff, 0xe3, 0x3f, 0x10, 0x1f, 0xff, 0xc4,
    0xef, 0xa8, 0xf, 0xfe, 0x53, 0xbe, 0xc4, 0x40,
    0xff, 0xf3, 0x13, 0x92, 0x9b, 0xa5, 0xad, 0xfd,
    0x62, 0x3, 0xff, 0x84,

    /* U+39 "9" */
    0x3, 0xff, 0x9a, 0x52, 0x36, 0x91, 0x6d, 0xb6,
    0xff, 0xff, 0xa1, 0xb7, 0x5a, 0x8d, 0x10, 0x3f,
    0xfb, 0xc5, 0x4b, 0xbf, 0x6b, 0x52, 0x1b, 0x25,
    0x13, 0x80, 0xff, 0xe8, 0x13, 0xc9, 0x1c, 0xbb,
    0xe8, 0xc8, 0x1f, 0xfd, 0x67, 0x7e, 0xad, 0x10,
    0x3f, 0xfd, 0x85, 0xcd, 0xe2, 0x3, 0xff, 0xa0,
    0x6f, 0x88, 0xf, 0xff, 0xbb, 0xbe, 0x10, 0x3f,
    0xf9, 0x66, 0xe4, 0x7, 0xff, 0xf5, 0xe8, 0x7,
    0xff, 0x25, 0xe4, 0x7, 0xff, 0xfc, 0x3, 0xec,
    0xf, 0xfe, 0x35, 0x80, 0x7f, 0xff, 0xc0, 0xf4,
    0xc4, 0xf, 0xfe, 0x1d, 0x40, 0x7f, 0xff, 0xc0,
    0xfc, 0x71, 0x3, 0xff, 0x83, 0x10, 0x1f, 0xff,
    0xf0, 0x3f, 0xec, 0x80, 0xff, 0x93, 0x3, 0xff,
    0xfe, 0x7, 0xff, 0x6, 0x90, 0x3f, 0xd4, 0xf,
    0xff, 0xf8, 0x1f, 0xfc, 0x3e, 0x7, 0xf4, 0x3,
    0xff, 0xfe, 0x7, 0xff, 0x10, 0xc0, 0x3f, 0x30,
    0x3f, 0xff, 0xe0, 0x7f, 0xf1, 0x58, 0x1f, 0x20,
    0x3f, 0xff, 0xe0, 0x7f, 0xf1, 0xd8, 0x1e, 0xe0,
    0x7f, 0xff, 0xc0, 0xff, 0xe3, 0xd0, 0x3c, 0x80,
    0xff, 0xff, 0x81, 0xff, 0xc7, 0x20, 0x71, 0x3,
    0xff, 0xfe, 0x7, 0xff, 0x25, 0x1, 0x90, 0x1f,
    0xfd, 0xe2, 0x7f, 0xf9, 0x60, 0x7f, 0xf4, 0xf0,
    0x1b, 0x81, 0xff, 0xd1, 0x52, 0xec, 0xff, 0xf6,
    0xdf, 0xfc, 0xbf, 0xda, 0x10, 0x3f, 0xf9, 0xc8,
    0xc, 0x40, 0xff, 0xe7, 0x1b, 0xeb, 0x44, 0x80,
    0xff, 0xea, 0x97, 0xa0, 0x1f, 0xfc, 0xd2, 0x6,
    0x60, 0x7f, 0xf3, 0x56, 0x40, 0x7f, 0xf7, 0x9e,
    0x3, 0xff, 0x9a, 0x40, 0x88, 0x1f, 0xfc, 0xc3,
    0x40, 0xff, 0xf0, 0x9a, 0x7, 0xff, 0x31, 0x81,
    0xff, 0xd0, 0xe0, 0x7f, 0xf8, 0xd1, 0x3, 0xff,
    0x96, 0x40, 0xff, 0xe7, 0xa2, 0x7, 0xff, 0x92,
    0x81, 0xff, 0xcb, 0xe0, 0x8, 0x1f, 0xfc, 0xcc,
    0x7, 0xff, 0x95, 0x1, 0xff, 0xcb, 0x20, 0x7f,
    0xf3, 0xd0, 0x1f, 0xfe, 0x52, 0x7, 0xff, 0x2d,
    0x81, 0xff, 0xcf, 0x20, 0x7f, 0xff, 0xc0, 0xff,
    0xff, 0x81, 0xff, 0xcd, 0x20, 0x7f, 0xff, 0xc0,
    0xff, 0xf5, 0x10, 0x3f, 0xfc, 0xa4, 0xf, 0xff,
    0x3b, 0x3, 0xff, 0xca, 0xc0, 0xff, 0xe6, 0x10,
    0x3f, 0xf9, 0xdc, 0xf, 0xff, 0x2f, 0x3, 0xff,
    0x9c, 0x40, 0xff, 0xe6, 0x20, 0x3f, 0xfc, 0xa8,
    0xf, 0xff, 0x45, 0x3, 0xff, 0xc7, 0x40, 0xff,
    0xe6, 0xb0, 0x4, 0xf, 0xfe, 0x62, 0x80, 0x7f,
    0xf8, 0x6a, 0x3, 0xff, 0xa0, 0xc0, 0xff, 0xe6,
    0xbc, 0x80, 0xff, 0xee, 0x19, 0xd0, 0x1f, 0xfd,
    0x1c, 0x7, 0xff, 0x38, 0xdf, 0xad, 0x49, 0x37,
    0xff, 0xcd, 0x92, 0xb5, 0xb3, 0xe6, 0x7, 0xff,
    0x4d, 0x1, 0xff, 0xd1, 0x29, 0x1b, 0xa4, 0xff,
    0xe6, 0xb7, 0x24, 0x24, 0x7, 0xff, 0x58, 0x81,
    0xff, 0xff, 0x3, 0xff, 0x9e, 0x80, 0xff, 0xff,
    0x81, 0xff, 0xce, 0xe0, 0x7f, 0xff, 0xc0, 0xff,
    0xe7, 0x20, 0x3f, 0xff, 0xe0, 0x7f, 0xf3, 0xe0,
    0x1f, 0xff, 0xf0, 0x3f, 0xf9, 0xcc, 0xf, 0xff,
    0xf8, 0x1f, 0xfc, 0xfa, 0x7, 0xff, 0xfc, 0xf,
    0xfe, 0x72, 0x60, 0x7f, 0xff, 0xc0, 0xff, 0xe7,
    0x44, 0x7, 0xff, 0xe2, 0x81, 0xff, 0xd4, 0xa8,
    0xf, 0xff, 0xb3, 0x40, 0x7f, 0xf5, 0x6c, 0x3,
    0xff, 0xe8, 0xe1, 0x3, 0xff, 0xac, 0xf2, 0x3,
    0xff, 0xe3, 0x20, 0xf, 0xfe, 0xc9, 0xb9, 0x81,
    0xff, 0xed, 0x39, 0x81, 0xff, 0xdc, 0x33, 0xd4,
    0x7, 0xff, 0xa1, 0x5c, 0x40, 0xff, 0xe8, 0x30,
    0x3f, 0xf8, 0x6a, 0xfd, 0x19, 0x3, 0xff, 0xbe,
    0x5d, 0xf5, 0x1, 0xff, 0xe5, 0x2e, 0x6f, 0xda,
    0xc8, 0x6e, 0x4b, 0xff, 0x92, 0xdf, 0x49, 0x5a,
    0xdf, 0xb4, 0x40, 0x7f, 0xfb, 0x8a, 0x6d, 0x25,
    0x6f, 0xff, 0x26, 0x4e, 0x6e, 0x48, 0x40, 0xff,
    0xe0, 0xb0, 0x3f, 0xf9, 0x84, 0xf, 0xff, 0xf8,
    0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xff,
    0xc0, 0xff, 0xff, 0x81, 0xf1, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0x98, 0x81, 0xff, 0xff, 0x1, 0xc0,
    0xff, 0xff, 0x81, 0xff, 0xce, 0x40, 0x7f, 0xf2,
    0xd8, 0x9f, 0xff, 0xf2, 0xd8, 0x1f, 0xfe, 0x72,
    0x7, 0xff, 0x2c, 0x82, 0x7, 0xff, 0x2f, 0x1,
    0xff, 0xe6, 0x60, 0x7f, 0xf9, 0x92, 0x1, 0xff,
    0xe4, 0x30, 0xf, 0xfe, 0x67, 0x3, 0xff, 0x9d,
    0x50, 0x1f, 0xfe, 0x3e, 0x7, 0xff, 0x34, 0x81,
    0xff, 0xcf, 0xb0, 0xf, 0xff, 0x3, 0xe4, 0xf,
    0xfe, 0x6b, 0x4, 0xf, 0xfe, 0x73, 0xf5, 0x90,
    0x3f, 0xfb, 0x5, 0xdf, 0x0, 0xff, 0xe7, 0x90,
    0x3f, 0xfa, 0x4a, 0x6f, 0xda, 0xd4, 0x9f, 0xfc,
    0xdb, 0x6d, 0xfb, 0x44, 0x7, 0xff, 0x41, 0x0,
    0xe0, 0x7f, 0xf5, 0x4a, 0x46, 0xff, 0xf9, 0xa9,
    0x44, 0xf, 0xfe, 0xae, 0x0, 0x80, 0xff, 0xff,
    0x81, 0xff, 0xcb, 0x40, 0x8, 0x1f, 0xff, 0xf0,
    0x3f, 0xf9, 0x44, 0x80, 0x88, 0x1f, 0xff, 0xf0,
    0x3f, 0xf9, 0x34, 0xd, 0x40, 0xff, 0xff, 0x81,
    0xff, 0xc9, 0x40, 0x66, 0x7, 0xff, 0xfc, 0xf,
    0xfe, 0x43, 0x20, 0x73, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0x1e, 0x1, 0xe8, 0x7, 0xff, 0xfc, 0xf,
    0xfe, 0x34, 0x3, 0xf4, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0x11, 0xb0, 0x1f, 0x9b, 0x1, 0xff, 0xff,
    0x3, 0xff, 0x84, 0x60, 0x1f, 0xe8, 0x80, 0xff,
    0xff, 0x81, 0xff, 0xc0, 0x58, 0xf, 0xfe, 0x5,
    0x80, 0x7f, 0xff, 0xc0, 0xff, 0x3a, 0x7, 0xff,
    0x9, 0xe2, 0x7, 0xff, 0xfc, 0xf, 0xac, 0x3,
    0xff, 0x88, 0x75, 0x20, 0x7f, 0xff, 0xc0, 0x9f,
    0x40, 0x7f, 0xf1, 0xd6, 0xc8, 0x80, 0xff, 0xfe,
    0x19, 0xe0, 0x1f, 0xfc, 0xb2, 0xef, 0xd5, 0xa2,
    0x7, 0xff, 0xcd, 0x4d, 0x8c, 0xf, 0xfe, 0x89,
    0x52, 0xef, 0xed, 0x64, 0x36, 0x4a, 0x27, 0x1,
    0xff, 0xdb, 0x24, 0x9c, 0xbb, 0xd6, 0x40, 0xff,
    0xe2, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 1947, .box_w = 107, .box_h = 87, .ofs_x = 7, .ofs_y = -1},
    {.bitmap_index = 797, .adv_w = 1947, .box_w = 68, .box_h = 85, .ofs_x = 17, .ofs_y = 0},
    {.bitmap_index = 1145, .adv_w = 1947, .box_w = 101, .box_h = 85, .ofs_x = 11, .ofs_y = 0},
    {.bitmap_index = 1843, .adv_w = 1947, .box_w = 103, .box_h = 86, .ofs_x = 9, .ofs_y = 0},
    {.bitmap_index = 2628, .adv_w = 1947, .box_w = 106, .box_h = 85, .ofs_x = 8, .ofs_y = 0},
    {.bitmap_index = 3164, .adv_w = 1947, .box_w = 103, .box_h = 85, .ofs_x = 10, .ofs_y = 0},
    {.bitmap_index = 3823, .adv_w = 1947, .box_w = 101, .box_h = 86, .ofs_x = 10, .ofs_y = 0},
    {.bitmap_index = 4633, .adv_w = 1947, .box_w = 102, .box_h = 85, .ofs_x = 10, .ofs_y = 0},
    {.bitmap_index = 5180, .adv_w = 1947, .box_w = 102, .box_h = 85, .ofs_x = 10, .ofs_y = 0},
    {.bitmap_index = 6032, .adv_w = 1947, .box_w = 102, .box_h = 86, .ofs_x = 10, .ofs_y = 0}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 48, .range_length = 10, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Pair left and right glyphs for kerning*/
static const uint8_t kern_pair_glyph_ids[] =
{
    1, 2,
    1, 5,
    1, 8,
    2, 1,
    2, 2,
    2, 3,
    2, 4,
    2, 5,
    2, 6,
    2, 7,
    2, 8,
    2, 9,
    2, 10,
    3, 2,
    3, 5,
    3, 8,
    4, 2,
    4, 8,
    5, 2,
    5, 5,
    5, 8,
    6, 2,
    6, 5,
    6, 8,
    7, 2,
    7, 5,
    7, 8,
    8, 2,
    8, 5,
    8, 7,
    8, 8,
    9, 2,
    9, 5,
    9, 8,
    10, 2,
    10, 5,
    10, 8
};

/* Kerning between the respective left and right glyphs
 * 4.4 format which needs to scaled with `kern_scale`*/
static const int8_t kern_pair_values[] =
{
    -25, 7, -3, -81, -121, -90, -93, -91,
    -93, -91, -96, -92, -94, -32, -3, -8,
    -35, -11, -70, 6, -45, -62, 0, -18,
    -39, -4, -14, -42, -54, -12, -6, -35,
    -2, -10, -33, -2, -9
};

/*Collect the kern pair's data in one place*/
static const lv_font_fmt_txt_kern_pair_t kern_pairs =
{
    .glyph_ids = kern_pair_glyph_ids,
    .values = kern_pair_values,
    .pair_cnt = 37,
    .glyph_ids_size = 0
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_pairs,
    .kern_scale = 38,
    .cmap_num = 1,
    .bpp = 3,
    .kern_classes = 0,
    .bitmap_format = 1
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t Number_128 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 87,          /*The maximum line height required by the font*/
    .base_line = 1,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if NUMBER_128*/

