// Max5478.h
// Basat en https://github.com/LinnesLab/MAX5419
#ifndef MAX5478_h
#define MAX5478_h

#include "Arduino.h"
#include <Wire.h>

class MAX5478
{
public:
    // address
    explicit MAX5478(const uint8_t);
	
    uint8_t write_A(const uint8_t); //write volatile
    uint8_t write_B(const uint8_t); //write volatile
    uint8_t write_AB(const uint8_t); //write volatile
	uint8_t writeNonvolatile_A(const uint8_t);  //write to nonvolatile
	uint8_t writeNonvolatile_B(const uint8_t);  //write to nonvolatile
	uint8_t writeNonvolatile_AB(const uint8_t);  //write to nonvolatile
	uint8_t switchVtoNV_A(); //switch memory from vol to nonvol
	uint8_t switchVtoNV_B(); //switch memory from vol to nonvol
	uint8_t switchVtoNV_AB(); //switch memory from vol to nonvol
	uint8_t switchNVtoV_A(); //opposite of above
	uint8_t switchNVtoV_B(); //opposite of above
	uint8_t switchNVtoV_AB(); //opposite of above
	
private:
    uint8_t send(const uint8_t, const uint8_t);     // cmd value
    uint8_t _address;
};

#endif