// Max5478.cpp
// Basat en https://github.com/LinnesLab/MAX5478

#include "MAX5478.h"

#define MAX5478_A_VREG 		    0x11
#define MAX5478_B_VREG 		    0x12
#define MAX5478_AB_VREG 		0x13
#define MAX5478_A_NVREG		    0x21
#define MAX5478_B_NVREG		    0x22
#define MAX5478_AB_NVREG	    0x23
#define MAX5478_A_NVREGxVREG    0x61
#define MAX5478_B_NVREGxVREG    0x62
#define MAX5478_AB_NVREGxVREG   0x63
#define MAX5478_A_VREGxNVREG    0x51
#define MAX5478_B_VREGxNVREG    0x52
#define MAX5478_AB_VREGxNVREG   0x53

MAX5478::MAX5478(const uint8_t address)
{
	_address = address;
}

uint8_t MAX5478::write_A(const uint8_t value)  //Standard write command
{
	uint8_t loc = MAX5478_A_VREG;
    return send(loc, value);
}

uint8_t MAX5478::write_B(const uint8_t value)  //Standard write command
{
	uint8_t loc = MAX5478_B_VREG;
    return send(loc, value);
}

uint8_t MAX5478::write_AB(const uint8_t value)  //Standard write command
{
	uint8_t loc = MAX5478_AB_VREG;
    return send(loc, value);
}

uint8_t MAX5478::writeNonvolatile_A(const uint8_t value) //Write to nonvolatile memory
{
	uint8_t loc = MAX5478_A_NVREG;
    return send(loc, value);
}

uint8_t MAX5478::writeNonvolatile_B(const uint8_t value) //Write to nonvolatile memory
{
	uint8_t loc = MAX5478_B_NVREG;
    return send(loc, value);
}

uint8_t MAX5478::writeNonvolatile_AB(const uint8_t value) //Write to nonvolatile memory
{
	uint8_t loc = MAX5478_AB_NVREG;
    return send(loc, value);
}

uint8_t MAX5478::switchNVtoV_A()  //Switch from NV to V
{
	uint8_t loc = MAX5478_A_NVREGxVREG;
	uint8_t value = 0x00;
    return send(loc, value);
}

uint8_t MAX5478::switchNVtoV_B()  //Switch from NV to V
{
	uint8_t loc = MAX5478_B_NVREGxVREG;
	uint8_t value = 0x00;
    return send(loc, value);
}

uint8_t MAX5478::switchNVtoV_AB()  //Switch from NV to V
{
	uint8_t loc = MAX5478_AB_NVREGxVREG;
	uint8_t value = 0x00;
    return send(loc, value);
}

uint8_t MAX5478::switchVtoNV_A() //Switch from V to NV
{
	uint8_t loc = MAX5478_A_VREGxNVREG;
	uint8_t value = 0x00;
    return send(loc, value);
}

uint8_t MAX5478::switchVtoNV_B() //Switch from V to NV
{
	uint8_t loc = MAX5478_B_VREGxNVREG;
	uint8_t value = 0x00;
    return send(loc, value);
}

uint8_t MAX5478::switchVtoNV_AB() //Switch from V to NV
{
	uint8_t loc = MAX5478_AB_VREGxNVREG;
	uint8_t value = 0x00;
    return send(loc, value);
}

uint8_t MAX5478::send(const uint8_t loc, const uint8_t value)  //send function
{
    Wire.beginTransmission(_address);
    Wire.write(loc);
    Wire.write(value);
    return Wire.endTransmission();
}