# MD_Parola Examples

If you like and use this library please consider making a small donation using [PayPal](https://paypal.me/MajicDesigns/4USD)

[Library Documentation](https://majicdesigns.github.io/MD_Parola/)

<hr>

**Parola_Ambulance**  
Demonstrates reversed text (as if on front of an ambulance)
<hr>

**Parola_Animation_2Speed**  
Program to show combination of all animations and manual setup process 
for animation with different IN and OUT speeds.
<hr>

**Parola_Animation_Catalog**  
Program to show full catalog of the MD_Parola animations.
<hr>

**Parola_Bluetooth_Control**  
Bluetooth control of Parola text display. Full featured example 
controlling a display through a BT interface to change the display 
parameters and text.

Provides control of:
 - Displayed message text and justification
 - Speed, pause time and inverted
 - Display intensity
 - Saving parameters to EEPROM
 - Display config reset, Arduino hardware reset

A companion Android application written using the MIT Application 
Inventor (AI2) can be run on an Android device to communicate with 
the Arduino application. The AI2 application is included and AI2 
can be found at http://ai2.appinventor.mit.edu/
<hr>

**Parola_CustomChars**  
Demonstrate the use of single characters font file replacements.
<hr>

**Parola_Display**  
For every string defined by in the application iterate through all 
combinations of entry and exit effects.

Animation speed can be controlled using a pot on an analog input
<hr>

**Parola_Double_Height_Clock**  
Display the time in a double height display with a fixed width font.
Time is shown in a user defined seven segment font and there is optional 
use of DS1307 module for RTC.
<hr>

**Parola_Double_Height_Scoreboard**  
Demonstrates using double height display to create a scoreboard.
<hr>

**Parola_Double_Height_Test**  
Demonstrates one double height display using the library an a single 
font file definition created with the MD_MAX72xx font builder. The 
upper and lower portions of the display are managed as 2 zones 
'stacked' on top of each other.

Each font file has the lower part of a character as ASCII codes 0-127 
and the upper part of the character in ASCII code 128-255. 
Adding 128 to each lower character creates the correct index for 
the upper character.
<hr>

**Parola_Double_Height_v1**  
Demonstrates one way to create a double height display using the 
library and 2 font files.

Largely based on code shared by arduino.cc forum user Arek00, 26 Sep 2015.
Video of running display can be seen at https://www.youtube.com/watch?v=7nPCIMVUo5g
<hr>

**Parola_Double_Height_v1_Russian**  
Demonstrates one way to create a double height display using the library.

This is code for Double_Height_v1 modified with Russian font by 
arduino.cc forum user borzov161, 25 May 2017.
<hr>

**Parola_Double_Height_v2**  
Demonstrates one double height display using the library and a single 
font file definition created with the MD_MAX72xx font builder.
<hr>

**Parola_Fonts**  
Display text using various fonts.
<hr>

**Parola_HelloWorld**  
Simplest program that does something useful ("Hello World!") using 
native library methods. This is more complex than Print_Minimal but 
allows the full flexibility of the library.
<hr>

**Parola_Print_Minimal**  
Simplest program to display something ("Hello!"), uses the Arduino 
Print Class extension.
<hr>

**Parola_Print_Test**  
Uses the Arduino Print Class extension with various output types.
<hr>

**Parola_Scrolling**  
Demonstrates the use of the scrolling function to display text received 
from the serial interface. The user can enter text on the serial monitor 
and this will display as a scrolling message on the display.

Speed for the display is controlled by a pot on an analog input.
Digital switches used for control of text scroll direction and 
invert mode.
<hr>

**Parola_Scrolling_ESP8266**  
Demonstrates receiving and displaying text received from a web interface. 
The user can enter text through a web page server by the application 
and this will display as a scrolling message on the display. Some display 
parameters for the text can also be controlled from the web page.

The IP address for the ESP8266 is displayed on the scrolling display 
after startup initialization and connection to the WiFi network.

<hr>

**Parola_Scrolling_Menu**  
Demonstrates the use of the scrolling function to display text received
from the serial interface and shared with a menu to change the 
parameters for the scrolling display and save them to EEPROM.

User can enter text on the serial monitor and this will display as a
scrolling message on the display. Speed, scroll direction, brightness 
and invert are controlled from the menu.

The interface for menu control can be either 3 momentary on (tact) 
switches or a rotary encoder with integrated switch.
<hr>

**Parola_Scrolling_ML**  
Demonstrates the use of the scrolling function to display text received
from the serial interface on multiple lines of matrix displays. User can 
enter text on the serial monitor and this will display as a scrolling 
message on the display. The message should be prefixed with the line 
number on which it should be displayed.

Speed for the display is controlled by a pot on an analog input.
Digital switches used for control of text scroll direction and 
invert mode.
<hr>

**Parola_Scrolling_Spacing**  
Demonstrates the use of the scrolling function to display text received
from the serial interface and how to adjust the spacing between the end
of one message at the start of the following one. User can enter text on 
the serial monitor and this will display as a scrolling message on the 
display.

Speed for the display is controlled by a pot on an analog input.
Digital switches used for control of text scroll direction and 
invert mode.
<hr>

**Parola_Scrolling_Vertical**  
Demonstrates the use of the scrolling function to display text received
from the serial interface in a vertical display. User can enter text 
on the serial monitor and this will display as a scrolling message on 
the display. 

Speed for the display is controlled by a pot on an analog input.
Digital switches used for control of text scroll direction and 
invert mode.
<hr>

**Parola_Sprites_Library**  
Demonstrates how to set up and use the user defined sprites for
text animations.

Speed for the display is controlled by a pot on an analog input.
Digital switches used for control of text justification and 
invert mode.
<hr>

**Parola_Sprites_Simple**  
Demonstrates minimum required for sprite animated text.
<hr>

**Parola_Test**  
Demonstrates most of the functions of the Parola library.
All animations are be run and tested under user control.

Speed for the display is controlled by a pot on an analog input.
Digital switches used for control of Justification, Effect progression,
Pause between animations, LED intensity, Display flip, and invert mode.
<hr>

**Parola_TG_Combo**  
Demonstrates the use of Parola to combine text and graphics in one combined
display.
<hr>

**Parola_TG_Coord**  
Demonstrates using Parola to display text and graphics in the same zone
at different times (coordinated).
<hr>

**Parola_TG_Zones**  
Demonstrates using Parola to display text and graphics in different zones
simultaneously.
<hr>

**Parola_UFT-8_Display**  
Demonstrates how UTF-8 multi-byte characters can be mapped to 
Extended ASCII characters that can be displayed with a suitable 
font file.
<hr>

**Parola_Zone_Display**  
For every string defined in the sketch iterate through all 
combinations of entry and exit effects in each zone independently. 
Requires at least 9 modules for 3 zones.

Animation speed can be controlled using a pot on an analog input.
<hr>

**Parola_Zone_Dynamic**  
Program to demonstrate using dynamic (changing) zones with the 
library. Zones are changed by 2 modules for each iteration and 
a simple string is displayed in the zone.
<hr>

**Parola_Zone_Mesg**  
Display messages in the zones. Wait for each zone to finish displaying 
before continuing. Animation speed can be controlled using a pot on 
an analog pin.
<hr>

**Parola_Zone_Mirror**  
Iterate through all combinations of entry and exit effects 
in 2 zones - one in normal mode and the second in inverted 
mirrored mode.
<hr>

**Parola_Zone_Sign**  
Demonstrate use of effects on different zones to create an animated sign.
<hr>

**Parola_Zone_TimeMsg**  
Display the time in one zone and other information scrolling 
through in another zone.

- Time is shown in a user defined fixed width font
- Scrolling text uses the default font
- Temperature display uses user defined characters
- Optional use of DS1307 module for time and 
  DHT11 sensor for temp and humidity
<hr>
