#include <Arduino.h>

#include "time.h"

static time_t _time = 0;
static millis_t _millis = 0;

////////////////////////////////////////////////////////////////////////////////////////////////////
static void updateTime() {
	static millis_t lastMillis = 0;

	millis_t now = millis();
	millis_t delay = now - lastMillis;

	if (delay > 0) {
		_millis += delay;
		if (_millis >= 1000) {
			_time += _millis / 1000;
			_millis %= 1000;
		}

		lastMillis = now;
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
time_t time() {
	updateTime();
	return _time;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
millis_t timeMillis() {
	updateTime();
	return _millis;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
time_t getTime() {
	return _time;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
millis_t getTimeMillis() {
	return _millis;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
time_t setTime(time_t t, millis_t m) {
	_time = t;
	_millis = m;

	return _time;
}
