/*
   Copyright (c) 2016 Boot&Work Corp., S.L. All rights reserved

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Include Industrial Shields libraries
#include <MDUINO.h>
#include <RS485.h>

/* IMPORTANT: SWITCHES configuration
COMMUNICATION SWITCH - A ZONE
  SCL: ON
  SDA: ON
  RX1: ON
  TX1: ON
  Pin3: ON
  Pin2: ON

DIGITAL/ANALOG OUT SWITCH - B ZONE
  Q0.7: ON
  Q0.6: ON
  Q0.5: ON

DIGITAL/ANALOG OUT SWITCH - C ZONE
  Q1.7: ON
  Q1.6: ON
  Q1.5: ON

DIGITAL/ANALOG OUT SWITCH - D ZONE
  Q2.7: ON
  Q2.6: ON
  Q2.5: ON
*/

////////////////////////////////////////////////////////////////////////////////////////////////////
void setup() {
  // Begin serial port
	Serial.begin(9600);

  // Begin RS485 port
  RS485.begin(38400);
}

////////////////////////////////////////////////////////////////////////////////////////////////////
void loop() {
  // Print received byte when available
  if (RS485.available()) {
    byte rx = RS485.read();

    // Hexadecimal representation
    Serial.print("HEX: ");
    Serial.print(rx, HEX);

    // Decimal representation
    Serial.print(", DEC: ");
    Serial.println(rx, DEC);
  }
}
