
// if having troubles with min/max, uncomment the following
//#undef min
//#undef max

#ifdef __has_attribute
#define HAVE_ATTRIBUTE(x) __has_attribute(x)
#else
#define HAVE_ATTRIBUTE(x) 0
#endif
#if HAVE_ATTRIBUTE(aligned) || (defined(__GNUC__) && !defined(__clang__))
#define DATA_ALIGN_ATTRIBUTE __attribute__((aligned(4)))
#else
#define DATA_ALIGN_ATTRIBUTE
#endif

const unsigned char sine_model[] DATA_ALIGN_ATTRIBUTE = {
        0x1c, 0x00, 0x00, 0x00, 0x54, 0x46, 0x4c, 0x33, 0x00, 0x00, 0x12, 0x00,
        0x1c, 0x00, 0x04, 0x00, 0x08, 0x00, 0x0c, 0x00, 0x10, 0x00, 0x14, 0x00,
        0x00, 0x00, 0x18, 0x00, 0x12, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
        0x14, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x00,
        0x18, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0xa0, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xac, 0x00, 0x00, 0x00,
        0x0c, 0x00, 0x00, 0x00, 0x98, 0x0a, 0x00, 0x00, 0x94, 0x0a, 0x00, 0x00,
        0x80, 0x09, 0x00, 0x00, 0xcc, 0x08, 0x00, 0x00, 0x60, 0x08, 0x00, 0x00,
        0xd0, 0x07, 0x00, 0x00, 0x7c, 0x03, 0x00, 0x00, 0xe8, 0x02, 0x00, 0x00,
        0x78, 0x0a, 0x00, 0x00, 0x74, 0x0a, 0x00, 0x00, 0x70, 0x0a, 0x00, 0x00,
        0x38, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
        0x08, 0x00, 0x0c, 0x00, 0x04, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00,
        0x08, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
        0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f,
        0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x00, 0xe2, 0xf6, 0xff, 0xff,
        0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x31, 0x2e, 0x35, 0x2e,
        0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x0f, 0x00, 0x00, 0x00, 0x4d, 0x4c, 0x49, 0x52, 0x20, 0x43, 0x6f, 0x6e,
        0x76, 0x65, 0x72, 0x74, 0x65, 0x64, 0x2e, 0x00, 0x00, 0x00, 0x0e, 0x00,
        0x18, 0x00, 0x04, 0x00, 0x08, 0x00, 0x0c, 0x00, 0x10, 0x00, 0x14, 0x00,
        0x0e, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00,
        0x40, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x90, 0x09, 0x00, 0x00, 0x20, 0x09, 0x00, 0x00,
        0x5c, 0x08, 0x00, 0x00, 0xb4, 0x07, 0x00, 0x00, 0x60, 0x07, 0x00, 0x00,
        0xcc, 0x06, 0x00, 0x00, 0x78, 0x02, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00,
        0xec, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
        0x03, 0x00, 0x00, 0x00, 0x4c, 0x01, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00,
        0x10, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x6d, 0x61, 0x69, 0x6e,
        0x00, 0x00, 0x00, 0x00, 0x8a, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x08,
        0x18, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
        0x94, 0xf6, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
        0x03, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0x03, 0x00, 0x00, 0x00, 0x08, 0xf7, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00,
        0x20, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x49, 0x64, 0x65, 0x6e,
        0x74, 0x69, 0x74, 0x79, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x0c, 0xf8, 0xff, 0xff,
        0x00, 0x00, 0x0e, 0x00, 0x14, 0x00, 0x00, 0x00, 0x08, 0x00, 0x0c, 0x00,
        0x07, 0x00, 0x10, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
        0x1c, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
        0x4e, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00,
        0x08, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x90, 0xf7, 0xff, 0xff,
        0x14, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
        0x58, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00,
        0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x2f, 0x64,
        0x65, 0x6e, 0x73, 0x65, 0x5f, 0x31, 0x2f, 0x52, 0x65, 0x6c, 0x75, 0x3b,
        0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x2f, 0x64,
        0x65, 0x6e, 0x73, 0x65, 0x5f, 0x31, 0x2f, 0x42, 0x69, 0x61, 0x73, 0x41,
        0x64, 0x64, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x10, 0x00, 0x00, 0x00, 0xbc, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x0e, 0x00,
        0x16, 0x00, 0x00, 0x00, 0x08, 0x00, 0x0c, 0x00, 0x07, 0x00, 0x10, 0x00,
        0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x24, 0x00, 0x00, 0x00,
        0x18, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00,
        0x08, 0x00, 0x07, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
        0x01, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x0a, 0x00, 0x0c, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x00, 0x00, 0x00,
        0x60, 0xf8, 0xff, 0xff, 0x14, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
        0x18, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
        0x2e, 0x00, 0x00, 0x00, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x69,
        0x61, 0x6c, 0x2f, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x2f, 0x52, 0x65, 0x6c,
        0x75, 0x3b, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
        0x2f, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x2f, 0x42, 0x69, 0x61, 0x73, 0x41,
        0x64, 0x64, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x10, 0x00, 0x00, 0x00, 0x6c, 0xf8, 0xff, 0xff, 0x82, 0xf9, 0xff, 0xff,
        0x04, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x25, 0x55, 0x34, 0xbf,
        0xfa, 0xa2, 0x01, 0xbf, 0x62, 0xbe, 0x25, 0xbf, 0x8a, 0x05, 0xae, 0xbe,
        0x74, 0x67, 0xda, 0x3e, 0x20, 0x7a, 0x00, 0x3f, 0xcc, 0xef, 0x55, 0x3e,
        0xc0, 0x2e, 0x83, 0xbe, 0x15, 0xf3, 0xc6, 0x3e, 0x92, 0xd1, 0xe9, 0xbd,
        0xdc, 0x11, 0xce, 0xbe, 0x85, 0x67, 0x37, 0xbf, 0x9a, 0x43, 0xa5, 0x3d,
        0x8f, 0x93, 0xae, 0xbe, 0x69, 0x98, 0x99, 0x3e, 0xd0, 0xe1, 0xb4, 0xbe,
        0x7a, 0xf9, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x14, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00,
        0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x2f, 0x64,
        0x65, 0x6e, 0x73, 0x65, 0x5f, 0x32, 0x2f, 0x4d, 0x61, 0x74, 0x4d, 0x75,
        0x6c, 0x00, 0x00, 0x00, 0xfc, 0xf8, 0xff, 0xff, 0x12, 0xfa, 0xff, 0xff,
        0x04, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0xea, 0xd7, 0x5d, 0x3e,
        0x49, 0xd2, 0xc8, 0xbe, 0x00, 0x2c, 0x69, 0x3d, 0x78, 0xd2, 0x0c, 0xbd,
        0x51, 0x70, 0xd4, 0x3c, 0x79, 0xaa, 0xbc, 0xbe, 0xf9, 0x60, 0x2b, 0x3f,
        0x13, 0xe6, 0x66, 0xbe, 0x36, 0x13, 0x00, 0x3e, 0x18, 0x89, 0xe0, 0xbe,
        0x1e, 0x81, 0x41, 0x3e, 0x6c, 0xcf, 0x82, 0xbd, 0x2b, 0xdc, 0xaa, 0x3e,
        0x10, 0x8e, 0x80, 0x3c, 0x5d, 0x3f, 0x24, 0xbe, 0x0a, 0x5e, 0x39, 0xbf,
        0x6d, 0x2c, 0xb3, 0x3e, 0xea, 0x1d, 0x74, 0x3e, 0xc0, 0x50, 0xc9, 0x3c,
        0xca, 0xe8, 0x54, 0x3e, 0x9d, 0x38, 0x7c, 0x3e, 0xcc, 0xd8, 0x85, 0xbe,
        0x68, 0x09, 0xd7, 0x3d, 0x80, 0x3d, 0xc7, 0xbe, 0xa8, 0xac, 0x8f, 0xbe,
        0x16, 0x2a, 0xcb, 0x3e, 0x52, 0xea, 0xb7, 0xbe, 0x6d, 0xfb, 0x9a, 0x3e,
        0x01, 0x50, 0xaf, 0x3e, 0x98, 0x2d, 0x2f, 0xbd, 0xe6, 0x2e, 0x98, 0xbe,
        0x09, 0x3f, 0xc5, 0x3c, 0x64, 0x12, 0xb2, 0xbd, 0xa4, 0x6e, 0x90, 0xbe,
        0xbc, 0x2b, 0x26, 0xbe, 0x28, 0xe2, 0x35, 0xbe, 0x79, 0xde, 0xa0, 0x3e,
        0xbd, 0xfb, 0xe7, 0x3d, 0xb0, 0x80, 0xdf, 0xbb, 0x40, 0xf1, 0xf6, 0xbd,
        0x32, 0x06, 0xf7, 0x3e, 0x38, 0xa9, 0x4c, 0xbc, 0x2f, 0x14, 0x51, 0xbe,
        0xcc, 0x82, 0x6e, 0xbe, 0x54, 0xba, 0x3a, 0xbe, 0x23, 0x42, 0x83, 0xbe,
        0xf6, 0xad, 0x81, 0xbe, 0x91, 0xe9, 0x89, 0x3e, 0x2c, 0x5a, 0xca, 0xbd,
        0x6b, 0xce, 0xaf, 0x3e, 0xe0, 0xe8, 0x39, 0xbc, 0xa2, 0x96, 0x09, 0xbe,
        0x46, 0xd8, 0x77, 0xbe, 0xde, 0x41, 0x28, 0x3e, 0xea, 0x11, 0xc9, 0x3e,
        0xc9, 0xeb, 0x84, 0x3e, 0xb5, 0x0b, 0xa8, 0x3e, 0xbe, 0xac, 0x5b, 0x3e,
        0x29, 0xe3, 0x8a, 0x3e, 0xbe, 0x49, 0x31, 0xbe, 0xbe, 0x15, 0x9d, 0xbe,
        0xdc, 0x73, 0xfd, 0xbd, 0x73, 0xf1, 0xf5, 0xbc, 0xc3, 0x10, 0x6b, 0x3e,
        0x64, 0x1d, 0x06, 0xbe, 0xb5, 0x1b, 0x75, 0xbe, 0x51, 0xb8, 0xb8, 0xbe,
        0x12, 0x39, 0x68, 0x3e, 0x8d, 0xf8, 0x95, 0x3e, 0x4f, 0x60, 0xbe, 0x3e,
        0x2e, 0x3b, 0x94, 0x3e, 0x59, 0xbb, 0xb5, 0x3e, 0x19, 0x77, 0xa2, 0xbe,
        0xbf, 0x98, 0xeb, 0xbc, 0xe9, 0x51, 0x92, 0x3e, 0x80, 0x38, 0xed, 0x3c,
        0xd3, 0x80, 0xbe, 0x3e, 0x58, 0xf8, 0x3f, 0x3d, 0x30, 0x42, 0x76, 0x3e,
        0x5b, 0xa9, 0x68, 0xbe, 0x9e, 0xf9, 0x32, 0x3e, 0xfc, 0x6b, 0x09, 0xbe,
        0x2c, 0x53, 0xb7, 0x3d, 0x1d, 0x3b, 0xb7, 0x3e, 0xef, 0x31, 0x8c, 0x3e,
        0xe1, 0x99, 0xea, 0xbd, 0x6d, 0x6a, 0xa8, 0x3d, 0x40, 0x9a, 0x5e, 0x3c,
        0xec, 0xf2, 0x4d, 0x3e, 0xcc, 0xb7, 0xa9, 0x3d, 0x00, 0xcb, 0xd9, 0xba,
        0x2a, 0xb7, 0x09, 0x3e, 0x44, 0x3a, 0xf4, 0xbd, 0x89, 0x41, 0xb8, 0x3e,
        0xac, 0x32, 0x52, 0x3e, 0x34, 0xa1, 0x37, 0x3e, 0xe8, 0xfb, 0x4a, 0xbd,
        0xbd, 0xe8, 0xd6, 0x3e, 0xac, 0x9c, 0xa0, 0xbd, 0xc6, 0x62, 0x21, 0xbe,
        0xfc, 0xc2, 0xab, 0xbd, 0xda, 0x61, 0x24, 0xbe, 0x70, 0xc2, 0x28, 0xbe,
        0x40, 0xd4, 0xff, 0xbd, 0x6a, 0xb5, 0x22, 0xbe, 0xa3, 0x4f, 0xda, 0xbe,
        0x90, 0xdc, 0xe9, 0x3c, 0x1a, 0xea, 0x1b, 0x3e, 0x44, 0x9c, 0x39, 0xbe,
        0x8f, 0xcb, 0x80, 0x3e, 0x50, 0x69, 0x15, 0xbd, 0x55, 0x4c, 0xd5, 0x3e,
        0xec, 0x98, 0x99, 0xbe, 0x31, 0xc0, 0xae, 0x3e, 0xfc, 0x73, 0xa4, 0xbe,
        0xb1, 0xa7, 0xa0, 0x3e, 0x75, 0x21, 0xa9, 0x3e, 0x14, 0x3e, 0x80, 0xbd,
        0x2a, 0x47, 0xb1, 0xbe, 0x7f, 0x5f, 0xc0, 0x3e, 0x15, 0x1e, 0xbe, 0xbd,
        0x66, 0xb3, 0x4d, 0x3e, 0xfe, 0x78, 0xac, 0xbe, 0x18, 0x19, 0xfa, 0xbd,
        0xdc, 0x4b, 0xb2, 0x3d, 0x88, 0x05, 0x5c, 0x3d, 0xcf, 0x28, 0xc6, 0x3d,
        0x09, 0xa4, 0x49, 0xbd, 0x20, 0xf4, 0x03, 0xbc, 0xfa, 0x6b, 0x90, 0xbe,
        0x5a, 0xea, 0x2f, 0x3e, 0x9a, 0x4d, 0x45, 0x3e, 0x2c, 0x17, 0xa6, 0x3e,
        0x3c, 0x8c, 0x90, 0x3e, 0xe4, 0xed, 0x9f, 0x3d, 0xca, 0x6d, 0x5e, 0x3e,
        0x31, 0x11, 0x8e, 0x3e, 0xea, 0xce, 0xeb, 0xbe, 0x00, 0x4c, 0x67, 0x3d,
        0x7a, 0x70, 0x05, 0x3e, 0xd8, 0xec, 0x9e, 0xbe, 0xf8, 0x46, 0xad, 0xbe,
        0x92, 0xe9, 0x91, 0x3e, 0xa0, 0x80, 0x58, 0x3e, 0xed, 0x7c, 0xa3, 0x3e,
        0xb6, 0x96, 0x03, 0x3e, 0x04, 0x9d, 0xd2, 0x3d, 0x76, 0xa7, 0xb1, 0xbe,
        0xbc, 0x3d, 0xc0, 0xbe, 0xc3, 0x1f, 0x82, 0xbe, 0xe4, 0x32, 0xca, 0xbe,
        0xb2, 0x4f, 0x3a, 0x3e, 0x44, 0x1a, 0xd9, 0x3d, 0x19, 0x43, 0x7a, 0x3e,
        0x97, 0xd5, 0xc8, 0x3e, 0x20, 0x32, 0x69, 0x3c, 0x9f, 0x5d, 0x3c, 0xbe,
        0x88, 0xcf, 0x88, 0xbd, 0x2c, 0xae, 0xb1, 0xbe, 0x7f, 0x08, 0x8d, 0xbe,
        0xd7, 0xd8, 0x7a, 0xbe, 0x64, 0xc3, 0xa2, 0xbe, 0xc1, 0x5b, 0x8d, 0x3e,
        0x1e, 0x72, 0x6e, 0x3e, 0x92, 0x8c, 0x81, 0xbe, 0x00, 0xa6, 0xce, 0x3c,
        0x3a, 0x11, 0x2f, 0xbe, 0x82, 0x71, 0x3d, 0x3e, 0xfd, 0xec, 0x36, 0x3d,
        0x32, 0x39, 0xa4, 0x3e, 0xf8, 0xcb, 0x95, 0xbe, 0x63, 0x58, 0xa8, 0x3e,
        0x80, 0x38, 0xb9, 0x3b, 0x81, 0xff, 0x84, 0xbe, 0x13, 0x59, 0x10, 0x3e,
        0x92, 0xe2, 0x6c, 0x3e, 0x4e, 0x6e, 0xc1, 0xbe, 0xf0, 0x64, 0x8f, 0xbe,
        0xb9, 0x9c, 0x84, 0x3e, 0x07, 0x8e, 0xa1, 0x3e, 0x97, 0xd8, 0x72, 0x3e,
        0x11, 0x05, 0x90, 0xbe, 0x3d, 0x41, 0x0a, 0x3f, 0x00, 0xf0, 0xfa, 0xbc,
        0x99, 0x87, 0xdc, 0xbe, 0x69, 0x5b, 0xd6, 0xbe, 0x0c, 0x79, 0x00, 0xbe,
        0x70, 0x22, 0x33, 0x3d, 0x05, 0x79, 0xbb, 0x3e, 0x51, 0x66, 0xa6, 0x3e,
        0x74, 0x32, 0xb7, 0xbe, 0x20, 0xd0, 0x6e, 0xbf, 0x18, 0x26, 0x92, 0xbe,
        0x60, 0x7a, 0x27, 0xbc, 0x20, 0x98, 0xfa, 0xbd, 0xd0, 0x32, 0xc2, 0x3c,
        0x05, 0x74, 0x85, 0xbe, 0x0d, 0x4c, 0x9c, 0xbe, 0x71, 0x1a, 0x8c, 0xbe,
        0xc3, 0x8e, 0x99, 0x3e, 0x96, 0xf9, 0xb3, 0xbe, 0xcc, 0x25, 0x9c, 0x3e,
        0xac, 0x51, 0xc4, 0xbd, 0xd6, 0x35, 0x60, 0x3e, 0xb8, 0x03, 0x24, 0xbd,
        0x88, 0x9a, 0x61, 0xbe, 0x8a, 0xfe, 0x2e, 0xbe, 0xab, 0x0d, 0x4c, 0xbe,
        0xf2, 0xfe, 0x0e, 0x3e, 0xe1, 0xca, 0x66, 0xbe, 0xf6, 0x9c, 0xb7, 0xbe,
        0xf4, 0x9a, 0xd0, 0x3d, 0xa7, 0x29, 0xd0, 0x3d, 0xde, 0xbd, 0xdd, 0x3e,
        0x61, 0x78, 0xd6, 0xbe, 0x50, 0xc5, 0x43, 0xbd, 0xb0, 0x62, 0x08, 0x3e,
        0xf9, 0x6c, 0x08, 0x3e, 0x21, 0x86, 0x88, 0x3e, 0xe0, 0x5c, 0xb4, 0xbe,
        0x40, 0x35, 0xd0, 0xbc, 0x80, 0x57, 0xac, 0xbd, 0xd8, 0x0b, 0xda, 0x3e,
        0x5a, 0x04, 0x89, 0x3e, 0xf8, 0xcd, 0xc5, 0xbd, 0xe2, 0xc0, 0x18, 0x3e,
        0x11, 0x34, 0x91, 0x3e, 0xac, 0x73, 0x29, 0xbe, 0x88, 0x2a, 0x30, 0x3d,
        0xd5, 0xd0, 0x08, 0xbe, 0x63, 0x45, 0x03, 0x3e, 0x8e, 0x6b, 0x59, 0x3e,
        0xef, 0xbe, 0x7c, 0xbe, 0xaf, 0x0f, 0x1e, 0xbd, 0x76, 0xdf, 0x0c, 0x3e,
        0x72, 0x71, 0x9b, 0xbe, 0x4e, 0x19, 0x6e, 0x3e, 0x04, 0x5d, 0x9d, 0x3d,
        0x9e, 0x42, 0x05, 0x3e, 0xf8, 0x74, 0x07, 0x3e, 0x3a, 0xe7, 0x13, 0x3e,
        0xd5, 0x25, 0x83, 0x3e, 0xe6, 0x1c, 0xbf, 0xbe, 0xff, 0x09, 0x9a, 0x3e,
        0x82, 0x55, 0xb3, 0x3d, 0x68, 0xd7, 0xaf, 0xbe, 0x2d, 0x24, 0x7a, 0xbe,
        0xba, 0xe2, 0x8d, 0xbe, 0x13, 0x26, 0xba, 0xbe, 0x27, 0xee, 0x08, 0xbe,
        0xdd, 0x7d, 0xac, 0x3e, 0xf8, 0xa1, 0x16, 0xbe, 0x90, 0xad, 0xa8, 0xbc,
        0xd6, 0xa5, 0xd0, 0xbe, 0x52, 0xb4, 0x8e, 0x3e, 0x76, 0x8d, 0x22, 0x3e,
        0xca, 0xfd, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0x14, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00,
        0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x2f, 0x64,
        0x65, 0x6e, 0x73, 0x65, 0x5f, 0x31, 0x2f, 0x4d, 0x61, 0x74, 0x4d, 0x75,
        0x6c, 0x00, 0x00, 0x00, 0x4c, 0xfd, 0xff, 0xff, 0x62, 0xfe, 0xff, 0xff,
        0x04, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x60, 0xce, 0xe9, 0xbc,
        0x16, 0xb6, 0x28, 0xbe, 0x70, 0xc5, 0x7d, 0xbe, 0x80, 0xb9, 0x65, 0xbc,
        0xc9, 0xea, 0x6f, 0x3e, 0x02, 0x1d, 0x9e, 0x3d, 0x70, 0x69, 0x2b, 0x3d,
        0x68, 0xa4, 0x08, 0xbf, 0xfc, 0xc2, 0x0b, 0x3e, 0x08, 0xb3, 0x0e, 0x3f,
        0x82, 0x03, 0x13, 0xbe, 0x95, 0xdc, 0xb6, 0xbe, 0xc0, 0x35, 0xf6, 0xbe,
        0xee, 0xf3, 0x13, 0xbf, 0x89, 0x70, 0x59, 0x3e, 0xf5, 0x73, 0xaa, 0x3e,
        0x5a, 0xfe, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
        0x14, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x10, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00,
        0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x2f, 0x64,
        0x65, 0x6e, 0x73, 0x65, 0x2f, 0x4d, 0x61, 0x74, 0x4d, 0x75, 0x6c, 0x00,
        0xd8, 0xfd, 0xff, 0xff, 0xee, 0xfe, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00,
        0x04, 0x00, 0x00, 0x00, 0xd5, 0x04, 0x56, 0x3e, 0xaa, 0xfe, 0xff, 0xff,
        0x10, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
        0x44, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x32, 0x00, 0x00, 0x00, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x69,
        0x61, 0x6c, 0x2f, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x32, 0x2f, 0x42,
        0x69, 0x61, 0x73, 0x41, 0x64, 0x64, 0x2f, 0x52, 0x65, 0x61, 0x64, 0x56,
        0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x70, 0x2f, 0x72, 0x65,
        0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x00, 0x00, 0x40, 0xfe, 0xff, 0xff,
        0x56, 0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
        0x34, 0x20, 0xb6, 0x3e, 0x6b, 0x93, 0x4d, 0xbe, 0x00, 0x79, 0x30, 0xbe,
        0x1a, 0x69, 0x5f, 0xbe, 0x8d, 0x64, 0x50, 0x3e, 0x71, 0x86, 0x50, 0x3e,
        0x00, 0x00, 0x00, 0x00, 0x50, 0x8e, 0x3c, 0xbe, 0xd5, 0xba, 0x4f, 0x3e,
        0xb4, 0x34, 0x4f, 0x3b, 0x25, 0xe8, 0x19, 0xbe, 0x3d, 0x45, 0x85, 0x3e,
        0xd0, 0x1e, 0x3a, 0x39, 0xbe, 0x88, 0x8f, 0xbe, 0xa7, 0xf0, 0x4e, 0x3e,
        0xa6, 0x74, 0x48, 0xbd, 0x4e, 0xff, 0xff, 0xff, 0x10, 0x00, 0x00, 0x00,
        0x03, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00,
        0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x2f, 0x64,
        0x65, 0x6e, 0x73, 0x65, 0x5f, 0x31, 0x2f, 0x42, 0x69, 0x61, 0x73, 0x41,
        0x64, 0x64, 0x2f, 0x52, 0x65, 0x61, 0x64, 0x56, 0x61, 0x72, 0x69, 0x61,
        0x62, 0x6c, 0x65, 0x4f, 0x70, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
        0x63, 0x65, 0x00, 0x00, 0x04, 0x00, 0x06, 0x00, 0x04, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x06, 0x00, 0x08, 0x00, 0x04, 0x00, 0x06, 0x00, 0x00, 0x00,
        0x04, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x4f, 0x80, 0x39, 0x3e, 0xc3, 0x1c, 0x68, 0xbb, 0x06, 0xde, 0x6c, 0x3e,
        0x00, 0x00, 0x00, 0x00, 0x4f, 0x83, 0x3c, 0xbe, 0x36, 0xd9, 0x30, 0xbe,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x5b, 0x68, 0x09, 0x3e, 0x3a, 0x00, 0x7f, 0xbb,
        0x00, 0x00, 0x0e, 0x00, 0x14, 0x00, 0x04, 0x00, 0x00, 0x00, 0x08, 0x00,
        0x0c, 0x00, 0x10, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00,
        0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x2f, 0x64,
        0x65, 0x6e, 0x73, 0x65, 0x2f, 0x42, 0x69, 0x61, 0x73, 0x41, 0x64, 0x64,
        0x2f, 0x52, 0x65, 0x61, 0x64, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
        0x65, 0x4f, 0x70, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
        0x00, 0x00, 0x00, 0x00, 0xa4, 0xff, 0xff, 0xff, 0x14, 0x00, 0x18, 0x00,
        0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x0c, 0x00, 0x10, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x14, 0x00, 0x14, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00,
        0x20, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x64, 0x65, 0x6e, 0x73,
        0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x00, 0x02, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff,
        0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00
};
const int sine_model_len = 2792;