/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EspStackTraceDecoder {
    File tool;
    File elf;
    private static String[] exceptions = new String[]{"Illegal instruction", "SYSCALL instruction", "InstructionFetchError: Processor internal physical address or data error during instruction fetch", "LoadStoreError: Processor internal physical address or data error during load or store", "Level1Interrupt: Level-1 interrupt as indicated by set level-1 bits in the INTERRUPT register", "Alloca: MOVSP instruction, if caller's registers are not in the register file", "IntegerDivideByZero: QUOS, QUOU, REMS, or REMU divisor operand is zero", "reserved", "Privileged: Attempt to execute a privileged operation when CRING ? 0", "LoadStoreAlignmentCause: Load or store to an unaligned address", "reserved", "reserved", "InstrPIFDataError: PIF data error during instruction fetch", "LoadStorePIFDataError: Synchronous PIF data error during LoadStore access", "InstrPIFAddrError: PIF address error during instruction fetch", "LoadStorePIFAddrError: Synchronous PIF address error during LoadStore access", "InstTLBMiss: Error during Instruction TLB refill", "InstTLBMultiHit: Multiple instruction TLB entries matched", "InstFetchPrivilege: An instruction fetch referenced a virtual address at a ring level less than CRING", "reserved", "InstFetchProhibited: An instruction fetch referenced a page mapped with an attribute that does not permit instruction fetch", "reserved", "reserved", "reserved", "LoadStoreTLBMiss: Error during TLB refill for a load or store", "LoadStoreTLBMultiHit: Multiple TLB entries matched for a load or store", "LoadStorePrivilege: A load or store referenced a virtual address at a ring level less than CRING", "reserved", "LoadProhibited: A load referenced a page mapped with an attribute that does not permit loads", "StoreProhibited: A store referenced a page mapped with an attribute that does not permit stores"};

    private String[] analyseStracktrace(String string) {
        Pattern pattern = Pattern.compile("40[0-2][0-9a-f]{5}\\b");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.tool.getAbsolutePath());
        arrayList.add("-aipfC");
        arrayList.add("-e");
        arrayList.add(this.elf.getAbsolutePath());
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        if (arrayList.size() == 4) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String analyseException(String string) {
        Pattern pattern = Pattern.compile("Exception \\(([0-9]*)\\):");
        Matcher matcher = pattern.matcher(string);
        String string2 = "Exception Cause: ";
        if (!matcher.find()) {
            string2 = string2 + "Not found";
        } else {
            int n = Integer.parseInt(matcher.group(1));
            string2 = string2 + matcher.group(1) + " ";
            string2 = n >= 0 && n < exceptions.length ? string2 + " [" + exceptions[n] + "]" : string2 + " [Unknown]";
        }
        return string2;
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        String string;
        String[] stringArray2;
        if (stringArray.length == 0) {
            EspStackTraceDecoder.usage();
            System.exit(1);
        }
        EspStackTraceDecoder espStackTraceDecoder = new EspStackTraceDecoder();
        espStackTraceDecoder.elf = new File(stringArray[1]);
        espStackTraceDecoder.tool = new File(stringArray[0]);
        String string2 = "";
        if (stringArray.length > 2) {
            string2 = new String(Files.readAllBytes(Paths.get(stringArray[2], new String[0])));
        } else {
            stringArray2 = null;
            while ((stringArray2 = System.console().readLine()) != null) {
                string2 = string2 + (String)stringArray2 + "\n";
            }
        }
        System.out.println(espStackTraceDecoder.analyseException(string2));
        System.out.println();
        stringArray2 = espStackTraceDecoder.analyseStracktrace(string2);
        if (stringArray2 == null) {
            System.out.println("No Addresse found in Stracktrace!");
            System.exit(1);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray2);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            System.out.println(string);
        }
        process.waitFor();
        bufferedReader.close();
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("java -jar EspEception <Path to xtensa-lx106-elf-addr2line> <Elf-File> <Dump of Exception>");
    }
}

