import QtQuick
import QtQuick.Controls 6.5
// import Qt.labs.settings 1.0
import QtCore

/*
  Mireu el main.cpp. He hagut d'afegir això
    // Settings necessita saber on desar les dades al sistema de fitxers.
    // Sense aquests identificadors, no pot crear el fitxer de configuració.
    QCoreApplication::setOrganizationName("ExempleOrg");
    QCoreApplication::setOrganizationDomain("exemple.cat");
    QCoreApplication::setApplicationName("RPSConfig");
    //
*/

Window {
    width: 400
    height: 300
    visible: true
    title: qsTr("ta08_09 - Settings")

    Settings {
        id: configuracio
        category: "estadistiques"

        property int partidesGuanyades: 0
        property int partidesPerdudes: 0
    }

    Column {
        anchors.centerIn: parent
        spacing: 10

        Label {
            text: "Guanyades: " + configuracio.partidesGuanyades
        }

        Label {
            text: "Perdudes: " + configuracio.partidesPerdudes
        }

        Button {
            text: "He guanyat!"
            onClicked: {
                configuracio.partidesGuanyades += 1
            }
        }

        Button {
            text: "He perdut"
            onClicked: {
                configuracio.partidesPerdudes += 1
            }
        }

        Button {
            text: "Reset"
            onClicked: {
                configuracio.partidesGuanyades = 0
                configuracio.partidesPerdudes = 0
            }
        }
    }
}
