import QtQuick
import QtQuick.Controls 6.5

Window {
    width: 640
    height: 480
    visible: true
    title: qsTr("ta08_06")

    SwipeView {
        id: vista
        anchors.fill: parent
        currentIndex: 0

        Page {
            id: pagina1
            background: Rectangle { color: "lightblue" }

            Label {
                text: "Pàgina 1"
                anchors.centerIn: parent
                font.pixelSize: 36
            }
            Button {
                anchors.bottom: parent.bottom
                anchors.margins: 20
                anchors.horizontalCenter: parent.horizontalCenter
                text: "Anar a configuració"
                onClicked: {
                    vista.currentIndex = 1
                }
            }
        }

        Page {
            id: pagina2
            background: Rectangle { color: "lightgreen" }

            Label {
                text: "Pàgina 2"
                anchors.centerIn: parent
                font.pixelSize: 36
            }
            Button {
                anchors.bottom: parent.bottom
                anchors.margins: 20
                anchors.horizontalCenter: parent.horizontalCenter
                text: "Tornar al joc"
                onClicked: {
                    vista.currentIndex = 0
                }
            }
        }
    }

    PageIndicator {
        count: vista.count
        currentIndex: vista.currentIndex
        anchors.bottom: parent.bottom
        anchors.horizontalCenter: parent.horizontalCenter
    }
}
