import QtQuick
import QtQuick.Controls
import desDe.connexio 1.0
Window {
    width: 640
    height: 480
    visible: true
    title: qsTr("Connexió mínima QML")

    // *** Eliminem: property int estatConnexio: 0 ***

    Rectangle{
        id: mainRect
        anchors.fill: parent
        color: "coral"

        Row{
            id: filaSup
            anchors.top: mainRect.top
            anchors.left: mainRect.left
            width: mainRect.width
            height: width / 4
            anchors.margins: 20
            spacing: 50

            Rectangle{
                id: rectFilaSup
                width: parent.width / 3
                height: parent.height
                color: mainRect.color

                Button {
                    id: exitButton
                    anchors.centerIn: parent

                    // 1. Text del botó inicial. Es canviarà pel C++
                    text: "&Connecta"

                    // 2. CRIDA DIRECTA AL MÈTODE DEL C++
                    onClicked: {
                        // El mètode C++ on_btConnecta_clicked() ja conté la lògica
                        // per decidir si connectar o desconnectar segons el text actual del botó.
                        mqttController.on_btConnecta_clicked();
                    }
                }
            }

            Text{
                id: estatText
                color: "darkblue"
                anchors.verticalCenter: rectFilaSup.verticalCenter
                font.pixelSize: 50
                font.bold: true

                // 3. Text inicial. Es canviarà amb els senyals.
                text: "Desconnectat"
            }
        }

        // 4. CONNEXIÓ ALS SENYALS DEL C++
        // Utilitzem l'objecte Layout (mainRect) per rebre els senyals.
        Connexio {
            id: mqttController

            // Rep el senyal quan el C++ confirma la connexió
            onVSignalMqttConnected: {
                estatText.text = "Connectat!";
                estatText.color = "green";
                exitButton.text = "&Desconnecta";
                // L'habilitació/deshabilitació del botó ja la gestiona el C++
            }

            // Rep el senyal quan el C++ confirma l'inici de la connexió
            onVSignalMqttConnecting: {
                estatText.text = "Connectant...";
                estatText.color = "blue";
                exitButton.text = "...";
            }

            // Rep el senyal quan el C++ confirma la desconnexió
            onVSignalMqttDisconnected: {
                estatText.text = "Desconnectat";
                estatText.color = "red";
                exitButton.text = "&Connecta";
            }
        }
    }
}
