#include "connexio.h"
#include <QObject>
#include <QDebug>

Connexio::Connexio(QObject *parent)
    : QObject(parent)
    , mqtt(nullptr)
    , m_isConnected(false)
{
    mqtt = new MqttBasic(this);

    // Sintaxi moderna de signals/slots
    connect(mqtt, &MqttBasic::vSignalMqttConnected,
            this, &Connexio::vOscaMqttConnected);
    connect(mqtt, &MqttBasic::vSignalMqttConnecting,
            this, &Connexio::vOscaMqttConnecting);
    connect(mqtt, &MqttBasic::vSignalMqttDisconnected,
            this, &Connexio::vOscaMqttDisconnected);
}

Connexio::~Connexio(){
    qDebug() << "Destructor Connexio";
    
    // Desconnectar del broker abans de destruir
    if(mqtt) {
        mqtt->vDisconnectBroker();
        // NO fer delete perquè mqtt té parent (this)
        // Qt s'encarregarà de destruir-lo automàticament
    }
}

void Connexio::on_btConnecta_clicked(){
    if(!mqtt) {
        qDebug() << "Error: mqtt és nullptr";
        return;
    }
    
    QString szNomBroker = "wss://broker.emqx.io:8084/mqtt";

    if(!m_isConnected){
        // IMPORTANT: NO cridar vIniciaConnectaClientMqtt() aquí!
        // El client ja està creat al constructor
        // Només connectar al broker
        mqtt->vSetWsBroker(szNomBroker,"","","112233445566");
    } else {
        // Si estem connectats, desconnectem
        mqtt->vDisconnectBroker();
    }
}

void Connexio::vOscaMqttConnected(){
    m_isConnected = true;
    qDebug() << "Estat: Connectat. (Emès a QML)";
    emit vSignalMqttConnected();
}

void Connexio::vOscaMqttConnecting(){
    qDebug() << "Estat: Connectant. (Emès a QML)";
    emit vSignalMqttConnecting();
}

void Connexio::vOscaMqttDisconnected(){
    m_isConnected = false;
    qDebug() << "Estat: Desconnectat. (Emès a QML)";
    emit vSignalMqttDisconnected();
}
